/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */

#ifndef _PLASMA_H_
#define _PLASMA_H_

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif

/*////////////////////////////////////////////////////////////////////////////////////////
 * PLASMA types
 */
typedef int PLASMA_enum;
typedef int PLASMA_bool;
typedef long PLASMA_long;

/*////////////////////////////////////////////////////////////////////////////////////////
 * PLASMA constants - CBLAS & LAPACK
 */
#define PlasmaNoTrans       111
#define PlasmaTrans         112
#define PlasmaConjTrans     113

#define PlasmaUpper         121
#define PlasmaLower         122

#define PlasmaNonUnit       131
#define PlasmaUnit          132

#define PlasmaLeft          141
#define PlasmaRight         142

#define PlasmaForward       391
#define PlasmaBackward      392

#define PlasmaColumnwise    401
#define PlasmaRowwise       402

#define plasma_const_neg(const) (((const-1)^0x01)+1)

/*////////////////////////////////////////////////////////////////////////////////////////
 * PLASMA constants - boolean
 */
#define PLASMA_FALSE    0
#define PLASMA_TRUE     1

/*////////////////////////////////////////////////////////////////////////////////////////
 * PLASMA constants - configuration parameters
 */
#define PLASMA_CONCURRENCY      1

/*////////////////////////////////////////////////////////////////////////////////////////
 * PLASMA constants - success & error codes
 */
#define PLASMA_SUCCESS               0
#define PLASMA_ERR_NOT_INITIALIZED  -1
#define PLASMA_ERR_REINITIALIZED    -2
#define PLASMA_ERR_NOT_SUPPORTED    -3
#define PLASMA_ERR_ILLEGAL_VALUE    -4
#define PLASMA_ERR_NOT_FOUND        -5
#define PLASMA_ERR_OUT_OF_MEMORY    -6
#define PLASMA_ERR_INTERNAL_LIMIT   -7
#define PLASMA_ERR_UNALLOCATED      -8
#define PLASMA_ERR_FILESYSTEM       -9

/*////////////////////////////////////////////////////////////////////////////////////////
 * LAPACK Constants
 */
char *lapack_constants[] =
{
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "Row",                  // 101
    "Column",               // 102
    "", "", "", "", "", "", "", "",
    "No transpose",         // 111
    "Transpose",            // 112
    "Conjugate transpose",  // 113
    "", "", "", "", "", "", "",
    "Upper",                // 121
    "Lower",                // 122
    "", "", "", "", "", "", "", "",
    "Non-unit",             // 131
    "Unit",                 // 132
    "", "", "", "", "", "", "", "",
    "Left",                 // 141
    "Right"                 // 142
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "",
    "Forward",              // 391
    "Backward",             // 391
    "", "", "", "", "", "", "", "",
    "Columnwise",           // 401
    "Rowwise"               // 402
};

#define lapack_const(plasma_const) lapack_constants[plasma_const]

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Configuration
 */
#define CACHE_LINE_SIZE     128
#define SHELL_CMD_OUT_MAX   256
#define HUGE_PAGE_FILE_NAME "/huge/plasma_huge_page.bin"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Action commands
 */
#define PLASMA_ACT_STAND_BY 0
#define PLASMA_ACT_FINALIZE 1

#define PLASMA_ACT_DGEQRF   2
#define PLASMA_ACT_DORMQR   3
#define PLASMA_ACT_DTRSM    4

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Tuned functions
 */
#define PLASMA_TUNE_DGELS   1

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Utility
 */
#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))
#define roundup(a, b) (b <= 0) ? (a) : (((a) + (b)-1) & ~((b)-1))

#if defined(c_plusplus) || defined(__cplusplus)
}
#endif

#endif
