      SUBROUTINE CORE_DSSRFB(SIDE, STOREV, M1, M2, NN, IB, K, A1, LDA1,
     $                      A2, LDA2, V, LDV, T, LDT, WORK, INFO)

      IMPLICIT NONE

      INTEGER           M1, M2, NN, K, LDA1, LDA2, LDV, LDT, IB, INFO
      DOUBLE PRECISION  A1(LDA1,*), A2(LDA2,*), V(LDV,*), 
     $                  T(LDT,*), WORK(IB,*)
      CHARACTER         SIDE, STOREV

      INTEGER           II, J, KB, MODK
*     .. External Functions ..
      LOGICAL           LSAME
      EXTERNAL          LSAME

*
*     Test the input arguments
*

      INFO = 0
      IF( M1.LT.0 ) THEN
         INFO = -3
      ELSE IF( M2.LT.0 ) THEN
         INFO = -4
      ELSE IF( NN.LT.0 ) THEN
         INFO = -5
      ELSE IF( IB.LT.0 ) THEN
         INFO = -6
      END IF

      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DSSRFB', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M1.LE.0 .OR. M2.LE.0 .OR. NN.LE.0 .OR. IB.LE.0 )
     $   RETURN
*
      KB = M1 / IB
      MODK = MOD(M1,IB)


      IF( LSAME( STOREV, 'C' ) ) THEN

         IF( LSAME( SIDE, 'L' ) ) THEN
            DO 10 II=1, KB*IB, IB
*
*              B = A1+V'*A2      
*
               CALL DLACPY('GENERAL', IB, NN, A1(II, 1), LDA1, WORK, IB)
               CALL DGEMM('TRANSPOSE', 'NOTRANSPOSE', IB, NN, M2, 1.D0,
     $              V(1, II), LDV, A2, LDA2, 1.D0, WORK, IB)
*
*              A2 = A2 - V*T*B --->  B=T*B, A2=A2-V*B
*
               CALL DTRMM('LEFT', 'UP', 'TRANSPOSE', 'NOUNIT', IB, NN, 
     $              1.D0, T(1,II), LDT, WORK, IB)
               CALL DGEMM('NOTRANSPOSE', 'NOTRANSPOSE', M2, NN, IB,
     $               -1.D0, V(1, II), LDV, WORK, IB, 1.D0, A2, LDA2)
*
*              A1 = A1 - T*B
*
               DO 20 J=1, NN
                  CALL DAXPY(IB, -1.D0, WORK(1,J), 1, A1(II, J), 1)
 20            CONTINUE
 10         CONTINUE
     

*
*           CLEANING CODE SECTION
*

            IF( MODK.GT.0 ) THEN
*
*              B = A1+V'*A2      
*
               CALL DLACPY('GENERAL',MODK,NN,A1(II, 1),LDA1, WORK, MODK)
               CALL DGEMM('TRANSPOSE','NOTRANSPOSE', MODK, NN, M2, 1.D0,
     $                    V(1, II), LDV, A2, LDA2, 1.D0, WORK, MODK)
*
*              A2 = A2 - V*T*B --->  B=T*B, A2=A2-V*B
*
               CALL DTRMM('LEFT','UP', 'TRANSPOSE', 'NOUNIT', MODK, NN, 
     $                    1.D0, T(1,II), LDT, WORK, MODK)
               CALL DGEMM('NOTRANSPOSE', 'NOTRANSPOSE', M2, NN, MODK,
     $                    -1.D0, V(1, II), LDV, WORK, MODK, 1.D0,
     $                    A2, LDA2)
*
*              A1 = A1 - T*B
*
               DO 30 J=1, NN
                  CALL DAXPY(MODK, -1.D0, WORK(1,J), 1, A1(II, J), 1)
 30            CONTINUE

            ENDIF

         ELSE IF( LSAME( SIDE, 'R' ) ) THEN

*
*                  LOOP: 40 50 60 
*

         ENDIF



      ELSE IF( LSAME( STOREV, 'R' ) ) THEN
         
              IF( LSAME( SIDE, 'L' ) ) THEN

*
*                  LOOP: 70 80 90 
*

              ELSE IF( LSAME( SIDE, 'R' ) ) THEN

                    DO 100 II=1, KB*IB, IB
*
*                     B = A1+A2*V
*
                      CALL DLACPY('GENERAL',NN,IB,A1(1,II),LDA1,WORK,NN)
        !write(*,*)'salem' ,NN
                      CALL DGEMM('NOTRANSPOSE', 'TRANSPOSE', NN, IB, M2,
     $                          1.D0,A2, LDA2, V(II, 1), LDV, 1.D0,
     $                          WORK, NN)
*
*                     A2 = A2 - B*T*V' --->  B=B*T, A2=A2-B*V'
*
                      CALL DTRMM('RIGHT','UP','NOTRANSPOSE','NOUNIT',NN,
     $                         IB, 1.D0, T(1,II), LDT, WORK, NN)
                      CALL DGEMM('NOTRANSPOSE','NOTRANSPOSE',NN, M2, IB,
     $                         -1.D0,WORK,NN,V(II, 1),LDV,1.D0,A2,LDA2)


*
*                     A1 = A1 - B*T
*   
                      DO 110 J=1, NN
                         CALL DAXPY(IB,-1.D0,WORK(J,1),NN,A1(J,II),LDA1)
 110                  CONTINUE
 100                CONTINUE

*
*                   CLEANING CODE SECTION
*

                    IF( MODK.GT.0 ) THEN
*
*                     B = A1+A2*V
*
                    CALL DLACPY('GENERAL',NN,MODK,A1(1,II),LDA1,WORK,NN)
                    CALL DGEMM('NOTRANSPOSE', 'TRANSPOSE', NN, MODK, M2,
     $                          1.D0,A2, LDA2, V(II, 1), LDV, 1.D0,
     $                          WORK, NN)
         
*
*                     A2 = A2 - B*T*V' --->  B=B*T, A2=A2-B*V'
*
                      CALL DTRMM('RIGHT','UP','NOTRANSPOSE','NOUNIT',NN,
     $                         MODK, 1.D0, T(1,II), LDT, WORK, NN)
                      CALL DGEMM('NOTRANSPOSE','NOTRANSPOSE',NN,M2,MODK,
     $                         -1.D0,WORK,NN,V(II, 1),LDV,1.D0,A2,LDA2)


*
*                     A1 = A1 - B*T
*   
                      DO 120 J=1, NN
                       CALL DAXPY(MODK,-1.D0,WORK(J,1),NN,A1(J,II),LDA1)
 120                  CONTINUE
                    ENDIF


              ENDIF

      ENDIF

*
*     End of CORE_DSSRFB
*
      END
