      SUBROUTINE CORE_DGEQRT(M, N, IB, A, LDA, T, LDT, TAU, WORK, INFO)

      IMPLICIT NONE
*
*  -- LAPACK routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA, LDT, M, N, IB
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * )
      DOUBLE PRECISION   T( LDT, * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  CORE_DGEQRT computes a QR factorization of a real m by n matrix A:
*  A = Q * R.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the matrix A.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the matrix A.  N >= 0.
*
*  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
*          On entry, the m by n matrix A.
*          On exit, the elements on and above the diagonal of the array
*          contain the min(m,n) by n upper trapezoidal matrix R (R is
*          upper triangular if m >= n); the elements below the diagonal,
*          with the array TAU, represent the orthogonal matrix Q as a
*          product of elementary reflectors (see Further Details).
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,M).
*
*  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
*          The scalar factors of the elementary reflectors (see Further
*          Details).
*
*  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -i, the i-th argument had an illegal value
*
*  Further Details
*  ===============
*
*  The matrix Q is represented as a product of elementary reflectors
*
*     Q = H(1) H(2) . . . H(k), where k = min(m,n).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
*  and tau in TAU(i).
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0 )
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, J, K, II, KB, MODK, IINFO
      DOUBLE PRECISION   AII
*     ..
*     .. External Subroutines ..
      EXTERNAL           DLARF, DLARFG, XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments
*

      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( IB.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -5
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DGEQRT', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 )
     $   RETURN
*
      K = MIN( M, N )
      KB = K / IB
      MODK = MOD(K,IB)
*
      DO 10 I = 0, KB-1

*         write(*,*) 'NORMAL CODE',M,N,K,IB,KB,MODK,I

         CALL DGEQR2( M-I*IB, IB, A( I*IB+1, I*IB+1 ), LDA, 
     $                TAU( I*IB+1 ), WORK, IINFO )

         !IF( (I*IB+IB).LE.N ) THEN

             CALL DLARFT( 'Forward', 'Columnwise', M-I*IB, IB,
     $                A( I*IB+1, I*IB+1 ), LDA, TAU( I*IB+1 ),
     $                T(1,I*IB+1), LDT )

             CALL CORE_DLARFB( 'Left', 'Transpose', 'Forward',
     $                'Columnwise', M-I*IB ,N-I*IB-IB, IB, IB,
     $                A( I*IB+1, I*IB+1 ), LDA, T(1,I*IB+1), LDT, 
     $                A( I*IB+1, I*IB+1+IB ),LDA,
     $                WORK, N-I*IB-IB, IINFO )
         !END IF

 10   CONTINUE



*
*     CLEANING CODE SECTION
*


      IF (MODK.GT.0) THEN

*         write(*,*) 'CLEANING CODE',M,N,K,IB,KB,MODK,I

         CALL DGEQR2( M-I*IB, MODK, A( I*IB+1, I*IB+1 ), LDA, 
     $                TAU( I*IB+1 ), WORK, IINFO )


         CALL DLARFT( 'Forward', 'Columnwise', M-I*IB, MODK,
     $                A( I*IB+1, I*IB+1 ), LDA, TAU( I*IB+1 ),
     $                T(1,I*IB+1), LDT )

         CALL CORE_DLARFB( 'Left', 'Transpose', 'Forward',
     $                'Columnwise', M-I*IB ,N-I*IB-MODK, MODK, MODK,
     $                A( I*IB+1, I*IB+1 ), LDA, T(1,I*IB+1), LDT, 
     $                A( I*IB+1, I*IB+1+MODK ),LDA,
     $                WORK, N-I*IB-MODK, IINFO )

      ENDIF 

      RETURN
*
*     End of CORE_DGEQRT
*
      END
