/**
 *
 * @precisions normal z -> c d s
 *
 **/
#define _TYPE  PLASMA_Complex64_t
#define _PREC  double
#define _LAMCH LAPACKE_dlamch_work

#define _NAME  "PLASMA_zheevd_Tile"
/* See Lawn 41 page 120 */
#define _FMULS ((2. / 3.) * ((double)N * (double)N * (double)N))
#define _FADDS ((2. / 3.) * ((double)N * (double)N * (double)N))

#include "./timing.c"

static int
RunTest(int *iparam, double *dparam, real_Double_t *t_)
{
    PASTE_CODE_IPARAM_LOCALS( iparam );
    PLASMA_desc *descT;
    int LDQ;
    int uplo = PlasmaLower;
    int vec  = PlasmaVec;
    int INFO;

    int mode = iparam[IPARAM_MODE];
    double dmax  = 1.0;
    double rcond = 1.0e6;
    int i;

    LDA = max(LDA, N);
    LDQ = N;

    /* Allocate Data */
    PASTE_CODE_ALLOCATE_MATRIX( A, 1, PLASMA_Complex64_t, LDA, N);
    PASTE_CODE_ALLOCATE_MATRIX( Q, (vec == PlasmaVec), PLASMA_Complex64_t, LDA, N );
    PASTE_CODE_ALLOCATE_MATRIX( W, 1, double, N, 1 );
    PASTE_CODE_ALLOCATE_MATRIX( S, 1, double, N, 1 );

    /* Set Q to 0. */
    if (vec == PlasmaVec) {
        memset(Q,0,LDQ*N*sizeof(PLASMA_Complex64_t));
    }

    PLASMA_Complex64_t *work = (PLASMA_Complex64_t *)malloc(3*N* sizeof(PLASMA_Complex64_t));
    INFO = LAPACKE_zlatms_work( LAPACK_COL_MAJOR, N, N,
                                lapack_const(PlasmaDistSymmetric), ISEED,
                                lapack_const(PlasmaHermGeev), W, mode, rcond,
                                dmax, N, N,
                                lapack_const(PlasmaNoPacking), A, LDA, work );

    LAPACKE_dlasrt_work('I', N, W);

    /* Allocate Workspace */
    PLASMA_Alloc_Workspace_zheevd(N, N, &descT);

    START_TIMING();
    INFO = PLASMA_zheevd(vec, uplo, N, A, LDA, S, descT, Q, LDQ);
    STOP_TIMING();

    if(INFO!=0){
        printf(" ERROR OCCURED INFO %d\n",INFO);
    }

    /* Check the solution */
    if ( check ){
        for (i=0; i<N; i++){
            if (fabs(W[i]-S[i]) > 0.001){
                printf("ERROR OCCURED %f %f\n", W[i], S[i]);
            }
        }
    }

    /* DeAllocate Workspace */
    PLASMA_Dealloc_Handle_Tile(&descT);

    if (vec == PlasmaVec) {
        free( Q );
    }
    free( A );
    free( W );
    free( work );
    return 0;
}
