/**
 *
 * @generated d Mon Apr 27 17:43:00 2015
 *
 **/
#define _TYPE  double
#define _PREC  double
#define _LAMCH LAPACKE_dlamch_work

#define _NAME  "PLASMA_dsyevd_Tile"
/* See Lawn 41 page 120 */
#define _FMULS ((2. / 3.) * ((double)N * (double)N * (double)N))
#define _FADDS ((2. / 3.) * ((double)N * (double)N * (double)N))

#include "./timing.c"

static int
RunTest(int *iparam, double *dparam, real_Double_t *t_)
{
    PASTE_CODE_IPARAM_LOCALS( iparam );
    PLASMA_desc *descT;
    int LDQ;
    int uplo = PlasmaLower;
    int vec  = PlasmaVec;
    int INFO;

    int mode = iparam[IPARAM_MODE];
    double dmax  = 1.0;
    double rcond = 1.0e6;
    int i;

    LDA = max(LDA, N);
    LDQ = N;

    /* Allocate Data */
    PASTE_CODE_ALLOCATE_MATRIX( A, 1, double, LDA, N);
    PASTE_CODE_ALLOCATE_MATRIX( Q, (vec == PlasmaVec), double, LDA, N );
    PASTE_CODE_ALLOCATE_MATRIX( W, 1, double, N, 1 );
    PASTE_CODE_ALLOCATE_MATRIX( S, 1, double, N, 1 );

    /* Set Q to 0. */
    if (vec == PlasmaVec) {
        memset(Q,0,LDQ*N*sizeof(double));
    }

    double *work = (double *)malloc(3*N* sizeof(double));
    INFO = LAPACKE_dlatms_work( LAPACK_COL_MAJOR, N, N,
                                lapack_const(PlasmaDistSymmetric), ISEED,
                                lapack_const(PlasmaHermGeev), W, mode, rcond,
                                dmax, N, N,
                                lapack_const(PlasmaNoPacking), A, LDA, work );

    LAPACKE_dlasrt_work('I', N, W);

    /* Allocate Workspace */
    PLASMA_Alloc_Workspace_dsyevd(N, N, &descT);

    START_TIMING();
    INFO = PLASMA_dsyevd(vec, uplo, N, A, LDA, S, descT, Q, LDQ);
    STOP_TIMING();

    if(INFO!=0){
        printf(" ERROR OCCURED INFO %d\n",INFO);
    }

    /* Check the solution */
    if ( check ){
        for (i=0; i<N; i++){
            if (fabs(W[i]-S[i]) > 0.001){
                printf("ERROR OCCURED %f %f\n", W[i], S[i]);
            }
        }
    }

    /* DeAllocate Workspace */
    PLASMA_Dealloc_Handle_Tile(&descT);

    if (vec == PlasmaVec) {
        free( Q );
    }
    free( A );
    free( W );
    free( work );
    return 0;
}
