/**
 *
 * @file qwrapper_slaed3_computevectors.c
 *
 *  PLASMA core_blas quark wrapper
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.7.1
 * @author Gregoire Pichon
 * @author Azzam Haidar
 * @date 2014-07
 * @generated s Mon Apr 27 17:42:32 2015
 *
 **/
#include <stdlib.h>
#include <lapacke.h>
#include "common.h"

void
CORE_slaed3_compvec_quark(Quark *quark);

void
CORE_slaed3_compvec_ws3_quark(Quark *quark);

void
CORE_slaed3_wscopy_quark(Quark *quark);

/***************************************************************************//**
 *
 **/
void QUARK_CORE_slaed3_computevectors(Quark *quark, Quark_Task_Flags *task_flags,
                                      int wsmode, int n, const int *K,
                      const int *il_nondef, const int *iu_nondef,
                                      float *Q, int LDQ, float *W, const int *INDXC,
                                      float **WSglobal, float **WSlocal,
                                      int start, int end )
{
    DAG_CORE_LAED3_COMPUTEVECTORS;

    if ( wsmode == 3 ) {
        /* Use ws as the Q pointer */
        QUARK_Insert_Task(quark, CORE_slaed3_compvec_ws3_quark, task_flags,
                          sizeof(int),       K,              NODEP,
                          sizeof(int),       il_nondef,      NODEP,
                          sizeof(int),       iu_nondef,      NODEP,
                          sizeof(float),    WSglobal,       NODEP,
                          sizeof(float),    W,                  INPUT,
                          sizeof(float)*n,  NULL,               SCRATCH,
                          sizeof(int),       INDXC,          NODEP,
                          sizeof(int),      &start,          VALUE,
                          sizeof(int),      &end,            VALUE,
                          sizeof(float),    Q+start*LDQ,        INOUT,
                          sizeof(float),    WSlocal,            OUTPUT,
                          0);
    }
    else {
        QUARK_Insert_Task(quark, CORE_slaed3_compvec_quark, task_flags,
                          sizeof(int),       K,                  INPUT,
                          sizeof(int),       il_nondef,          INPUT,
                          sizeof(int),       iu_nondef,          INPUT,
                          sizeof(float),    Q,                  INPUT,
                          sizeof(int),      &LDQ,            VALUE,
                          sizeof(float),    W,                  INPUT,
                          sizeof(float)*n,  NULL,               SCRATCH,
                          sizeof(int),       INDXC,              NODEP,
                          sizeof(int),      &start,          VALUE,
                          sizeof(int),      &end,            VALUE,
                          sizeof(float),    Q+start*LDQ,        INOUT,
                          sizeof(float),    WSlocal,            ((wsmode==0) ? NODEP : OUTPUT),
                          0);
    }
}
/***************************************************************************//**
 *
 **/
#if defined(PLASMA_HAVE_WEAK)
#pragma weak CORE_slaed3_compvec_ws3_quark = PCORE_slaed3_compvec_ws3_quark
#define CORE_slaed3_compvec_ws3_quark PCORE_slaed3_compvec_ws3_quark
#endif
void CORE_slaed3_compvec_ws3_quark(Quark *quark)
{
    const int *K;
    const int *il_nondef;
    const int *iu_nondef;
    float **WSg;
    float *W;
    float *S;
    const int *INDXC;
    int start;
    int end;
    void *fake, *fake2;

    quark_unpack_args_11(quark, K, il_nondef, iu_nondef,
                         WSg, W, S, INDXC,
                         start, end, fake, fake2 );

    CORE_slaed3_computevectors(*K, *il_nondef, *iu_nondef,
                               (*WSg), *K, W, S, INDXC,
                               start, end);
}

/***************************************************************************//**
 *
 **/
#if defined(PLASMA_HAVE_WEAK)
#pragma weak CORE_slaed3_compvec_quark = PCORE_slaed3_compvec_quark
#define CORE_slaed3_compvec_quark PCORE_slaed3_compvec_quark
#endif
void CORE_slaed3_compvec_quark(Quark *quark)
{
    const int *K;
    const int *il_nondef;
    const int *iu_nondef;
    float *Q;
    int LDQ;
    float *W;
    float *S;
    const int *INDXC;
    int start;
    int end;
    void *fake, *fake2;

    quark_unpack_args_12(quark, K, il_nondef, iu_nondef,
                         Q, LDQ, W, S, INDXC,
                         start, end, fake, fake2 );

    CORE_slaed3_computevectors(*K, *il_nondef, *iu_nondef,
                               Q, LDQ, W, S, INDXC,
                               start, end);
}

/***************************************************************************//**
 *
 **/
void QUARK_CORE_slaed3_wscopy( Quark *quark, Quark_Task_Flags *task_flags,
                               const int *K, const int *il_nondef, const int *iu_nondef,
                               const float *Q, int LDQ, float **WORK,
                               int start, int end )
{
    QUARK_Insert_Task(quark, CORE_slaed3_wscopy_quark, task_flags,
        sizeof(int),     K,               INPUT,
        sizeof(int),     il_nondef,       NODEP,
        sizeof(int),     iu_nondef,       NODEP,
        sizeof(float),  Q,               NODEP,
        sizeof(int),    &LDQ,           VALUE,
        sizeof(float),  WORK,            INOUT,
        sizeof(int),    &start,         VALUE,
        sizeof(int),    &end,           VALUE,
        sizeof(float),  Q+start*LDQ,     INPUT,
        0);
}

/***************************************************************************//**
 *
 **/
#if defined(PLASMA_HAVE_WEAK)
#pragma weak CORE_slaed3_wscopy_quark = PCORE_slaed3_wscopy_quark
#define CORE_slaed3_wscopy_quark PCORE_slaed3_wscopy_quark
#endif
void CORE_slaed3_wscopy_quark(Quark *quark)
{
    const int *K;
    const int *il_nondef;
    const int *iu_nondef;
    const float *Q;
    int LDQ;
    float **WORK;
    int start;
    int end;
    int size;
    void *fake;

    quark_unpack_args_9(quark, K, il_nondef, iu_nondef,
                        Q, LDQ, WORK,
                        start, end, fake);

    /* Compute the size */
    start = max( 0,   max(  start, *il_nondef ) );
    end   = min( end, min( *K,     *iu_nondef ) );
    size  = max( 0, end-start );

    if ((size > 0) && (*K > 0)) {
        *WORK = malloc( size * (*K) * sizeof(float) );
        LAPACKE_slacpy_work(LAPACK_COL_MAJOR,
                            lapack_const(PlasmaUpperLower), *K, size,
                            Q+start*LDQ, LDQ, *WORK, *K);
    } else {
        *WORK = NULL;
    }
}
