/**
 *
 * @file plasma_zf77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *  This file is automatically generated by tools/genf77interface.pl
 *
 *  WARNING: This file is automatically generated through
 *  tools/genf77interface.pl script, please do not manually edit it.
 *
 * @version 2.7.1
 * @author Bilel Hadri
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @precisions normal z -> c d s
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef REAL
#define COMPLEX


/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
#define PLASMA_ZLAPACK_TO_TILE PLASMA_FNAME(zlapack_to_tile, ZLAPACK_TO_TILE)
#define PLASMA_ZLAPACK_TO_TILE_ASYNC PLASMA_FNAME(zlapack_to_tile_async, ZLAPACK_TO_TILE_ASYNC)
#define PLASMA_ZTILE_TO_LAPACK PLASMA_FNAME(ztile_to_lapack, ZTILE_TO_LAPACK)
#define PLASMA_ZTILE_TO_LAPACK_ASYNC PLASMA_FNAME(ztile_to_lapack_async, ZTILE_TO_LAPACK_ASYNC)
#define PLASMA_ZGEBRD          PLASMA_FNAME(zgebrd       , ZGEBRD       )
#define PLASMA_ZGECFI          PLASMA_FNAME(zgecfi       , ZGECFI       )
#define PLASMA_ZGECFI_ASYNC    PLASMA_FNAME(zgecfi_async , ZGECFI_ASYNC )
#define PLASMA_ZGECON          PLASMA_FNAME(zgecon       , ZGECON       )
#define PLASMA_ZGELQF          PLASMA_FNAME(zgelqf       , ZGELQF       )
#define PLASMA_ZGELQS          PLASMA_FNAME(zgelqs       , ZGELQS       )
#define PLASMA_ZGELS           PLASMA_FNAME(zgels        , ZGELS        )
#define PLASMA_ZGEMM           PLASMA_FNAME(zgemm        , ZGEMM        )
#define PLASMA_ZGEQP3          PLASMA_FNAME(zgeqp3       , ZGEQP3       )
#define PLASMA_ZGEQRF          PLASMA_FNAME(zgeqrf       , ZGEQRF       )
#define PLASMA_ZGEQRS          PLASMA_FNAME(zgeqrs       , ZGEQRS       )
#define PLASMA_ZGESDD          PLASMA_FNAME(zgesdd       , ZGESDD       )
#define PLASMA_ZGESV           PLASMA_FNAME(zgesv        , ZGESV        )
#define PLASMA_ZGESV_INCPIV    PLASMA_FNAME(zgesv_incpiv , ZGESV_INCPIV )
#define PLASMA_ZGESVD          PLASMA_FNAME(zgesvd       , ZGESVD       )
#define PLASMA_ZGETMI          PLASMA_FNAME(zgetmi       , ZGETMI       )
#define PLASMA_ZGETMI_ASYNC    PLASMA_FNAME(zgetmi_async , ZGETMI_ASYNC )
#define PLASMA_ZGETRF          PLASMA_FNAME(zgetrf       , ZGETRF       )
#define PLASMA_ZGETRF_INCPIV   PLASMA_FNAME(zgetrf_incpiv, ZGETRF_INCPIV)
#define PLASMA_ZGETRF_NOPIV    PLASMA_FNAME(zgetrf_nopiv , ZGETRF_NOPIV )
#define PLASMA_ZGETRF_TNTPIV   PLASMA_FNAME(zgetrf_tntpiv, ZGETRF_TNTPIV)
#define PLASMA_ZGETRI          PLASMA_FNAME(zgetri       , ZGETRI       )
#define PLASMA_ZGETRS          PLASMA_FNAME(zgetrs       , ZGETRS       )
#define PLASMA_ZGETRS_INCPIV   PLASMA_FNAME(zgetrs_incpiv, ZGETRS_INCPIV)
#define PLASMA_ZHEEV           PLASMA_FNAME(zheev        , ZHEEV        )
#define PLASMA_ZHEEVD          PLASMA_FNAME(zheevd       , ZHEEVD       )
#define PLASMA_ZHEEVR          PLASMA_FNAME(zheevr       , ZHEEVR       )
#define PLASMA_ZHEGST          PLASMA_FNAME(zhegst       , ZHEGST       )
#define PLASMA_ZHEGV           PLASMA_FNAME(zhegv        , ZHEGV        )
#define PLASMA_ZHEGVD          PLASMA_FNAME(zhegvd       , ZHEGVD       )
#ifdef COMPLEX
#define PLASMA_ZHEMM           PLASMA_FNAME(zhemm        , ZHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_ZHER2K          PLASMA_FNAME(zher2k       , ZHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_ZHERK           PLASMA_FNAME(zherk        , ZHERK        )
#endif
#define PLASMA_ZHETRD          PLASMA_FNAME(zhetrd       , ZHETRD       )
#define PLASMA_ZLACPY          PLASMA_FNAME(zlacpy       , ZLACPY       )
#define PLASMA_ZLANGE          PLASMA_FNAME(zlange       , ZLANGE       )
#ifdef COMPLEX
#define PLASMA_ZLANHE          PLASMA_FNAME(zlanhe       , ZLANHE       )
#endif
#define PLASMA_ZLANSY          PLASMA_FNAME(zlansy       , ZLANSY       )
#define PLASMA_ZLANTR          PLASMA_FNAME(zlantr       , ZLANTR       )
#define PLASMA_ZLASET          PLASMA_FNAME(zlaset       , ZLASET       )
#define PLASMA_ZLASWP          PLASMA_FNAME(zlaswp       , ZLASWP       )
#define PLASMA_ZLASWPC         PLASMA_FNAME(zlaswpc      , ZLASWPC      )
#define PLASMA_ZLAUUM          PLASMA_FNAME(zlauum       , ZLAUUM       )
#ifdef COMPLEX
#define PLASMA_ZPLGHE          PLASMA_FNAME(zplghe       , ZPLGHE       )
#endif
#define PLASMA_ZPLGSY          PLASMA_FNAME(zplgsy       , ZPLGSY       )
#define PLASMA_ZPLRNT          PLASMA_FNAME(zplrnt       , ZPLRNT       )
#define PLASMA_ZPLTMG          PLASMA_FNAME(zpltmg       , ZPLTMG       )
#define PLASMA_ZPOCON          PLASMA_FNAME(zpocon       , ZPOCON       )
#define PLASMA_ZPOSV           PLASMA_FNAME(zposv        , ZPOSV        )
#define PLASMA_ZPOTRF          PLASMA_FNAME(zpotrf       , ZPOTRF       )
#define PLASMA_ZPOTRI          PLASMA_FNAME(zpotri       , ZPOTRI       )
#define PLASMA_ZPOTRS          PLASMA_FNAME(zpotrs       , ZPOTRS       )
#define PLASMA_ZSTEDC          PLASMA_FNAME(zstedc       , ZSTEDC       )
#define PLASMA_ZSTEDC_ASYNC    PLASMA_FNAME(zstedc_async , ZSTEDC_ASYNC )
#define PLASMA_ZSYMM           PLASMA_FNAME(zsymm        , ZSYMM        )
#define PLASMA_ZSYR2K          PLASMA_FNAME(zsyr2k       , ZSYR2K       )
#define PLASMA_ZSYRK           PLASMA_FNAME(zsyrk        , ZSYRK        )
#define PLASMA_ZTRMM           PLASMA_FNAME(ztrmm        , ZTRMM        )
#define PLASMA_ZTRSM           PLASMA_FNAME(ztrsm        , ZTRSM        )
#define PLASMA_ZTRSMPL         PLASMA_FNAME(ztrsmpl      , ZTRSMPL      )
#define PLASMA_ZTRSMRV         PLASMA_FNAME(ztrsmrv      , ZTRSMRV      )
#define PLASMA_ZTRTRI          PLASMA_FNAME(ztrtri       , ZTRTRI       )
#define PLASMA_ZUNGLQ          PLASMA_FNAME(zunglq       , ZUNGLQ       )
#define PLASMA_ZUNGQR          PLASMA_FNAME(zungqr       , ZUNGQR       )
#define PLASMA_ZUNMLQ          PLASMA_FNAME(zunmlq       , ZUNMLQ       )
#define PLASMA_ZUNMQR          PLASMA_FNAME(zunmqr       , ZUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
#define PLASMA_ZGEBRD_TILE          PLASMA_TILE_FNAME(zgebrd       , ZGEBRD       )
#define PLASMA_ZGECON_TILE          PLASMA_TILE_FNAME(zgecon       , ZGECON       )
#define PLASMA_ZGELQF_TILE          PLASMA_TILE_FNAME(zgelqf       , ZGELQF       )
#define PLASMA_ZGELQS_TILE          PLASMA_TILE_FNAME(zgelqs       , ZGELQS       )
#define PLASMA_ZGELS_TILE           PLASMA_TILE_FNAME(zgels        , ZGELS        )
#define PLASMA_ZGEMM_TILE           PLASMA_TILE_FNAME(zgemm        , ZGEMM        )
#define PLASMA_ZGEQP3_TILE          PLASMA_TILE_FNAME(zgeqp3       , ZGEQP3       )
#define PLASMA_ZGEQRF_TILE          PLASMA_TILE_FNAME(zgeqrf       , ZGEQRF       )
#define PLASMA_ZGEQRS_TILE          PLASMA_TILE_FNAME(zgeqrs       , ZGEQRS       )
#define PLASMA_ZGESDD_TILE          PLASMA_TILE_FNAME(zgesdd       , ZGESDD       )
#define PLASMA_ZGESV_TILE           PLASMA_TILE_FNAME(zgesv        , ZGESV        )
#define PLASMA_ZGESV_INCPIV_TILE    PLASMA_TILE_FNAME(zgesv_incpiv , ZGESV_INCPIV )
#define PLASMA_ZGESVD_TILE          PLASMA_TILE_FNAME(zgesvd       , ZGESVD       )
#define PLASMA_ZGETRF_TILE          PLASMA_TILE_FNAME(zgetrf       , ZGETRF       )
#define PLASMA_ZGETRF_INCPIV_TILE   PLASMA_TILE_FNAME(zgetrf_incpiv, ZGETRF_INCPIV)
#define PLASMA_ZGETRF_NOPIV_TILE    PLASMA_TILE_FNAME(zgetrf_nopiv , ZGETRF_NOPIV )
#define PLASMA_ZGETRF_TNTPIV_TILE   PLASMA_TILE_FNAME(zgetrf_tntpiv, ZGETRF_TNTPIV)
#define PLASMA_ZGETRI_TILE          PLASMA_TILE_FNAME(zgetri       , ZGETRI       )
#define PLASMA_ZGETRS_TILE          PLASMA_TILE_FNAME(zgetrs       , ZGETRS       )
#define PLASMA_ZGETRS_INCPIV_TILE   PLASMA_TILE_FNAME(zgetrs_incpiv, ZGETRS_INCPIV)
#define PLASMA_ZHEEV_TILE           PLASMA_TILE_FNAME(zheev        , ZHEEV        )
#define PLASMA_ZHEEVD_TILE          PLASMA_TILE_FNAME(zheevd       , ZHEEVD       )
#define PLASMA_ZHEEVR_TILE          PLASMA_TILE_FNAME(zheevr       , ZHEEVR       )
#define PLASMA_ZHEGST_TILE          PLASMA_TILE_FNAME(zhegst       , ZHEGST       )
#define PLASMA_ZHEGV_TILE           PLASMA_TILE_FNAME(zhegv        , ZHEGV        )
#define PLASMA_ZHEGVD_TILE          PLASMA_TILE_FNAME(zhegvd       , ZHEGVD       )
#ifdef COMPLEX
#define PLASMA_ZHEMM_TILE           PLASMA_TILE_FNAME(zhemm        , ZHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_ZHER2K_TILE          PLASMA_TILE_FNAME(zher2k       , ZHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_ZHERK_TILE           PLASMA_TILE_FNAME(zherk        , ZHERK        )
#endif
#define PLASMA_ZHETRD_TILE          PLASMA_TILE_FNAME(zhetrd       , ZHETRD       )
#define PLASMA_ZLACPY_TILE          PLASMA_TILE_FNAME(zlacpy       , ZLACPY       )
#define PLASMA_ZLANGE_TILE          PLASMA_TILE_FNAME(zlange       , ZLANGE       )
#ifdef COMPLEX
#define PLASMA_ZLANHE_TILE          PLASMA_TILE_FNAME(zlanhe       , ZLANHE       )
#endif
#define PLASMA_ZLANSY_TILE          PLASMA_TILE_FNAME(zlansy       , ZLANSY       )
#define PLASMA_ZLANTR_TILE          PLASMA_TILE_FNAME(zlantr       , ZLANTR       )
#define PLASMA_ZLASET_TILE          PLASMA_TILE_FNAME(zlaset       , ZLASET       )
#define PLASMA_ZLASWP_TILE          PLASMA_TILE_FNAME(zlaswp       , ZLASWP       )
#define PLASMA_ZLASWPC_TILE         PLASMA_TILE_FNAME(zlaswpc      , ZLASWPC      )
#define PLASMA_ZLAUUM_TILE          PLASMA_TILE_FNAME(zlauum       , ZLAUUM       )
#ifdef COMPLEX
#define PLASMA_ZPLGHE_TILE          PLASMA_TILE_FNAME(zplghe       , ZPLGHE       )
#endif
#define PLASMA_ZPLGSY_TILE          PLASMA_TILE_FNAME(zplgsy       , ZPLGSY       )
#define PLASMA_ZPLRNT_TILE          PLASMA_TILE_FNAME(zplrnt       , ZPLRNT       )
#define PLASMA_ZPLTMG_TILE          PLASMA_TILE_FNAME(zpltmg       , ZPLTMG       )
#define PLASMA_ZPOCON_TILE          PLASMA_TILE_FNAME(zpocon       , ZPOCON       )
#define PLASMA_ZPOSV_TILE           PLASMA_TILE_FNAME(zposv        , ZPOSV        )
#define PLASMA_ZPOTRF_TILE          PLASMA_TILE_FNAME(zpotrf       , ZPOTRF       )
#define PLASMA_ZPOTRI_TILE          PLASMA_TILE_FNAME(zpotri       , ZPOTRI       )
#define PLASMA_ZPOTRS_TILE          PLASMA_TILE_FNAME(zpotrs       , ZPOTRS       )
#define PLASMA_ZSYMM_TILE           PLASMA_TILE_FNAME(zsymm        , ZSYMM        )
#define PLASMA_ZSYR2K_TILE          PLASMA_TILE_FNAME(zsyr2k       , ZSYR2K       )
#define PLASMA_ZSYRK_TILE           PLASMA_TILE_FNAME(zsyrk        , ZSYRK        )
#define PLASMA_ZTRMM_TILE           PLASMA_TILE_FNAME(ztrmm        , ZTRMM        )
#define PLASMA_ZTRSM_TILE           PLASMA_TILE_FNAME(ztrsm        , ZTRSM        )
#define PLASMA_ZTRSMPL_TILE         PLASMA_TILE_FNAME(ztrsmpl      , ZTRSMPL      )
#define PLASMA_ZTRSMRV_TILE         PLASMA_TILE_FNAME(ztrsmrv      , ZTRSMRV      )
#define PLASMA_ZTRTRI_TILE          PLASMA_TILE_FNAME(ztrtri       , ZTRTRI       )
#define PLASMA_ZUNGLQ_TILE          PLASMA_TILE_FNAME(zunglq       , ZUNGLQ       )
#define PLASMA_ZUNGQR_TILE          PLASMA_TILE_FNAME(zungqr       , ZUNGQR       )
#define PLASMA_ZUNMLQ_TILE          PLASMA_TILE_FNAME(zunmlq       , ZUNMLQ       )
#define PLASMA_ZUNMQR_TILE          PLASMA_TILE_FNAME(zunmqr       , ZUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
#define PLASMA_ZGEBRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgebrd       , ZGEBRD       )
#define PLASMA_ZGECON_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgecon       , ZGECON       )
#define PLASMA_ZGELQF_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgelqf       , ZGELQF       )
#define PLASMA_ZGELQS_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgelqs       , ZGELQS       )
#define PLASMA_ZGELS_TILE_ASYNC           PLASMA_ASYNC_FNAME(zgels        , ZGELS        )
#define PLASMA_ZGEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(zgemm        , ZGEMM        )
#define PLASMA_ZGEQP3_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgeqp3       , ZGEQP3       )
#define PLASMA_ZGEQRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgeqrf       , ZGEQRF       )
#define PLASMA_ZGEQRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgeqrs       , ZGEQRS       )
#define PLASMA_ZGESDD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgesdd       , ZGESDD       )
#define PLASMA_ZGESV_TILE_ASYNC           PLASMA_ASYNC_FNAME(zgesv        , ZGESV        )
#define PLASMA_ZGESV_INCPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(zgesv_incpiv , ZGESV_INCPIV )
#define PLASMA_ZGESVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgesvd       , ZGESVD       )
#define PLASMA_ZGETRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgetrf       , ZGETRF       )
#define PLASMA_ZGETRF_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(zgetrf_incpiv, ZGETRF_INCPIV)
#define PLASMA_ZGETRF_NOPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(zgetrf_nopiv , ZGETRF_NOPIV )
#define PLASMA_ZGETRF_TNTPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(zgetrf_tntpiv, ZGETRF_TNTPIV)
#define PLASMA_ZGETRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgetri       , ZGETRI       )
#define PLASMA_ZGETRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(zgetrs       , ZGETRS       )
#define PLASMA_ZGETRS_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(zgetrs_incpiv, ZGETRS_INCPIV)
#define PLASMA_ZHEEV_TILE_ASYNC           PLASMA_ASYNC_FNAME(zheev        , ZHEEV        )
#define PLASMA_ZHEEVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zheevd       , ZHEEVD       )
#define PLASMA_ZHEEVR_TILE_ASYNC          PLASMA_ASYNC_FNAME(zheevr       , ZHEEVR       )
#define PLASMA_ZHEGST_TILE_ASYNC          PLASMA_ASYNC_FNAME(zhegst       , ZHEGST       )
#define PLASMA_ZHEGV_TILE_ASYNC           PLASMA_ASYNC_FNAME(zhegv        , ZHEGV        )
#define PLASMA_ZHEGVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zhegvd       , ZHEGVD       )
#ifdef COMPLEX
#define PLASMA_ZHEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(zhemm        , ZHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_ZHER2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(zher2k       , ZHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_ZHERK_TILE_ASYNC           PLASMA_ASYNC_FNAME(zherk        , ZHERK        )
#endif
#define PLASMA_ZHETRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(zhetrd       , ZHETRD       )
#define PLASMA_ZLACPY_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlacpy       , ZLACPY       )
#define PLASMA_ZLANGE_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlange       , ZLANGE       )
#ifdef COMPLEX
#define PLASMA_ZLANHE_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlanhe       , ZLANHE       )
#endif
#define PLASMA_ZLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlansy       , ZLANSY       )
#define PLASMA_ZLANTR_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlantr       , ZLANTR       )
#define PLASMA_ZLASET_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlaset       , ZLASET       )
#define PLASMA_ZLASWP_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlaswp       , ZLASWP       )
#define PLASMA_ZLASWPC_TILE_ASYNC         PLASMA_ASYNC_FNAME(zlaswpc      , ZLASWPC      )
#define PLASMA_ZLAUUM_TILE_ASYNC          PLASMA_ASYNC_FNAME(zlauum       , ZLAUUM       )
#ifdef COMPLEX
#define PLASMA_ZPLGHE_TILE_ASYNC          PLASMA_ASYNC_FNAME(zplghe       , ZPLGHE       )
#endif
#define PLASMA_ZPLGSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(zplgsy       , ZPLGSY       )
#define PLASMA_ZPLRNT_TILE_ASYNC          PLASMA_ASYNC_FNAME(zplrnt       , ZPLRNT       )
#define PLASMA_ZPLTMG_TILE_ASYNC          PLASMA_ASYNC_FNAME(zpltmg       , ZPLTMG       )
#define PLASMA_ZPOCON_TILE_ASYNC          PLASMA_ASYNC_FNAME(zpocon       , ZPOCON       )
#define PLASMA_ZPOSV_TILE_ASYNC           PLASMA_ASYNC_FNAME(zposv        , ZPOSV        )
#define PLASMA_ZPOTRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(zpotrf       , ZPOTRF       )
#define PLASMA_ZPOTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(zpotri       , ZPOTRI       )
#define PLASMA_ZPOTRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(zpotrs       , ZPOTRS       )
#define PLASMA_ZSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(zsymm        , ZSYMM        )
#define PLASMA_ZSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(zsyr2k       , ZSYR2K       )
#define PLASMA_ZSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(zsyrk        , ZSYRK        )
#define PLASMA_ZTRMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ztrmm        , ZTRMM        )
#define PLASMA_ZTRSM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ztrsm        , ZTRSM        )
#define PLASMA_ZTRSMPL_TILE_ASYNC         PLASMA_ASYNC_FNAME(ztrsmpl      , ZTRSMPL      )
#define PLASMA_ZTRSMRV_TILE_ASYNC         PLASMA_ASYNC_FNAME(ztrsmrv      , ZTRSMRV      )
#define PLASMA_ZTRTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(ztrtri       , ZTRTRI       )
#define PLASMA_ZUNGLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(zunglq       , ZUNGLQ       )
#define PLASMA_ZUNGQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(zungqr       , ZUNGQR       )
#define PLASMA_ZUNMLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(zunmlq       , ZUNMLQ       )
#define PLASMA_ZUNMQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(zunmqr       , ZUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
#define PLASMA_ALLOC_WORKSPACE_ZGEBRD              PLASMA_WS_FNAME(zgebrd            , ZGEBRD            )
#define PLASMA_ALLOC_WORKSPACE_ZGEEV               PLASMA_WS_FNAME(zgeev             , ZGEEV             )
#define PLASMA_ALLOC_WORKSPACE_ZGEHRD              PLASMA_WS_FNAME(zgehrd            , ZGEHRD            )
#define PLASMA_ALLOC_WORKSPACE_ZGELQF              PLASMA_WS_FNAME(zgelqf            , ZGELQF            )
#define PLASMA_ALLOC_WORKSPACE_ZGELQF_TILE         PLASMA_WS_FNAME(zgelqf_tile       , ZGELQF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_ZGELS               PLASMA_WS_FNAME(zgels             , ZGELS             )
#define PLASMA_ALLOC_WORKSPACE_ZGELS_TILE          PLASMA_WS_FNAME(zgels_tile        , ZGELS_TILE        )
#define PLASMA_ALLOC_WORKSPACE_ZGEQRF              PLASMA_WS_FNAME(zgeqrf            , ZGEQRF            )
#define PLASMA_ALLOC_WORKSPACE_ZGEQRF_TILE         PLASMA_WS_FNAME(zgeqrf_tile       , ZGEQRF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_ZGESDD              PLASMA_WS_FNAME(zgesdd            , ZGESDD            )
#define PLASMA_ALLOC_WORKSPACE_ZGESV_INCPIV        PLASMA_WS_FNAME(zgesv_incpiv      , ZGESV_INCPIV      )
#define PLASMA_ALLOC_WORKSPACE_ZGESV_INCPIV_TILE   PLASMA_WS_FNAME(zgesv_incpiv_tile , ZGESV_INCPIV_TILE )
#define PLASMA_ALLOC_WORKSPACE_ZGESVD              PLASMA_WS_FNAME(zgesvd            , ZGESVD            )
#define PLASMA_ALLOC_WORKSPACE_ZGETRF_INCPIV       PLASMA_WS_FNAME(zgetrf_incpiv     , ZGETRF_INCPIV     )
#define PLASMA_ALLOC_WORKSPACE_ZGETRF_INCPIV_TILE  PLASMA_WS_FNAME(zgetrf_incpiv_tile, ZGETRF_INCPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_ZGETRF_TNTPIV_TILE  PLASMA_WS_FNAME(zgetrf_tntpiv_tile, ZGETRF_TNTPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_ZGETRI_TILE_ASYNC   PLASMA_WS_FNAME(zgetri_tile_async , ZGETRI_TILE_ASYNC )
#define PLASMA_ALLOC_WORKSPACE_ZHEEV               PLASMA_WS_FNAME(zheev             , ZHEEV             )
#define PLASMA_ALLOC_WORKSPACE_ZHEEVD              PLASMA_WS_FNAME(zheevd            , ZHEEVD            )
#define PLASMA_ALLOC_WORKSPACE_ZHEEVR              PLASMA_WS_FNAME(zheevr            , ZHEEVR            )
#define PLASMA_ALLOC_WORKSPACE_ZHEGV               PLASMA_WS_FNAME(zhegv             , ZHEGV             )
#define PLASMA_ALLOC_WORKSPACE_ZHEGVD              PLASMA_WS_FNAME(zhegvd            , ZHEGVD            )
#define PLASMA_ALLOC_WORKSPACE_ZHETRD              PLASMA_WS_FNAME(zhetrd            , ZHETRD            )



/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_ZLAPACK_TO_TILE(PLASMA_Complex64_t *Af77, int *LDA, PLASMA_desc **A, int *info)
{ *info = PLASMA_zLapack_to_Tile(Af77, *LDA, *A); }

void PLASMA_ZLAPACK_TO_TILE_ASYNC(PLASMA_Complex64_t *Af77, int *LDA, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zLapack_to_Tile_Async(Af77, *LDA, *A, sequence, request); }

void PLASMA_ZTILE_TO_LAPACK(PLASMA_desc **A, PLASMA_Complex64_t *Af77, int *LDA, int *info)
{ *info = PLASMA_zTile_to_Lapack(*A, Af77, *LDA); }

void PLASMA_ZTILE_TO_LAPACK_ASYNC(PLASMA_desc **A, PLASMA_Complex64_t *Af77, int *LDA, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zTile_to_Lapack_Async(*A, Af77, *LDA, sequence, request); }

void PLASMA_ZGEBRD(PLASMA_enum *jobq, PLASMA_enum *jobpt, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, double *D, double *E, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_Complex64_t *PT, int *LDPT, int *info)
{ *info = PLASMA_zgebrd(*jobq, *jobpt, *M, *N, A, *LDA, D, E, *descT, Q, *LDQ, PT, *LDPT); }

void PLASMA_ZGECFI(int *m, int *n, PLASMA_Complex64_t *A, PLASMA_enum *fin, int *imb, int *inb, PLASMA_enum *fout, int *omb, int *onb, int *info)
{ *info = PLASMA_zgecfi(*m, *n, A, *fin, *imb, *inb, *fout, *omb, *onb); }

void PLASMA_ZGECFI_ASYNC(int *m, int *n, PLASMA_Complex64_t *A, PLASMA_enum *f_in, int *imb, int *inb, PLASMA_enum *f_out, int *omb, int *onb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgecfi_Async(*m, *n, A, *f_in, *imb, *inb, *f_out, *omb, *onb, sequence, request); }

void PLASMA_ZGECON(PLASMA_enum *norm, int *N, PLASMA_Complex64_t *A, int *LDA, double *anorm, double *rcond, int *info)
{ *info = PLASMA_zgecon(*norm, *N, A, *LDA, *anorm, rcond); }

void PLASMA_ZGELQF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_zgelqf(*M, *N, A, *LDA, *descT); }

void PLASMA_ZGELQS(int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgelqs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgels(*trans, *M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_ZGEQP3(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, int *jpvt, PLASMA_Complex64_t *tau, PLASMA_Complex64_t *work, double *rwork, int *info)
{ *info = PLASMA_zgeqp3(*M, *N, A, *LDA, jpvt, tau, work, rwork); }

void PLASMA_ZGEQRF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_zgeqrf(*M, *N, A, *LDA, *descT); }

void PLASMA_ZGEQRS(int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgeqrs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZGESDD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, double *S, PLASMA_desc **descT, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, int *info)
{ *info = PLASMA_zgesdd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_ZGESV(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, int *IPIV, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgesv(*N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_ZGESV_INCPIV(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descL, int *IPIV, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgesv_incpiv(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_ZGESVD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, double *S, PLASMA_desc **descT, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, int *info)
{ *info = PLASMA_zgesvd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_ZGETMI(int *m, int *n, PLASMA_Complex64_t *A, PLASMA_enum *fin, int *mb, int *nb, int *info)
{ *info = PLASMA_zgetmi(*m, *n, A, *fin, *mb, *nb); }

void PLASMA_ZGETMI_ASYNC(int *m, int *n, PLASMA_Complex64_t *A, PLASMA_enum *f_in, int *mb, int *inb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetmi_Async(*m, *n, A, *f_in, *mb, *inb, sequence, request); }

void PLASMA_ZGETRF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_zgetrf(*M, *N, A, *LDA, IPIV); }

void PLASMA_ZGETRF_INCPIV(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descL, int *IPIV, int *info)
{ *info = PLASMA_zgetrf_incpiv(*M, *N, A, *LDA, *descL, IPIV); }

void PLASMA_ZGETRF_NOPIV(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_zgetrf_nopiv(*M, *N, A, *LDA); }

void PLASMA_ZGETRF_TNTPIV(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_zgetrf_tntpiv(*M, *N, A, *LDA, IPIV); }

void PLASMA_ZGETRI(int *N, PLASMA_Complex64_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_zgetri(*N, A, *LDA, IPIV); }

void PLASMA_ZGETRS(PLASMA_enum *trans, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, const int *IPIV, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgetrs(*trans, *N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_ZGETRS_INCPIV(PLASMA_enum *trans, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descL, const int *IPIV, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zgetrs_incpiv(*trans, *N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_ZHEEV(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *W, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheev(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_ZHEEVD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *W, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheevd(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_ZHEEVR(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheevr(*jobz, *range, *uplo, *N, A, *LDA, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, *descT, Q, *LDQ); }

void PLASMA_ZHEGST(PLASMA_enum *itype, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zhegst(*itype, *uplo, *N, A, *LDA, B, *LDB); }

void PLASMA_ZHEGV(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, double *W, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zhegv(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

void PLASMA_ZHEGVD(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, double *W, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zhegvd(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

#ifdef COMPLEX
void PLASMA_ZHEMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zhemm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_ZHER2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, double *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zher2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_ZHERK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, PLASMA_Complex64_t *A, int *LDA, double *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zherk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

void PLASMA_ZHETRD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *D, double *E, PLASMA_desc **descT, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zhetrd(*jobz, *uplo, *N, A, *LDA, D, E, *descT, Q, *LDQ); }

void PLASMA_ZLACPY(PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zlacpy(*uplo, *M, *N, A, *LDA, B, *LDB); }

void PLASMA_ZLANGE(PLASMA_enum *norm, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, double *result)
{ *result = PLASMA_zlange(*norm, *M, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_ZLANHE(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *result)
{ *result = PLASMA_zlanhe(*norm, *uplo, *N, A, *LDA); }
#endif

void PLASMA_ZLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *result)
{ *result = PLASMA_zlansy(*norm, *uplo, *N, A, *LDA); }

void PLASMA_ZLANTR(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, double *result)
{ *result = PLASMA_zlantr(*norm, *uplo, *diag, *M, *N, A, *LDA); }

void PLASMA_ZLASET(PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_zlaset(*uplo, *M, *N, *alpha, *beta, A, *LDA); }

void PLASMA_ZLASWP(int *N, PLASMA_Complex64_t *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_zlaswp(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_ZLASWPC(int *N, PLASMA_Complex64_t *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_zlaswpc(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_ZLAUUM(PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_zlauum(*uplo, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_ZPLGHE(double *bump, int *N, PLASMA_Complex64_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplghe(*bump, *N, A, *LDA, *seed); }
#endif

void PLASMA_ZPLGSY(PLASMA_Complex64_t *bump, int *N, PLASMA_Complex64_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplgsy(*bump, *N, A, *LDA, *seed); }

void PLASMA_ZPLRNT(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplrnt(*M, *N, A, *LDA, *seed); }

void PLASMA_ZPLTMG(PLASMA_enum *mtxtype, int *M, int *N, PLASMA_Complex64_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_zpltmg(*mtxtype, *M, *N, A, *LDA, *seed); }

void PLASMA_ZPOCON(PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, double *anorm, double *rcond, int *info)
{ *info = PLASMA_zpocon(*uplo, *N, A, *LDA, *anorm, rcond); }

void PLASMA_ZPOSV(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_ZPOTRF(PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_zpotrf(*uplo, *N, A, *LDA); }

void PLASMA_ZPOTRI(PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_zpotri(*uplo, *N, A, *LDA); }

void PLASMA_ZPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_ZSTEDC(PLASMA_enum *jobz, int *n, double *D, double *E, PLASMA_Complex64_t *Z, int *LDZ, int *info)
{ *info = PLASMA_zstedc(*jobz, *n, D, E, Z, *LDZ); }

void PLASMA_ZSTEDC_ASYNC(PLASMA_enum *jobz, int *n, double *D, double *E, PLASMA_Complex64_t *Z, int *LDZ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zstedc_Async(*jobz, *n, D, E, Z, *LDZ, sequence, request); }

void PLASMA_ZSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zsymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_ZSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zsyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_ZSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *beta, PLASMA_Complex64_t *C, int *LDC, int *info)
{ *info = PLASMA_zsyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

void PLASMA_ZTRMM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_ztrmm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_ZTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_ztrsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_ZTRSMPL(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descL, const int *IPIV, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_ztrsmpl(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_ZTRSMRV(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_ztrsmrv(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_ZTRTRI(PLASMA_enum *uplo, PLASMA_enum *diag, int *N, PLASMA_Complex64_t *A, int *LDA, int *info)
{ *info = PLASMA_ztrtri(*uplo, *diag, *N, A, *LDA); }

void PLASMA_ZUNGLQ(int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zunglq(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZUNGQR(int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zungqr(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZUNMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zunmlq(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_ZUNMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex64_t *B, int *LDB, int *info)
{ *info = PLASMA_zunmqr(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }


/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_ZGEBRD_TILE(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc **A, double *D, double *E, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_Complex64_t *PT, int *LDPT, int *info)
{ *info = PLASMA_zgebrd_Tile(*jobq, *jobpt, *A, D, E, *T, Q, *LDQ, PT, *LDPT); }

void PLASMA_ZGECON_TILE(PLASMA_enum *norm, PLASMA_desc **A, double *anorm, double *rcond, int *info)
{ *info = PLASMA_zgecon_Tile(*norm, *A, *anorm, rcond); }

void PLASMA_ZGELQF_TILE(PLASMA_desc **A, PLASMA_desc **T, int *info)
{ *info = PLASMA_zgelqf_Tile(*A, *T); }

void PLASMA_ZGELQS_TILE(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgelqs_Tile(*A, *T, *B); }

void PLASMA_ZGELS_TILE(PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgels_Tile(*trans, *A, *T, *B); }

void PLASMA_ZGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zgemm_Tile(*transA, *transB, *alpha, *A, *B, *beta, *C); }

void PLASMA_ZGEQP3_TILE(PLASMA_desc **A, int *jpvt, PLASMA_Complex64_t *tau, PLASMA_Complex64_t *work, double *rwork, int *info)
{ *info = PLASMA_zgeqp3_Tile(*A, jpvt, tau, work, rwork); }

void PLASMA_ZGEQRF_TILE(PLASMA_desc **A, PLASMA_desc **T, int *info)
{ *info = PLASMA_zgeqrf_Tile(*A, *T); }

void PLASMA_ZGEQRS_TILE(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgeqrs_Tile(*A, *T, *B); }

void PLASMA_ZGESDD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc **A, double *S, PLASMA_desc **T, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, int *info)
{ *info = PLASMA_zgesdd_Tile(*jobu, *jobvt, *A, S, *T, U, *LDU, VT, *LDVT); }

void PLASMA_ZGESV_TILE(PLASMA_desc **A, int *IPIV, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgesv_Tile(*A, IPIV, *B); }

void PLASMA_ZGESV_INCPIV_TILE(PLASMA_desc **A, PLASMA_desc **L, int *IPIV, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgesv_incpiv_Tile(*A, *L, IPIV, *B); }

void PLASMA_ZGESVD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc **A, double *S, PLASMA_desc **T, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, int *info)
{ *info = PLASMA_zgesvd_Tile(*jobu, *jobvt, *A, S, *T, U, *LDU, VT, *LDVT); }

void PLASMA_ZGETRF_TILE(PLASMA_desc **A, int *IPIV, int *info)
{ *info = PLASMA_zgetrf_Tile(*A, IPIV); }

void PLASMA_ZGETRF_INCPIV_TILE(PLASMA_desc **A, PLASMA_desc **L, int *IPIV, int *info)
{ *info = PLASMA_zgetrf_incpiv_Tile(*A, *L, IPIV); }

void PLASMA_ZGETRF_NOPIV_TILE(PLASMA_desc **A, int *info)
{ *info = PLASMA_zgetrf_nopiv_Tile(*A); }

void PLASMA_ZGETRF_TNTPIV_TILE(PLASMA_desc **A, int *IPIV, int *info)
{ *info = PLASMA_zgetrf_tntpiv_Tile(*A, IPIV); }

void PLASMA_ZGETRI_TILE(PLASMA_desc **A, int *IPIV, int *info)
{ *info = PLASMA_zgetri_Tile(*A, IPIV); }

void PLASMA_ZGETRS_TILE(PLASMA_enum *trans, PLASMA_desc **A, const int *IPIV, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgetrs_Tile(*trans, *A, IPIV, *B); }

void PLASMA_ZGETRS_INCPIV_TILE(PLASMA_desc **A, PLASMA_desc **L, const int *IPIV, PLASMA_desc **B, int *info)
{ *info = PLASMA_zgetrs_incpiv_Tile(*A, *L, IPIV, *B); }

void PLASMA_ZHEEV_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheev_Tile(*jobz, *uplo, *A, W, *T, Q, *LDQ); }

void PLASMA_ZHEEVD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheevd_Tile(*jobz, *uplo, *A, W, *T, Q, *LDQ); }

void PLASMA_ZHEEVR_TILE(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc **A, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zheevr_Tile(*jobz, *range, *uplo, *A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, *T, Q, *LDQ); }

void PLASMA_ZHEGST_TILE(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_zhegst_Tile(*itype, *uplo, *A, *B); }

void PLASMA_ZHEGV_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, double *W, PLASMA_desc **T, PLASMA_desc **Q, int *info)
{ *info = PLASMA_zhegv_Tile(*itype, *jobz, *uplo, *A, *B, W, *T, *Q); }

void PLASMA_ZHEGVD_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, double *W, PLASMA_desc **T, PLASMA_desc **Q, int *info)
{ *info = PLASMA_zhegvd_Tile(*itype, *jobz, *uplo, *A, *B, W, *T, *Q); }

#ifdef COMPLEX
void PLASMA_ZHEMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zhemm_Tile(*side, *uplo, *alpha, *A, *B, *beta, *C); }
#endif

#ifdef COMPLEX
void PLASMA_ZHER2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, double *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zher2k_Tile(*uplo, *trans, *alpha, *A, *B, *beta, *C); }
#endif

#ifdef COMPLEX
void PLASMA_ZHERK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc **A, double *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zherk_Tile(*uplo, *trans, *alpha, *A, *beta, *C); }
#endif

void PLASMA_ZHETRD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *D, double *E, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, int *info)
{ *info = PLASMA_zhetrd_Tile(*jobz, *uplo, *A, D, E, *T, Q, *LDQ); }

void PLASMA_ZLACPY_TILE(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_zlacpy_Tile(*uplo, *A, *B); }

void PLASMA_ZLANGE_TILE(PLASMA_enum *norm, PLASMA_desc **A, double *result)
{ *result = PLASMA_zlange_Tile(*norm, *A); }

#ifdef COMPLEX
void PLASMA_ZLANHE_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc **A, double *result)
{ *result = PLASMA_zlanhe_Tile(*norm, *uplo, *A); }
#endif

void PLASMA_ZLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc **A, double *result)
{ *result = PLASMA_zlansy_Tile(*norm, *uplo, *A); }

void PLASMA_ZLANTR_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc **A, double *result)
{ *result = PLASMA_zlantr_Tile(*norm, *uplo, *diag, *A); }

void PLASMA_ZLASET_TILE(PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *beta, PLASMA_desc **A, int *info)
{ *info = PLASMA_zlaset_Tile(*uplo, *alpha, *beta, *A); }

void PLASMA_ZLASWP_TILE(PLASMA_desc **A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_zlaswp_Tile(*A, *K1, *K2, IPIV, *INCX); }

void PLASMA_ZLASWPC_TILE(PLASMA_desc **A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_zlaswpc_Tile(*A, *K1, *K2, IPIV, *INCX); }

void PLASMA_ZLAUUM_TILE(PLASMA_enum *uplo, PLASMA_desc **A, int *info)
{ *info = PLASMA_zlauum_Tile(*uplo, *A); }

#ifdef COMPLEX
void PLASMA_ZPLGHE_TILE(double *bump, PLASMA_desc **A, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplghe_Tile(*bump, *A, *seed); }
#endif

void PLASMA_ZPLGSY_TILE(PLASMA_Complex64_t *bump, PLASMA_desc **A, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplgsy_Tile(*bump, *A, *seed); }

void PLASMA_ZPLRNT_TILE(PLASMA_desc **A, unsigned long long int *seed, int *info)
{ *info = PLASMA_zplrnt_Tile(*A, *seed); }

void PLASMA_ZPLTMG_TILE(PLASMA_enum *mtxtype, PLASMA_desc **A, unsigned long long int *seed, int *info)
{ *info = PLASMA_zpltmg_Tile(*mtxtype, *A, *seed); }

void PLASMA_ZPOCON_TILE(PLASMA_enum *uplo, PLASMA_desc **A, double *anorm, double *rcond, int *info)
{ *info = PLASMA_zpocon_Tile(*uplo, *A, *anorm, rcond); }

void PLASMA_ZPOSV_TILE(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_zposv_Tile(*uplo, *A, *B); }

void PLASMA_ZPOTRF_TILE(PLASMA_enum *uplo, PLASMA_desc **A, int *info)
{ *info = PLASMA_zpotrf_Tile(*uplo, *A); }

void PLASMA_ZPOTRI_TILE(PLASMA_enum *uplo, PLASMA_desc **A, int *info)
{ *info = PLASMA_zpotri_Tile(*uplo, *A); }

void PLASMA_ZPOTRS_TILE(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_zpotrs_Tile(*uplo, *A, *B); }

void PLASMA_ZSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zsymm_Tile(*side, *uplo, *alpha, *A, *B, *beta, *C); }

void PLASMA_ZSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zsyr2k_Tile(*uplo, *trans, *alpha, *A, *B, *beta, *C); }

void PLASMA_ZSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_Complex64_t *beta, PLASMA_desc **C, int *info)
{ *info = PLASMA_zsyrk_Tile(*uplo, *trans, *alpha, *A, *beta, *C); }

void PLASMA_ZTRMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_ztrmm_Tile(*side, *uplo, *transA, *diag, *alpha, *A, *B); }

void PLASMA_ZTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_ztrsm_Tile(*side, *uplo, *transA, *diag, *alpha, *A, *B); }

void PLASMA_ZTRSMPL_TILE(PLASMA_desc **A, PLASMA_desc **L, const int *IPIV, PLASMA_desc **B, int *info)
{ *info = PLASMA_ztrsmpl_Tile(*A, *L, IPIV, *B); }

void PLASMA_ZTRSMRV_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, int *info)
{ *info = PLASMA_ztrsmrv_Tile(*side, *uplo, *transA, *diag, *alpha, *A, *B); }

void PLASMA_ZTRTRI_TILE(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc **A, int *info)
{ *info = PLASMA_ztrtri_Tile(*uplo, *diag, *A); }

void PLASMA_ZUNGLQ_TILE(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zunglq_Tile(*A, *T, *B); }

void PLASMA_ZUNGQR_TILE(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zungqr_Tile(*A, *T, *B); }

void PLASMA_ZUNMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zunmlq_Tile(*side, *trans, *A, *T, *B); }

void PLASMA_ZUNMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, int *info)
{ *info = PLASMA_zunmqr_Tile(*side, *trans, *A, *T, *B); }


/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
void PLASMA_ZGEBRD_TILE_ASYNC(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc **A, double *S, double *E, PLASMA_desc **T, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgebrd_Tile_Async(*jobq, *jobpt, *A, S, E, *T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_ZGECON_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc **A, double *anorm, double *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgecon_Tile_Async(*norm, *A, *anorm, rcond, sequence, request); }

void PLASMA_ZGELQF_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgelqf_Tile_Async(*A, *T, sequence, request); }

void PLASMA_ZGELQS_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgelqs_Tile_Async(*A, *T, *B, sequence, request); }

void PLASMA_ZGELS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgels_Tile_Async(*trans, *A, *T, *B, sequence, request); }

void PLASMA_ZGEMM_TILE_ASYNC(PLASMA_enum *transA, PLASMA_enum *transB, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgemm_Tile_Async(*transA, *transB, *alpha, *A, *B, *beta, *C, sequence, request); }

void PLASMA_ZGEQP3_TILE_ASYNC(PLASMA_desc **A, int *jpvt, PLASMA_Complex64_t *tau, PLASMA_Complex64_t *work, double *rwork, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgeqp3_Tile_Async(*A, jpvt, tau, work, rwork, sequence, request); }

void PLASMA_ZGEQRF_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgeqrf_Tile_Async(*A, *T, sequence, request); }

void PLASMA_ZGEQRS_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgeqrs_Tile_Async(*A, *T, *B, sequence, request); }

void PLASMA_ZGESDD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc **A, double *S, PLASMA_desc **T, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgesdd_Tile_Async(*jobu, *jobvt, *A, S, *T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_ZGESV_TILE_ASYNC(PLASMA_desc **A, int *IPIV, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgesv_Tile_Async(*A, IPIV, *B, sequence, request); }

void PLASMA_ZGESV_INCPIV_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **L, int *IPIV, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgesv_incpiv_Tile_Async(*A, *L, IPIV, *B, sequence, request); }

void PLASMA_ZGESVD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc **A, double *S, PLASMA_desc **T, PLASMA_Complex64_t *U, int *LDU, PLASMA_Complex64_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgesvd_Tile_Async(*jobu, *jobvt, *A, S, *T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_ZGETRF_TILE_ASYNC(PLASMA_desc **A, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrf_Tile_Async(*A, IPIV, sequence, request); }

void PLASMA_ZGETRF_INCPIV_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **L, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrf_incpiv_Tile_Async(*A, *L, IPIV, sequence, request); }

void PLASMA_ZGETRF_NOPIV_TILE_ASYNC(PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrf_nopiv_Tile_Async(*A, sequence, request); }

void PLASMA_ZGETRF_TNTPIV_TILE_ASYNC(PLASMA_desc **A, int *IPIV, PLASMA_desc **W, int *Wpivot, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrf_tntpiv_Tile_Async(*A, IPIV, *W, Wpivot, sequence, request); }

void PLASMA_ZGETRI_TILE_ASYNC(PLASMA_desc **A, int *IPIV, PLASMA_desc **W, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetri_Tile_Async(*A, IPIV, *W, sequence, request); }

void PLASMA_ZGETRS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc **A, const int *IPIV, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrs_Tile_Async(*trans, *A, IPIV, *B, sequence, request); }

void PLASMA_ZGETRS_INCPIV_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **L, const int *IPIV, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zgetrs_incpiv_Tile_Async(*A, *L, IPIV, *B, sequence, request); }

void PLASMA_ZHEEV_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zheev_Tile_Async(*jobz, *uplo, *A, W, *T, Q, *LDQ, sequence, request); }

void PLASMA_ZHEEVD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zheevd_Tile_Async(*jobz, *uplo, *A, W, *T, Q, *LDQ, sequence, request); }

void PLASMA_ZHEEVR_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc **A, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zheevr_Tile_Async(*jobz, *range, *uplo, *A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, *T, Q, *LDQ, sequence, request); }

void PLASMA_ZHEGST_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zhegst_Tile_Async(*itype, *uplo, *A, *B, sequence, request); }

void PLASMA_ZHEGV_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, double *W, PLASMA_desc **T, PLASMA_desc **Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zhegv_Tile_Async(*itype, *jobz, *uplo, *A, *B, W, *T, *Q, sequence, request); }

void PLASMA_ZHEGVD_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, double *W, PLASMA_desc **T, PLASMA_desc **Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zhegvd_Tile_Async(*itype, *jobz, *uplo, *A, *B, W, *T, *Q, sequence, request); }

#ifdef COMPLEX
void PLASMA_ZHEMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zhemm_Tile_Async(*side, *uplo, *alpha, *A, *B, *beta, *C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_ZHER2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, double *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zher2k_Tile_Async(*uplo, *trans, *alpha, *A, *B, *beta, *C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_ZHERK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc **A, double *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zherk_Tile_Async(*uplo, *trans, *alpha, *A, *beta, *C, sequence, request); }
#endif

void PLASMA_ZHETRD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc **A, double *D, double *E, PLASMA_desc **T, PLASMA_Complex64_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zhetrd_Tile_Async(*jobz, *uplo, *A, D, E, *T, Q, *LDQ, sequence, request); }

void PLASMA_ZLACPY_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlacpy_Tile_Async(*uplo, *A, *B, sequence, request); }

void PLASMA_ZLANGE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc **A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlange_Tile_Async(*norm, *A, result, sequence, request); }

#ifdef COMPLEX
void PLASMA_ZLANHE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc **A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlanhe_Tile_Async(*norm, *uplo, *A, result, sequence, request); }
#endif

void PLASMA_ZLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc **A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlansy_Tile_Async(*norm, *uplo, *A, result, sequence, request); }

void PLASMA_ZLANTR_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc **A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlantr_Tile_Async(*norm, *uplo, *diag, *A, result, sequence, request); }

void PLASMA_ZLASET_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_Complex64_t *beta, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlaset_Tile_Async(*uplo, *alpha, *beta, *A, sequence, request); }

void PLASMA_ZLASWP_TILE_ASYNC(PLASMA_desc **A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlaswp_Tile_Async(*A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_ZLASWPC_TILE_ASYNC(PLASMA_desc **A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlaswpc_Tile_Async(*A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_ZLAUUM_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zlauum_Tile_Async(*uplo, *A, sequence, request); }

#ifdef COMPLEX
void PLASMA_ZPLGHE_TILE_ASYNC(double *bump, PLASMA_desc **A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zplghe_Tile_Async(*bump, *A, *seed, sequence, request); }
#endif

void PLASMA_ZPLGSY_TILE_ASYNC(PLASMA_Complex64_t *bump, PLASMA_desc **A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zplgsy_Tile_Async(*bump, *A, *seed, sequence, request); }

void PLASMA_ZPLRNT_TILE_ASYNC(PLASMA_desc **A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zplrnt_Tile_Async(*A, *seed, sequence, request); }

void PLASMA_ZPLTMG_TILE_ASYNC(PLASMA_enum *mtxtype, PLASMA_desc **A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zpltmg_Tile_Async(*mtxtype, *A, *seed, sequence, request); }

void PLASMA_ZPOCON_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, double *anorm, double *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zpocon_Tile_Async(*uplo, *A, *anorm, rcond, sequence, request); }

void PLASMA_ZPOSV_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zposv_Tile_Async(*uplo, *A, *B, sequence, request); }

void PLASMA_ZPOTRF_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zpotrf_Tile_Async(*uplo, *A, sequence, request); }

void PLASMA_ZPOTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zpotri_Tile_Async(*uplo, *A, sequence, request); }

void PLASMA_ZPOTRS_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zpotrs_Tile_Async(*uplo, *A, *B, sequence, request); }

void PLASMA_ZSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zsymm_Tile_Async(*side, *uplo, *alpha, *A, *B, *beta, *C, sequence, request); }

void PLASMA_ZSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_Complex64_t *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zsyr2k_Tile_Async(*uplo, *trans, *alpha, *A, *B, *beta, *C, sequence, request); }

void PLASMA_ZSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_Complex64_t *beta, PLASMA_desc **C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zsyrk_Tile_Async(*uplo, *trans, *alpha, *A, *beta, *C, sequence, request); }

void PLASMA_ZTRMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ztrmm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, *A, *B, sequence, request); }

void PLASMA_ZTRSM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ztrsm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, *A, *B, sequence, request); }

void PLASMA_ZTRSMPL_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **L, const int *IPIV, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ztrsmpl_Tile_Async(*A, *L, IPIV, *B, sequence, request); }

void PLASMA_ZTRSMRV_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex64_t *alpha, PLASMA_desc **A, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ztrsmrv_Tile_Async(*side, *uplo, *transA, *diag, *alpha, *A, *B, sequence, request); }

void PLASMA_ZTRTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc **A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ztrtri_Tile_Async(*uplo, *diag, *A, sequence, request); }

void PLASMA_ZUNGLQ_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zunglq_Tile_Async(*A, *T, *B, sequence, request); }

void PLASMA_ZUNGQR_TILE_ASYNC(PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zungqr_Tile_Async(*A, *T, *B, sequence, request); }

void PLASMA_ZUNMLQ_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zunmlq_Tile_Async(*side, *trans, *A, *T, *B, sequence, request); }

void PLASMA_ZUNMQR_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc **A, PLASMA_desc **T, PLASMA_desc **B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_zunmqr_Tile_Async(*side, *trans, *A, *T, *B, sequence, request); }


/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_ZGEBRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgebrd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGEEV(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgeev(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGEHRD(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgehrd(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGELQF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_zgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGELQF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgelqf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGELS(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_zgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGELS_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgels_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGEQRF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_zgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGEQRF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgeqrf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGESDD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgesdd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGESV_INCPIV(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_zgesv_incpiv(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_ZGESV_INCPIV_TILE (int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_zgesv_incpiv_Tile (*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_ZGESVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zgesvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZGETRF_INCPIV(int *M, int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_zgetrf_incpiv(*M, *N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_ZGETRF_INCPIV_TILE(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_zgetrf_incpiv_Tile(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_ZGETRF_TNTPIV_TILE(PLASMA_desc *A, PLASMA_desc *W, int **Wpivot, int *info)
{ *info = PLASMA_Alloc_Workspace_zgetrf_tntpiv_Tile(A, W, Wpivot); }

void PLASMA_ALLOC_WORKSPACE_ZGETRI_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *W, int *info)
{ *info = PLASMA_Alloc_Workspace_zgetri_Tile_Async(A, W); }

void PLASMA_ALLOC_WORKSPACE_ZHEEV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zheev(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZHEEVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zheevd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZHEEVR(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zheevr(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZHEGV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zhegv(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZHEGVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zhegvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_ZHETRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_zhetrd(*M, *N, descT); }



