/**
 *
 * @generated s Sun Mar  1 20:23:24 2015
 *
 **/
#define _TYPE  float
#define _PREC  float
#define _LAMCH LAPACKE_slamch_work

#define _NAME  "PLASMA_ssyevd_Tile"
/* See Lawn 41 page 120 */
#define _FMULS ((2. / 3.) * ((float)N * (float)N * (float)N))
#define _FADDS ((2. / 3.) * ((float)N * (float)N * (float)N))

#include "./timing.c"

static int
RunTest(int *iparam, float *dparam, real_Double_t *t_)
{
    PASTE_CODE_IPARAM_LOCALS( iparam );
    PLASMA_desc *descT;
    int LDQ;
    int uplo = PlasmaLower;
    int vec  = PlasmaVec;
    int INFO;

    int mode = iparam[IPARAM_MODE];
    float dmax  = 1.0;
    float rcond = 1.0e6;
    int i;

    LDA = max(LDA, N);
    LDQ = N;

    /* Allocate Data */
    PASTE_CODE_ALLOCATE_MATRIX( A, 1, float, LDA, N);
    PASTE_CODE_ALLOCATE_MATRIX( Q, (vec == PlasmaVec), float, LDA, N );
    PASTE_CODE_ALLOCATE_MATRIX( W, 1, float, N, 1 );
    PASTE_CODE_ALLOCATE_MATRIX( S, 1, float, N, 1 );

    /* Set Q to 0. */
    if (vec == PlasmaVec) {
        memset(Q,0,LDQ*N*sizeof(float));
    }

    float *work = (float *)malloc(3*N* sizeof(float));
    INFO = LAPACKE_slatms_work( LAPACK_COL_MAJOR, N, N,
                                lapack_const(PlasmaDistSymmetric), ISEED,
                                lapack_const(PlasmaHermGeev), W, mode, rcond,
                                dmax, N, N,
                                lapack_const(PlasmaNoPacking), A, LDA, work );

    LAPACKE_slasrt_work('I', N, W);

    /* Allocate Workspace */
    PLASMA_Alloc_Workspace_ssyevd(N, N, &descT);

    START_TIMING();
    INFO = PLASMA_ssyevd(vec, uplo, N, A, LDA, S, descT, Q, LDQ);
    STOP_TIMING();

    if(INFO!=0){
        printf(" ERROR OCCURED INFO %d\n",INFO);
    }

    /* Check the solution */
    if ( check ){
        for (i=0; i<N; i++){
            if (fabs(W[i]-S[i]) > 0.001){
                printf("ERROR OCCURED %f %f\n", W[i], S[i]);
            }
        }
    }

    /* DeAllocate Workspace */
    PLASMA_Dealloc_Handle_Tile(&descT);

    if (vec == PlasmaVec) {
        free( Q );
    }
    free( A );
    free( W );
    free( work );
    return 0;
}
