!
!     Copyright © 2011 The Numerical Algorithms Group Ltd. All rights reserved.
!
!     Redistribution and use in source and binary forms, with or without
!     modification, are permitted provided that the following conditions are
!     met:
!     - Redistributions of source code must retain the above copyright notice,
!       this list of conditions, and the following disclaimer.
!     - Redistributions in binary form must reproduce the above copyright
!       notice, this list of conditions and the following disclaimer listed in
!       this license in the documentation and/or other materials provided with
!       the distribution.
!     - Neither the name of the copyright holders nor the names of its
!       contributors may be used to endorse or promote products derived from
!       this software without specific prior written permission.
!
!     This software is provided by the copyright holders and contributors "as
!     is" and any express or implied warranties, including, but not limited
!     to, the implied warranties of merchantability and fitness for a
!     particular purpose are disclaimed. in no event shall the copyright owner
!     or contributors be liable for any direct, indirect, incidental, special,
!     exemplary, or consequential damages (including, but not limited to,
!     procurement of substitute goods or services; loss of use, data, or
!     profits; or business interruption) however caused and on any theory of
!     liability, whether in contract, strict liability, or tort (including
!     negligence or otherwise) arising in any way out of the use of this
!     software, even if advised of the possibility of such damage.
!
!
! @file plasma_df90.F90
!
!  PLASMA Fortran 90 interfaces using Fortran 2003 ISO C bindings
!  PLASMA is a software package provided by Univ. of Tennessee,
!  Univ. of California Berkeley and Univ. of Colorado Denver
!
!  WARNING: This file is automatically generated through
!  tools/genf90interface.pl script, please do not manually edit it.
!
! @version 2.7.0
! @author Numerical Algorithms Group
! @author Mathieu Faverge
! @date 2011-12-15
! @generated d Sun Mar  1 20:23:15 2015
!
#define PRECISION_d

module plasma_d
    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (simple interface)
    !
      interface
         function PLASMA_dLapack_to_Tile_c(Af77,LDA,A) &
          & bind(c, name='PLASMA_dLapack_to_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dLapack_to_Tile_c
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: A
          end function PLASMA_dLapack_to_Tile_c
      end interface

      interface
         function PLASMA_dLapack_to_Tile_Async_c(Af77,LDA,A,sequence,request) &
          & bind(c, name='PLASMA_dLapack_to_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dLapack_to_Tile_Async_c
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dLapack_to_Tile_Async_c
      end interface

      interface
         function PLASMA_dTile_to_Lapack_c(A,Af77,LDA) &
          & bind(c, name='PLASMA_dTile_to_Lapack')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dTile_to_Lapack_c
            type(c_ptr), value :: A
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
          end function PLASMA_dTile_to_Lapack_c
      end interface

      interface
         function PLASMA_dTile_to_Lapack_Async_c(A,Af77,LDA,sequence,request) &
          & bind(c, name='PLASMA_dTile_to_Lapack_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dTile_to_Lapack_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dTile_to_Lapack_Async_c
      end interface

      interface
         function PLASMA_dgebrd_c(jobq,jobpt,M,N,A,LDA,D,E,descT,Q,LDQ,PT,LDPT) &
          & bind(c, name='PLASMA_dgebrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgebrd_c
            integer(kind=c_int), value :: jobq
            integer(kind=c_int), value :: jobpt
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: PT
            integer(kind=c_int), value :: LDPT
          end function PLASMA_dgebrd_c
      end interface

      interface
         function PLASMA_dgecfi_c(m,n,A,fin,imb,inb,fout,omb,onb) &
          & bind(c, name='PLASMA_dgecfi')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgecfi_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: fin
            integer(kind=c_int), value :: imb
            integer(kind=c_int), value :: inb
            integer(kind=c_int), value :: fout
            integer(kind=c_int), value :: omb
            integer(kind=c_int), value :: onb
          end function PLASMA_dgecfi_c
      end interface

      interface
         function PLASMA_dgecfi_Async_c(m,n,A,f_in,imb,inb,f_out,omb,onb,sequence,request) &
          & bind(c, name='PLASMA_dgecfi_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgecfi_Async_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: f_in
            integer(kind=c_int), value :: imb
            integer(kind=c_int), value :: inb
            integer(kind=c_int), value :: f_out
            integer(kind=c_int), value :: omb
            integer(kind=c_int), value :: onb
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgecfi_Async_c
      end interface

      interface
         function PLASMA_dgecon_c(norm,N,A,LDA,anorm,rcond) &
          & bind(c, name='PLASMA_dgecon')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgecon_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
          end function PLASMA_dgecon_c
      end interface

      interface
         function PLASMA_dgelqf_c(M,N,A,LDA,descT) &
          & bind(c, name='PLASMA_dgelqf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
          end function PLASMA_dgelqf_c
      end interface

      interface
         function PLASMA_dgelqs_c(M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dgelqs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqs_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgelqs_c
      end interface

      interface
         function PLASMA_dgels_c(trans,M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dgels')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgels_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgels_c
      end interface

      interface
         function PLASMA_dgemm_c(transA,transB,M,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_dgemm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgemm_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dgemm_c
      end interface

      interface
         function PLASMA_dgeqp3_c(M,N,A,LDA,jpvt,tau,work,rwork) &
          & bind(c, name='PLASMA_dgeqp3')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqp3_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: jpvt
            type(c_ptr), value :: tau
            type(c_ptr), value :: work
            type(c_ptr), value :: rwork
          end function PLASMA_dgeqp3_c
      end interface

      interface
         function PLASMA_dgeqrf_c(M,N,A,LDA,descT) &
          & bind(c, name='PLASMA_dgeqrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
          end function PLASMA_dgeqrf_c
      end interface

      interface
         function PLASMA_dgeqrs_c(M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dgeqrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrs_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgeqrs_c
      end interface

      interface
         function PLASMA_dgesdd_c(jobu,jobvt,M,N,A,LDA,S,descT,U,LDU,VT,LDVT) &
          & bind(c, name='PLASMA_dgesdd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesdd_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: S
            type(c_ptr), value :: descT
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
          end function PLASMA_dgesdd_c
      end interface

      interface
         function PLASMA_dgesv_c(N,NRHS,A,LDA,IPIV,B,LDB) &
          & bind(c, name='PLASMA_dgesv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgesv_c
      end interface

      interface
         function PLASMA_dgesv_incpiv_c(N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_dgesv_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_incpiv_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgesv_incpiv_c
      end interface

      interface
         function PLASMA_dgesvd_c(jobu,jobvt,M,N,A,LDA,S,descT,U,LDU,VT,LDVT) &
          & bind(c, name='PLASMA_dgesvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesvd_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: S
            type(c_ptr), value :: descT
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
          end function PLASMA_dgesvd_c
      end interface

      interface
         function PLASMA_dgetmi_c(m,n,A,fin,mb,nb) &
          & bind(c, name='PLASMA_dgetmi')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetmi_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: fin
            integer(kind=c_int), value :: mb
            integer(kind=c_int), value :: nb
          end function PLASMA_dgetmi_c
      end interface

      interface
         function PLASMA_dgetmi_Async_c(m,n,A,f_in,mb,inb,sequence,request) &
          & bind(c, name='PLASMA_dgetmi_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetmi_Async_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: f_in
            integer(kind=c_int), value :: mb
            integer(kind=c_int), value :: inb
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetmi_Async_c
      end interface

      interface
         function PLASMA_dgetrf_c(M,N,A,LDA,IPIV) &
          & bind(c, name='PLASMA_dgetrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_c
      end interface

      interface
         function PLASMA_dgetrf_incpiv_c(M,N,A,LDA,descL,IPIV) &
          & bind(c, name='PLASMA_dgetrf_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_incpiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_incpiv_c
      end interface

      interface
         function PLASMA_dgetrf_nopiv_c(M,N,A,LDA) &
          & bind(c, name='PLASMA_dgetrf_nopiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_nopiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dgetrf_nopiv_c
      end interface

      interface
         function PLASMA_dgetrf_tntpiv_c(M,N,A,LDA,IPIV) &
          & bind(c, name='PLASMA_dgetrf_tntpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_tntpiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_tntpiv_c
      end interface

      interface
         function PLASMA_dgetri_c(N,A,LDA,IPIV) &
          & bind(c, name='PLASMA_dgetri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetri_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetri_c
      end interface

      interface
         function PLASMA_dgetrs_c(trans,N,NRHS,A,LDA,IPIV,B,LDB) &
          & bind(c, name='PLASMA_dgetrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgetrs_c
      end interface

      interface
         function PLASMA_dgetrs_incpiv_c(trans,N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_dgetrs_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_incpiv_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dgetrs_incpiv_c
      end interface

      interface
         function PLASMA_dsyev_c(jobz,uplo,N,A,LDA,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsyev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyev_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyev_c
      end interface

      interface
         function PLASMA_dsyevd_c(jobz,uplo,N,A,LDA,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsyevd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevd_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyevd_c
      end interface

      interface
         function PLASMA_dsyevr_c(jobz,range,uplo,N,A,LDA,vl,vu,il,iu,abstol,nbcomputedeig,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsyevr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevr_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: range
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_double), value :: vl
            real(kind=c_double), value :: vu
            integer(kind=c_int), value :: il
            integer(kind=c_int), value :: iu
            real(kind=c_double), value :: abstol
            type(c_ptr), value :: nbcomputedeig
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyevr_c
      end interface

      interface
         function PLASMA_dsygst_c(itype,uplo,N,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dsygst')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygst_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dsygst_c
      end interface

      interface
         function PLASMA_dsygv_c(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsygv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygv_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsygv_c
      end interface

      interface
         function PLASMA_dsygvd_c(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsygvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygvd_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsygvd_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsymm_c(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_dsymm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsymm_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyr2k_c(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_dsyr2k')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsyr2k_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyrk_c(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC) &
          & bind(c, name='PLASMA_dsyrk')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsyrk_c
      end interface
#endif

      interface
         function PLASMA_dsytrd_c(jobz,uplo,N,A,LDA,D,E,descT,Q,LDQ) &
          & bind(c, name='PLASMA_dsytrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsytrd_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsytrd_c
      end interface

      interface
         function PLASMA_dlacpy_c(uplo,M,N,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dlacpy')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlacpy_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dlacpy_c
      end interface

      interface
         function PLASMA_dlange_c(norm,M,N,A,LDA) &
          & bind(c, name='PLASMA_dlange')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlange_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlange_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dlansy_c(norm,uplo,N,A,LDA) &
          & bind(c, name='PLASMA_dlansy')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlansy_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlansy_c
      end interface
#endif

      interface
         function PLASMA_dlansy_c(norm,uplo,N,A,LDA) &
          & bind(c, name='PLASMA_dlansy')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlansy_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlansy_c
      end interface

      interface
         function PLASMA_dlantr_c(norm,uplo,diag,M,N,A,LDA) &
          & bind(c, name='PLASMA_dlantr')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlantr_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlantr_c
      end interface

      interface
         function PLASMA_dlaset_c(uplo,M,N,alpha,beta,A,LDA) &
          & bind(c, name='PLASMA_dlaset')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaset_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            real(kind=c_double), value :: alpha
            real(kind=c_double), value :: beta
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlaset_c
      end interface

      interface
         function PLASMA_dlaswp_c(N,A,LDA,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_dlaswp')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswp_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_dlaswp_c
      end interface

      interface
         function PLASMA_dlaswpc_c(N,A,LDA,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_dlaswpc')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswpc_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_dlaswpc_c
      end interface

      interface
         function PLASMA_dlauum_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_dlauum')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlauum_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dlauum_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dplgsy_c(bump,N,A,LDA,seed) &
          & bind(c, name='PLASMA_dplgsy')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_c
            real(kind=c_double), value :: bump
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplgsy_c
      end interface
#endif

      interface
         function PLASMA_dplgsy_c(bump,N,A,LDA,seed) &
          & bind(c, name='PLASMA_dplgsy')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_c
            real(kind=c_double), value :: bump
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplgsy_c
      end interface

      interface
         function PLASMA_dplrnt_c(M,N,A,LDA,seed) &
          & bind(c, name='PLASMA_dplrnt')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplrnt_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplrnt_c
      end interface

      interface
         function PLASMA_dpltmg_c(mtxtype,M,N,A,LDA,seed) &
          & bind(c, name='PLASMA_dpltmg')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpltmg_c
            integer(kind=c_int), value :: mtxtype
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dpltmg_c
      end interface

      interface
         function PLASMA_dpocon_c(uplo,N,A,LDA,anorm,rcond) &
          & bind(c, name='PLASMA_dpocon')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpocon_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
          end function PLASMA_dpocon_c
      end interface

      interface
         function PLASMA_dposv_c(uplo,N,NRHS,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dposv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dposv_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dposv_c
      end interface

      interface
         function PLASMA_dpotrf_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_dpotrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrf_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dpotrf_c
      end interface

      interface
         function PLASMA_dpotri_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_dpotri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotri_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dpotri_c
      end interface

      interface
         function PLASMA_dpotrs_c(uplo,N,NRHS,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dpotrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrs_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dpotrs_c
      end interface

      interface
         function PLASMA_dsymm_c(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_dsymm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsymm_c
      end interface

      interface
         function PLASMA_dsyr2k_c(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_dsyr2k')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsyr2k_c
      end interface

      interface
         function PLASMA_dsyrk_c(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC) &
          & bind(c, name='PLASMA_dsyrk')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_dsyrk_c
      end interface

      interface
         function PLASMA_dtrmm_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dtrmm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrmm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dtrmm_c
      end interface

      interface
         function PLASMA_dtrsm_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dtrsm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dtrsm_c
      end interface

      interface
         function PLASMA_dtrsmpl_c(N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_dtrsmpl')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmpl_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dtrsmpl_c
      end interface

      interface
         function PLASMA_dtrsmrv_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_dtrsmrv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmrv_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dtrsmrv_c
      end interface

      interface
         function PLASMA_dtrtri_c(uplo,diag,N,A,LDA) &
          & bind(c, name='PLASMA_dtrtri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrtri_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_dtrtri_c
      end interface

      interface
         function PLASMA_dorglq_c(M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dorglq')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorglq_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dorglq_c
      end interface

      interface
         function PLASMA_dorgqr_c(M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dorgqr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorgqr_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dorgqr_c
      end interface

      interface
         function PLASMA_dormlq_c(side,trans,M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dormlq')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormlq_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dormlq_c
      end interface

      interface
         function PLASMA_dormqr_c(side,trans,M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_dormqr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormqr_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_dormqr_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (native interface)
    !
      interface
         function PLASMA_dgebrd_Tile_c(jobq,jobpt,A,D,E,T,Q,LDQ,PT,LDPT) &
          & bind(c, name='PLASMA_dgebrd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgebrd_Tile_c
            integer(kind=c_int), value :: jobq
            integer(kind=c_int), value :: jobpt
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: PT
            integer(kind=c_int), value :: LDPT
          end function PLASMA_dgebrd_Tile_c
      end interface

      interface
         function PLASMA_dgecon_Tile_c(norm,A,anorm,rcond) &
          & bind(c, name='PLASMA_dgecon_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgecon_Tile_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
          end function PLASMA_dgecon_Tile_c
      end interface

      interface
         function PLASMA_dgelqf_Tile_c(A,T) &
          & bind(c, name='PLASMA_dgelqf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
          end function PLASMA_dgelqf_Tile_c
      end interface

      interface
         function PLASMA_dgelqs_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_dgelqs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqs_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dgelqs_Tile_c
      end interface

      interface
         function PLASMA_dgels_Tile_c(trans,A,T,B) &
          & bind(c, name='PLASMA_dgels_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgels_Tile_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dgels_Tile_c
      end interface

      interface
         function PLASMA_dgemm_Tile_c(transA,transB,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_dgemm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgemm_Tile_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dgemm_Tile_c
      end interface

      interface
         function PLASMA_dgeqp3_Tile_c(A,jpvt,tau,work,rwork) &
          & bind(c, name='PLASMA_dgeqp3_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqp3_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: jpvt
            type(c_ptr), value :: tau
            type(c_ptr), value :: work
            type(c_ptr), value :: rwork
          end function PLASMA_dgeqp3_Tile_c
      end interface

      interface
         function PLASMA_dgeqrf_Tile_c(A,T) &
          & bind(c, name='PLASMA_dgeqrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
          end function PLASMA_dgeqrf_Tile_c
      end interface

      interface
         function PLASMA_dgeqrs_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_dgeqrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrs_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dgeqrs_Tile_c
      end interface

      interface
         function PLASMA_dgesdd_Tile_c(jobu,jobvt,A,S,T,U,LDU,VT,LDVT) &
          & bind(c, name='PLASMA_dgesdd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesdd_Tile_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: T
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
          end function PLASMA_dgesdd_Tile_c
      end interface

      interface
         function PLASMA_dgesv_Tile_c(A,IPIV,B) &
          & bind(c, name='PLASMA_dgesv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_dgesv_Tile_c
      end interface

      interface
         function PLASMA_dgesv_incpiv_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_dgesv_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_dgesv_incpiv_Tile_c
      end interface

      interface
         function PLASMA_dgesvd_Tile_c(jobu,jobvt,A,S,T,U,LDU,VT,LDVT) &
          & bind(c, name='PLASMA_dgesvd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesvd_Tile_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: T
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
          end function PLASMA_dgesvd_Tile_c
      end interface

      interface
         function PLASMA_dgetrf_Tile_c(A,IPIV) &
          & bind(c, name='PLASMA_dgetrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_Tile_c
      end interface

      interface
         function PLASMA_dgetrf_incpiv_Tile_c(A,L,IPIV) &
          & bind(c, name='PLASMA_dgetrf_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_incpiv_Tile_c
      end interface

      interface
         function PLASMA_dgetrf_nopiv_Tile_c(A) &
          & bind(c, name='PLASMA_dgetrf_nopiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_nopiv_Tile_c
            type(c_ptr), value :: A
          end function PLASMA_dgetrf_nopiv_Tile_c
      end interface

      interface
         function PLASMA_dgetrf_tntpiv_Tile_c(A,IPIV) &
          & bind(c, name='PLASMA_dgetrf_tntpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_tntpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetrf_tntpiv_Tile_c
      end interface

      interface
         function PLASMA_dgetri_Tile_c(A,IPIV) &
          & bind(c, name='PLASMA_dgetri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetri_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
          end function PLASMA_dgetri_Tile_c
      end interface

      interface
         function PLASMA_dgetrs_Tile_c(trans,A,IPIV,B) &
          & bind(c, name='PLASMA_dgetrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_Tile_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_dgetrs_Tile_c
      end interface

      interface
         function PLASMA_dgetrs_incpiv_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_dgetrs_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_dgetrs_incpiv_Tile_c
      end interface

      interface
         function PLASMA_dsyev_Tile_c(jobz,uplo,A,W,T,Q,LDQ) &
          & bind(c, name='PLASMA_dsyev_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyev_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyev_Tile_c
      end interface

      interface
         function PLASMA_dsyevd_Tile_c(jobz,uplo,A,W,T,Q,LDQ) &
          & bind(c, name='PLASMA_dsyevd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevd_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyevd_Tile_c
      end interface

      interface
         function PLASMA_dsyevr_Tile_c(jobz,range,uplo,A,vl,vu,il,iu,abstol,nbcomputedeig,W,T,Q,LDQ) &
          & bind(c, name='PLASMA_dsyevr_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevr_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: range
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            real(kind=c_double), value :: vl
            real(kind=c_double), value :: vu
            integer(kind=c_int), value :: il
            integer(kind=c_int), value :: iu
            real(kind=c_double), value :: abstol
            type(c_ptr), value :: nbcomputedeig
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsyevr_Tile_c
      end interface

      interface
         function PLASMA_dsygst_Tile_c(itype,uplo,A,B) &
          & bind(c, name='PLASMA_dsygst_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygst_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dsygst_Tile_c
      end interface

      interface
         function PLASMA_dsygv_Tile_c(itype,jobz,uplo,A,B,W,T,Q) &
          & bind(c, name='PLASMA_dsygv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygv_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
          end function PLASMA_dsygv_Tile_c
      end interface

      interface
         function PLASMA_dsygvd_Tile_c(itype,jobz,uplo,A,B,W,T,Q) &
          & bind(c, name='PLASMA_dsygvd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygvd_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
          end function PLASMA_dsygvd_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsymm_Tile_c(side,uplo,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_dsymm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsymm_Tile_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_dsyr2k_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsyr2k_Tile_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyrk_Tile_c(uplo,trans,alpha,A,beta,C) &
          & bind(c, name='PLASMA_dsyrk_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsyrk_Tile_c
      end interface
#endif

      interface
         function PLASMA_dsytrd_Tile_c(jobz,uplo,A,D,E,T,Q,LDQ) &
          & bind(c, name='PLASMA_dsytrd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsytrd_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_dsytrd_Tile_c
      end interface

      interface
         function PLASMA_dlacpy_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_dlacpy_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlacpy_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dlacpy_Tile_c
      end interface

      interface
         function PLASMA_dlange_Tile_c(norm,A) &
          & bind(c, name='PLASMA_dlange_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlange_Tile_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
          end function PLASMA_dlange_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dlansy_Tile_c(norm,uplo,A) &
          & bind(c, name='PLASMA_dlansy_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlansy_Tile_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_dlansy_Tile_c
      end interface
#endif

      interface
         function PLASMA_dlansy_Tile_c(norm,uplo,A) &
          & bind(c, name='PLASMA_dlansy_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlansy_Tile_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_dlansy_Tile_c
      end interface

      interface
         function PLASMA_dlantr_Tile_c(norm,uplo,diag,A) &
          & bind(c, name='PLASMA_dlantr_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_double) :: PLASMA_dlantr_Tile_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
          end function PLASMA_dlantr_Tile_c
      end interface

      interface
         function PLASMA_dlaset_Tile_c(uplo,alpha,beta,A) &
          & bind(c, name='PLASMA_dlaset_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaset_Tile_c
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            real(kind=c_double), value :: beta
            type(c_ptr), value :: A
          end function PLASMA_dlaset_Tile_c
      end interface

      interface
         function PLASMA_dlaswp_Tile_c(A,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_dlaswp_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswp_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_dlaswp_Tile_c
      end interface

      interface
         function PLASMA_dlaswpc_Tile_c(A,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_dlaswpc_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswpc_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_dlaswpc_Tile_c
      end interface

      interface
         function PLASMA_dlauum_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_dlauum_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlauum_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_dlauum_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dplgsy_Tile_c(bump,A,seed) &
          & bind(c, name='PLASMA_dplgsy_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_Tile_c
            real(kind=c_double), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplgsy_Tile_c
      end interface
#endif

      interface
         function PLASMA_dplgsy_Tile_c(bump,A,seed) &
          & bind(c, name='PLASMA_dplgsy_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_Tile_c
            real(kind=c_double), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplgsy_Tile_c
      end interface

      interface
         function PLASMA_dplrnt_Tile_c(A,seed) &
          & bind(c, name='PLASMA_dplrnt_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplrnt_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dplrnt_Tile_c
      end interface

      interface
         function PLASMA_dpltmg_Tile_c(mtxtype,A,seed) &
          & bind(c, name='PLASMA_dpltmg_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpltmg_Tile_c
            integer(kind=c_int), value :: mtxtype
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_dpltmg_Tile_c
      end interface

      interface
         function PLASMA_dpocon_Tile_c(uplo,A,anorm,rcond) &
          & bind(c, name='PLASMA_dpocon_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpocon_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
          end function PLASMA_dpocon_Tile_c
      end interface

      interface
         function PLASMA_dposv_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_dposv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dposv_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dposv_Tile_c
      end interface

      interface
         function PLASMA_dpotrf_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_dpotrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrf_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_dpotrf_Tile_c
      end interface

      interface
         function PLASMA_dpotri_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_dpotri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotri_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_dpotri_Tile_c
      end interface

      interface
         function PLASMA_dpotrs_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_dpotrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrs_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dpotrs_Tile_c
      end interface

      interface
         function PLASMA_dsymm_Tile_c(side,uplo,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_dsymm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsymm_Tile_c
      end interface

      interface
         function PLASMA_dsyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_dsyr2k_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsyr2k_Tile_c
      end interface

      interface
         function PLASMA_dsyrk_Tile_c(uplo,trans,alpha,A,beta,C) &
          & bind(c, name='PLASMA_dsyrk_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_dsyrk_Tile_c
      end interface

      interface
         function PLASMA_dtrmm_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_dtrmm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrmm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dtrmm_Tile_c
      end interface

      interface
         function PLASMA_dtrsm_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_dtrsm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dtrsm_Tile_c
      end interface

      interface
         function PLASMA_dtrsmpl_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_dtrsmpl_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmpl_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_dtrsmpl_Tile_c
      end interface

      interface
         function PLASMA_dtrsmrv_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_dtrsmrv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmrv_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_dtrsmrv_Tile_c
      end interface

      interface
         function PLASMA_dtrtri_Tile_c(uplo,diag,A) &
          & bind(c, name='PLASMA_dtrtri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrtri_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
          end function PLASMA_dtrtri_Tile_c
      end interface

      interface
         function PLASMA_dorglq_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_dorglq_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorglq_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dorglq_Tile_c
      end interface

      interface
         function PLASMA_dorgqr_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_dorgqr_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorgqr_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dorgqr_Tile_c
      end interface

      interface
         function PLASMA_dormlq_Tile_c(side,trans,A,T,B) &
          & bind(c, name='PLASMA_dormlq_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormlq_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dormlq_Tile_c
      end interface

      interface
         function PLASMA_dormqr_Tile_c(side,trans,A,T,B) &
          & bind(c, name='PLASMA_dormqr_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormqr_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_dormqr_Tile_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (asynchronous interface)
    !
      interface
         function PLASMA_dgebrd_Tile_Async_c(jobq,jobpt,A,S,E,T,U,LDU,VT,LDVT,sequence,request) &
          & bind(c, name='PLASMA_dgebrd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgebrd_Tile_Async_c
            integer(kind=c_int), value :: jobq
            integer(kind=c_int), value :: jobpt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgebrd_Tile_Async_c
      end interface

      interface
         function PLASMA_dgecon_Tile_Async_c(norm,A,anorm,rcond,sequence,request) &
          & bind(c, name='PLASMA_dgecon_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgecon_Tile_Async_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgecon_Tile_Async_c
      end interface

      interface
         function PLASMA_dgelqf_Tile_Async_c(A,T,sequence,request) &
          & bind(c, name='PLASMA_dgelqf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgelqf_Tile_Async_c
      end interface

      interface
         function PLASMA_dgelqs_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dgelqs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgelqs_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgelqs_Tile_Async_c
      end interface

      interface
         function PLASMA_dgels_Tile_Async_c(trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dgels_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgels_Tile_Async_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgels_Tile_Async_c
      end interface

      interface
         function PLASMA_dgemm_Tile_Async_c(transA,transB,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dgemm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgemm_Tile_Async_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgemm_Tile_Async_c
      end interface

      interface
         function PLASMA_dgeqp3_Tile_Async_c(A,jpvt,tau,work,rwork,sequence,request) &
          & bind(c, name='PLASMA_dgeqp3_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqp3_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: jpvt
            type(c_ptr), value :: tau
            type(c_ptr), value :: work
            type(c_ptr), value :: rwork
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgeqp3_Tile_Async_c
      end interface

      interface
         function PLASMA_dgeqrf_Tile_Async_c(A,T,sequence,request) &
          & bind(c, name='PLASMA_dgeqrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgeqrf_Tile_Async_c
      end interface

      interface
         function PLASMA_dgeqrs_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dgeqrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgeqrs_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgeqrs_Tile_Async_c
      end interface

      interface
         function PLASMA_dgesdd_Tile_Async_c(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,sequence,request) &
          & bind(c, name='PLASMA_dgesdd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesdd_Tile_Async_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: T
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgesdd_Tile_Async_c
      end interface

      interface
         function PLASMA_dgesv_Tile_Async_c(A,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_dgesv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgesv_Tile_Async_c
      end interface

      interface
         function PLASMA_dgesv_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_dgesv_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesv_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgesv_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_dgesvd_Tile_Async_c(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,sequence,request) &
          & bind(c, name='PLASMA_dgesvd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgesvd_Tile_Async_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: T
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgesvd_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrf_Tile_Async_c(A,IPIV,sequence,request) &
          & bind(c, name='PLASMA_dgetrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrf_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrf_incpiv_Tile_Async_c(A,L,IPIV,sequence,request) &
          & bind(c, name='PLASMA_dgetrf_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrf_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrf_nopiv_Tile_Async_c(A,sequence,request) &
          & bind(c, name='PLASMA_dgetrf_nopiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_nopiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrf_nopiv_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrf_tntpiv_Tile_Async_c(A,IPIV,W,Wpivot,sequence,request) &
          & bind(c, name='PLASMA_dgetrf_tntpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrf_tntpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: W
            type(c_ptr), value :: Wpivot
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrf_tntpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetri_Tile_Async_c(A,IPIV,W,sequence,request) &
          & bind(c, name='PLASMA_dgetri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetri_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: W
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetri_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrs_Tile_Async_c(trans,A,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_dgetrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_Tile_Async_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrs_Tile_Async_c
      end interface

      interface
         function PLASMA_dgetrs_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_dgetrs_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dgetrs_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dgetrs_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_dsyev_Tile_Async_c(jobz,uplo,A,W,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_dsyev_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyev_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyev_Tile_Async_c
      end interface

      interface
         function PLASMA_dsyevd_Tile_Async_c(jobz,uplo,A,W,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_dsyevd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevd_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyevd_Tile_Async_c
      end interface

      interface
         function PLASMA_dsyevr_Tile_Async_c(jobz,range,uplo,A,vl,vu,il,iu,abstol,nbcomputedeig,W,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_dsyevr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyevr_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: range
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            real(kind=c_double), value :: vl
            real(kind=c_double), value :: vu
            integer(kind=c_int), value :: il
            integer(kind=c_int), value :: iu
            real(kind=c_double), value :: abstol
            type(c_ptr), value :: nbcomputedeig
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyevr_Tile_Async_c
      end interface

      interface
         function PLASMA_dsygst_Tile_Async_c(itype,uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_dsygst_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygst_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsygst_Tile_Async_c
      end interface

      interface
         function PLASMA_dsygv_Tile_Async_c(itype,jobz,uplo,A,B,W,T,Q,sequence,request) &
          & bind(c, name='PLASMA_dsygv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygv_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsygv_Tile_Async_c
      end interface

      interface
         function PLASMA_dsygvd_Tile_Async_c(itype,jobz,uplo,A,B,W,T,Q,sequence,request) &
          & bind(c, name='PLASMA_dsygvd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsygvd_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsygvd_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsymm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsymm_Tile_Async_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsyr2k_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyr2k_Tile_Async_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dsyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsyrk_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyrk_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_dsytrd_Tile_Async_c(jobz,uplo,A,D,E,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_dsytrd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsytrd_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsytrd_Tile_Async_c
      end interface

      interface
         function PLASMA_dlacpy_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_dlacpy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlacpy_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlacpy_Tile_Async_c
      end interface

      interface
         function PLASMA_dlange_Tile_Async_c(norm,A,result,sequence,request) &
          & bind(c, name='PLASMA_dlange_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlange_Tile_Async_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
            type(c_ptr), value :: result
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlange_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dlansy_Tile_Async_c(norm,uplo,A,result,sequence,request) &
          & bind(c, name='PLASMA_dlansy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlansy_Tile_Async_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: result
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlansy_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_dlansy_Tile_Async_c(norm,uplo,A,result,sequence,request) &
          & bind(c, name='PLASMA_dlansy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlansy_Tile_Async_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: result
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlansy_Tile_Async_c
      end interface

      interface
         function PLASMA_dlantr_Tile_Async_c(norm,uplo,diag,A,result,sequence,request) &
          & bind(c, name='PLASMA_dlantr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlantr_Tile_Async_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
            type(c_ptr), value :: result
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlantr_Tile_Async_c
      end interface

      interface
         function PLASMA_dlaset_Tile_Async_c(uplo,alpha,beta,A,sequence,request) &
          & bind(c, name='PLASMA_dlaset_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaset_Tile_Async_c
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            real(kind=c_double), value :: beta
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlaset_Tile_Async_c
      end interface

      interface
         function PLASMA_dlaswp_Tile_Async_c(A,K1,K2,IPIV,INCX,sequence,request) &
          & bind(c, name='PLASMA_dlaswp_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswp_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlaswp_Tile_Async_c
      end interface

      interface
         function PLASMA_dlaswpc_Tile_Async_c(A,K1,K2,IPIV,INCX,sequence,request) &
          & bind(c, name='PLASMA_dlaswpc_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlaswpc_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlaswpc_Tile_Async_c
      end interface

      interface
         function PLASMA_dlauum_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_dlauum_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dlauum_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dlauum_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_dplgsy_Tile_Async_c(bump,A,seed,sequence,request) &
          & bind(c, name='PLASMA_dplgsy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_Tile_Async_c
            real(kind=c_double), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dplgsy_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_dplgsy_Tile_Async_c(bump,A,seed,sequence,request) &
          & bind(c, name='PLASMA_dplgsy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplgsy_Tile_Async_c
            real(kind=c_double), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dplgsy_Tile_Async_c
      end interface

      interface
         function PLASMA_dplrnt_Tile_Async_c(A,seed,sequence,request) &
          & bind(c, name='PLASMA_dplrnt_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dplrnt_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dplrnt_Tile_Async_c
      end interface

      interface
         function PLASMA_dpltmg_Tile_Async_c(mtxtype,A,seed,sequence,request) &
          & bind(c, name='PLASMA_dpltmg_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpltmg_Tile_Async_c
            integer(kind=c_int), value :: mtxtype
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dpltmg_Tile_Async_c
      end interface

      interface
         function PLASMA_dpocon_Tile_Async_c(uplo,A,anorm,rcond,sequence,request) &
          & bind(c, name='PLASMA_dpocon_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpocon_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            real(kind=c_double), value :: anorm
            type(c_ptr), value :: rcond
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dpocon_Tile_Async_c
      end interface

      interface
         function PLASMA_dposv_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_dposv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dposv_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dposv_Tile_Async_c
      end interface

      interface
         function PLASMA_dpotrf_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_dpotrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrf_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dpotrf_Tile_Async_c
      end interface

      interface
         function PLASMA_dpotri_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_dpotri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotri_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dpotri_Tile_Async_c
      end interface

      interface
         function PLASMA_dpotrs_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_dpotrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dpotrs_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dpotrs_Tile_Async_c
      end interface

      interface
         function PLASMA_dsymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsymm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsymm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsymm_Tile_Async_c
      end interface

      interface
         function PLASMA_dsyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsyr2k_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyr2k_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyr2k_Tile_Async_c
      end interface

      interface
         function PLASMA_dsyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request) &
          & bind(c, name='PLASMA_dsyrk_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dsyrk_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_double), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dsyrk_Tile_Async_c
      end interface

      interface
         function PLASMA_dtrmm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_dtrmm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrmm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dtrmm_Tile_Async_c
      end interface

      interface
         function PLASMA_dtrsm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_dtrsm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dtrsm_Tile_Async_c
      end interface

      interface
         function PLASMA_dtrsmpl_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_dtrsmpl_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmpl_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dtrsmpl_Tile_Async_c
      end interface

      interface
         function PLASMA_dtrsmrv_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_dtrsmrv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrsmrv_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            real(kind=c_double), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dtrsmrv_Tile_Async_c
      end interface

      interface
         function PLASMA_dtrtri_Tile_Async_c(uplo,diag,A,sequence,request) &
          & bind(c, name='PLASMA_dtrtri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dtrtri_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dtrtri_Tile_Async_c
      end interface

      interface
         function PLASMA_dorglq_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dorglq_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorglq_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dorglq_Tile_Async_c
      end interface

      interface
         function PLASMA_dorgqr_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dorgqr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dorgqr_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dorgqr_Tile_Async_c
      end interface

      interface
         function PLASMA_dormlq_Tile_Async_c(side,trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dormlq_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormlq_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dormlq_Tile_Async_c
      end interface

      interface
         function PLASMA_dormqr_Tile_Async_c(side,trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_dormqr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_dormqr_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_dormqr_Tile_Async_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - workspace allocation
    !
      interface
         function PLASMA_Alloc_Workspace_dgebrd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgebrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgebrd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgebrd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgeev_c(N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgeev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgeev_c
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgeev_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgehrd_c(N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgehrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgehrd_c
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgehrd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgelqf_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgelqf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgelqf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgelqf_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgelqf_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgelqf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgelqf_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgelqf_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgels_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgels')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgels_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgels_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgels_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgels_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgels_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgels_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgeqrf_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgeqrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgeqrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgeqrf_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgeqrf_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgeqrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgeqrf_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgeqrf_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgesdd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgesdd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgesdd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgesdd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgesv_incpiv_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgesv_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgesv_incpiv_c
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
            type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgesv_incpiv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgesv_incpiv_Tile_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgesv_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgesv_incpiv_Tile_c
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
            type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgesv_incpiv_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgesvd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgesvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgesvd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgesvd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgetrf_incpiv_c(M,N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgetrf_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgetrf_incpiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
            type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgetrf_incpiv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile_c
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
            type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile_c(A,W,Wpivot) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), intent(inout) :: Wpivot ! Wpivot is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dgetri_Tile_Async_c(A,W) &
          & bind(c, name='PLASMA_Alloc_Workspace_dgetri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dgetri_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: W
          end function PLASMA_Alloc_Workspace_dgetri_Tile_Async_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsyev_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsyev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsyev_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsyev_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsyevd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsyevd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsyevd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsyevd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsyevr_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsyevr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsyevr_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsyevr_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsygv_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsygv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsygv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsygv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsygvd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsygvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsygvd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsygvd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_dsytrd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_dsytrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_dsytrd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_dsytrd_c
      end interface

  contains

!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!  FORTRAN API - math functions (simple interface)
!

      subroutine PLASMA_dLapack_to_Tile(Af77,LDA,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(inout), target :: Af77(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dLapack_to_Tile_c(c_loc(Af77),LDA,A)
      end subroutine PLASMA_dLapack_to_Tile


      subroutine PLASMA_dLapack_to_Tile_Async(Af77,LDA,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(inout), target :: Af77(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dLapack_to_Tile_Async_c(c_loc(Af77),LDA,A,sequence,request)
      end subroutine PLASMA_dLapack_to_Tile_Async


      subroutine PLASMA_dTile_to_Lapack(A,Af77,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Af77(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dTile_to_Lapack_c(A,c_loc(Af77),LDA)
      end subroutine PLASMA_dTile_to_Lapack


      subroutine PLASMA_dTile_to_Lapack_Async(A,Af77,LDA,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Af77(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dTile_to_Lapack_Async_c(A,c_loc(Af77),LDA,sequence,request)
      end subroutine PLASMA_dTile_to_Lapack_Async


      subroutine PLASMA_dgebrd(jobq,jobpt,M,N,A,LDA,D,E,descT,Q,LDQ,PT,LDPT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobq
         integer(kind=c_int), intent(in) :: jobpt
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: D(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         real(kind=c_double), intent(inout), target :: PT(*)
         integer(kind=c_int), intent(in) :: LDPT
         info = PLASMA_dgebrd_c(jobq,jobpt,M,N,c_loc(A),LDA,c_loc(D),c_loc(E),descT,c_loc(Q),LDQ,c_loc(PT),LDPT)
      end subroutine PLASMA_dgebrd


      subroutine PLASMA_dgecfi(m,n,A,fin,imb,inb,fout,omb,onb,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: imb
         integer(kind=c_int), intent(in) :: inb
         integer(kind=c_int), intent(in) :: fout
         integer(kind=c_int), intent(in) :: omb
         integer(kind=c_int), intent(in) :: onb
         info = PLASMA_dgecfi_c(m,n,c_loc(A),fin,imb,inb,fout,omb,onb)
      end subroutine PLASMA_dgecfi


      subroutine PLASMA_dgecfi_Async(m,n,A,f_in,imb,inb,f_out,omb,onb,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: f_in
         integer(kind=c_int), intent(in) :: imb
         integer(kind=c_int), intent(in) :: inb
         integer(kind=c_int), intent(in) :: f_out
         integer(kind=c_int), intent(in) :: omb
         integer(kind=c_int), intent(in) :: onb
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgecfi_Async_c(m,n,c_loc(A),f_in,imb,inb,f_out,omb,onb,sequence,request)
      end subroutine PLASMA_dgecfi_Async


      subroutine PLASMA_dgecon(norm,N,A,LDA,anorm,rcond,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         info = PLASMA_dgecon_c(norm,N,c_loc(A),LDA,anorm,c_loc(rcond))
      end subroutine PLASMA_dgecon


      subroutine PLASMA_dgelqf(M,N,A,LDA,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgelqf_c(M,N,c_loc(A),LDA,descT)
      end subroutine PLASMA_dgelqf


      subroutine PLASMA_dgelqs(M,N,NRHS,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgelqs_c(M,N,NRHS,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dgelqs


      subroutine PLASMA_dgels(trans,M,N,NRHS,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgels_c(trans,M,N,NRHS,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dgels


      subroutine PLASMA_dgemm(transA,transB,M,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dgemm_c(transA,transB,M,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_dgemm


      subroutine PLASMA_dgeqp3(M,N,A,LDA,jpvt,tau,work,rwork,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(inout), target :: jpvt(*)
         real(kind=c_double), intent(inout), target :: tau(*)
         real(kind=c_double), intent(inout), target :: work(*)
         real(kind=c_double), intent(inout), target :: rwork(*)
         info = PLASMA_dgeqp3_c(M,N,c_loc(A),LDA,c_loc(jpvt),c_loc(tau),c_loc(work),c_loc(rwork))
      end subroutine PLASMA_dgeqp3


      subroutine PLASMA_dgeqrf(M,N,A,LDA,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqrf_c(M,N,c_loc(A),LDA,descT)
      end subroutine PLASMA_dgeqrf


      subroutine PLASMA_dgeqrs(M,N,NRHS,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgeqrs_c(M,N,NRHS,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dgeqrs


      subroutine PLASMA_dgesdd(jobu,jobvt,M,N,A,LDA,S,descT,U,LDU,VT,LDVT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         info = PLASMA_dgesdd_c(jobu,jobvt,M,N,c_loc(A),LDA,c_loc(S),descT,c_loc(U),LDU,c_loc(VT),LDVT)
      end subroutine PLASMA_dgesdd


      subroutine PLASMA_dgesv(N,NRHS,A,LDA,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgesv_c(N,NRHS,c_loc(A),LDA,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_dgesv


      subroutine PLASMA_dgesv_incpiv(N,NRHS,A,LDA,descL,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descL ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgesv_incpiv_c(N,NRHS,c_loc(A),LDA,descL,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_dgesv_incpiv


      subroutine PLASMA_dgesvd(jobu,jobvt,M,N,A,LDA,S,descT,U,LDU,VT,LDVT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         info = PLASMA_dgesvd_c(jobu,jobvt,M,N,c_loc(A),LDA,c_loc(S),descT,c_loc(U),LDU,c_loc(VT),LDVT)
      end subroutine PLASMA_dgesvd


      subroutine PLASMA_dgetmi(m,n,A,fin,mb,nb,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: mb
         integer(kind=c_int), intent(in) :: nb
         info = PLASMA_dgetmi_c(m,n,c_loc(A),fin,mb,nb)
      end subroutine PLASMA_dgetmi


      subroutine PLASMA_dgetmi_Async(m,n,A,f_in,mb,inb,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: f_in
         integer(kind=c_int), intent(in) :: mb
         integer(kind=c_int), intent(in) :: inb
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetmi_Async_c(m,n,c_loc(A),f_in,mb,inb,sequence,request)
      end subroutine PLASMA_dgetmi_Async


      subroutine PLASMA_dgetrf(M,N,A,LDA,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_c(M,N,c_loc(A),LDA,c_loc(IPIV))
      end subroutine PLASMA_dgetrf


      subroutine PLASMA_dgetrf_incpiv(M,N,A,LDA,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descL ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_incpiv_c(M,N,c_loc(A),LDA,descL,c_loc(IPIV))
      end subroutine PLASMA_dgetrf_incpiv


      subroutine PLASMA_dgetrf_nopiv(M,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dgetrf_nopiv_c(M,N,c_loc(A),LDA)
      end subroutine PLASMA_dgetrf_nopiv


      subroutine PLASMA_dgetrf_tntpiv(M,N,A,LDA,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_tntpiv_c(M,N,c_loc(A),LDA,c_loc(IPIV))
      end subroutine PLASMA_dgetrf_tntpiv


      subroutine PLASMA_dgetri(N,A,LDA,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetri_c(N,c_loc(A),LDA,c_loc(IPIV))
      end subroutine PLASMA_dgetri


      subroutine PLASMA_dgetrs(trans,N,NRHS,A,LDA,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in), target :: IPIV(*)
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgetrs_c(trans,N,NRHS,c_loc(A),LDA,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_dgetrs


      subroutine PLASMA_dgetrs_incpiv(trans,N,NRHS,A,LDA,descL,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descL ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dgetrs_incpiv_c(trans,N,NRHS,c_loc(A),LDA,descL,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_dgetrs_incpiv


      subroutine PLASMA_dsyev(jobz,uplo,N,A,LDA,W,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyev_c(jobz,uplo,N,c_loc(A),LDA,c_loc(W),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyev


      subroutine PLASMA_dsyevd(jobz,uplo,N,A,LDA,W,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyevd_c(jobz,uplo,N,c_loc(A),LDA,c_loc(W),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyevd


      subroutine PLASMA_dsyevr(jobz,range,uplo,N,A,LDA,vl,vu,il,iu,abstol,nbcomputedeig,W,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: range
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(in) :: vl
         real(kind=c_double), intent(in) :: vu
         integer(kind=c_int), intent(in) :: il
         integer(kind=c_int), intent(in) :: iu
         real(kind=c_double), intent(in) :: abstol
         integer(kind=c_int), intent(inout), target :: nbcomputedeig(*)
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyevr_c(jobz,range,uplo,N,c_loc(A),LDA,vl,vu,il,iu,abstol,c_loc(nbcomputedeig),c_loc(W),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyevr


      subroutine PLASMA_dsygst(itype,uplo,N,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dsygst_c(itype,uplo,N,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dsygst


      subroutine PLASMA_dsygv(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsygv_c(itype,jobz,uplo,N,c_loc(A),LDA,c_loc(B),LDB,c_loc(W),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsygv


      subroutine PLASMA_dsygvd(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsygvd_c(itype,jobz,uplo,N,c_loc(A),LDA,c_loc(B),LDB,c_loc(W),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsygvd

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsymm(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsymm_c(side,uplo,M,N,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsymm
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyr2k(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsyr2k_c(uplo,trans,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsyr2k
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyrk(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsyrk_c(uplo,trans,N,K,alpha,c_loc(A),LDA,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsyrk
#endif


      subroutine PLASMA_dsytrd(jobz,uplo,N,A,LDA,D,E,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: D(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsytrd_c(jobz,uplo,N,c_loc(A),LDA,c_loc(D),c_loc(E),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_dsytrd


      subroutine PLASMA_dlacpy(uplo,M,N,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dlacpy_c(uplo,M,N,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dlacpy


      subroutine PLASMA_dlange(norm,M,N,A,LDA,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         retval = PLASMA_dlange_c(norm,M,N,c_loc(A),LDA)
      end subroutine PLASMA_dlange

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dlansy(norm,uplo,N,A,LDA,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         retval = PLASMA_dlansy_c(norm,uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_dlansy
#endif


      subroutine PLASMA_dlansy(norm,uplo,N,A,LDA,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         retval = PLASMA_dlansy_c(norm,uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_dlansy


      subroutine PLASMA_dlantr(norm,uplo,diag,M,N,A,LDA,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         retval = PLASMA_dlantr_c(norm,uplo,diag,M,N,c_loc(A),LDA)
      end subroutine PLASMA_dlantr


      subroutine PLASMA_dlaset(uplo,M,N,alpha,beta,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dlaset_c(uplo,M,N,alpha,beta,c_loc(A),LDA)
      end subroutine PLASMA_dlaset


      subroutine PLASMA_dlaswp(N,A,LDA,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         info = PLASMA_dlaswp_c(N,c_loc(A),LDA,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_dlaswp


      subroutine PLASMA_dlaswpc(N,A,LDA,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         info = PLASMA_dlaswpc_c(N,c_loc(A),LDA,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_dlaswpc


      subroutine PLASMA_dlauum(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dlauum_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_dlauum

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dplgsy(bump,N,A,LDA,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplgsy_c(bump,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_dplgsy
#endif


      subroutine PLASMA_dplgsy(bump,N,A,LDA,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplgsy_c(bump,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_dplgsy


      subroutine PLASMA_dplrnt(M,N,A,LDA,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplrnt_c(M,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_dplrnt


      subroutine PLASMA_dpltmg(mtxtype,M,N,A,LDA,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: mtxtype
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dpltmg_c(mtxtype,M,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_dpltmg


      subroutine PLASMA_dpocon(uplo,N,A,LDA,anorm,rcond,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         info = PLASMA_dpocon_c(uplo,N,c_loc(A),LDA,anorm,c_loc(rcond))
      end subroutine PLASMA_dpocon


      subroutine PLASMA_dposv(uplo,N,NRHS,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dposv_c(uplo,N,NRHS,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dposv


      subroutine PLASMA_dpotrf(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dpotrf_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_dpotrf


      subroutine PLASMA_dpotri(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dpotri_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_dpotri


      subroutine PLASMA_dpotrs(uplo,N,NRHS,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dpotrs_c(uplo,N,NRHS,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dpotrs


      subroutine PLASMA_dsymm(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsymm_c(side,uplo,M,N,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsymm


      subroutine PLASMA_dsyr2k(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsyr2k_c(uplo,trans,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsyr2k


      subroutine PLASMA_dsyrk(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(in) :: beta
         real(kind=c_double), intent(inout), target :: C(*)
         integer(kind=c_int), intent(in) :: LDC
         info = PLASMA_dsyrk_c(uplo,trans,N,K,alpha,c_loc(A),LDA,beta,c_loc(C),LDC)
      end subroutine PLASMA_dsyrk


      subroutine PLASMA_dtrmm(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dtrmm_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dtrmm


      subroutine PLASMA_dtrsm(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dtrsm_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dtrsm


      subroutine PLASMA_dtrsmpl(N,NRHS,A,LDA,descL,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descL ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dtrsmpl_c(N,NRHS,c_loc(A),LDA,descL,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_dtrsmpl


      subroutine PLASMA_dtrsmrv(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dtrsmrv_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_dtrsmrv


      subroutine PLASMA_dtrtri(uplo,diag,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: N
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         info = PLASMA_dtrtri_c(uplo,diag,N,c_loc(A),LDA)
      end subroutine PLASMA_dtrtri


      subroutine PLASMA_dorglq(M,N,K,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dorglq_c(M,N,K,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dorglq


      subroutine PLASMA_dorgqr(M,N,K,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dorgqr_c(M,N,K,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dorgqr


      subroutine PLASMA_dormlq(side,trans,M,N,K,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dormlq_c(side,trans,M,N,K,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dormlq


      subroutine PLASMA_dormqr(side,trans,M,N,K,A,LDA,descT,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: K
         real(kind=c_double), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: LDA
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: B(*)
         integer(kind=c_int), intent(in) :: LDB
         info = PLASMA_dormqr_c(side,trans,M,N,K,c_loc(A),LDA,descT,c_loc(B),LDB)
      end subroutine PLASMA_dormqr

!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!  FORTRAN API - math functions (native interface)
!

      subroutine PLASMA_dgebrd_Tile(jobq,jobpt,A,D,E,T,Q,LDQ,PT,LDPT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobq
         integer(kind=c_int), intent(in) :: jobpt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: D(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         real(kind=c_double), intent(inout), target :: PT(*)
         integer(kind=c_int), intent(in) :: LDPT
         info = PLASMA_dgebrd_Tile_c(jobq,jobpt,A,c_loc(D),c_loc(E),T,c_loc(Q),LDQ,c_loc(PT),LDPT)
      end subroutine PLASMA_dgebrd_Tile


      subroutine PLASMA_dgecon_Tile(norm,A,anorm,rcond,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         info = PLASMA_dgecon_Tile_c(norm,A,anorm,c_loc(rcond))
      end subroutine PLASMA_dgecon_Tile


      subroutine PLASMA_dgelqf_Tile(A,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgelqf_Tile_c(A,T)
      end subroutine PLASMA_dgelqf_Tile


      subroutine PLASMA_dgelqs_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgelqs_Tile_c(A,T,B)
      end subroutine PLASMA_dgelqs_Tile


      subroutine PLASMA_dgels_Tile(trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgels_Tile_c(trans,A,T,B)
      end subroutine PLASMA_dgels_Tile


      subroutine PLASMA_dgemm_Tile(transA,transB,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgemm_Tile_c(transA,transB,alpha,A,B,beta,C)
      end subroutine PLASMA_dgemm_Tile


      subroutine PLASMA_dgeqp3_Tile(A,jpvt,tau,work,rwork,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: jpvt(*)
         real(kind=c_double), intent(inout), target :: tau(*)
         real(kind=c_double), intent(inout), target :: work(*)
         real(kind=c_double), intent(inout), target :: rwork(*)
         info = PLASMA_dgeqp3_Tile_c(A,c_loc(jpvt),c_loc(tau),c_loc(work),c_loc(rwork))
      end subroutine PLASMA_dgeqp3_Tile


      subroutine PLASMA_dgeqrf_Tile(A,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqrf_Tile_c(A,T)
      end subroutine PLASMA_dgeqrf_Tile


      subroutine PLASMA_dgeqrs_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqrs_Tile_c(A,T,B)
      end subroutine PLASMA_dgeqrs_Tile


      subroutine PLASMA_dgesdd_Tile(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         info = PLASMA_dgesdd_Tile_c(jobu,jobvt,A,c_loc(S),T,c_loc(U),LDU,c_loc(VT),LDVT)
      end subroutine PLASMA_dgesdd_Tile


      subroutine PLASMA_dgesv_Tile(A,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesv_Tile_c(A,c_loc(IPIV),B)
      end subroutine PLASMA_dgesv_Tile


      subroutine PLASMA_dgesv_incpiv_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesv_incpiv_Tile_c(A,L,c_loc(IPIV),B)
      end subroutine PLASMA_dgesv_incpiv_Tile


      subroutine PLASMA_dgesvd_Tile(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         info = PLASMA_dgesvd_Tile_c(jobu,jobvt,A,c_loc(S),T,c_loc(U),LDU,c_loc(VT),LDVT)
      end subroutine PLASMA_dgesvd_Tile


      subroutine PLASMA_dgetrf_Tile(A,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_Tile_c(A,c_loc(IPIV))
      end subroutine PLASMA_dgetrf_Tile


      subroutine PLASMA_dgetrf_incpiv_Tile(A,L,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_incpiv_Tile_c(A,L,c_loc(IPIV))
      end subroutine PLASMA_dgetrf_incpiv_Tile


      subroutine PLASMA_dgetrf_nopiv_Tile(A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrf_nopiv_Tile_c(A)
      end subroutine PLASMA_dgetrf_nopiv_Tile


      subroutine PLASMA_dgetrf_tntpiv_Tile(A,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetrf_tntpiv_Tile_c(A,c_loc(IPIV))
      end subroutine PLASMA_dgetrf_tntpiv_Tile


      subroutine PLASMA_dgetri_Tile(A,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         info = PLASMA_dgetri_Tile_c(A,c_loc(IPIV))
      end subroutine PLASMA_dgetri_Tile


      subroutine PLASMA_dgetrs_Tile(trans,A,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrs_Tile_c(trans,A,c_loc(IPIV),B)
      end subroutine PLASMA_dgetrs_Tile


      subroutine PLASMA_dgetrs_incpiv_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrs_incpiv_Tile_c(A,L,c_loc(IPIV),B)
      end subroutine PLASMA_dgetrs_incpiv_Tile


      subroutine PLASMA_dsyev_Tile(jobz,uplo,A,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyev_Tile_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyev_Tile


      subroutine PLASMA_dsyevd_Tile(jobz,uplo,A,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyevd_Tile_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyevd_Tile


      subroutine PLASMA_dsyevr_Tile(jobz,range,uplo,A,vl,vu,il,iu,abstol,nbcomputedeig,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: range
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: vl
         real(kind=c_double), intent(in) :: vu
         integer(kind=c_int), intent(in) :: il
         integer(kind=c_int), intent(in) :: iu
         real(kind=c_double), intent(in) :: abstol
         integer(kind=c_int), intent(inout), target :: nbcomputedeig(*)
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsyevr_Tile_c(jobz,range,uplo,A,vl,vu,il,iu,abstol,c_loc(nbcomputedeig),c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_dsyevr_Tile


      subroutine PLASMA_dsygst_Tile(itype,uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygst_Tile_c(itype,uplo,A,B)
      end subroutine PLASMA_dsygst_Tile


      subroutine PLASMA_dsygv_Tile(itype,jobz,uplo,A,B,W,T,Q,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygv_Tile_c(itype,jobz,uplo,A,B,c_loc(W),T,Q)
      end subroutine PLASMA_dsygv_Tile


      subroutine PLASMA_dsygvd_Tile(itype,jobz,uplo,A,B,W,T,Q,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygvd_Tile_c(itype,jobz,uplo,A,B,c_loc(W),T,Q)
      end subroutine PLASMA_dsygvd_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsymm_Tile(side,uplo,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsymm_Tile_c(side,uplo,alpha,A,B,beta,C)
      end subroutine PLASMA_dsymm_Tile
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyr2k_Tile(uplo,trans,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C)
      end subroutine PLASMA_dsyr2k_Tile
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyrk_Tile(uplo,trans,alpha,A,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyrk_Tile_c(uplo,trans,alpha,A,beta,C)
      end subroutine PLASMA_dsyrk_Tile
#endif


      subroutine PLASMA_dsytrd_Tile(jobz,uplo,A,D,E,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: D(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         info = PLASMA_dsytrd_Tile_c(jobz,uplo,A,c_loc(D),c_loc(E),T,c_loc(Q),LDQ)
      end subroutine PLASMA_dsytrd_Tile


      subroutine PLASMA_dlacpy_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlacpy_Tile_c(uplo,A,B)
      end subroutine PLASMA_dlacpy_Tile


      subroutine PLASMA_dlange_Tile(norm,A,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         retval = PLASMA_dlange_Tile_c(norm,A)
      end subroutine PLASMA_dlange_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dlansy_Tile(norm,uplo,A,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         retval = PLASMA_dlansy_Tile_c(norm,uplo,A)
      end subroutine PLASMA_dlansy_Tile
#endif


      subroutine PLASMA_dlansy_Tile(norm,uplo,A,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         retval = PLASMA_dlansy_Tile_c(norm,uplo,A)
      end subroutine PLASMA_dlansy_Tile


      subroutine PLASMA_dlantr_Tile(norm,uplo,diag,A,retval)
         use iso_c_binding
         implicit none
         real(kind=c_double), intent(out) :: retval
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         retval = PLASMA_dlantr_Tile_c(norm,uplo,diag,A)
      end subroutine PLASMA_dlantr_Tile


      subroutine PLASMA_dlaset_Tile(uplo,alpha,beta,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlaset_Tile_c(uplo,alpha,beta,A)
      end subroutine PLASMA_dlaset_Tile


      subroutine PLASMA_dlaswp_Tile(A,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         info = PLASMA_dlaswp_Tile_c(A,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_dlaswp_Tile


      subroutine PLASMA_dlaswpc_Tile(A,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         info = PLASMA_dlaswpc_Tile_c(A,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_dlaswpc_Tile


      subroutine PLASMA_dlauum_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlauum_Tile_c(uplo,A)
      end subroutine PLASMA_dlauum_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dplgsy_Tile(bump,A,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplgsy_Tile_c(bump,A,seed)
      end subroutine PLASMA_dplgsy_Tile
#endif


      subroutine PLASMA_dplgsy_Tile(bump,A,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplgsy_Tile_c(bump,A,seed)
      end subroutine PLASMA_dplgsy_Tile


      subroutine PLASMA_dplrnt_Tile(A,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dplrnt_Tile_c(A,seed)
      end subroutine PLASMA_dplrnt_Tile


      subroutine PLASMA_dpltmg_Tile(mtxtype,A,seed,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: mtxtype
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         info = PLASMA_dpltmg_Tile_c(mtxtype,A,seed)
      end subroutine PLASMA_dpltmg_Tile


      subroutine PLASMA_dpocon_Tile(uplo,A,anorm,rcond,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         info = PLASMA_dpocon_Tile_c(uplo,A,anorm,c_loc(rcond))
      end subroutine PLASMA_dpocon_Tile


      subroutine PLASMA_dposv_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dposv_Tile_c(uplo,A,B)
      end subroutine PLASMA_dposv_Tile


      subroutine PLASMA_dpotrf_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotrf_Tile_c(uplo,A)
      end subroutine PLASMA_dpotrf_Tile


      subroutine PLASMA_dpotri_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotri_Tile_c(uplo,A)
      end subroutine PLASMA_dpotri_Tile


      subroutine PLASMA_dpotrs_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotrs_Tile_c(uplo,A,B)
      end subroutine PLASMA_dpotrs_Tile


      subroutine PLASMA_dsymm_Tile(side,uplo,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsymm_Tile_c(side,uplo,alpha,A,B,beta,C)
      end subroutine PLASMA_dsymm_Tile


      subroutine PLASMA_dsyr2k_Tile(uplo,trans,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C)
      end subroutine PLASMA_dsyr2k_Tile


      subroutine PLASMA_dsyrk_Tile(uplo,trans,alpha,A,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyrk_Tile_c(uplo,trans,alpha,A,beta,C)
      end subroutine PLASMA_dsyrk_Tile


      subroutine PLASMA_dtrmm_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrmm_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_dtrmm_Tile


      subroutine PLASMA_dtrsm_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsm_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_dtrsm_Tile


      subroutine PLASMA_dtrsmpl_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsmpl_Tile_c(A,L,c_loc(IPIV),B)
      end subroutine PLASMA_dtrsmpl_Tile


      subroutine PLASMA_dtrsmrv_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsmrv_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_dtrsmrv_Tile


      subroutine PLASMA_dtrtri_Tile(uplo,diag,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrtri_Tile_c(uplo,diag,A)
      end subroutine PLASMA_dtrtri_Tile


      subroutine PLASMA_dorglq_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dorglq_Tile_c(A,T,B)
      end subroutine PLASMA_dorglq_Tile


      subroutine PLASMA_dorgqr_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dorgqr_Tile_c(A,T,B)
      end subroutine PLASMA_dorgqr_Tile


      subroutine PLASMA_dormlq_Tile(side,trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dormlq_Tile_c(side,trans,A,T,B)
      end subroutine PLASMA_dormlq_Tile


      subroutine PLASMA_dormqr_Tile(side,trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dormqr_Tile_c(side,trans,A,T,B)
      end subroutine PLASMA_dormqr_Tile

!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!  FORTRAN API - math functions (asynchronous interface)
!

      subroutine PLASMA_dgebrd_Tile_Async(jobq,jobpt,A,S,E,T,U,LDU,VT,LDVT,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobq
         integer(kind=c_int), intent(in) :: jobpt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: S(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgebrd_Tile_Async_c(jobq,jobpt,A,c_loc(S),c_loc(E),T,c_loc(U),LDU,c_loc(VT),LDVT,sequence,request)
      end subroutine PLASMA_dgebrd_Tile_Async


      subroutine PLASMA_dgecon_Tile_Async(norm,A,anorm,rcond,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgecon_Tile_Async_c(norm,A,anorm,c_loc(rcond),sequence,request)
      end subroutine PLASMA_dgecon_Tile_Async


      subroutine PLASMA_dgelqf_Tile_Async(A,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgelqf_Tile_Async_c(A,T,sequence,request)
      end subroutine PLASMA_dgelqf_Tile_Async


      subroutine PLASMA_dgelqs_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgelqs_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_dgelqs_Tile_Async


      subroutine PLASMA_dgels_Tile_Async(trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgels_Tile_Async_c(trans,A,T,B,sequence,request)
      end subroutine PLASMA_dgels_Tile_Async


      subroutine PLASMA_dgemm_Tile_Async(transA,transB,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgemm_Tile_Async_c(transA,transB,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_dgemm_Tile_Async


      subroutine PLASMA_dgeqp3_Tile_Async(A,jpvt,tau,work,rwork,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: jpvt(*)
         real(kind=c_double), intent(inout), target :: tau(*)
         real(kind=c_double), intent(inout), target :: work(*)
         real(kind=c_double), intent(inout), target :: rwork(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqp3_Tile_Async_c(A,c_loc(jpvt),c_loc(tau),c_loc(work),c_loc(rwork),sequence,request)
      end subroutine PLASMA_dgeqp3_Tile_Async


      subroutine PLASMA_dgeqrf_Tile_Async(A,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqrf_Tile_Async_c(A,T,sequence,request)
      end subroutine PLASMA_dgeqrf_Tile_Async


      subroutine PLASMA_dgeqrs_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgeqrs_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_dgeqrs_Tile_Async


      subroutine PLASMA_dgesdd_Tile_Async(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesdd_Tile_Async_c(jobu,jobvt,A,c_loc(S),T,c_loc(U),LDU,c_loc(VT),LDVT,sequence,request)
      end subroutine PLASMA_dgesdd_Tile_Async


      subroutine PLASMA_dgesv_Tile_Async(A,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesv_Tile_Async_c(A,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_dgesv_Tile_Async


      subroutine PLASMA_dgesv_incpiv_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesv_incpiv_Tile_Async_c(A,L,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_dgesv_incpiv_Tile_Async


      subroutine PLASMA_dgesvd_Tile_Async(jobu,jobvt,A,S,T,U,LDU,VT,LDVT,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: S(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: U(*)
         integer(kind=c_int), intent(in) :: LDU
         real(kind=c_double), intent(inout), target :: VT(*)
         integer(kind=c_int), intent(in) :: LDVT
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgesvd_Tile_Async_c(jobu,jobvt,A,c_loc(S),T,c_loc(U),LDU,c_loc(VT),LDVT,sequence,request)
      end subroutine PLASMA_dgesvd_Tile_Async


      subroutine PLASMA_dgetrf_Tile_Async(A,IPIV,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrf_Tile_Async_c(A,c_loc(IPIV),sequence,request)
      end subroutine PLASMA_dgetrf_Tile_Async


      subroutine PLASMA_dgetrf_incpiv_Tile_Async(A,L,IPIV,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrf_incpiv_Tile_Async_c(A,L,c_loc(IPIV),sequence,request)
      end subroutine PLASMA_dgetrf_incpiv_Tile_Async


      subroutine PLASMA_dgetrf_nopiv_Tile_Async(A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrf_nopiv_Tile_Async_c(A,sequence,request)
      end subroutine PLASMA_dgetrf_nopiv_Tile_Async


      subroutine PLASMA_dgetrf_tntpiv_Tile_Async(A,IPIV,W,Wpivot,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: Wpivot(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrf_tntpiv_Tile_Async_c(A,c_loc(IPIV),W,c_loc(Wpivot),sequence,request)
      end subroutine PLASMA_dgetrf_tntpiv_Tile_Async


      subroutine PLASMA_dgetri_Tile_Async(A,IPIV,W,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(inout), target :: IPIV(*)
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetri_Tile_Async_c(A,c_loc(IPIV),W,sequence,request)
      end subroutine PLASMA_dgetri_Tile_Async


      subroutine PLASMA_dgetrs_Tile_Async(trans,A,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrs_Tile_Async_c(trans,A,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_dgetrs_Tile_Async


      subroutine PLASMA_dgetrs_incpiv_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dgetrs_incpiv_Tile_Async_c(A,L,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_dgetrs_incpiv_Tile_Async


      subroutine PLASMA_dsyev_Tile_Async(jobz,uplo,A,W,T,Q,LDQ,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyev_Tile_Async_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_dsyev_Tile_Async


      subroutine PLASMA_dsyevd_Tile_Async(jobz,uplo,A,W,T,Q,LDQ,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyevd_Tile_Async_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_dsyevd_Tile_Async


      subroutine PLASMA_dsyevr_Tile_Async(jobz,range,uplo,A,vl,vu,il,iu,abstol, &
           nbcomputedeig,W,T,Q,LDQ,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: range
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: vl
         real(kind=c_double), intent(in) :: vu
         integer(kind=c_int), intent(in) :: il
         integer(kind=c_int), intent(in) :: iu
         real(kind=c_double), intent(in) :: abstol
         integer(kind=c_int), intent(inout), target :: nbcomputedeig(*)
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyevr_Tile_Async_c(jobz,range,uplo,A,vl,vu,il,iu,abstol, &
              c_loc(nbcomputedeig),c_loc(W),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_dsyevr_Tile_Async


      subroutine PLASMA_dsygst_Tile_Async(itype,uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygst_Tile_Async_c(itype,uplo,A,B,sequence,request)
      end subroutine PLASMA_dsygst_Tile_Async


      subroutine PLASMA_dsygv_Tile_Async(itype,jobz,uplo,A,B,W,T,Q,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygv_Tile_Async_c(itype,jobz,uplo,A,B,c_loc(W),T,Q,sequence,request)
      end subroutine PLASMA_dsygv_Tile_Async


      subroutine PLASMA_dsygvd_Tile_Async(itype,jobz,uplo,A,B,W,T,Q,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsygvd_Tile_Async_c(itype,jobz,uplo,A,B,c_loc(W),T,Q,sequence,request)
      end subroutine PLASMA_dsygvd_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsymm_Tile_Async(side,uplo,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_dsymm_Tile_Async
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyr2k_Tile_Async(uplo,trans,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_dsyr2k_Tile_Async
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dsyrk_Tile_Async(uplo,trans,alpha,A,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request)
      end subroutine PLASMA_dsyrk_Tile_Async
#endif


      subroutine PLASMA_dsytrd_Tile_Async(jobz,uplo,A,D,E,T,Q,LDQ,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: D(*)
         real(kind=c_double), intent(inout), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: Q(*)
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsytrd_Tile_Async_c(jobz,uplo,A,c_loc(D),c_loc(E),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_dsytrd_Tile_Async


      subroutine PLASMA_dlacpy_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlacpy_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_dlacpy_Tile_Async


      subroutine PLASMA_dlange_Tile_Async(norm,A,result,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: result(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlange_Tile_Async_c(norm,A,c_loc(result),sequence,request)
      end subroutine PLASMA_dlange_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dlansy_Tile_Async(norm,uplo,A,result,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: result(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlansy_Tile_Async_c(norm,uplo,A,c_loc(result),sequence,request)
      end subroutine PLASMA_dlansy_Tile_Async
#endif


      subroutine PLASMA_dlansy_Tile_Async(norm,uplo,A,result,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: result(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlansy_Tile_Async_c(norm,uplo,A,c_loc(result),sequence,request)
      end subroutine PLASMA_dlansy_Tile_Async


      subroutine PLASMA_dlantr_Tile_Async(norm,uplo,diag,A,result,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(inout), target :: result(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlantr_Tile_Async_c(norm,uplo,diag,A,c_loc(result),sequence,request)
      end subroutine PLASMA_dlantr_Tile_Async


      subroutine PLASMA_dlaset_Tile_Async(uplo,alpha,beta,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlaset_Tile_Async_c(uplo,alpha,beta,A,sequence,request)
      end subroutine PLASMA_dlaset_Tile_Async


      subroutine PLASMA_dlaswp_Tile_Async(A,K1,K2,IPIV,INCX,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlaswp_Tile_Async_c(A,K1,K2,c_loc(IPIV),INCX,sequence,request)
      end subroutine PLASMA_dlaswp_Tile_Async


      subroutine PLASMA_dlaswpc_Tile_Async(A,K1,K2,IPIV,INCX,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlaswpc_Tile_Async_c(A,K1,K2,c_loc(IPIV),INCX,sequence,request)
      end subroutine PLASMA_dlaswpc_Tile_Async


      subroutine PLASMA_dlauum_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dlauum_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_dlauum_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)

      subroutine PLASMA_dplgsy_Tile_Async(bump,A,seed,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dplgsy_Tile_Async_c(bump,A,seed,sequence,request)
      end subroutine PLASMA_dplgsy_Tile_Async
#endif


      subroutine PLASMA_dplgsy_Tile_Async(bump,A,seed,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_double), intent(in) :: bump
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dplgsy_Tile_Async_c(bump,A,seed,sequence,request)
      end subroutine PLASMA_dplgsy_Tile_Async


      subroutine PLASMA_dplrnt_Tile_Async(A,seed,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dplrnt_Tile_Async_c(A,seed,sequence,request)
      end subroutine PLASMA_dplrnt_Tile_Async


      subroutine PLASMA_dpltmg_Tile_Async(mtxtype,A,seed,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: mtxtype
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpltmg_Tile_Async_c(mtxtype,A,seed,sequence,request)
      end subroutine PLASMA_dpltmg_Tile_Async


      subroutine PLASMA_dpocon_Tile_Async(uplo,A,anorm,rcond,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: anorm
         real(kind=c_double), intent(inout), target :: rcond(*)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpocon_Tile_Async_c(uplo,A,anorm,c_loc(rcond),sequence,request)
      end subroutine PLASMA_dpocon_Tile_Async


      subroutine PLASMA_dposv_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dposv_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_dposv_Tile_Async


      subroutine PLASMA_dpotrf_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotrf_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_dpotrf_Tile_Async


      subroutine PLASMA_dpotri_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotri_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_dpotri_Tile_Async


      subroutine PLASMA_dpotrs_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dpotrs_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_dpotrs_Tile_Async


      subroutine PLASMA_dsymm_Tile_Async(side,uplo,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_dsymm_Tile_Async


      subroutine PLASMA_dsyr2k_Tile_Async(uplo,trans,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_dsyr2k_Tile_Async


      subroutine PLASMA_dsyrk_Tile_Async(uplo,trans,alpha,A,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: trans
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_double), intent(in) :: beta
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dsyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request)
      end subroutine PLASMA_dsyrk_Tile_Async


      subroutine PLASMA_dtrmm_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrmm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_dtrmm_Tile_Async


      subroutine PLASMA_dtrsm_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_dtrsm_Tile_Async


      subroutine PLASMA_dtrsmpl_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsmpl_Tile_Async_c(A,L,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_dtrsmpl_Tile_Async


      subroutine PLASMA_dtrsmrv_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: diag
         real(kind=c_double), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrsmrv_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_dtrsmrv_Tile_Async


      subroutine PLASMA_dtrtri_Tile_Async(uplo,diag,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: diag
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dtrtri_Tile_Async_c(uplo,diag,A,sequence,request)
      end subroutine PLASMA_dtrtri_Tile_Async


      subroutine PLASMA_dorglq_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dorglq_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_dorglq_Tile_Async


      subroutine PLASMA_dorgqr_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dorgqr_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_dorgqr_Tile_Async


      subroutine PLASMA_dormlq_Tile_Async(side,trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dormlq_Tile_Async_c(side,trans,A,T,B,sequence,request)
      end subroutine PLASMA_dormlq_Tile_Async


      subroutine PLASMA_dormqr_Tile_Async(side,trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_dormqr_Tile_Async_c(side,trans,A,T,B,sequence,request)
      end subroutine PLASMA_dormqr_Tile_Async

!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!  FORTRAN API - workspace allocation
!

      subroutine PLASMA_Alloc_Workspace_dgebrd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgebrd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgebrd


      subroutine PLASMA_Alloc_Workspace_dgeev(N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgeev_c(N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgeev


      subroutine PLASMA_Alloc_Workspace_dgehrd(N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgehrd_c(N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgehrd


      subroutine PLASMA_Alloc_Workspace_dgelqf(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgelqf_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_dgelqf


      subroutine PLASMA_Alloc_Workspace_dgelqf_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgelqf_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgelqf_Tile


      subroutine PLASMA_Alloc_Workspace_dgels(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgels_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_dgels


      subroutine PLASMA_Alloc_Workspace_dgels_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgels_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgels_Tile


      subroutine PLASMA_Alloc_Workspace_dgeqrf(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgeqrf_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_dgeqrf


      subroutine PLASMA_Alloc_Workspace_dgeqrf_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgeqrf_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgeqrf_Tile


      subroutine PLASMA_Alloc_Workspace_dgesdd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgesdd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgesdd


      subroutine PLASMA_Alloc_Workspace_dgesv_incpiv(N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
         type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgesv_incpiv_c(N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_dgesv_incpiv


      subroutine PLASMA_Alloc_Workspace_dgesv_incpiv_Tile(N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
         type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgesv_incpiv_Tile_c(N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_dgesv_incpiv_Tile


      subroutine PLASMA_Alloc_Workspace_dgesvd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgesvd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dgesvd


      subroutine PLASMA_Alloc_Workspace_dgetrf_incpiv(M,N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
         type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgetrf_incpiv_c(M,N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_dgetrf_incpiv


      subroutine PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile(N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descL ! descL is **, so pass by reference
         type(c_ptr), intent(inout) :: IPIV ! IPIV is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile_c(N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile


      subroutine PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile(A,W,Wpivot,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), intent(inout) :: Wpivot ! Wpivot is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile_c(A,W,Wpivot)
      end subroutine PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile


      subroutine PLASMA_Alloc_Workspace_dgetri_Tile_Async(A,W,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_Alloc_Workspace_dgetri_Tile_Async_c(A,W)
      end subroutine PLASMA_Alloc_Workspace_dgetri_Tile_Async


      subroutine PLASMA_Alloc_Workspace_dsyev(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsyev_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsyev


      subroutine PLASMA_Alloc_Workspace_dsyevd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsyevd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsyevd


      subroutine PLASMA_Alloc_Workspace_dsyevr(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsyevr_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsyevr


      subroutine PLASMA_Alloc_Workspace_dsygv(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsygv_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsygv


      subroutine PLASMA_Alloc_Workspace_dsygvd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsygvd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsygvd


      subroutine PLASMA_Alloc_Workspace_dsytrd(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr), intent(inout) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_dsytrd_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_dsytrd

end module plasma_d
