/**
 *
 * @file coreblas_d.c
 *
 *  PLASMA core_blas tracing kernel
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 *  This file provides the wrapper for each function of the
 *  core_blas library which will generate an event before and
 *  after the execution of the kernel.
 *  This file is automatically generated with convert2eztrace.pl
 *  script. DO NOT MANUALLY EDIT THIS FILE.
 *
 * @version 2.6.0
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated d Tue Jan  7 11:45:26 2014
 *
 **/
#include <eztrace.h>
#include <ev_codes.h>
#include "common.h"
#include "coreblas_ev_codes.h"
#include "coreblas_macros.h"
#undef COMPLEX
#define REAL
FUNCTION_VOID( CORE_dasum, ASUM, void ,
          (PLASMA_enum storev, PLASMA_enum uplo, int M, int N, const double *A, int lda, double *work),
          (storev, uplo, M, N, A, lda, work) )
FUNCTION_VOID( CORE_dbrdalg1, BRDALG, void ,
          ( PLASMA_enum uplo, int n, int nb, double *A, int lda, double *VQ, double *TAUQ, double *VP, double *TAUP, int Vblksiz, int wantz, int i, int sweepid, int m, int grsiz, double *work),
          (uplo, n, nb, A, lda, VQ, TAUQ, VP, TAUP, Vblksiz, wantz, i, sweepid, m, grsiz, work) )
FUNCTION_TYPE( CORE_dgeadd, GEADD, int ,
          (int M, int N, double alpha, const double *A, int LDA, double *B, int LDB),
          (M, N, alpha, A, LDA, B, LDB) )
FUNCTION_TYPE( CORE_dgelqt, GELQT, int ,
          (int M, int N, int IB, double *A, int LDA, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_VOID( CORE_dgemm, GEMM, void ,
          (PLASMA_enum transA, int transB, int M, int N, int K, double alpha, const double *A, int LDA, const double *B, int LDB, double beta, double *C, int LDC),
          (transA, transB, M, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_dgemv, GEMV, void ,
          (PLASMA_enum trans, int m, int n, double alpha, const double *A, int lda, const double *x, int incx, double beta, double *y, int incy),
          (trans, m, n, alpha, A, lda, x, incx, beta, y, incy) )
FUNCTION_VOID( CORE_dgeqp3_init, GEQP3_INIT, void ,
          ( int n, int *jpvt ),
          (n, jpvt) )
FUNCTION_VOID( CORE_dgeqp3_larfg, LARFG, void ,
          ( PLASMA_desc A, int ii, int jj, int i, int j, double *tau, double *beta ),
          (A, ii, jj, i, j, tau, beta) )
FUNCTION_VOID( CORE_dgeqp3_norms, GEQP3_NORMS, void ,
          ( PLASMA_desc A, int ioff, int joff, double *norms1, double *norms2 ),
          (A, ioff, joff, norms1, norms2) )
FUNCTION_VOID( CORE_dgeqp3_pivot, GEQP3_PIVOT, void ,
          ( PLASMA_desc A, double *F, int ldf, int jj, int k, int *jpvt, double *norms1, double *norms2, int *info ),
          (A, F, ldf, jj, k, jpvt, norms1, norms2, info) )
FUNCTION_TYPE( CORE_dgeqp3_tntpiv, GEQRT, int ,
          (int m, int n, double *A, int lda, int *IPIV, double *tau, int *iwork),
          (m, n, A, lda, IPIV, tau, iwork) )
FUNCTION_VOID( CORE_dgeqp3_update, GEQP3_UPDATE, void ,
          ( const double *Ajj, int lda1, double *Ajk, int lda2, const double *Fk, int ldf, int joff, int k, int koff, int nb, double *norms1, double *norms2, int *info ),
          (Ajj, lda1, Ajk, lda2, Fk, ldf, joff, k, koff, nb, norms1, norms2, info) )
FUNCTION_TYPE( CORE_dgeqrt, GEQRT, int ,
          (int M, int N, int IB, double *A, int LDA, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_dgessm, GESSM, int ,
          (int M, int N, int K, int IB, const int *IPIV, const double *L, int LDL, double *A, int LDA),
          (M, N, K, IB, IPIV, L, LDL, A, LDA) )
FUNCTION_TYPE( CORE_dgessq, LASSQ, int ,
          (int M, int N, const double *A, int LDA, double *scale, double *sumsq),
          (M, N, A, LDA, scale, sumsq) )
FUNCTION_TYPE( CORE_dgetrf, GETRF, int ,
          (int m, int n, double *A, int lda, int *IPIV, int *info),
          (m, n, A, lda, IPIV, info) )
FUNCTION_TYPE( CORE_dgetrf_incpiv, GETRF, int ,
          (int M, int N, int IB, double *A, int LDA, int *IPIV, int *INFO),
          (M, N, IB, A, LDA, IPIV, INFO) )
FUNCTION_TYPE( CORE_dgetrf_nopiv, GETRF, int ,
          (int M, int N, int IB, double *A, int LDA),
          (M, N, IB, A, LDA) )
FUNCTION_TYPE( CORE_dgetrf_reclap, GETRF, int ,
          (int M, int N, double *A, int LDA, int *IPIV, int *info),
          (M, N, A, LDA, IPIV, info) )
FUNCTION_TYPE( CORE_dgetrf_rectil, GETRF, int ,
          (const PLASMA_desc A, int *IPIV, int *info),
          (A, IPIV, info) )
FUNCTION_VOID( CORE_dgetrip, GETRIP, void ,
          (int m, int n, double *A, double *W) ,
          (m, n, A, W)  )
FUNCTION_VOID( CORE_dsygst, HEGST, void ,
          (int itype, PLASMA_enum uplo, int N, double *A, int LDA, double *B, int LDB, int *INFO),
          (itype, uplo, N, A, LDA, B, LDB, INFO) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_dsymm, HEMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, int M, int N, double alpha, const double *A, int LDA, const double *B, int LDB, double beta, double *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
#ifdef COMPLEX
FUNCTION_VOID( CORE_dsyr2k, HER2K, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, double alpha, const double *A, int LDA, const double *B, int LDB, double beta, double *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
FUNCTION_TYPE( CORE_dsyrfb, HERFB, int ,
          ( PLASMA_enum uplo, int n, int k, int ib, int nb, const double *A, int lda, const double *T, int ldt, double *C, int ldc, double *WORK, int ldwork ),
          (uplo, n, k, ib, nb, A, lda, T, ldt, C, ldc, WORK, ldwork) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_dsyrk, HERK, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, double alpha, const double *A, int LDA, double beta, double *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
#endif
#ifdef COMPLEX
FUNCTION_TYPE( CORE_dhessq, LASSQ, int ,
          (PLASMA_enum uplo, int N, const double *A, int LDA, double *scale, double *sumsq),
          (uplo, N, A, LDA, scale, sumsq) )
#endif
FUNCTION_VOID( CORE_dlacpy, LACPY, void ,
          (PLASMA_enum uplo, int M, int N, const double *A, int LDA, double *B, int LDB),
          (uplo, M, N, A, LDA, B, LDB) )
FUNCTION_TYPE( CORE_dlacpy_pivot, LACPY, int ,
          ( const PLASMA_desc descA, PLASMA_enum direct, int k1, int k2, const int *ipiv, int *rankin, int *rankout, double *A, int lda, int init),
          (descA, direct, k1, k2, ipiv, rankin, rankout, A, lda, init) )
FUNCTION_VOID( CORE_dlange, LANGE, void ,
          (int norm, int M, int N, const double *A, int LDA, double *work, double *normA),
          (norm, M, N, A, LDA, work, normA) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_dlansy, LANHE, void ,
          (int norm, PLASMA_enum uplo, int N, const double *A, int LDA, double *work, double *normA),
          (norm, uplo, N, A, LDA, work, normA) )
#endif
FUNCTION_VOID( CORE_dlansy, LANSY, void ,
          (int norm, PLASMA_enum uplo, int N, const double *A, int LDA, double *work, double *normA),
          (norm, uplo, N, A, LDA, work, normA) )
FUNCTION_VOID( CORE_dlantr, LANGE, void ,
          (PLASMA_enum norm, PLASMA_enum uplo, PLASMA_enum diag, int M, int N, const double *A, int LDA, double *work, double *normA),
          (norm, uplo, diag, M, N, A, LDA, work, normA) )
FUNCTION_TYPE( CORE_dlarfb_gemm, LARFB, int ,
          (PLASMA_enum side, PLASMA_enum trans, int direct, int storev, int M, int N, int K, const double *V, int LDV, const double *T, int LDT, double *C, int LDC, double *WORK, int LDWORK),
          (side, trans, direct, storev, M, N, K, V, LDV, T, LDT, C, LDC, WORK, LDWORK) )
FUNCTION_VOID( CORE_dlaset2, LASET, void ,
          (PLASMA_enum uplo, int M, int N, double alpha, double *A, int LDA),
          (uplo, M, N, alpha, A, LDA) )
FUNCTION_VOID( CORE_dlaset, LASET, void ,
          (PLASMA_enum uplo, int M, int N, double alpha, double beta, double *A, int LDA),
          (uplo, M, N, alpha, beta, A, LDA) )
FUNCTION_VOID( CORE_dlaswp, LASWP, void ,
          (int N, double *A, int LDA, int I1, int I2, const int *IPIV, int INC),
          (N, A, LDA, I1, I2, IPIV, INC) )
FUNCTION_TYPE( CORE_dlaswp_ontile, LASWP, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc),
          (descA, i1, i2, ipiv, inc) )
FUNCTION_TYPE( CORE_dswptr_ontile, TRSM, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc, const double *Akk, int ldak),
          (descA, i1, i2, ipiv, inc, Akk, ldak) )
FUNCTION_TYPE( CORE_dlaswpc_ontile, LASWP, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc),
          (descA, i1, i2, ipiv, inc) )
FUNCTION_TYPE( CORE_dlatro, LATRO, int ,
          (PLASMA_enum uplo, PLASMA_enum trans, int M, int N, const double *A, int LDA, double *B, int LDB),
          (uplo, trans, M, N, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_dlauum, LAUUM, void ,
          (PLASMA_enum uplo, int N, double *A, int LDA),
          (uplo, N, A, LDA) )
FUNCTION_TYPE( CORE_dpemv, PEMV, int ,
          (PLASMA_enum trans, int storev, int M, int N, int L, double ALPHA, const double *A, int LDA, const double *X, int INCX, double BETA, double *Y, int INCY, double *WORK),
          (trans, storev, M, N, L, ALPHA, A, LDA, X, INCX, BETA, Y, INCY, WORK) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_dplgsy, PLGHE, void ,
          ( double bump, int m, int n, double *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
#endif
FUNCTION_VOID( CORE_dplgsy, PLGSY, void ,
          ( double bump, int m, int n, double *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
FUNCTION_VOID( CORE_dplrnt, PLRNT, void ,
          ( int m, int n, double *A, int lda, int gM, int m0, int n0, unsigned long long int seed ),
          (m, n, A, lda, gM, m0, n0, seed) )
FUNCTION_TYPE( CORE_dpltmg, PLRNT, int ,
          ( PLASMA_enum mtxtype, int M, int N, double *A, int LDA, int gM, int gN, int m0, int n0, unsigned long long int seed ),
          (mtxtype, M, N, A, LDA, gM, gN, m0, n0, seed) )
FUNCTION_TYPE( CORE_dpltmg_chebvand, PLRNT, int ,
          ( int M, int N, double *A, int LDA, int gN, int m0, int n0, double *W ),
          (M, N, A, LDA, gN, m0, n0, W) )
FUNCTION_TYPE( CORE_dpltmg_circul, PLRNT, int ,
          ( int M, int N, double *A, int LDA, int gM, int m0, int n0, const double *V ),
          (M, N, A, LDA, gM, m0, n0, V) )
FUNCTION_VOID( CORE_dpltmg_condexq, PLRNT, void ,
          ( int M, int N, double *Q, int LDQ ),
          (M, N, Q, LDQ) )
FUNCTION_VOID( CORE_dpltmg_fiedler, PLRNT, void ,
          ( int M, int N, const double *X, int incX, const double *Y, int incY, double *A, int LDA ),
          (M, N, X, incX, Y, incY, A, LDA) )
FUNCTION_TYPE( CORE_dpltmg_hankel, PLRNT, int ,
          ( PLASMA_enum uplo, int M, int N, double *A, int LDA, int m0, int n0, int nb, const double *V1, const double *V2 ),
          (uplo, M, N, A, LDA, m0, n0, nb, V1, V2) )
FUNCTION_VOID( CORE_dpltmg_toeppd1, PLRNT, void ,
          ( int gM, int m0, int M, double *W, unsigned long long int seed ),
          (gM, m0, M, W, seed) )
FUNCTION_VOID( CORE_dpltmg_toeppd2, PLRNT, void ,
          ( int M, int N, int K, int m0, int n0, const double *W, double *A, int LDA ),
          (M, N, K, m0, n0, W, A, LDA) )
FUNCTION_VOID( CORE_dpotrf, POTRF, void ,
          (PLASMA_enum uplo, int N, double *A, int LDA, int *INFO),
          (uplo, N, A, LDA, INFO) )
FUNCTION_VOID( CORE_dsetvar, SETVAR, void ,
          (const double *alpha, double *x),
          (alpha, x) )
FUNCTION_VOID( CORE_dshiftw, SHIFTW, void ,
          (int s, int cl, int m, int n, int L, double *A, double *W) ,
          (s, cl, m, n, L, A, W)  )
FUNCTION_VOID( CORE_dshift, SHIFT, void ,
          (int s, int m, int n, int L, double *A) ,
          (s, m, n, L, A)  )
FUNCTION_TYPE( CORE_dssssm, SSSSM, int ,
          (int M1, int N1, int M2, int N2, int K, int IB, double *A1, int LDA1, double *A2, int LDA2, const double *L1, int LDL1, const double *L2, int LDL2, const int *IPIV),
          (M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, L1, LDL1, L2, LDL2, IPIV) )
FUNCTION_VOID( CORE_dswpab, SWPAB, void ,
          (int i, int n1, int n2, double *A, double *work) ,
          (i, n1, n2, A, work)  )
FUNCTION_VOID( CORE_dsymm, SYMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, int M, int N, double alpha, const double *A, int LDA, const double *B, int LDB, double beta, double *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_dsyr2k, SYR2K, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, double alpha, const double *A, int LDA, const double *B, int LDB, double beta, double *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_dsyrk, SYRK, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, double alpha, const double *A, int LDA, double beta, double *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
FUNCTION_TYPE( CORE_dsyssq, LASSQ, int ,
          (PLASMA_enum uplo, int N, const double *A, int LDA, double *scale, double *sumsq),
          (uplo, N, A, LDA, scale, sumsq) )
FUNCTION_VOID( CORE_dtrasm, ASUM, void ,
          (PLASMA_enum storev, PLASMA_enum uplo, PLASMA_enum diag, int M, int N, const double *A, int lda, double *work),
          (storev, uplo, diag, M, N, A, lda, work) )
FUNCTION_VOID( CORE_dtrdalg1, TRDALG, void ,
          ( int n, int nb, double *A, int lda, double *V, double *TAU, int Vblksiz, int wantz, int i, int sweepid, int m, int grsiz, double *work),
          (n, nb, A, lda, V, TAU, Vblksiz, wantz, i, sweepid, m, grsiz, work) )
FUNCTION_VOID( CORE_dtrmm, TRMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, int M, int N, double alpha, const double *A, int LDA, double *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_dtrsm, TRSM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, int M, int N, double alpha, const double *A, int LDA, double *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_TYPE( CORE_dtrssq, LASSQ, int ,
          (PLASMA_enum uplo, PLASMA_enum diag, int M, int N, const double *A, int LDA, double *scale, double *sumsq),
          (uplo, diag, M, N, A, LDA, scale, sumsq) )
FUNCTION_VOID( CORE_dtrtri, TRTRI, void ,
          (PLASMA_enum uplo, PLASMA_enum diag, int N, double *A, int LDA, int *info),
          (uplo, diag, N, A, LDA, info) )
FUNCTION_TYPE( CORE_dtslqt, TSLQT, int ,
          (int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_dtsmlq, TSMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, double *A1, int LDA1, double *A2, int LDA2, const double *V, int LDV, const double *T, int LDT, double *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_dtsmlq_corner, TSMLQ, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, double *A1, int lda1, double *A2, int lda2, double *A3, int lda3, const double *V, int ldv, const double *T, int ldt, double *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_dtsmlq_sytra1, TSMLQ, int ,
          ( PLASMA_enum side, PLASMA_enum trans, int m1, int n1, int m2, int n2, int k, int ib, double *A1, int lda1, double *A2, int lda2, const double *V, int ldv, const double *T, int ldt, double *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_dtsmqr, TSMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, double *A1, int LDA1, double *A2, int LDA2, const double *V, int LDV, const double *T, int LDT, double *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_dtsmqr_corner, TSMQR, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, double *A1, int lda1, double *A2, int lda2, double *A3, int lda3, const double *V, int ldv, const double *T, int ldt, double *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_dtsmqr_sytra1, TSMQR, int ,
          ( PLASMA_enum side, PLASMA_enum trans, int m1, int n1, int m2, int n2, int k, int ib, double *A1, int lda1, double *A2, int lda2, const double *V, int ldv, const double *T, int ldt, double *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_dtsqrt, TSQRT, int ,
          (int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_dtstrf, TSTRF, int ,
          (int M, int N, int IB, int NB, double *U, int LDU, double *A, int LDA, double *L, int LDL, int *IPIV, double *WORK, int LDWORK, int *INFO),
          (M, N, IB, NB, U, LDU, A, LDA, L, LDL, IPIV, WORK, LDWORK, INFO) )
FUNCTION_TYPE( CORE_dttlqt, TTLQT, int ,
          (int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_dttmlq, TTMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, double *A1, int LDA1, double *A2, int LDA2, const double *V, int LDV, const double *T, int LDT, double *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_dttmqr, TTMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, double *A1, int LDA1, double *A2, int LDA2, const double *V, int LDV, const double *T, int LDT, double *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_dttqrt, TTQRT, int ,
          (int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2, double *T, int LDT, double *TAU, double *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_dormlq, UNMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, int IB, const double *A, int LDA, const double *T, int LDT, double *C, int LDC, double *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )
FUNCTION_TYPE( CORE_dormqr, UNMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, int IB, const double *A, int LDA, const double *T, int LDT, double *C, int LDC, double *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )

