/**
 *
 * @file plasma_df77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *  This file is automatically generated by tools/genf77interface.pl
 *
 *  WARNING: This file is automatically generated through
 *  tools/genf77interface.pl script, please do not manually edit it.
 *
 * @version 2.6.0
 * @author Bilel Hadri
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated d Tue Jan  7 11:45:15 2014
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef COMPLEX
#define REAL


/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
#define PLASMA_DLAPACK_TO_TILE PLASMA_FNAME(dlapack_to_tile, DLAPACK_TO_TILE)
#define PLASMA_DLAPACK_TO_TILE_ASYNC PLASMA_FNAME(dlapack_to_tile_async, DLAPACK_TO_TILE_ASYNC)
#define PLASMA_DTILE_TO_LAPACK PLASMA_FNAME(dtile_to_lapack, DTILE_TO_LAPACK)
#define PLASMA_DTILE_TO_LAPACK_ASYNC PLASMA_FNAME(dtile_to_lapack_async, DTILE_TO_LAPACK_ASYNC)
#define PLASMA_DGEBRD          PLASMA_FNAME(dgebrd       , DGEBRD       )
#define PLASMA_DGECFI          PLASMA_FNAME(dgecfi       , DGECFI       )
#define PLASMA_DGECFI_ASYNC    PLASMA_FNAME(dgecfi_async , DGECFI_ASYNC )
#define PLASMA_DGECON          PLASMA_FNAME(dgecon       , ZGECON       )
#define PLASMA_DGELQF          PLASMA_FNAME(dgelqf       , DGELQF       )
#define PLASMA_DGELQS          PLASMA_FNAME(dgelqs       , DGELQS       )
#define PLASMA_DGELS           PLASMA_FNAME(dgels        , DGELS        )
#define PLASMA_DGEMM           PLASMA_FNAME(dgemm        , DGEMM        )
#define PLASMA_DGEQP3          PLASMA_FNAME(dgeqp3       , ZGEQP3       )
#define PLASMA_DGEQRF          PLASMA_FNAME(dgeqrf       , DGEQRF       )
#define PLASMA_DGEQRS          PLASMA_FNAME(dgeqrs       , DGEQRS       )
#define PLASMA_DGESDD          PLASMA_FNAME(dgesdd       , DGESDD       )
#define PLASMA_DGESV           PLASMA_FNAME(dgesv        , DGESV        )
#define PLASMA_DGESV_INCPIV    PLASMA_FNAME(dgesv_incpiv , DGESV_INCPIV )
#define PLASMA_DGESVD          PLASMA_FNAME(dgesvd       , DGESVD       )
#define PLASMA_DGETMI          PLASMA_FNAME(dgetmi       , DGETMI       )
#define PLASMA_DGETMI_ASYNC    PLASMA_FNAME(dgetmi_async , DGETMI_ASYNC )
#define PLASMA_DGETRF          PLASMA_FNAME(dgetrf       , DGETRF       )
#define PLASMA_DGETRF_INCPIV   PLASMA_FNAME(dgetrf_incpiv, DGETRF_INCPIV)
#define PLASMA_DGETRF_NOPIV    PLASMA_FNAME(dgetrf_nopiv , DGETRF_NOPIV )
#define PLASMA_DGETRF_TNTPIV   PLASMA_FNAME(dgetrf_tntpiv, DGETRF_TNTPIV)
#define PLASMA_DGETRI          PLASMA_FNAME(dgetri       , DGETRI       )
#define PLASMA_DGETRS          PLASMA_FNAME(dgetrs       , DGETRS       )
#define PLASMA_DGETRS_INCPIV   PLASMA_FNAME(dgetrs_incpiv, DGETRS_INCPIV)
#define PLASMA_DSYEV           PLASMA_FNAME(dsyev        , DSYEV        )
#define PLASMA_DSYEVD          PLASMA_FNAME(dsyevd       , DSYEVD       )
#define PLASMA_DSYEVR          PLASMA_FNAME(dsyevr       , DSYEVR       )
#define PLASMA_DSYGST          PLASMA_FNAME(dsygst       , DSYGST       )
#define PLASMA_DSYGV           PLASMA_FNAME(dsygv        , DSYGV        )
#define PLASMA_DSYGVD          PLASMA_FNAME(dsygvd       , DSYGVD       )
#ifdef COMPLEX
#define PLASMA_DSYMM           PLASMA_FNAME(dsymm        , DSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_DSYR2K          PLASMA_FNAME(dsyr2k       , DSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_DSYRK           PLASMA_FNAME(dsyrk        , DSYRK        )
#endif
#define PLASMA_DSYTRD          PLASMA_FNAME(dsytrd       , DSYTRD       )
#define PLASMA_DLACPY          PLASMA_FNAME(dlacpy       , DLACPY       )
#define PLASMA_DLANGE          PLASMA_FNAME(dlange       , DLANGE       )
#ifdef COMPLEX
#define PLASMA_DLANSY          PLASMA_FNAME(dlansy       , DLANSY       )
#endif
#define PLASMA_DLANSY          PLASMA_FNAME(dlansy       , DLANSY       )
#define PLASMA_DLANTR          PLASMA_FNAME(dlantr       , DLANTR       )
#define PLASMA_DLASET          PLASMA_FNAME(dlaset       , DLASET       )
#define PLASMA_DLASWP          PLASMA_FNAME(dlaswp       , DLASWP       )
#define PLASMA_DLASWPC         PLASMA_FNAME(dlaswpc      , DLASWPC      )
#define PLASMA_DLAUUM          PLASMA_FNAME(dlauum       , DLAUUM       )
#ifdef COMPLEX
#define PLASMA_DPLGSY          PLASMA_FNAME(dplgsy       , DPLGSY       )
#endif
#define PLASMA_DPLGSY          PLASMA_FNAME(dplgsy       , DPLGSY       )
#define PLASMA_DPLRNT          PLASMA_FNAME(dplrnt       , DPLRNT       )
#define PLASMA_DPLTMG          PLASMA_FNAME(dpltmg       , DPLTMG       )
#define PLASMA_DPOCON          PLASMA_FNAME(dpocon       , ZPOCON       )
#define PLASMA_DPOSV           PLASMA_FNAME(dposv        , DPOSV        )
#define PLASMA_DPOTRF          PLASMA_FNAME(dpotrf       , DPOTRF       )
#define PLASMA_DPOTRI          PLASMA_FNAME(dpotri       , DPOTRI       )
#define PLASMA_DPOTRS          PLASMA_FNAME(dpotrs       , DPOTRS       )
#define PLASMA_DSYMM           PLASMA_FNAME(dsymm        , DSYMM        )
#define PLASMA_DSYR2K          PLASMA_FNAME(dsyr2k       , DSYR2K       )
#define PLASMA_DSYRK           PLASMA_FNAME(dsyrk        , DSYRK        )
#define PLASMA_DTRMM           PLASMA_FNAME(dtrmm        , DTRMM        )
#define PLASMA_DTRSM           PLASMA_FNAME(dtrsm        , DTRSM        )
#define PLASMA_DTRSMPL         PLASMA_FNAME(dtrsmpl      , DTRSMPL      )
#define PLASMA_DTRSMRV         PLASMA_FNAME(dtrsmrv      , DTRSMRV      )
#define PLASMA_DTRTRI          PLASMA_FNAME(dtrtri       , DTRTRI       )
#define PLASMA_DORGLQ          PLASMA_FNAME(dorglq       , DORGLQ       )
#define PLASMA_DORGQR          PLASMA_FNAME(dorgqr       , DORGQR       )
#define PLASMA_DORMLQ          PLASMA_FNAME(dormlq       , DORMLQ       )
#define PLASMA_DORMQR          PLASMA_FNAME(dormqr       , DORMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
#define PLASMA_DGEBRD_TILE          PLASMA_TILE_FNAME(dgebrd       , DGEBRD       )
#define PLASMA_DGECON_TILE          PLASMA_TILE_FNAME(dgecon       , ZGECON       )
#define PLASMA_DGELQF_TILE          PLASMA_TILE_FNAME(dgelqf       , DGELQF       )
#define PLASMA_DGELQS_TILE          PLASMA_TILE_FNAME(dgelqs       , DGELQS       )
#define PLASMA_DGELS_TILE           PLASMA_TILE_FNAME(dgels        , DGELS        )
#define PLASMA_DGEMM_TILE           PLASMA_TILE_FNAME(dgemm        , DGEMM        )
#define PLASMA_DGEQP3_TILE          PLASMA_TILE_FNAME(dgeqp3       , ZGEQP3       )
#define PLASMA_DGEQRF_TILE          PLASMA_TILE_FNAME(dgeqrf       , DGEQRF       )
#define PLASMA_DGEQRS_TILE          PLASMA_TILE_FNAME(dgeqrs       , DGEQRS       )
#define PLASMA_DGESDD_TILE          PLASMA_TILE_FNAME(dgesdd       , DGESDD       )
#define PLASMA_DGESV_TILE           PLASMA_TILE_FNAME(dgesv        , DGESV        )
#define PLASMA_DGESV_INCPIV_TILE    PLASMA_TILE_FNAME(dgesv_incpiv , DGESV_INCPIV )
#define PLASMA_DGESVD_TILE          PLASMA_TILE_FNAME(dgesvd       , DGESVD       )
#define PLASMA_DGETRF_TILE          PLASMA_TILE_FNAME(dgetrf       , DGETRF       )
#define PLASMA_DGETRF_INCPIV_TILE   PLASMA_TILE_FNAME(dgetrf_incpiv, DGETRF_INCPIV)
#define PLASMA_DGETRF_NOPIV_TILE    PLASMA_TILE_FNAME(dgetrf_nopiv , DGETRF_NOPIV )
#define PLASMA_DGETRF_TNTPIV_TILE   PLASMA_TILE_FNAME(dgetrf_tntpiv, DGETRF_TNTPIV)
#define PLASMA_DGETRI_TILE          PLASMA_TILE_FNAME(dgetri       , DGETRI       )
#define PLASMA_DGETRS_TILE          PLASMA_TILE_FNAME(dgetrs       , DGETRS       )
#define PLASMA_DGETRS_INCPIV_TILE   PLASMA_TILE_FNAME(dgetrs_incpiv, DGETRS_INCPIV)
#define PLASMA_DSYEV_TILE           PLASMA_TILE_FNAME(dsyev        , DSYEV        )
#define PLASMA_DSYEVD_TILE          PLASMA_TILE_FNAME(dsyevd       , DSYEVD       )
#define PLASMA_DSYEVR_TILE          PLASMA_TILE_FNAME(dsyevr       , DSYEVR       )
#define PLASMA_DSYGST_TILE          PLASMA_TILE_FNAME(dsygst       , DSYGST       )
#define PLASMA_DSYGV_TILE           PLASMA_TILE_FNAME(dsygv        , DSYGV        )
#define PLASMA_DSYGVD_TILE          PLASMA_TILE_FNAME(dsygvd       , DSYGVD       )
#ifdef COMPLEX
#define PLASMA_DSYMM_TILE           PLASMA_TILE_FNAME(dsymm        , DSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_DSYR2K_TILE          PLASMA_TILE_FNAME(dsyr2k       , DSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_DSYRK_TILE           PLASMA_TILE_FNAME(dsyrk        , DSYRK        )
#endif
#define PLASMA_DSYTRD_TILE          PLASMA_TILE_FNAME(dsytrd       , DSYTRD       )
#define PLASMA_DLACPY_TILE          PLASMA_TILE_FNAME(dlacpy       , DLACPY       )
#define PLASMA_DLANGE_TILE          PLASMA_TILE_FNAME(dlange       , DLANGE       )
#ifdef COMPLEX
#define PLASMA_DLANSY_TILE          PLASMA_TILE_FNAME(dlansy       , DLANSY       )
#endif
#define PLASMA_DLANSY_TILE          PLASMA_TILE_FNAME(dlansy       , DLANSY       )
#define PLASMA_DLANTR_TILE          PLASMA_TILE_FNAME(dlantr       , DLANTR       )
#define PLASMA_DLASET_TILE          PLASMA_TILE_FNAME(dlaset       , DLASET       )
#define PLASMA_DLASWP_TILE          PLASMA_TILE_FNAME(dlaswp       , DLASWP       )
#define PLASMA_DLASWPC_TILE         PLASMA_TILE_FNAME(dlaswpc      , DLASWPC      )
#define PLASMA_DLAUUM_TILE          PLASMA_TILE_FNAME(dlauum       , DLAUUM       )
#ifdef COMPLEX
#define PLASMA_DPLGSY_TILE          PLASMA_TILE_FNAME(dplgsy       , DPLGSY       )
#endif
#define PLASMA_DPLGSY_TILE          PLASMA_TILE_FNAME(dplgsy       , DPLGSY       )
#define PLASMA_DPLRNT_TILE          PLASMA_TILE_FNAME(dplrnt       , DPLRNT       )
#define PLASMA_DPLTMG_TILE          PLASMA_TILE_FNAME(dpltmg       , DPLTMG       )
#define PLASMA_DPOCON_TILE          PLASMA_TILE_FNAME(dpocon       , ZPOCON       )
#define PLASMA_DPOSV_TILE           PLASMA_TILE_FNAME(dposv        , DPOSV        )
#define PLASMA_DPOTRF_TILE          PLASMA_TILE_FNAME(dpotrf       , DPOTRF       )
#define PLASMA_DPOTRI_TILE          PLASMA_TILE_FNAME(dpotri       , DPOTRI       )
#define PLASMA_DPOTRS_TILE          PLASMA_TILE_FNAME(dpotrs       , DPOTRS       )
#define PLASMA_DSYMM_TILE           PLASMA_TILE_FNAME(dsymm        , DSYMM        )
#define PLASMA_DSYR2K_TILE          PLASMA_TILE_FNAME(dsyr2k       , DSYR2K       )
#define PLASMA_DSYRK_TILE           PLASMA_TILE_FNAME(dsyrk        , DSYRK        )
#define PLASMA_DTRMM_TILE           PLASMA_TILE_FNAME(dtrmm        , DTRMM        )
#define PLASMA_DTRSM_TILE           PLASMA_TILE_FNAME(dtrsm        , DTRSM        )
#define PLASMA_DTRSMPL_TILE         PLASMA_TILE_FNAME(dtrsmpl      , DTRSMPL      )
#define PLASMA_DTRSMRV_TILE         PLASMA_TILE_FNAME(dtrsmrv      , DTRSMRV      )
#define PLASMA_DTRTRI_TILE          PLASMA_TILE_FNAME(dtrtri       , DTRTRI       )
#define PLASMA_DORGLQ_TILE          PLASMA_TILE_FNAME(dorglq       , DORGLQ       )
#define PLASMA_DORGQR_TILE          PLASMA_TILE_FNAME(dorgqr       , DORGQR       )
#define PLASMA_DORMLQ_TILE          PLASMA_TILE_FNAME(dormlq       , DORMLQ       )
#define PLASMA_DORMQR_TILE          PLASMA_TILE_FNAME(dormqr       , DORMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
#define PLASMA_DGEBRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgebrd       , DGEBRD       )
#define PLASMA_DGECON_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgecon       , ZGECON       )
#define PLASMA_DGELQF_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgelqf       , DGELQF       )
#define PLASMA_DGELQS_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgelqs       , DGELQS       )
#define PLASMA_DGELS_TILE_ASYNC           PLASMA_ASYNC_FNAME(dgels        , DGELS        )
#define PLASMA_DGEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(dgemm        , DGEMM        )
#define PLASMA_DGEQP3_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgeqp3       , ZGEQP3       )
#define PLASMA_DGEQRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgeqrf       , DGEQRF       )
#define PLASMA_DGEQRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgeqrs       , DGEQRS       )
#define PLASMA_DGESDD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgesdd       , DGESDD       )
#define PLASMA_DGESV_TILE_ASYNC           PLASMA_ASYNC_FNAME(dgesv        , DGESV        )
#define PLASMA_DGESV_INCPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(dgesv_incpiv , DGESV_INCPIV )
#define PLASMA_DGESVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgesvd       , DGESVD       )
#define PLASMA_DGETRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgetrf       , DGETRF       )
#define PLASMA_DGETRF_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(dgetrf_incpiv, DGETRF_INCPIV)
#define PLASMA_DGETRF_NOPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(dgetrf_nopiv , DGETRF_NOPIV )
#define PLASMA_DGETRF_TNTPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(dgetrf_tntpiv, DGETRF_TNTPIV)
#define PLASMA_DGETRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgetri       , DGETRI       )
#define PLASMA_DGETRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(dgetrs       , DGETRS       )
#define PLASMA_DGETRS_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(dgetrs_incpiv, DGETRS_INCPIV)
#define PLASMA_DSYEV_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsyev        , DSYEV        )
#define PLASMA_DSYEVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsyevd       , DSYEVD       )
#define PLASMA_DSYEVR_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsyevr       , DSYEVR       )
#define PLASMA_DSYGST_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsygst       , DSYGST       )
#define PLASMA_DSYGV_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsygv        , DSYGV        )
#define PLASMA_DSYGVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsygvd       , DSYGVD       )
#ifdef COMPLEX
#define PLASMA_DSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsymm        , DSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_DSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsyr2k       , DSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_DSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsyrk        , DSYRK        )
#endif
#define PLASMA_DSYTRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsytrd       , DSYTRD       )
#define PLASMA_DLACPY_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlacpy       , DLACPY       )
#define PLASMA_DLANGE_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlange       , DLANGE       )
#ifdef COMPLEX
#define PLASMA_DLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlansy       , DLANSY       )
#endif
#define PLASMA_DLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlansy       , DLANSY       )
#define PLASMA_DLANTR_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlantr       , DLANTR       )
#define PLASMA_DLASET_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlaset       , DLASET       )
#define PLASMA_DLASWP_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlaswp       , DLASWP       )
#define PLASMA_DLASWPC_TILE_ASYNC         PLASMA_ASYNC_FNAME(dlaswpc      , DLASWPC      )
#define PLASMA_DLAUUM_TILE_ASYNC          PLASMA_ASYNC_FNAME(dlauum       , DLAUUM       )
#ifdef COMPLEX
#define PLASMA_DPLGSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(dplgsy       , DPLGSY       )
#endif
#define PLASMA_DPLGSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(dplgsy       , DPLGSY       )
#define PLASMA_DPLRNT_TILE_ASYNC          PLASMA_ASYNC_FNAME(dplrnt       , DPLRNT       )
#define PLASMA_DPLTMG_TILE_ASYNC          PLASMA_ASYNC_FNAME(dpltmg       , DPLTMG       )
#define PLASMA_DPOCON_TILE_ASYNC          PLASMA_ASYNC_FNAME(dpocon       , ZPOCON       )
#define PLASMA_DPOSV_TILE_ASYNC           PLASMA_ASYNC_FNAME(dposv        , DPOSV        )
#define PLASMA_DPOTRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(dpotrf       , DPOTRF       )
#define PLASMA_DPOTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(dpotri       , DPOTRI       )
#define PLASMA_DPOTRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(dpotrs       , DPOTRS       )
#define PLASMA_DSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsymm        , DSYMM        )
#define PLASMA_DSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(dsyr2k       , DSYR2K       )
#define PLASMA_DSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(dsyrk        , DSYRK        )
#define PLASMA_DTRMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(dtrmm        , DTRMM        )
#define PLASMA_DTRSM_TILE_ASYNC           PLASMA_ASYNC_FNAME(dtrsm        , DTRSM        )
#define PLASMA_DTRSMPL_TILE_ASYNC         PLASMA_ASYNC_FNAME(dtrsmpl      , DTRSMPL      )
#define PLASMA_DTRSMRV_TILE_ASYNC         PLASMA_ASYNC_FNAME(dtrsmrv      , DTRSMRV      )
#define PLASMA_DTRTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(dtrtri       , DTRTRI       )
#define PLASMA_DORGLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(dorglq       , DORGLQ       )
#define PLASMA_DORGQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(dorgqr       , DORGQR       )
#define PLASMA_DORMLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(dormlq       , DORMLQ       )
#define PLASMA_DORMQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(dormqr       , DORMQR       )

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
#define PLASMA_ALLOC_WORKSPACE_DGEBRD              PLASMA_WS_FNAME(dgebrd            , DGEBRD            )
#define PLASMA_ALLOC_WORKSPACE_DGEEV               PLASMA_WS_FNAME(dgeev             , DGEEV             )
#define PLASMA_ALLOC_WORKSPACE_DGEHRD              PLASMA_WS_FNAME(dgehrd            , DGEHRD            )
#define PLASMA_ALLOC_WORKSPACE_DGELQF              PLASMA_WS_FNAME(dgelqf            , DGELQF            )
#define PLASMA_ALLOC_WORKSPACE_DGELQF_TILE         PLASMA_WS_FNAME(dgelqf_tile       , DGELQF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_DGELS               PLASMA_WS_FNAME(dgels             , DGELS             )
#define PLASMA_ALLOC_WORKSPACE_DGELS_TILE          PLASMA_WS_FNAME(dgels_tile        , DGELS_TILE        )
#define PLASMA_ALLOC_WORKSPACE_DGEQRF              PLASMA_WS_FNAME(dgeqrf            , DGEQRF            )
#define PLASMA_ALLOC_WORKSPACE_DGEQRF_TILE         PLASMA_WS_FNAME(dgeqrf_tile       , DGEQRF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_DGESDD              PLASMA_WS_FNAME(dgesdd            , DGESDD            )
#define PLASMA_ALLOC_WORKSPACE_DGESV_INCPIV        PLASMA_WS_FNAME(dgesv_incpiv      , DGESV_INCPIV      )
#define PLASMA_ALLOC_WORKSPACE_DGESV_INCPIV_TILE   PLASMA_WS_FNAME(dgesv_incpiv_tile , DGESV_INCPIV_TILE )
#define PLASMA_ALLOC_WORKSPACE_DGESVD              PLASMA_WS_FNAME(dgesvd            , DGESVD            )
#define PLASMA_ALLOC_WORKSPACE_DGETRF_INCPIV       PLASMA_WS_FNAME(dgetrf_incpiv     , DGETRF_INCPIV     )
#define PLASMA_ALLOC_WORKSPACE_DGETRF_INCPIV_TILE  PLASMA_WS_FNAME(dgetrf_incpiv_tile, DGETRF_INCPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_DGETRF_TNTPIV_TILE  PLASMA_WS_FNAME(dgetrf_tntpiv_tile, DGETRF_TNTPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_DGETRI_TILE_ASYNC   PLASMA_WS_FNAME(dgetri_tile_async , DGETRI_TILE_ASYNC )
#define PLASMA_ALLOC_WORKSPACE_DSYEV               PLASMA_WS_FNAME(dsyev             , DSYEV             )
#define PLASMA_ALLOC_WORKSPACE_DSYEVD              PLASMA_WS_FNAME(dsyevd            , DSYEVD            )
#define PLASMA_ALLOC_WORKSPACE_DSYEVR              PLASMA_WS_FNAME(dsyevr            , DSYEVR            )
#define PLASMA_ALLOC_WORKSPACE_DSYGV               PLASMA_WS_FNAME(dsygv             , DSYGV             )
#define PLASMA_ALLOC_WORKSPACE_DSYGVD              PLASMA_WS_FNAME(dsygvd            , DSYGVD            )
#define PLASMA_ALLOC_WORKSPACE_DSYTRD              PLASMA_WS_FNAME(dsytrd            , DSYTRD            )



/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_DLAPACK_TO_TILE(double *Af77, int *LDA, PLASMA_desc *A, int *info)
{ *info = PLASMA_dLapack_to_Tile(Af77, *LDA, A); }

void PLASMA_DLAPACK_TO_TILE_ASYNC(double *Af77, int *LDA, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dLapack_to_Tile_Async(Af77, *LDA, A, sequence, request); }

void PLASMA_DTILE_TO_LAPACK(PLASMA_desc *A, double *Af77, int *LDA, int *info)
{ *info = PLASMA_dTile_to_Lapack(A, Af77, *LDA); }

void PLASMA_DTILE_TO_LAPACK_ASYNC(PLASMA_desc *A, double *Af77, int *LDA, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dTile_to_Lapack_Async(A, Af77, *LDA, sequence, request); }

void PLASMA_DGEBRD(PLASMA_enum *jobq, PLASMA_enum *jobpt, int *M, int *N, double *A, int *LDA, double *D, double *E, PLASMA_desc **descT, double *Q, int *LDQ, double *PT, int *LDPT, int *info)
{ *info = PLASMA_dgebrd(*jobq, *jobpt, *M, *N, A, *LDA, D, E, *descT, Q, *LDQ, PT, *LDPT); }

void PLASMA_DGECFI(int *m, int *n, double *A, PLASMA_enum *fin, int *imb, int *inb, PLASMA_enum *fout, int *omb, int *onb, int *info)
{ *info = PLASMA_dgecfi(*m, *n, A, *fin, *imb, *inb, *fout, *omb, *onb); }

void PLASMA_DGECFI_ASYNC(int *m, int *n, double *A, PLASMA_enum *f_in, int *imb, int *inb, PLASMA_enum *f_out, int *omb, int *onb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgecfi_Async(*m, *n, A, *f_in, *imb, *inb, *f_out, *omb, *onb, sequence, request); }

void PLASMA_DGECON(PLASMA_enum *norm, int *N, double *A, int *LDA, double *anorm, double *rcond, int *info)
{ *info = PLASMA_dgecon(*norm, *N, A, *LDA, *anorm, rcond); }

void PLASMA_DGELQF(int *M, int *N, double *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_dgelqf(*M, *N, A, *LDA, *descT); }

void PLASMA_DGELQS(int *M, int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dgelqs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_DGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dgels(*trans, *M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_DGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DGEQP3(int *M, int *N, double *A, int *LDA, int *jpvt, double *tau, double *work, double *rwork, int *info)
{ *info = PLASMA_dgeqp3(*M, *N, A, *LDA, jpvt, tau, work, rwork); }

void PLASMA_DGEQRF(int *M, int *N, double *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_dgeqrf(*M, *N, A, *LDA, *descT); }

void PLASMA_DGEQRS(int *M, int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dgeqrs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_DGESDD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, double *A, int *LDA, double *S, PLASMA_desc **descT, double *U, int *LDU, double *VT, int *LDVT, int *info)
{ *info = PLASMA_dgesdd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_DGESV(int *N, int *NRHS, double *A, int *LDA, int *IPIV, double *B, int *LDB, int *info)
{ *info = PLASMA_dgesv(*N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_DGESV_INCPIV(int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descL, int *IPIV, double *B, int *LDB, int *info)
{ *info = PLASMA_dgesv_incpiv(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_DGESVD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, double *A, int *LDA, double *S, PLASMA_desc **descT, double *U, int *LDU, double *VT, int *LDVT, int *info)
{ *info = PLASMA_dgesvd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_DGETMI(int *m, int *n, double *A, PLASMA_enum *fin, int *mb, int *nb, int *info)
{ *info = PLASMA_dgetmi(*m, *n, A, *fin, *mb, *nb); }

void PLASMA_DGETMI_ASYNC(int *m, int *n, double *A, PLASMA_enum *f_in, int *mb, int *inb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetmi_Async(*m, *n, A, *f_in, *mb, *inb, sequence, request); }

void PLASMA_DGETRF(int *M, int *N, double *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_dgetrf(*M, *N, A, *LDA, IPIV); }

void PLASMA_DGETRF_INCPIV(int *M, int *N, double *A, int *LDA, PLASMA_desc **descL, int *IPIV, int *info)
{ *info = PLASMA_dgetrf_incpiv(*M, *N, A, *LDA, *descL, IPIV); }

void PLASMA_DGETRF_NOPIV(int *M, int *N, double *A, int *LDA, int *info)
{ *info = PLASMA_dgetrf_nopiv(*M, *N, A, *LDA); }

void PLASMA_DGETRF_TNTPIV(int *M, int *N, double *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_dgetrf_tntpiv(*M, *N, A, *LDA, IPIV); }

void PLASMA_DGETRI(int *N, double *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_dgetri(*N, A, *LDA, IPIV); }

void PLASMA_DGETRS(PLASMA_enum *trans, int *N, int *NRHS, double *A, int *LDA, const int *IPIV, double *B, int *LDB, int *info)
{ *info = PLASMA_dgetrs(*trans, *N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_DGETRS_INCPIV(PLASMA_enum *trans, int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descL, const int *IPIV, double *B, int *LDB, int *info)
{ *info = PLASMA_dgetrs_incpiv(*trans, *N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_DSYEV(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *W, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyev(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_DSYEVD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *W, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyevd(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_DSYEVR(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyevr(*jobz, *range, *uplo, *N, A, *LDA, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, *descT, Q, *LDQ); }

void PLASMA_DSYGST(PLASMA_enum *itype, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dsygst(*itype, *uplo, *N, A, *LDA, B, *LDB); }

void PLASMA_DSYGV(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *B, int *LDB, double *W, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsygv(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

void PLASMA_DSYGVD(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *B, int *LDB, double *W, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsygvd(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

#ifdef COMPLEX
void PLASMA_DSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_DSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_DSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

void PLASMA_DSYTRD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *D, double *E, PLASMA_desc **descT, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsytrd(*jobz, *uplo, *N, A, *LDA, D, E, *descT, Q, *LDQ); }

void PLASMA_DLACPY(PLASMA_enum *uplo, int *M, int *N, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dlacpy(*uplo, *M, *N, A, *LDA, B, *LDB); }

void PLASMA_DLANGE(PLASMA_enum *norm, int *M, int *N, double *A, int *LDA, double *result)
{ *result = PLASMA_dlange(*norm, *M, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_DLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *result)
{ *result = PLASMA_dlansy(*norm, *uplo, *N, A, *LDA); }
#endif

void PLASMA_DLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, double *A, int *LDA, double *result)
{ *result = PLASMA_dlansy(*norm, *uplo, *N, A, *LDA); }

void PLASMA_DLANTR(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, int *M, int *N, double *A, int *LDA, double *result)
{ *result = PLASMA_dlantr(*norm, *uplo, *diag, *M, *N, A, *LDA); }

void PLASMA_DLASET(PLASMA_enum *uplo, int *M, int *N, double *alpha, double *beta, double *A, int *LDA, int *info)
{ *info = PLASMA_dlaset(*uplo, *M, *N, *alpha, *beta, A, *LDA); }

void PLASMA_DLASWP(int *N, double *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_dlaswp(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_DLASWPC(int *N, double *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_dlaswpc(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_DLAUUM(PLASMA_enum *uplo, int *N, double *A, int *LDA, int *info)
{ *info = PLASMA_dlauum(*uplo, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_DPLGSY(double *bump, int *N, double *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplgsy(*bump, *N, A, *LDA, *seed); }
#endif

void PLASMA_DPLGSY(double *bump, int *N, double *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplgsy(*bump, *N, A, *LDA, *seed); }

void PLASMA_DPLRNT(int *M, int *N, double *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplrnt(*M, *N, A, *LDA, *seed); }

void PLASMA_DPLTMG(PLASMA_enum *mtxtype, int *M, int *N, double *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_dpltmg(*mtxtype, *M, *N, A, *LDA, *seed); }

void PLASMA_DPOCON(PLASMA_enum *uplo, int *N, double *A, int *LDA, double *anorm, double *rcond, int *info)
{ *info = PLASMA_dpocon(*uplo, *N, A, *LDA, *anorm, rcond); }

void PLASMA_DPOSV(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_DPOTRF(PLASMA_enum *uplo, int *N, double *A, int *LDA, int *info)
{ *info = PLASMA_dpotrf(*uplo, *N, A, *LDA); }

void PLASMA_DPOTRI(PLASMA_enum *uplo, int *N, double *A, int *LDA, int *info)
{ *info = PLASMA_dpotri(*uplo, *N, A, *LDA); }

void PLASMA_DPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_DSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *beta, double *C, int *LDC, int *info)
{ *info = PLASMA_dsyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

void PLASMA_DTRMM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, double *alpha, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dtrmm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_DTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, double *alpha, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dtrsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_DTRSMPL(int *N, int *NRHS, double *A, int *LDA, PLASMA_desc **descL, const int *IPIV, double *B, int *LDB, int *info)
{ *info = PLASMA_dtrsmpl(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_DTRSMRV(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, double *alpha, double *A, int *LDA, double *B, int *LDB, int *info)
{ *info = PLASMA_dtrsmrv(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_DTRTRI(PLASMA_enum *uplo, PLASMA_enum *diag, int *N, double *A, int *LDA, int *info)
{ *info = PLASMA_dtrtri(*uplo, *diag, *N, A, *LDA); }

void PLASMA_DORGLQ(int *M, int *N, int *K, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dorglq(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_DORGQR(int *M, int *N, int *K, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dorgqr(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_DORMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dormlq(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_DORMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, double *A, int *LDA, PLASMA_desc **descT, double *B, int *LDB, int *info)
{ *info = PLASMA_dormqr(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }


/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_DGEBRD_TILE(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc *A, double *D, double *E, PLASMA_desc *T, double *Q, int *LDQ, double *PT, int *LDPT, int *info)
{ *info = PLASMA_dgebrd_Tile(*jobq, *jobpt, A, D, E, T, Q, *LDQ, PT, *LDPT); }

void PLASMA_DGECON_TILE(PLASMA_enum *norm, PLASMA_desc *A, double *anorm, double *rcond, int *info)
{ *info = PLASMA_dgecon_Tile(*norm, A, *anorm, rcond); }

void PLASMA_DGELQF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_dgelqf_Tile(A, T); }

void PLASMA_DGELQS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgelqs_Tile(A, T, B); }

void PLASMA_DGELS_TILE(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgels_Tile(*trans, A, T, B); }

void PLASMA_DGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dgemm_Tile(*transA, *transB, *alpha, A, B, *beta, C); }

void PLASMA_DGEQP3_TILE(PLASMA_desc *A, int *jpvt, double *tau, double *work, double *rwork, int *info)
{ *info = PLASMA_dgeqp3_Tile(A, jpvt, tau, work, rwork); }

void PLASMA_DGEQRF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_dgeqrf_Tile(A, T); }

void PLASMA_DGEQRS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgeqrs_Tile(A, T, B); }

void PLASMA_DGESDD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, double *S, PLASMA_desc *T, double *U, int *LDU, double *VT, int *LDVT, int *info)
{ *info = PLASMA_dgesdd_Tile(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT); }

void PLASMA_DGESV_TILE(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgesv_Tile(A, IPIV, B); }

void PLASMA_DGESV_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgesv_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_DGESVD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, double *S, PLASMA_desc *T, double *U, int *LDU, double *VT, int *LDVT, int *info)
{ *info = PLASMA_dgesvd_Tile(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT); }

void PLASMA_DGETRF_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_dgetrf_Tile(A, IPIV); }

void PLASMA_DGETRF_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, int *info)
{ *info = PLASMA_dgetrf_incpiv_Tile(A, L, IPIV); }

void PLASMA_DGETRF_NOPIV_TILE(PLASMA_desc *A, int *info)
{ *info = PLASMA_dgetrf_nopiv_Tile(A); }

void PLASMA_DGETRF_TNTPIV_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_dgetrf_tntpiv_Tile(A, IPIV); }

void PLASMA_DGETRI_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_dgetri_Tile(A, IPIV); }

void PLASMA_DGETRS_TILE(PLASMA_enum *trans, PLASMA_desc *A, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgetrs_Tile(*trans, A, IPIV, B); }

void PLASMA_DGETRS_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_dgetrs_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_DSYEV_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *W, PLASMA_desc *T, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyev_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_DSYEVD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *W, PLASMA_desc *T, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyevd_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_DSYEVR_TILE(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc *A, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc *T, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsyevr_Tile(*jobz, *range, *uplo, A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, T, Q, *LDQ); }

void PLASMA_DSYGST_TILE(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dsygst_Tile(*itype, *uplo, A, B); }

void PLASMA_DSYGV_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, double *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_dsygv_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

void PLASMA_DSYGVD_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, double *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_dsygvd_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

#ifdef COMPLEX
void PLASMA_DSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsymm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_DSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsyr2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_DSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsyrk_Tile(*uplo, *trans, *alpha, A, *beta, C); }
#endif

void PLASMA_DSYTRD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *D, double *E, PLASMA_desc *T, double *Q, int *LDQ, int *info)
{ *info = PLASMA_dsytrd_Tile(*jobz, *uplo, A, D, E, T, Q, *LDQ); }

void PLASMA_DLACPY_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dlacpy_Tile(*uplo, A, B); }

void PLASMA_DLANGE_TILE(PLASMA_enum *norm, PLASMA_desc *A, double *result)
{ *result = PLASMA_dlange_Tile(*norm, A); }

#ifdef COMPLEX
void PLASMA_DLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, double *result)
{ *result = PLASMA_dlansy_Tile(*norm, *uplo, A); }
#endif

void PLASMA_DLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, double *result)
{ *result = PLASMA_dlansy_Tile(*norm, *uplo, A); }

void PLASMA_DLANTR_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, double *result)
{ *result = PLASMA_dlantr_Tile(*norm, *uplo, *diag, A); }

void PLASMA_DLASET_TILE(PLASMA_enum *uplo, double *alpha, double *beta, PLASMA_desc *A, int *info)
{ *info = PLASMA_dlaset_Tile(*uplo, *alpha, *beta, A); }

void PLASMA_DLASWP_TILE(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_dlaswp_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_DLASWPC_TILE(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_dlaswpc_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_DLAUUM_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_dlauum_Tile(*uplo, A); }

#ifdef COMPLEX
void PLASMA_DPLGSY_TILE(double *bump, PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplgsy_Tile(*bump, A, *seed); }
#endif

void PLASMA_DPLGSY_TILE(double *bump, PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplgsy_Tile(*bump, A, *seed); }

void PLASMA_DPLRNT_TILE(PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_dplrnt_Tile(A, *seed); }

void PLASMA_DPLTMG_TILE(PLASMA_enum *mtxtype, PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_dpltmg_Tile(*mtxtype, A, *seed); }

void PLASMA_DPOCON_TILE(PLASMA_enum *uplo, PLASMA_desc *A, double *anorm, double *rcond, int *info)
{ *info = PLASMA_dpocon_Tile(*uplo, A, *anorm, rcond); }

void PLASMA_DPOSV_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dposv_Tile(*uplo, A, B); }

void PLASMA_DPOTRF_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_dpotrf_Tile(*uplo, A); }

void PLASMA_DPOTRI_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_dpotri_Tile(*uplo, A); }

void PLASMA_DPOTRS_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dpotrs_Tile(*uplo, A, B); }

void PLASMA_DSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsymm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }

void PLASMA_DSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsyr2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }

void PLASMA_DSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, double *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_dsyrk_Tile(*uplo, *trans, *alpha, A, *beta, C); }

void PLASMA_DTRMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dtrmm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_DTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dtrsm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_DTRSMPL_TILE(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_dtrsmpl_Tile(A, L, IPIV, B); }

void PLASMA_DTRSMRV_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_dtrsmrv_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_DTRTRI_TILE(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, int *info)
{ *info = PLASMA_dtrtri_Tile(*uplo, *diag, A); }

void PLASMA_DORGLQ_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dorglq_Tile(A, T, B); }

void PLASMA_DORGQR_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dorgqr_Tile(A, T, B); }

void PLASMA_DORMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dormlq_Tile(*side, *trans, A, T, B); }

void PLASMA_DORMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_dormqr_Tile(*side, *trans, A, T, B); }


/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
void PLASMA_DGEBRD_TILE_ASYNC(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc *A, double *S, double *E, PLASMA_desc *T, double *U, int *LDU, double *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgebrd_Tile_Async(*jobq, *jobpt, A, S, E, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_DGECON_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc *A, double *anorm, double *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgecon_Tile_Async(*norm, A, *anorm, rcond, sequence, request); }

void PLASMA_DGELQF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgelqf_Tile_Async(A, T, sequence, request); }

void PLASMA_DGELQS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgelqs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_DGELS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgels_Tile_Async(*trans, A, T, B, sequence, request); }

void PLASMA_DGEMM_TILE_ASYNC(PLASMA_enum *transA, PLASMA_enum *transB, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgemm_Tile_Async(*transA, *transB, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_DGEQP3_TILE_ASYNC(PLASMA_desc *A, int *jpvt, double *tau, double *work, double *rwork, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgeqp3_Tile_Async(A, jpvt, tau, work, rwork, sequence, request); }

void PLASMA_DGEQRF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgeqrf_Tile_Async(A, T, sequence, request); }

void PLASMA_DGEQRS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgeqrs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_DGESDD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, double *S, PLASMA_desc *T, double *U, int *LDU, double *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgesdd_Tile_Async(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_DGESV_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgesv_Tile_Async(A, IPIV, B, sequence, request); }

void PLASMA_DGESV_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgesv_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_DGESVD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, double *S, PLASMA_desc *T, double *U, int *LDU, double *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgesvd_Tile_Async(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_DGETRF_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrf_Tile_Async(A, IPIV, sequence, request); }

void PLASMA_DGETRF_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrf_incpiv_Tile_Async(A, L, IPIV, sequence, request); }

void PLASMA_DGETRF_NOPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrf_nopiv_Tile_Async(A, sequence, request); }

void PLASMA_DGETRF_TNTPIV_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *W, int *Wpivot, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrf_tntpiv_Tile_Async(A, IPIV, W, Wpivot, sequence, request); }

void PLASMA_DGETRI_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *W, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetri_Tile_Async(A, IPIV, W, sequence, request); }

void PLASMA_DGETRS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrs_Tile_Async(*trans, A, IPIV, B, sequence, request); }

void PLASMA_DGETRS_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dgetrs_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_DSYEV_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *W, PLASMA_desc *T, double *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyev_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_DSYEVD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *W, PLASMA_desc *T, double *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyevd_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_DSYEVR_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc *A, double *vl, double *vu, int *il, int *iu, double *abstol, int *nbcomputedeig, double *W, PLASMA_desc *T, double *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyevr_Tile_Async(*jobz, *range, *uplo, A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, T, Q, *LDQ, sequence, request); }

void PLASMA_DSYGST_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsygst_Tile_Async(*itype, *uplo, A, B, sequence, request); }

void PLASMA_DSYGV_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, double *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsygv_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

void PLASMA_DSYGVD_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, double *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsygvd_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

#ifdef COMPLEX
void PLASMA_DSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsymm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_DSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyr2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_DSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyrk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }
#endif

void PLASMA_DSYTRD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, double *D, double *E, PLASMA_desc *T, double *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsytrd_Tile_Async(*jobz, *uplo, A, D, E, T, Q, *LDQ, sequence, request); }

void PLASMA_DLACPY_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlacpy_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_DLANGE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc *A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlange_Tile_Async(*norm, A, result, sequence, request); }

#ifdef COMPLEX
void PLASMA_DLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlansy_Tile_Async(*norm, *uplo, A, result, sequence, request); }
#endif

void PLASMA_DLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlansy_Tile_Async(*norm, *uplo, A, result, sequence, request); }

void PLASMA_DLANTR_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, double *result, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlantr_Tile_Async(*norm, *uplo, *diag, A, result, sequence, request); }

void PLASMA_DLASET_TILE_ASYNC(PLASMA_enum *uplo, double *alpha, double *beta, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlaset_Tile_Async(*uplo, *alpha, *beta, A, sequence, request); }

void PLASMA_DLASWP_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlaswp_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_DLASWPC_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlaswpc_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_DLAUUM_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dlauum_Tile_Async(*uplo, A, sequence, request); }

#ifdef COMPLEX
void PLASMA_DPLGSY_TILE_ASYNC(double *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dplgsy_Tile_Async(*bump, A, *seed, sequence, request); }
#endif

void PLASMA_DPLGSY_TILE_ASYNC(double *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dplgsy_Tile_Async(*bump, A, *seed, sequence, request); }

void PLASMA_DPLRNT_TILE_ASYNC(PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dplrnt_Tile_Async(A, *seed, sequence, request); }

void PLASMA_DPLTMG_TILE_ASYNC(PLASMA_enum *mtxtype, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dpltmg_Tile_Async(*mtxtype, A, *seed, sequence, request); }

void PLASMA_DPOCON_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, double *anorm, double *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dpocon_Tile_Async(*uplo, A, *anorm, rcond, sequence, request); }

void PLASMA_DPOSV_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dposv_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_DPOTRF_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dpotrf_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_DPOTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dpotri_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_DPOTRS_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dpotrs_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_DSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsymm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_DSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, PLASMA_desc *B, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyr2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_DSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, PLASMA_desc *A, double *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dsyrk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }

void PLASMA_DTRMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dtrmm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_DTRSM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dtrsm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_DTRSMPL_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dtrsmpl_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_DTRSMRV_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dtrsmrv_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_DTRTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dtrtri_Tile_Async(*uplo, *diag, A, sequence, request); }

void PLASMA_DORGLQ_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dorglq_Tile_Async(A, T, B, sequence, request); }

void PLASMA_DORGQR_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dorgqr_Tile_Async(A, T, B, sequence, request); }

void PLASMA_DORMLQ_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dormlq_Tile_Async(*side, *trans, A, T, B, sequence, request); }

void PLASMA_DORMQR_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_dormqr_Tile_Async(*side, *trans, A, T, B, sequence, request); }


/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_DGEBRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgebrd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGEEV(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgeev(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGEHRD(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgehrd(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGELQF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_dgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGELQF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgelqf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGELS(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_dgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGELS_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgels_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGEQRF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_dgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGEQRF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgeqrf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGESDD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgesdd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGESV_INCPIV(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_dgesv_incpiv(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_DGESV_INCPIV_TILE (int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_dgesv_incpiv_Tile (*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_DGESVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dgesvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DGETRF_INCPIV(int *M, int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_dgetrf_incpiv(*M, *N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_DGETRF_INCPIV_TILE(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_dgetrf_incpiv_Tile(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_DGETRF_TNTPIV_TILE(PLASMA_desc *A, PLASMA_desc *W, int **Wpivot, int *info)
{ *info = PLASMA_Alloc_Workspace_dgetrf_tntpiv_Tile(A, W, Wpivot); }

void PLASMA_ALLOC_WORKSPACE_DGETRI_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *W, int *info)
{ *info = PLASMA_Alloc_Workspace_dgetri_Tile_Async(A, W); }

void PLASMA_ALLOC_WORKSPACE_DSYEV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsyev(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DSYEVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsyevd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DSYEVR(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsyevr(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DSYGV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsygv(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DSYGVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsygvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_DSYTRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_dsytrd(*M, *N, descT); }



