/**                                                               
 *                                                                
 * @file coreblas_c.c                                             
 *                                                                
 *  PLASMA core_blas tracing kernel                               
 *  PLASMA is a software package provided by Univ. of Tennessee,  
 *  Univ. of California Berkeley and Univ. of Colorado Denver     
 *                                                                
 *  This file provides the wrapper for each function of the       
 *  core_blas library which will generate an event before and     
 *  after the execution of the kernel.                            
 *  This file is automatically generated with convert2eztrace.pl  
 *  script. DO NOT MANUALLY EDIT THIS FILE.                       
 *                                                                
 * @version 2.5.1                                                 
 * @author Mathieu Faverge                                        
 * @date 2010-11-15                                               
 * @generated c Tue Jul 16 14:24:51 2013
 *                                                                
 **/                                                              
#include <eztrace.h>           
#include <ev_codes.h>          
#include "common.h"            
#include "coreblas_ev_codes.h" 
#include "coreblas_macros.h"   
#undef REAL                    
#define COMPLEX                

/*****************************************************************
 *        Core functions                                          
 */

FUNCTION_VOID( CORE_scasum, ASUM, void ,
          (PLASMA_enum storev, PLASMA_enum uplo, int M, int N, const PLASMA_Complex32_t *A, int lda, float *work),
          (storev, uplo, M, N, A, lda, work) )
FUNCTION_VOID( CORE_cbrdalg1, BRDALG, void ,
          ( PLASMA_enum uplo, int n, int nb, PLASMA_Complex32_t *A, int lda, PLASMA_Complex32_t *VQ, PLASMA_Complex32_t *TAUQ, PLASMA_Complex32_t *VP, PLASMA_Complex32_t *TAUP, int Vblksiz, int wantz, int i, int sweepid, int m, int grsiz, PLASMA_Complex32_t *work),
          (uplo, n, nb, A, lda, VQ, TAUQ, VP, TAUP, Vblksiz, wantz, i, sweepid, m, grsiz, work) )
FUNCTION_TYPE( CORE_cgeadd, GEADD, int ,
          (int M, int N, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB),
          (M, N, alpha, A, LDA, B, LDB) )
FUNCTION_TYPE( CORE_cgelqt, GELQT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_VOID( CORE_cgemm, GEMM, void ,
          (PLASMA_enum transA, int transB, int M, int N, int K, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *B, int LDB, PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC),
          (transA, transB, M, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_cgemm_tile, GEMM, void ,
          (PLASMA_enum transA, PLASMA_enum transB, int m, int n, int k, const PLASMA_Complex32_t *alpha, const PLASMA_Complex32_t *A, int lda, const PLASMA_Complex32_t *B, int ldb, const PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int ldc ),
          (transA, transB, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc) )
FUNCTION_VOID( CORE_cgemv, GEMV, void ,
          (PLASMA_enum trans, int m, int n, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int lda, const PLASMA_Complex32_t *x, int incx, PLASMA_Complex32_t beta, PLASMA_Complex32_t *y, int incy),
          (trans, m, n, alpha, A, lda, x, incx, beta, y, incy) )
FUNCTION_VOID( CORE_cgemv_tile, GEMV, void ,
          (PLASMA_enum trans, int m, int n, const PLASMA_Complex32_t *alpha, const PLASMA_Complex32_t *A, int lda, const PLASMA_Complex32_t *x, int incx, const PLASMA_Complex32_t *beta, PLASMA_Complex32_t *y, int incy ),
          (trans, m, n, alpha, A, lda, x, incx, beta, y, incy) )
FUNCTION_VOID( CORE_cgeqp3_init, GEQP3_INIT, void ,
          ( int n, int *jpvt ),
          (n, jpvt) )
FUNCTION_VOID( CORE_cgeqp3_larfg, LARFG, void ,
          ( PLASMA_desc A, int ii, int jj, int i, int j, PLASMA_Complex32_t *tau, PLASMA_Complex32_t *beta ),
          (A, ii, jj, i, j, tau, beta) )
FUNCTION_VOID( CORE_cgeqp3_norms, GEQP3_NORMS, void ,
          ( PLASMA_desc A, int ioff, int joff, float *norms1, float *norms2 ),
          (A, ioff, joff, norms1, norms2) )
FUNCTION_VOID( CORE_cgeqp3_pivot, GEQP3_PIVOT, void ,
          ( PLASMA_desc A, PLASMA_Complex32_t *F, int ldf, int jj, int k, int *jpvt, float *norms1, float *norms2, int *info ),
          (A, F, ldf, jj, k, jpvt, norms1, norms2, info) )
FUNCTION_TYPE( CORE_cgeqp3_tntpiv, GEQRT, int ,
          (int m, int n, PLASMA_Complex32_t *A, int lda, int *IPIV, PLASMA_Complex32_t *tau, int *iwork),
          (m, n, A, lda, IPIV, tau, iwork) )
FUNCTION_VOID( CORE_cgeqp3_update, GEQP3_UPDATE, void ,
          ( const PLASMA_Complex32_t *Ajj, int lda1, PLASMA_Complex32_t *Ajk, int lda2, const PLASMA_Complex32_t *Fk, int ldf, int joff, int k, int koff, int nb, float *norms1, float *norms2, int *info ),
          (Ajj, lda1, Ajk, lda2, Fk, ldf, joff, k, koff, nb, norms1, norms2, info) )
FUNCTION_TYPE( CORE_cgeqrt, GEQRT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_cgessm, GESSM, int ,
          (int M, int N, int K, int IB, const int *IPIV, const PLASMA_Complex32_t *L, int LDL, PLASMA_Complex32_t *A, int LDA),
          (M, N, K, IB, IPIV, L, LDL, A, LDA) )
FUNCTION_TYPE( CORE_cgessq, LASSQ, int ,
          (int M, int N, const PLASMA_Complex32_t *A, int LDA, float *scale, float *sumsq),
          (M, N, A, LDA, scale, sumsq) )
FUNCTION_TYPE( CORE_cgetrf, GETRF, int ,
          (int m, int n, PLASMA_Complex32_t *A, int lda, int *IPIV, int *info),
          (m, n, A, lda, IPIV, info) )
FUNCTION_TYPE( CORE_cgetrf_incpiv, GETRF, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A, int LDA, int *IPIV, int *INFO),
          (M, N, IB, A, LDA, IPIV, INFO) )
FUNCTION_TYPE( CORE_cgetrf_nopiv, GETRF, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A, int LDA),
          (M, N, IB, A, LDA) )
FUNCTION_TYPE( CORE_cgetrf_reclap, GETRF, int ,
          (int M, int N, PLASMA_Complex32_t *A, int LDA, int *IPIV, int *info),
          (M, N, A, LDA, IPIV, info) )
FUNCTION_TYPE( CORE_cgetrf_rectil, GETRF, int ,
          (const PLASMA_desc A, int *IPIV, int *info),
          (A, IPIV, info) )
FUNCTION_VOID( CORE_cgetrip, GETRIP, void ,
          (int m, int n, PLASMA_Complex32_t *A, PLASMA_Complex32_t *W) ,
          (m, n, A, W)  )
FUNCTION_VOID( CORE_chegst, HEGST, void ,
          (int itype, PLASMA_enum uplo, int N, PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB, int *INFO),
          (itype, uplo, N, A, LDA, B, LDB, INFO) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_chemm, HEMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, int M, int N, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *B, int LDB, PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
#ifdef COMPLEX
FUNCTION_VOID( CORE_cher2k, HER2K, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *B, int LDB, float beta, PLASMA_Complex32_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
FUNCTION_TYPE( CORE_cherfb, HERFB, int ,
          ( PLASMA_enum uplo, int n, int k, int ib, int nb, const PLASMA_Complex32_t *A, int lda, const PLASMA_Complex32_t *T, int ldt, PLASMA_Complex32_t *C, int ldc, PLASMA_Complex32_t *WORK, int ldwork ),
          (uplo, n, k, ib, nb, A, lda, T, ldt, C, ldc, WORK, ldwork) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_cherk, HERK, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, float alpha, const PLASMA_Complex32_t *A, int LDA, float beta, PLASMA_Complex32_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
#endif
#ifdef COMPLEX
FUNCTION_TYPE( CORE_chessq, LASSQ, int ,
          (PLASMA_enum uplo, int N, const PLASMA_Complex32_t *A, int LDA, float *scale, float *sumsq),
          (uplo, N, A, LDA, scale, sumsq) )
#endif
FUNCTION_VOID( CORE_clacpy, LACPY, void ,
          (PLASMA_enum uplo, int M, int N, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB),
          (uplo, M, N, A, LDA, B, LDB) )
FUNCTION_TYPE( CORE_clacpy_pivot, LACPY, int ,
          ( const PLASMA_desc descA, PLASMA_enum direct, int k1, int k2, const int *ipiv, int *rankin, int *rankout, PLASMA_Complex32_t *A, int lda, int init),
          (descA, direct, k1, k2, ipiv, rankin, rankout, A, lda, init) )
FUNCTION_VOID( CORE_clange, LANGE, void ,
          (int norm, int M, int N, const PLASMA_Complex32_t *A, int LDA, float *work, float *normA),
          (norm, M, N, A, LDA, work, normA) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_clanhe, LANHE, void ,
          (int norm, PLASMA_enum uplo, int N, const PLASMA_Complex32_t *A, int LDA, float *work, float *normA),
          (norm, uplo, N, A, LDA, work, normA) )
#endif
FUNCTION_VOID( CORE_clansy, LANSY, void ,
          (int norm, PLASMA_enum uplo, int N, const PLASMA_Complex32_t *A, int LDA, float *work, float *normA),
          (norm, uplo, N, A, LDA, work, normA) )
FUNCTION_TYPE( CORE_clarfb_gemm, LARFB, int ,
          (PLASMA_enum side, PLASMA_enum trans, int direct, int storev, int M, int N, int K, const PLASMA_Complex32_t *V, int LDV, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *C, int LDC, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, direct, storev, M, N, K, V, LDV, T, LDT, C, LDC, WORK, LDWORK) )
FUNCTION_VOID( CORE_claset2, LASET, void ,
          (PLASMA_enum uplo, int M, int N, PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA),
          (uplo, M, N, alpha, A, LDA) )
FUNCTION_VOID( CORE_claset, LASET, void ,
          (PLASMA_enum uplo, int M, int N, PLASMA_Complex32_t alpha, PLASMA_Complex32_t beta, PLASMA_Complex32_t *A, int LDA),
          (uplo, M, N, alpha, beta, A, LDA) )
FUNCTION_VOID( CORE_claswp, LASWP, void ,
          (int N, PLASMA_Complex32_t *A, int LDA, int I1, int I2, const int *IPIV, int INC),
          (N, A, LDA, I1, I2, IPIV, INC) )
FUNCTION_TYPE( CORE_claswp_ontile, LASWP, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc),
          (descA, i1, i2, ipiv, inc) )
FUNCTION_TYPE( CORE_cswptr_ontile, TRSM, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc, const PLASMA_Complex32_t *Akk, int ldak),
          (descA, i1, i2, ipiv, inc, Akk, ldak) )
FUNCTION_TYPE( CORE_claswpc_ontile, LASWP, int ,
          (PLASMA_desc descA, int i1, int i2, const int *ipiv, int inc),
          (descA, i1, i2, ipiv, inc) )
FUNCTION_TYPE( CORE_clatro, LATRO, int ,
          (PLASMA_enum uplo, PLASMA_enum trans, int M, int N, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB),
          (uplo, trans, M, N, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_clauum, LAUUM, void ,
          (PLASMA_enum uplo, int N, PLASMA_Complex32_t *A, int LDA),
          (uplo, N, A, LDA) )
FUNCTION_TYPE( CORE_cpemv, PEMV, int ,
          (PLASMA_enum trans, int storev, int M, int N, int L, PLASMA_Complex32_t ALPHA, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *X, int INCX, PLASMA_Complex32_t BETA, PLASMA_Complex32_t *Y, int INCY, PLASMA_Complex32_t *WORK),
          (trans, storev, M, N, L, ALPHA, A, LDA, X, INCX, BETA, Y, INCY, WORK) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_cplghe, PLGHE, void ,
          ( float bump, int m, int n, PLASMA_Complex32_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
#endif
FUNCTION_VOID( CORE_cplgsy, PLGSY, void ,
          ( PLASMA_Complex32_t bump, int m, int n, PLASMA_Complex32_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
FUNCTION_VOID( CORE_cplrnt, PLRNT, void ,
          ( int m, int n, PLASMA_Complex32_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (m, n, A, lda, bigM, m0, n0, seed) )
FUNCTION_VOID( CORE_cpotrf, POTRF, void ,
          (PLASMA_enum uplo, int N, PLASMA_Complex32_t *A, int LDA, int *INFO),
          (uplo, N, A, LDA, INFO) )
FUNCTION_VOID( CORE_csetvar, SETVAR, void ,
          (const PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *x),
          (alpha, x) )
FUNCTION_VOID( CORE_cshiftw, SHIFTW, void ,
          (int s, int cl, int m, int n, int L, PLASMA_Complex32_t *A, PLASMA_Complex32_t *W) ,
          (s, cl, m, n, L, A, W)  )
FUNCTION_VOID( CORE_cshift, SHIFT, void ,
          (int s, int m, int n, int L, PLASMA_Complex32_t *A) ,
          (s, m, n, L, A)  )
FUNCTION_TYPE( CORE_cssssm, SSSSM, int ,
          (int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, const PLASMA_Complex32_t *L1, int LDL1, const PLASMA_Complex32_t *L2, int LDL2, const int *IPIV),
          (M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, L1, LDL1, L2, LDL2, IPIV) )
FUNCTION_VOID( CORE_cswpab, SWPAB, void ,
          (int i, int n1, int n2, PLASMA_Complex32_t *A, PLASMA_Complex32_t *work) ,
          (i, n1, n2, A, work)  )
FUNCTION_VOID( CORE_csymm, SYMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, int M, int N, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *B, int LDB, PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_csyr2k, SYR2K, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *B, int LDB, PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_csyrk, SYRK, void ,
          (PLASMA_enum uplo, PLASMA_enum trans, int N, int K, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
FUNCTION_TYPE( CORE_csyssq, LASSQ, int ,
          (PLASMA_enum uplo, int N, const PLASMA_Complex32_t *A, int LDA, float *scale, float *sumsq),
          (uplo, N, A, LDA, scale, sumsq) )
FUNCTION_VOID( CORE_ctrdalg1, TRDALG, void ,
          ( int n, int nb, PLASMA_Complex32_t *A, int lda, PLASMA_Complex32_t *V, PLASMA_Complex32_t *TAU, int Vblksiz, int wantz, int i, int sweepid, int m, int grsiz, PLASMA_Complex32_t *work),
          (n, nb, A, lda, V, TAU, Vblksiz, wantz, i, sweepid, m, grsiz, work) )
FUNCTION_VOID( CORE_ctrmm, TRMM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, int M, int N, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_ctrsm, TRSM, void ,
          (PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, int M, int N, PLASMA_Complex32_t alpha, const PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_ctrtri, TRTRI, void ,
          (PLASMA_enum uplo, PLASMA_enum diag, int N, PLASMA_Complex32_t *A, int LDA, int *info),
          (uplo, diag, N, A, LDA, info) )
FUNCTION_TYPE( CORE_ctslqt, TSLQT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_ctsmlq, TSMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, const PLASMA_Complex32_t *V, int LDV, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_ctsmlq_corner, TSMLQ, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, PLASMA_Complex32_t *A1, int lda1, PLASMA_Complex32_t *A2, int lda2, PLASMA_Complex32_t *A3, int lda3, const PLASMA_Complex32_t *V, int ldv, const PLASMA_Complex32_t *T, int ldt, PLASMA_Complex32_t *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ctsmlq_hetra1, TSMLQ, int ,
          ( PLASMA_enum side, PLASMA_enum trans, int m1, int n1, int m2, int n2, int k, int ib, PLASMA_Complex32_t *A1, int lda1, PLASMA_Complex32_t *A2, int lda2, const PLASMA_Complex32_t *V, int ldv, const PLASMA_Complex32_t *T, int ldt, PLASMA_Complex32_t *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ctsmqr, TSMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, const PLASMA_Complex32_t *V, int LDV, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_ctsmqr_corner, TSMQR, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, PLASMA_Complex32_t *A1, int lda1, PLASMA_Complex32_t *A2, int lda2, PLASMA_Complex32_t *A3, int lda3, const PLASMA_Complex32_t *V, int ldv, const PLASMA_Complex32_t *T, int ldt, PLASMA_Complex32_t *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ctsmqr_hetra1, TSMQR, int ,
          ( PLASMA_enum side, PLASMA_enum trans, int m1, int n1, int m2, int n2, int k, int ib, PLASMA_Complex32_t *A1, int lda1, PLASMA_Complex32_t *A2, int lda2, const PLASMA_Complex32_t *V, int ldv, const PLASMA_Complex32_t *T, int ldt, PLASMA_Complex32_t *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ctsqrt, TSQRT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_ctstrf, TSTRF, int ,
          (int M, int N, int IB, int NB, PLASMA_Complex32_t *U, int LDU, PLASMA_Complex32_t *A, int LDA, PLASMA_Complex32_t *L, int LDL, int *IPIV, PLASMA_Complex32_t *WORK, int LDWORK, int *INFO),
          (M, N, IB, NB, U, LDU, A, LDA, L, LDL, IPIV, WORK, LDWORK, INFO) )
FUNCTION_TYPE( CORE_cttlqt, TTLQT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_cttmlq, TTMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, const PLASMA_Complex32_t *V, int LDV, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_cttmqr, TTMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, const PLASMA_Complex32_t *V, int LDV, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_cttqrt, TTQRT, int ,
          (int M, int N, int IB, PLASMA_Complex32_t *A1, int LDA1, PLASMA_Complex32_t *A2, int LDA2, PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_cunmlq, UNMLQ, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, int IB, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *C, int LDC, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )
FUNCTION_TYPE( CORE_cunmqr, UNMQR, int ,
          (PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, int IB, const PLASMA_Complex32_t *A, int LDA, const PLASMA_Complex32_t *T, int LDT, PLASMA_Complex32_t *C, int LDC, PLASMA_Complex32_t *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )

/*****************************************************************
 *        QUARK Wrapper functions                                 
 */

FUNCTION_QUARK( CORE_scasum_quark, ASUM )
FUNCTION_QUARK( CORE_scasum_f1_quark, ASUM )
FUNCTION_QUARK( CORE_cbrdalg1_quark, BRDALG )
FUNCTION_QUARK( CORE_cgeadd_quark, GEADD )
FUNCTION_QUARK( CORE_cgelqt_quark, GELQT )
FUNCTION_QUARK( CORE_cgemm_quark, GEMM )
FUNCTION_QUARK( CORE_cgemm_f2_quark, GEMM )
FUNCTION_QUARK( CORE_cgemm_p2_quark, GEMM )
FUNCTION_QUARK( CORE_cgemm_p3_quark, GEMM )
FUNCTION_QUARK( CORE_cgemm_p2f1_quark, GEMM )
FUNCTION_QUARK( CORE_cgemm_tile_quark, GEMM )
FUNCTION_QUARK( CORE_cgemv_quark, GEMV )
FUNCTION_QUARK( CORE_cgemv_tile_quark, GEMV )
FUNCTION_QUARK( CORE_cgeqp3_init_quark, GEQP3_INIT )
FUNCTION_QUARK( CORE_cgeqp3_larfg_quark, LARFG )
FUNCTION_QUARK( CORE_cgeqp3_norms_quark, GEQP3_NORMS )
FUNCTION_QUARK( CORE_cgeqp3_pivot_quark, GEQP3_PIVOT )
FUNCTION_QUARK( CORE_cgeqp3_tntpiv_quark, GEQRT )
FUNCTION_QUARK( CORE_cgeqp3_update_quark, GEQP3_UPDATE )
FUNCTION_QUARK( CORE_cgeqrt_quark, GEQRT )
FUNCTION_QUARK( CORE_cgessm_quark, GESSM )
FUNCTION_QUARK( CORE_cgessq_quark, LASSQ )
FUNCTION_QUARK( CORE_cgessq_f1_quark, LASSQ )
FUNCTION_QUARK( CORE_cgetrf_quark, GETRF )
FUNCTION_QUARK( CORE_cgetrf_incpiv_quark, GETRF )
FUNCTION_QUARK( CORE_cgetrf_nopiv_quark, GETRF )
FUNCTION_QUARK( CORE_cgetrf_reclap_quark, GETRF )
FUNCTION_QUARK( CORE_cgetrf_rectil_quark, GETRF )
FUNCTION_QUARK( CORE_cgetrip_quark, GETRIP )
FUNCTION_QUARK( CORE_cgetrip_f1_quark, GETRIP )
FUNCTION_QUARK( CORE_cgetrip_f2_quark, GETRIP )
FUNCTION_QUARK( CORE_chegst_quark, HEGST )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_chemm_quark, HEMM )
#endif
#ifdef COMPLEX
FUNCTION_QUARK( CORE_cher2k_quark, HER2K )
#endif
FUNCTION_QUARK( CORE_cherfb_quark, HERFB )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_cherk_quark, HERK )
#endif
#ifdef COMPLEX
FUNCTION_QUARK( CORE_chessq_quark, LASSQ )
FUNCTION_QUARK( CORE_chessq_f1_quark, LASSQ )
#endif
FUNCTION_QUARK( CORE_clacpy_quark, LACPY )
FUNCTION_QUARK( CORE_clacpy_f1_quark, LACPY )
FUNCTION_QUARK( CORE_clacpy_pivot_quark, LACPY )
FUNCTION_QUARK( CORE_clange_quark, LANGE )
FUNCTION_QUARK( CORE_clange_f1_quark, LANGE )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_clanhe_quark, LANHE )
FUNCTION_QUARK( CORE_clanhe_f1_quark, LANHE )
#endif
FUNCTION_QUARK( CORE_clansy_quark, LANSY )
FUNCTION_QUARK( CORE_clansy_f1_quark, LANSY )
FUNCTION_QUARK( CORE_claset2_quark, LASET )
FUNCTION_QUARK( CORE_claset_quark, LASET )
FUNCTION_QUARK( CORE_claswp_quark, LASWP )
FUNCTION_QUARK( CORE_claswp_f2_quark, LASWP )
FUNCTION_QUARK( CORE_claswp_ontile_quark, LASWP )
FUNCTION_QUARK( CORE_claswp_ontile_f2_quark, LASWP )
FUNCTION_QUARK( CORE_cswptr_ontile_quark, TRSM )
FUNCTION_QUARK( CORE_claswpc_ontile_quark, LASWP )
FUNCTION_QUARK( CORE_clatro_quark, LATRO )
FUNCTION_QUARK( CORE_clatro_f1_quark, LATRO )
FUNCTION_QUARK( CORE_clauum_quark, LAUUM )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_cplghe_quark, PLGHE )
#endif
FUNCTION_QUARK( CORE_cplgsy_quark, PLGSY )
FUNCTION_QUARK( CORE_cplrnt_quark, PLRNT )
FUNCTION_QUARK( CORE_cplssq_quark, LASSQ )
FUNCTION_QUARK( CORE_cpotrf_quark, POTRF )
FUNCTION_QUARK( CORE_csetvar_quark, SETVAR )
FUNCTION_QUARK( CORE_cshiftw_quark, SHIFTW )
FUNCTION_QUARK( CORE_cshift_quark, SHIFT )
FUNCTION_QUARK( CORE_cssssm_quark, SSSSM )
FUNCTION_QUARK( CORE_cswpab_quark, SWPAB )
FUNCTION_QUARK( CORE_csymm_quark, SYMM )
FUNCTION_QUARK( CORE_csyr2k_quark, SYR2K )
FUNCTION_QUARK( CORE_csyrk_quark, SYRK )
FUNCTION_QUARK( CORE_csyssq_quark, LASSQ )
FUNCTION_QUARK( CORE_csyssq_f1_quark, LASSQ )
FUNCTION_QUARK( CORE_ctrdalg1_quark, TRDALG )
FUNCTION_QUARK( CORE_ctrmm_quark, TRMM )
FUNCTION_QUARK( CORE_ctrmm_p2_quark, TRMM )
FUNCTION_QUARK( CORE_ctrsm_quark, TRSM )
FUNCTION_QUARK( CORE_ctrtri_quark, TRTRI )
FUNCTION_QUARK( CORE_ctslqt_quark, TSLQT )
FUNCTION_QUARK( CORE_ctsmlq_quark, TSMLQ )
FUNCTION_QUARK( CORE_ctsmlq_corner_quark, TSMLQ )
FUNCTION_QUARK( CORE_ctsmlq_hetra1_quark, TSMLQ )
FUNCTION_QUARK( CORE_ctsmqr_quark, TSMQR )
FUNCTION_QUARK( CORE_ctsmqr_corner_quark, TSMQR )
FUNCTION_QUARK( CORE_ctsmqr_hetra1_quark, TSMQR )
FUNCTION_QUARK( CORE_ctsqrt_quark, TSQRT )
FUNCTION_QUARK( CORE_ctstrf_quark, TSTRF )
FUNCTION_QUARK( CORE_cttlqt_quark, TTLQT )
FUNCTION_QUARK( CORE_cttmlq_quark, TTMLQ )
FUNCTION_QUARK( CORE_cttmqr_quark, TTMQR )
FUNCTION_QUARK( CORE_cttqrt_quark, TTQRT )
FUNCTION_QUARK( CORE_cunmlq_quark, UNMLQ )
FUNCTION_QUARK( CORE_cunmqr_quark, UNMQR )

