/**
 *
 * @file plasma_cf77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *  This file is automatically generated by tools/genf77interface.pl
 *
 *  WARNING: This file is automatically generated through
 *  tools/genf77interface.pl script, please do not manually edit it.
 *
 * @version 2.5.1
 * @author Bilel Hadri
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated c Tue Jul 16 14:24:40 2013
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef REAL
#define COMPLEX


/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
#define PLASMA_CLAPACK_TO_TILE PLASMA_FNAME(clapack_to_tile, CLAPACK_TO_TILE)
#define PLASMA_CLAPACK_TO_TILE_ASYNC PLASMA_FNAME(clapack_to_tile_async, CLAPACK_TO_TILE_ASYNC)
#define PLASMA_CTILE_TO_LAPACK PLASMA_FNAME(ctile_to_lapack, CTILE_TO_LAPACK)
#define PLASMA_CTILE_TO_LAPACK_ASYNC PLASMA_FNAME(ctile_to_lapack_async, CTILE_TO_LAPACK_ASYNC)
#define PLASMA_CGEBRD          PLASMA_FNAME(cgebrd       , CGEBRD       )
#define PLASMA_CGECFI          PLASMA_FNAME(cgecfi       , CGECFI       )
#define PLASMA_CGECFI_ASYNC    PLASMA_FNAME(cgecfi_async , CGECFI_ASYNC )
#define PLASMA_CGECON          PLASMA_FNAME(cgecon       , ZGECON       )
#define PLASMA_CGELQF          PLASMA_FNAME(cgelqf       , CGELQF       )
#define PLASMA_CGELQS          PLASMA_FNAME(cgelqs       , CGELQS       )
#define PLASMA_CGELS           PLASMA_FNAME(cgels        , CGELS        )
#define PLASMA_CGEMM           PLASMA_FNAME(cgemm        , CGEMM        )
#define PLASMA_CGEQP3          PLASMA_FNAME(cgeqp3       , ZGEQP3       )
#define PLASMA_CGEQRF          PLASMA_FNAME(cgeqrf       , CGEQRF       )
#define PLASMA_CGEQRS          PLASMA_FNAME(cgeqrs       , CGEQRS       )
#define PLASMA_CGESDD          PLASMA_FNAME(cgesdd       , CGESDD       )
#define PLASMA_CGESV           PLASMA_FNAME(cgesv        , CGESV        )
#define PLASMA_CGESV_INCPIV    PLASMA_FNAME(cgesv_incpiv , CGESV_INCPIV )
#define PLASMA_CGESVD          PLASMA_FNAME(cgesvd       , CGESVD       )
#define PLASMA_CGETMI          PLASMA_FNAME(cgetmi       , CGETMI       )
#define PLASMA_CGETMI_ASYNC    PLASMA_FNAME(cgetmi_async , CGETMI_ASYNC )
#define PLASMA_CGETRF          PLASMA_FNAME(cgetrf       , CGETRF       )
#define PLASMA_CGETRF_INCPIV   PLASMA_FNAME(cgetrf_incpiv, CGETRF_INCPIV)
#define PLASMA_CGETRF_NOPIV    PLASMA_FNAME(cgetrf_nopiv , CGETRF_NOPIV )
#define PLASMA_CGETRF_TNTPIV   PLASMA_FNAME(cgetrf_tntpiv, CGETRF_TNTPIV)
#define PLASMA_CGETRI          PLASMA_FNAME(cgetri       , CGETRI       )
#define PLASMA_CGETRS          PLASMA_FNAME(cgetrs       , CGETRS       )
#define PLASMA_CGETRS_INCPIV   PLASMA_FNAME(cgetrs_incpiv, CGETRS_INCPIV)
#define PLASMA_CHEEV           PLASMA_FNAME(cheev        , CHEEV        )
#define PLASMA_CHEEVD          PLASMA_FNAME(cheevd       , CHEEVD       )
#define PLASMA_CHEEVR          PLASMA_FNAME(cheevr       , CHEEVR       )
#define PLASMA_CHEGST          PLASMA_FNAME(chegst       , CHEGST       )
#define PLASMA_CHEGV           PLASMA_FNAME(chegv        , CHEGV        )
#define PLASMA_CHEGVD          PLASMA_FNAME(chegvd       , CHEGVD       )
#ifdef COMPLEX
#define PLASMA_CHEMM           PLASMA_FNAME(chemm        , CHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_CHER2K          PLASMA_FNAME(cher2k       , CHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_CHERK           PLASMA_FNAME(cherk        , CHERK        )
#endif
#define PLASMA_CHETRD          PLASMA_FNAME(chetrd       , CHETRD       )
#define PLASMA_CLACPY          PLASMA_FNAME(clacpy       , CLACPY       )
#define PLASMA_CLANGE          PLASMA_FNAME(clange       , CLANGE       )
#ifdef COMPLEX
#define PLASMA_CLANHE          PLASMA_FNAME(clanhe       , CLANHE       )
#endif
#define PLASMA_CLANSY          PLASMA_FNAME(clansy       , CLANSY       )
#define PLASMA_CLASET          PLASMA_FNAME(claset       , CLASET       )
#define PLASMA_CLASWP          PLASMA_FNAME(claswp       , CLASWP       )
#define PLASMA_CLASWPC         PLASMA_FNAME(claswpc      , CLASWPC      )
#define PLASMA_CLAUUM          PLASMA_FNAME(clauum       , CLAUUM       )
#ifdef COMPLEX
#define PLASMA_CPLGHE          PLASMA_FNAME(cplghe       , ZPLGHE       )
#endif
#define PLASMA_CPLGSY          PLASMA_FNAME(cplgsy       , ZPLGSY       )
#define PLASMA_CPLRNT          PLASMA_FNAME(cplrnt       , ZPLRNT       )
#define PLASMA_CPOCON          PLASMA_FNAME(cpocon       , ZPOCON       )
#define PLASMA_CPOSV           PLASMA_FNAME(cposv        , CPOSV        )
#define PLASMA_CPOTRF          PLASMA_FNAME(cpotrf       , CPOTRF       )
#define PLASMA_CPOTRI          PLASMA_FNAME(cpotri       , CPOTRI       )
#define PLASMA_CPOTRS          PLASMA_FNAME(cpotrs       , CPOTRS       )
#define PLASMA_CSYMM           PLASMA_FNAME(csymm        , CSYMM        )
#define PLASMA_CSYR2K          PLASMA_FNAME(csyr2k       , CSYR2K       )
#define PLASMA_CSYRK           PLASMA_FNAME(csyrk        , CSYRK        )
#define PLASMA_CTRMM           PLASMA_FNAME(ctrmm        , CTRMM        )
#define PLASMA_CTRSM           PLASMA_FNAME(ctrsm        , CTRSM        )
#define PLASMA_CTRSMPL         PLASMA_FNAME(ctrsmpl      , CTRSMPL      )
#define PLASMA_CTRSMRV         PLASMA_FNAME(ctrsmrv      , CTRSMRV      )
#define PLASMA_CTRTRI          PLASMA_FNAME(ctrtri       , CTRTRI       )
#define PLASMA_CUNGLQ          PLASMA_FNAME(cunglq       , CUNGLQ       )
#define PLASMA_CUNGQR          PLASMA_FNAME(cungqr       , CUNGQR       )
#define PLASMA_CUNMLQ          PLASMA_FNAME(cunmlq       , CUNMLQ       )
#define PLASMA_CUNMQR          PLASMA_FNAME(cunmqr       , CUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
#define PLASMA_CGEBRD_TILE          PLASMA_TILE_FNAME(cgebrd       , CGEBRD       )
#define PLASMA_CGECON_TILE          PLASMA_TILE_FNAME(cgecon       , ZGECON       )
#define PLASMA_CGELQF_TILE          PLASMA_TILE_FNAME(cgelqf       , CGELQF       )
#define PLASMA_CGELQS_TILE          PLASMA_TILE_FNAME(cgelqs       , CGELQS       )
#define PLASMA_CGELS_TILE           PLASMA_TILE_FNAME(cgels        , CGELS        )
#define PLASMA_CGEMM_TILE           PLASMA_TILE_FNAME(cgemm        , CGEMM        )
#define PLASMA_CGEQP3_TILE          PLASMA_TILE_FNAME(cgeqp3       , ZGEQP3       )
#define PLASMA_CGEQRF_TILE          PLASMA_TILE_FNAME(cgeqrf       , CGEQRF       )
#define PLASMA_CGEQRS_TILE          PLASMA_TILE_FNAME(cgeqrs       , CGEQRS       )
#define PLASMA_CGESDD_TILE          PLASMA_TILE_FNAME(cgesdd       , CGESDD       )
#define PLASMA_CGESV_TILE           PLASMA_TILE_FNAME(cgesv        , CGESV        )
#define PLASMA_CGESV_INCPIV_TILE    PLASMA_TILE_FNAME(cgesv_incpiv , CGESV_INCPIV )
#define PLASMA_CGESVD_TILE          PLASMA_TILE_FNAME(cgesvd       , CGESVD       )
#define PLASMA_CGETRF_TILE          PLASMA_TILE_FNAME(cgetrf       , CGETRF       )
#define PLASMA_CGETRF_INCPIV_TILE   PLASMA_TILE_FNAME(cgetrf_incpiv, CGETRF_INCPIV)
#define PLASMA_CGETRF_NOPIV_TILE    PLASMA_TILE_FNAME(cgetrf_nopiv , CGETRF_NOPIV )
#define PLASMA_CGETRF_TNTPIV_TILE   PLASMA_TILE_FNAME(cgetrf_tntpiv, CGETRF_TNTPIV)
#define PLASMA_CGETRI_TILE          PLASMA_TILE_FNAME(cgetri       , CGETRI       )
#define PLASMA_CGETRS_TILE          PLASMA_TILE_FNAME(cgetrs       , CGETRS       )
#define PLASMA_CGETRS_INCPIV_TILE   PLASMA_TILE_FNAME(cgetrs_incpiv, CGETRS_INCPIV)
#define PLASMA_CHEEV_TILE           PLASMA_TILE_FNAME(cheev        , CHEEV        )
#define PLASMA_CHEEVD_TILE          PLASMA_TILE_FNAME(cheevd       , CHEEVD       )
#define PLASMA_CHEEVR_TILE          PLASMA_TILE_FNAME(cheevr       , CHEEVR       )
#define PLASMA_CHEGST_TILE          PLASMA_TILE_FNAME(chegst       , CHEGST       )
#define PLASMA_CHEGV_TILE           PLASMA_TILE_FNAME(chegv        , CHEGV        )
#define PLASMA_CHEGVD_TILE          PLASMA_TILE_FNAME(chegvd       , CHEGVD       )
#ifdef COMPLEX
#define PLASMA_CHEMM_TILE           PLASMA_TILE_FNAME(chemm        , CHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_CHER2K_TILE          PLASMA_TILE_FNAME(cher2k       , CHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_CHERK_TILE           PLASMA_TILE_FNAME(cherk        , CHERK        )
#endif
#define PLASMA_CHETRD_TILE          PLASMA_TILE_FNAME(chetrd       , CHETRD       )
#define PLASMA_CLACPY_TILE          PLASMA_TILE_FNAME(clacpy       , CLACPY       )
#define PLASMA_CLANGE_TILE          PLASMA_TILE_FNAME(clange       , CLANGE       )
#ifdef COMPLEX
#define PLASMA_CLANHE_TILE          PLASMA_TILE_FNAME(clanhe       , CLANHE       )
#endif
#define PLASMA_CLANSY_TILE          PLASMA_TILE_FNAME(clansy       , CLANSY       )
#define PLASMA_CLASET_TILE          PLASMA_TILE_FNAME(claset       , CLASET       )
#define PLASMA_CLASWP_TILE          PLASMA_TILE_FNAME(claswp       , CLASWP       )
#define PLASMA_CLASWPC_TILE         PLASMA_TILE_FNAME(claswpc      , CLASWPC      )
#define PLASMA_CLAUUM_TILE          PLASMA_TILE_FNAME(clauum       , CLAUUM       )
#ifdef COMPLEX
#define PLASMA_CPLGHE_TILE          PLASMA_TILE_FNAME(cplghe       , ZPLGHE       )
#endif
#define PLASMA_CPLGSY_TILE          PLASMA_TILE_FNAME(cplgsy       , ZPLGSY       )
#define PLASMA_CPLRNT_TILE          PLASMA_TILE_FNAME(cplrnt       , ZPLRNT       )
#define PLASMA_CPOCON_TILE          PLASMA_TILE_FNAME(cpocon       , ZPOCON       )
#define PLASMA_CPOSV_TILE           PLASMA_TILE_FNAME(cposv        , CPOSV        )
#define PLASMA_CPOTRF_TILE          PLASMA_TILE_FNAME(cpotrf       , CPOTRF       )
#define PLASMA_CPOTRI_TILE          PLASMA_TILE_FNAME(cpotri       , CPOTRI       )
#define PLASMA_CPOTRS_TILE          PLASMA_TILE_FNAME(cpotrs       , CPOTRS       )
#define PLASMA_CSYMM_TILE           PLASMA_TILE_FNAME(csymm        , CSYMM        )
#define PLASMA_CSYR2K_TILE          PLASMA_TILE_FNAME(csyr2k       , CSYR2K       )
#define PLASMA_CSYRK_TILE           PLASMA_TILE_FNAME(csyrk        , CSYRK        )
#define PLASMA_CTRMM_TILE           PLASMA_TILE_FNAME(ctrmm        , CTRMM        )
#define PLASMA_CTRSM_TILE           PLASMA_TILE_FNAME(ctrsm        , CTRSM        )
#define PLASMA_CTRSMPL_TILE         PLASMA_TILE_FNAME(ctrsmpl      , CTRSMPL      )
#define PLASMA_CTRSMRV_TILE         PLASMA_TILE_FNAME(ctrsmrv      , CTRSMRV      )
#define PLASMA_CTRTRI_TILE          PLASMA_TILE_FNAME(ctrtri       , CTRTRI       )
#define PLASMA_CUNGLQ_TILE          PLASMA_TILE_FNAME(cunglq       , CUNGLQ       )
#define PLASMA_CUNGQR_TILE          PLASMA_TILE_FNAME(cungqr       , CUNGQR       )
#define PLASMA_CUNMLQ_TILE          PLASMA_TILE_FNAME(cunmlq       , CUNMLQ       )
#define PLASMA_CUNMQR_TILE          PLASMA_TILE_FNAME(cunmqr       , CUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
#define PLASMA_CGEBRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgebrd       , CGEBRD       )
#define PLASMA_CGECON_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgecon       , ZGECON       )
#define PLASMA_CGELQF_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgelqf       , CGELQF       )
#define PLASMA_CGELQS_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgelqs       , CGELQS       )
#define PLASMA_CGELS_TILE_ASYNC           PLASMA_ASYNC_FNAME(cgels        , CGELS        )
#define PLASMA_CGEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(cgemm        , CGEMM        )
#define PLASMA_CGEQP3_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgeqp3       , ZGEQP3       )
#define PLASMA_CGEQRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgeqrf       , CGEQRF       )
#define PLASMA_CGEQRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgeqrs       , CGEQRS       )
#define PLASMA_CGESDD_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgesdd       , CGESDD       )
#define PLASMA_CGESV_TILE_ASYNC           PLASMA_ASYNC_FNAME(cgesv        , CGESV        )
#define PLASMA_CGESV_INCPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(cgesv_incpiv , CGESV_INCPIV )
#define PLASMA_CGESVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgesvd       , CGESVD       )
#define PLASMA_CGETRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgetrf       , CGETRF       )
#define PLASMA_CGETRF_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(cgetrf_incpiv, CGETRF_INCPIV)
#define PLASMA_CGETRF_NOPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(cgetrf_nopiv , CGETRF_NOPIV )
#define PLASMA_CGETRF_TNTPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(cgetrf_tntpiv, CGETRF_TNTPIV)
#define PLASMA_CGETRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgetri       , CGETRI       )
#define PLASMA_CGETRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(cgetrs       , CGETRS       )
#define PLASMA_CGETRS_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(cgetrs_incpiv, CGETRS_INCPIV)
#define PLASMA_CHEEV_TILE_ASYNC           PLASMA_ASYNC_FNAME(cheev        , CHEEV        )
#define PLASMA_CHEEVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(cheevd       , CHEEVD       )
#define PLASMA_CHEEVR_TILE_ASYNC          PLASMA_ASYNC_FNAME(cheevr       , CHEEVR       )
#define PLASMA_CHEGST_TILE_ASYNC          PLASMA_ASYNC_FNAME(chegst       , CHEGST       )
#define PLASMA_CHEGV_TILE_ASYNC           PLASMA_ASYNC_FNAME(chegv        , CHEGV        )
#define PLASMA_CHEGVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(chegvd       , CHEGVD       )
#ifdef COMPLEX
#define PLASMA_CHEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(chemm        , CHEMM        )
#endif
#ifdef COMPLEX
#define PLASMA_CHER2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(cher2k       , CHER2K       )
#endif
#ifdef COMPLEX
#define PLASMA_CHERK_TILE_ASYNC           PLASMA_ASYNC_FNAME(cherk        , CHERK        )
#endif
#define PLASMA_CHETRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(chetrd       , CHETRD       )
#define PLASMA_CLACPY_TILE_ASYNC          PLASMA_ASYNC_FNAME(clacpy       , CLACPY       )
#define PLASMA_CLANGE_TILE_ASYNC          PLASMA_ASYNC_FNAME(clange       , CLANGE       )
#ifdef COMPLEX
#define PLASMA_CLANHE_TILE_ASYNC          PLASMA_ASYNC_FNAME(clanhe       , CLANHE       )
#endif
#define PLASMA_CLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(clansy       , CLANSY       )
#define PLASMA_CLASET_TILE_ASYNC          PLASMA_ASYNC_FNAME(claset       , CLASET       )
#define PLASMA_CLASWP_TILE_ASYNC          PLASMA_ASYNC_FNAME(claswp       , CLASWP       )
#define PLASMA_CLASWPC_TILE_ASYNC         PLASMA_ASYNC_FNAME(claswpc      , CLASWPC      )
#define PLASMA_CLAUUM_TILE_ASYNC          PLASMA_ASYNC_FNAME(clauum       , CLAUUM       )
#ifdef COMPLEX
#define PLASMA_CPLGHE_TILE_ASYNC          PLASMA_ASYNC_FNAME(cplghe       , ZPLGHE       )
#endif
#define PLASMA_CPLGSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(cplgsy       , ZPLGSY       )
#define PLASMA_CPLRNT_TILE_ASYNC          PLASMA_ASYNC_FNAME(cplrnt       , ZPLRNT       )
#define PLASMA_CPOCON_TILE_ASYNC          PLASMA_ASYNC_FNAME(cpocon       , ZPOCON       )
#define PLASMA_CPOSV_TILE_ASYNC           PLASMA_ASYNC_FNAME(cposv        , CPOSV        )
#define PLASMA_CPOTRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(cpotrf       , CPOTRF       )
#define PLASMA_CPOTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(cpotri       , CPOTRI       )
#define PLASMA_CPOTRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(cpotrs       , CPOTRS       )
#define PLASMA_CSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(csymm        , CSYMM        )
#define PLASMA_CSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(csyr2k       , CSYR2K       )
#define PLASMA_CSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(csyrk        , CSYRK        )
#define PLASMA_CTRMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ctrmm        , CTRMM        )
#define PLASMA_CTRSM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ctrsm        , CTRSM        )
#define PLASMA_CTRSMPL_TILE_ASYNC         PLASMA_ASYNC_FNAME(ctrsmpl      , CTRSMPL      )
#define PLASMA_CTRSMRV_TILE_ASYNC         PLASMA_ASYNC_FNAME(ctrsmrv      , CTRSMRV      )
#define PLASMA_CTRTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(ctrtri       , CTRTRI       )
#define PLASMA_CUNGLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(cunglq       , CUNGLQ       )
#define PLASMA_CUNGQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(cungqr       , CUNGQR       )
#define PLASMA_CUNMLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(cunmlq       , CUNMLQ       )
#define PLASMA_CUNMQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(cunmqr       , CUNMQR       )

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
#define PLASMA_ALLOC_WORKSPACE_CGEBRD              PLASMA_WS_FNAME(cgebrd            , CGEBRD            )
#define PLASMA_ALLOC_WORKSPACE_CGEEV               PLASMA_WS_FNAME(cgeev             , CGEEV             )
#define PLASMA_ALLOC_WORKSPACE_CGEHRD              PLASMA_WS_FNAME(cgehrd            , CGEHRD            )
#define PLASMA_ALLOC_WORKSPACE_CGELQF              PLASMA_WS_FNAME(cgelqf            , CGELQF            )
#define PLASMA_ALLOC_WORKSPACE_CGELQF_TILE         PLASMA_WS_FNAME(cgelqf_tile       , CGELQF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_CGELS               PLASMA_WS_FNAME(cgels             , CGELS             )
#define PLASMA_ALLOC_WORKSPACE_CGELS_TILE          PLASMA_WS_FNAME(cgels_tile        , CGELS_TILE        )
#define PLASMA_ALLOC_WORKSPACE_CGEQRF              PLASMA_WS_FNAME(cgeqrf            , CGEQRF            )
#define PLASMA_ALLOC_WORKSPACE_CGEQRF_TILE         PLASMA_WS_FNAME(cgeqrf_tile       , CGEQRF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_CGESDD              PLASMA_WS_FNAME(cgesdd            , CGESDD            )
#define PLASMA_ALLOC_WORKSPACE_CGESV_INCPIV        PLASMA_WS_FNAME(cgesv_incpiv      , CGESV_INCPIV      )
#define PLASMA_ALLOC_WORKSPACE_CGESV_INCPIV_TILE   PLASMA_WS_FNAME(cgesv_incpiv_tile , CGESV_INCPIV_TILE )
#define PLASMA_ALLOC_WORKSPACE_CGESVD              PLASMA_WS_FNAME(cgesvd            , CGESVD            )
#define PLASMA_ALLOC_WORKSPACE_CGETRF_INCPIV       PLASMA_WS_FNAME(cgetrf_incpiv     , CGETRF_INCPIV     )
#define PLASMA_ALLOC_WORKSPACE_CGETRF_INCPIV_TILE  PLASMA_WS_FNAME(cgetrf_incpiv_tile, CGETRF_INCPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_CGETRF_TNTPIV_TILE  PLASMA_WS_FNAME(cgetrf_tntpiv_tile, CGETRF_TNTPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_CGETRI_TILE_ASYNC   PLASMA_WS_FNAME(cgetri_tile_async , CGETRI_TILE_ASYNC )
#define PLASMA_ALLOC_WORKSPACE_CHEEV               PLASMA_WS_FNAME(cheev             , CHEEV             )
#define PLASMA_ALLOC_WORKSPACE_CHEEVD              PLASMA_WS_FNAME(cheevd            , CHEEVD            )
#define PLASMA_ALLOC_WORKSPACE_CHEEVR              PLASMA_WS_FNAME(cheevr            , CHEEVR            )
#define PLASMA_ALLOC_WORKSPACE_CHEGV               PLASMA_WS_FNAME(chegv             , CHEGV             )
#define PLASMA_ALLOC_WORKSPACE_CHEGVD              PLASMA_WS_FNAME(chegvd            , CHEGVD            )
#define PLASMA_ALLOC_WORKSPACE_CHETRD              PLASMA_WS_FNAME(chetrd            , CHETRD            )



/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_CLAPACK_TO_TILE(PLASMA_Complex32_t *Af77, int *LDA, PLASMA_desc *A, int *info)
{ *info = PLASMA_cLapack_to_Tile(Af77, *LDA, A); }

void PLASMA_CLAPACK_TO_TILE_ASYNC(PLASMA_Complex32_t *Af77, int *LDA, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cLapack_to_Tile_Async(Af77, *LDA, A, sequence, request); }

void PLASMA_CTILE_TO_LAPACK(PLASMA_desc *A, PLASMA_Complex32_t *Af77, int *LDA, int *info)
{ *info = PLASMA_cTile_to_Lapack(A, Af77, *LDA); }

void PLASMA_CTILE_TO_LAPACK_ASYNC(PLASMA_desc *A, PLASMA_Complex32_t *Af77, int *LDA, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cTile_to_Lapack_Async(A, Af77, *LDA, sequence, request); }

void PLASMA_CGEBRD(PLASMA_enum *jobq, PLASMA_enum *jobpt, int *M, int *N, PLASMA_Complex32_t *A, int *LDA, float *D, float *E, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_Complex32_t *PT, int *LDPT, int *info)
{ *info = PLASMA_cgebrd(*jobq, *jobpt, *M, *N, A, *LDA, D, E, *descT, Q, *LDQ, PT, *LDPT); }

void PLASMA_CGECFI(int *m, int *n, PLASMA_Complex32_t *A, PLASMA_enum *fin, int *imb, int *inb, PLASMA_enum *fout, int *omb, int *onb, int *info)
{ *info = PLASMA_cgecfi(*m, *n, A, *fin, *imb, *inb, *fout, *omb, *onb); }

void PLASMA_CGECFI_ASYNC(int *m, int *n, PLASMA_Complex32_t *A, PLASMA_enum *f_in, int *imb, int *inb, PLASMA_enum *f_out, int *omb, int *onb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgecfi_Async(*m, *n, A, *f_in, *imb, *inb, *f_out, *omb, *onb, sequence, request); }

void PLASMA_CGECON(PLASMA_enum *norm, int *N, PLASMA_Complex32_t *A, int *LDA, float *anorm, float *rcond, int *info)
{ *info = PLASMA_cgecon(*norm, *N, A, *LDA, *anorm, rcond); }

void PLASMA_CGELQF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_cgelqf(*M, *N, A, *LDA, *descT); }

void PLASMA_CGELQS(int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgelqs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_CGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgels(*trans, *M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_CGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_cgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CGEQP3(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, int *jpvt, PLASMA_Complex32_t *tau, PLASMA_Complex32_t *work, float *rwork, int *info)
{ *info = PLASMA_cgeqp3(*M, *N, A, *LDA, jpvt, tau, work, rwork); }

void PLASMA_CGEQRF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_cgeqrf(*M, *N, A, *LDA, *descT); }

void PLASMA_CGEQRS(int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgeqrs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_CGESDD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, PLASMA_Complex32_t *A, int *LDA, float *S, PLASMA_desc **descT, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, int *info)
{ *info = PLASMA_cgesdd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_CGESV(int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, int *IPIV, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgesv(*N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_CGESV_INCPIV(int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descL, int *IPIV, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgesv_incpiv(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_CGESVD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, PLASMA_Complex32_t *A, int *LDA, float *S, PLASMA_desc **descT, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, int *info)
{ *info = PLASMA_cgesvd(*jobu, *jobvt, *M, *N, A, *LDA, S, *descT, U, *LDU, VT, *LDVT); }

void PLASMA_CGETMI(int *m, int *n, PLASMA_Complex32_t *A, PLASMA_enum *fin, int *mb, int *nb, int *info)
{ *info = PLASMA_cgetmi(*m, *n, A, *fin, *mb, *nb); }

void PLASMA_CGETMI_ASYNC(int *m, int *n, PLASMA_Complex32_t *A, PLASMA_enum *f_in, int *mb, int *inb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetmi_Async(*m, *n, A, *f_in, *mb, *inb, sequence, request); }

void PLASMA_CGETRF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_cgetrf(*M, *N, A, *LDA, IPIV); }

void PLASMA_CGETRF_INCPIV(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descL, int *IPIV, int *info)
{ *info = PLASMA_cgetrf_incpiv(*M, *N, A, *LDA, *descL, IPIV); }

void PLASMA_CGETRF_NOPIV(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_cgetrf_nopiv(*M, *N, A, *LDA); }

void PLASMA_CGETRF_TNTPIV(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_cgetrf_tntpiv(*M, *N, A, *LDA, IPIV); }

void PLASMA_CGETRI(int *N, PLASMA_Complex32_t *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_cgetri(*N, A, *LDA, IPIV); }

void PLASMA_CGETRS(PLASMA_enum *trans, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, const int *IPIV, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgetrs(*trans, *N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_CGETRS_INCPIV(PLASMA_enum *trans, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descL, const int *IPIV, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cgetrs_incpiv(*trans, *N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_CHEEV(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *W, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheev(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_CHEEVD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *W, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheevd(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_CHEEVR(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *vl, float *vu, int *il, int *iu, float *abstol, int *nbcomputedeig, float *W, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheevr(*jobz, *range, *uplo, *N, A, *LDA, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, *descT, Q, *LDQ); }

void PLASMA_CHEGST(PLASMA_enum *itype, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_chegst(*itype, *uplo, *N, A, *LDA, B, *LDB); }

void PLASMA_CHEGV(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, float *W, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_chegv(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

void PLASMA_CHEGVD(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, float *W, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_chegvd(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

#ifdef COMPLEX
void PLASMA_CHEMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_chemm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_CHER2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, float *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_cher2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_CHERK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, PLASMA_Complex32_t *A, int *LDA, float *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_cherk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

void PLASMA_CHETRD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *D, float *E, PLASMA_desc **descT, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_chetrd(*jobz, *uplo, *N, A, *LDA, D, E, *descT, Q, *LDQ); }

void PLASMA_CLACPY(PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_clacpy(*uplo, *M, *N, A, *LDA, B, *LDB); }

void PLASMA_CLANGE(PLASMA_enum *norm, int *M, int *N, PLASMA_Complex32_t *A, int *LDA, float *result)
{ *result = PLASMA_clange(*norm, *M, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_CLANHE(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *result)
{ *result = PLASMA_clanhe(*norm, *uplo, *N, A, *LDA); }
#endif

void PLASMA_CLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *result)
{ *result = PLASMA_clansy(*norm, *uplo, *N, A, *LDA); }

void PLASMA_CLASET(PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_claset(*uplo, *M, *N, *alpha, *beta, A, *LDA); }

void PLASMA_CLASWP(int *N, PLASMA_Complex32_t *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_claswp(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_CLASWPC(int *N, PLASMA_Complex32_t *A, int *LDA, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_claswpc(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_CLAUUM(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_clauum(*uplo, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_CPLGHE(float *bump, int *N, PLASMA_Complex32_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplghe(*bump, *N, A, *LDA, *seed); }
#endif

void PLASMA_CPLGSY(PLASMA_Complex32_t *bump, int *N, PLASMA_Complex32_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplgsy(*bump, *N, A, *LDA, *seed); }

void PLASMA_CPLRNT(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplrnt(*M, *N, A, *LDA, *seed); }

void PLASMA_CPOCON(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, float *anorm, float *rcond, int *info)
{ *info = PLASMA_cpocon(*uplo, *N, A, *LDA, *anorm, rcond); }

void PLASMA_CPOSV(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_CPOTRF(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_cpotrf(*uplo, *N, A, *LDA); }

void PLASMA_CPOTRI(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_cpotri(*uplo, *N, A, *LDA); }

void PLASMA_CPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_CSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_csymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_csyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *info)
{ *info = PLASMA_csyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

void PLASMA_CTRMM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_ctrmm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_CTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_ctrsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_CTRSMPL(int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descL, const int *IPIV, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_ctrsmpl(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_CTRSMRV(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_ctrsmrv(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_CTRTRI(PLASMA_enum *uplo, PLASMA_enum *diag, int *N, PLASMA_Complex32_t *A, int *LDA, int *info)
{ *info = PLASMA_ctrtri(*uplo, *diag, *N, A, *LDA); }

void PLASMA_CUNGLQ(int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cunglq(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_CUNGQR(int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cungqr(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_CUNMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cunmlq(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_CUNMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_desc **descT, PLASMA_Complex32_t *B, int *LDB, int *info)
{ *info = PLASMA_cunmqr(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }


/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_CGEBRD_TILE(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_Complex32_t *PT, int *LDPT, int *info)
{ *info = PLASMA_cgebrd_Tile(*jobq, *jobpt, A, D, E, T, Q, *LDQ, PT, *LDPT); }

void PLASMA_CGECON_TILE(PLASMA_enum *norm, PLASMA_desc *A, float *anorm, float *rcond, int *info)
{ *info = PLASMA_cgecon_Tile(*norm, A, *anorm, rcond); }

void PLASMA_CGELQF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_cgelqf_Tile(A, T); }

void PLASMA_CGELQS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgelqs_Tile(A, T, B); }

void PLASMA_CGELS_TILE(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgels_Tile(*trans, A, T, B); }

void PLASMA_CGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_cgemm_Tile(*transA, *transB, *alpha, A, B, *beta, C); }

void PLASMA_CGEQP3_TILE(PLASMA_desc *A, int *jpvt, PLASMA_Complex32_t *tau, PLASMA_Complex32_t *work, float *rwork, int *info)
{ *info = PLASMA_cgeqp3_Tile(A, jpvt, tau, work, rwork); }

void PLASMA_CGEQRF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_cgeqrf_Tile(A, T); }

void PLASMA_CGEQRS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgeqrs_Tile(A, T, B); }

void PLASMA_CGESDD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *T, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, int *info)
{ *info = PLASMA_cgesdd_Tile(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT); }

void PLASMA_CGESV_TILE(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgesv_Tile(A, IPIV, B); }

void PLASMA_CGESV_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgesv_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_CGESVD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *T, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, int *info)
{ *info = PLASMA_cgesvd_Tile(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT); }

void PLASMA_CGETRF_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_cgetrf_Tile(A, IPIV); }

void PLASMA_CGETRF_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, int *info)
{ *info = PLASMA_cgetrf_incpiv_Tile(A, L, IPIV); }

void PLASMA_CGETRF_NOPIV_TILE(PLASMA_desc *A, int *info)
{ *info = PLASMA_cgetrf_nopiv_Tile(A); }

void PLASMA_CGETRF_TNTPIV_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_cgetrf_tntpiv_Tile(A, IPIV); }

void PLASMA_CGETRI_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_cgetri_Tile(A, IPIV); }

void PLASMA_CGETRS_TILE(PLASMA_enum *trans, PLASMA_desc *A, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgetrs_Tile(*trans, A, IPIV, B); }

void PLASMA_CGETRS_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_cgetrs_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_CHEEV_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheev_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_CHEEVD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheevd_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_CHEEVR_TILE(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc *A, float *vl, float *vu, int *il, int *iu, float *abstol, int *nbcomputedeig, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_cheevr_Tile(*jobz, *range, *uplo, A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, T, Q, *LDQ); }

void PLASMA_CHEGST_TILE(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_chegst_Tile(*itype, *uplo, A, B); }

void PLASMA_CHEGV_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_chegv_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

void PLASMA_CHEGVD_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_chegvd_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

#ifdef COMPLEX
void PLASMA_CHEMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_chemm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_CHER2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_cher2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_CHERK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_cherk_Tile(*uplo, *trans, *alpha, A, *beta, C); }
#endif

void PLASMA_CHETRD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, int *info)
{ *info = PLASMA_chetrd_Tile(*jobz, *uplo, A, D, E, T, Q, *LDQ); }

void PLASMA_CLACPY_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_clacpy_Tile(*uplo, A, B); }

void PLASMA_CLANGE_TILE(PLASMA_enum *norm, PLASMA_desc *A, float *result)
{ *result = PLASMA_clange_Tile(*norm, A); }

#ifdef COMPLEX
void PLASMA_CLANHE_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *result)
{ *result = PLASMA_clanhe_Tile(*norm, *uplo, A); }
#endif

void PLASMA_CLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *result)
{ *result = PLASMA_clansy_Tile(*norm, *uplo, A); }

void PLASMA_CLASET_TILE(PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *beta, PLASMA_desc *A, int *info)
{ *info = PLASMA_claset_Tile(*uplo, *alpha, *beta, A); }

void PLASMA_CLASWP_TILE(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_claswp_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_CLASWPC_TILE(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, int *info)
{ *info = PLASMA_claswpc_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_CLAUUM_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_clauum_Tile(*uplo, A); }

#ifdef COMPLEX
void PLASMA_CPLGHE_TILE(float *bump, PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplghe_Tile(*bump, A, *seed); }
#endif

void PLASMA_CPLGSY_TILE(PLASMA_Complex32_t *bump, PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplgsy_Tile(*bump, A, *seed); }

void PLASMA_CPLRNT_TILE(PLASMA_desc *A, unsigned long long int *seed, int *info)
{ *info = PLASMA_cplrnt_Tile(A, *seed); }

void PLASMA_CPOCON_TILE(PLASMA_enum *uplo, PLASMA_desc *A, float *anorm, float *rcond, int *info)
{ *info = PLASMA_cpocon_Tile(*uplo, A, *anorm, rcond); }

void PLASMA_CPOSV_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_cposv_Tile(*uplo, A, B); }

void PLASMA_CPOTRF_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_cpotrf_Tile(*uplo, A); }

void PLASMA_CPOTRI_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_cpotri_Tile(*uplo, A); }

void PLASMA_CPOTRS_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_cpotrs_Tile(*uplo, A, B); }

void PLASMA_CSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_csymm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }

void PLASMA_CSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_csyr2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }

void PLASMA_CSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_Complex32_t *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_csyrk_Tile(*uplo, *trans, *alpha, A, *beta, C); }

void PLASMA_CTRMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_ctrmm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_CTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_ctrsm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_CTRSMPL_TILE(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_ctrsmpl_Tile(A, L, IPIV, B); }

void PLASMA_CTRSMRV_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_ctrsmrv_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_CTRTRI_TILE(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, int *info)
{ *info = PLASMA_ctrtri_Tile(*uplo, *diag, A); }

void PLASMA_CUNGLQ_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cunglq_Tile(A, T, B); }

void PLASMA_CUNGQR_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cungqr_Tile(A, T, B); }

void PLASMA_CUNMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cunmlq_Tile(*side, *trans, A, T, B); }

void PLASMA_CUNMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_cunmqr_Tile(*side, *trans, A, T, B); }


/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
void PLASMA_CGEBRD_TILE_ASYNC(PLASMA_enum *jobq, PLASMA_enum *jobpt, PLASMA_desc *A, float *S, float *E, PLASMA_desc *T, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgebrd_Tile_Async(*jobq, *jobpt, A, S, E, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_CGECON_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc *A, float *anorm, float *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgecon_Tile_Async(*norm, A, *anorm, rcond, sequence, request); }

void PLASMA_CGELQF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgelqf_Tile_Async(A, T, sequence, request); }

void PLASMA_CGELQS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgelqs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_CGELS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgels_Tile_Async(*trans, A, T, B, sequence, request); }

void PLASMA_CGEMM_TILE_ASYNC(PLASMA_enum *transA, PLASMA_enum *transB, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgemm_Tile_Async(*transA, *transB, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_CGEQP3_TILE_ASYNC(PLASMA_desc *A, int *jpvt, PLASMA_Complex32_t *tau, PLASMA_Complex32_t *work, float *rwork, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgeqp3_Tile_Async(A, jpvt, tau, work, rwork, sequence, request); }

void PLASMA_CGEQRF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgeqrf_Tile_Async(A, T, sequence, request); }

void PLASMA_CGEQRS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgeqrs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_CGESDD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *T, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgesdd_Tile_Async(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_CGESV_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgesv_Tile_Async(A, IPIV, B, sequence, request); }

void PLASMA_CGESV_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgesv_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_CGESVD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *T, PLASMA_Complex32_t *U, int *LDU, PLASMA_Complex32_t *VT, int *LDVT, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgesvd_Tile_Async(*jobu, *jobvt, A, S, T, U, *LDU, VT, *LDVT, sequence, request); }

void PLASMA_CGETRF_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrf_Tile_Async(A, IPIV, sequence, request); }

void PLASMA_CGETRF_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrf_incpiv_Tile_Async(A, L, IPIV, sequence, request); }

void PLASMA_CGETRF_NOPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrf_nopiv_Tile_Async(A, sequence, request); }

void PLASMA_CGETRF_TNTPIV_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *W, int *Wpivot, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrf_tntpiv_Tile_Async(A, IPIV, W, Wpivot, sequence, request); }

void PLASMA_CGETRI_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *W, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetri_Tile_Async(A, IPIV, W, sequence, request); }

void PLASMA_CGETRS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrs_Tile_Async(*trans, A, IPIV, B, sequence, request); }

void PLASMA_CGETRS_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cgetrs_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_CHEEV_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cheev_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_CHEEVD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cheevd_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_CHEEVR_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *range, PLASMA_enum *uplo, PLASMA_desc *A, float *vl, float *vu, int *il, int *iu, float *abstol, int *nbcomputedeig, float *W, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cheevr_Tile_Async(*jobz, *range, *uplo, A, *vl, *vu, *il, *iu, *abstol, nbcomputedeig, W, T, Q, *LDQ, sequence, request); }

void PLASMA_CHEGST_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_chegst_Tile_Async(*itype, *uplo, A, B, sequence, request); }

void PLASMA_CHEGV_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_chegv_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

void PLASMA_CHEGVD_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_chegvd_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

#ifdef COMPLEX
void PLASMA_CHEMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_chemm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_CHER2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cher2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_CHERK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cherk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }
#endif

void PLASMA_CHETRD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, PLASMA_Complex32_t *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_chetrd_Tile_Async(*jobz, *uplo, A, D, E, T, Q, *LDQ, sequence, request); }

void PLASMA_CLACPY_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_clacpy_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_CLANGE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc *A, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_clange_Tile_Async(*norm, A, value, sequence, request); }

#ifdef COMPLEX
void PLASMA_CLANHE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_clanhe_Tile_Async(*norm, *uplo, A, value, sequence, request); }
#endif

void PLASMA_CLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_clansy_Tile_Async(*norm, *uplo, A, value, sequence, request); }

void PLASMA_CLASET_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *beta, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_claset_Tile_Async(*uplo, *alpha, *beta, A, sequence, request); }

void PLASMA_CLASWP_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_claswp_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_CLASWPC_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, const int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_claswpc_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_CLAUUM_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_clauum_Tile_Async(*uplo, A, sequence, request); }

#ifdef COMPLEX
void PLASMA_CPLGHE_TILE_ASYNC(float *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cplghe_Tile_Async(*bump, A, *seed, sequence, request); }
#endif

void PLASMA_CPLGSY_TILE_ASYNC(PLASMA_Complex32_t *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cplgsy_Tile_Async(*bump, A, *seed, sequence, request); }

void PLASMA_CPLRNT_TILE_ASYNC(PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cplrnt_Tile_Async(A, *seed, sequence, request); }

void PLASMA_CPOCON_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, float *anorm, float *rcond, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cpocon_Tile_Async(*uplo, A, *anorm, rcond, sequence, request); }

void PLASMA_CPOSV_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cposv_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_CPOTRF_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cpotrf_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_CPOTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cpotri_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_CPOTRS_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cpotrs_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_CSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_csymm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_CSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_Complex32_t *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_csyr2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_CSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_Complex32_t *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_csyrk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }

void PLASMA_CTRMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ctrmm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_CTRSM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ctrsm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_CTRSMPL_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, const int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ctrsmpl_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_CTRSMRV_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ctrsmrv_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_CTRTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ctrtri_Tile_Async(*uplo, *diag, A, sequence, request); }

void PLASMA_CUNGLQ_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cunglq_Tile_Async(A, T, B, sequence, request); }

void PLASMA_CUNGQR_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cungqr_Tile_Async(A, T, B, sequence, request); }

void PLASMA_CUNMLQ_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cunmlq_Tile_Async(*side, *trans, A, T, B, sequence, request); }

void PLASMA_CUNMQR_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_cunmqr_Tile_Async(*side, *trans, A, T, B, sequence, request); }


/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_CGEBRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgebrd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGEEV(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgeev(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGEHRD(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgehrd(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGELQF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_cgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGELQF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgelqf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGELS(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_cgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGELS_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgels_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGEQRF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_cgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGEQRF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgeqrf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGESDD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgesdd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGESV_INCPIV(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_cgesv_incpiv(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_CGESV_INCPIV_TILE (int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_cgesv_incpiv_Tile (*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_CGESVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cgesvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CGETRF_INCPIV(int *M, int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_cgetrf_incpiv(*M, *N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_CGETRF_INCPIV_TILE(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_CGETRF_TNTPIV_TILE(PLASMA_desc *A, PLASMA_desc *W, int **Wpivot, int *info)
{ *info = PLASMA_Alloc_Workspace_cgetrf_tntpiv_Tile(A, W, Wpivot); }

void PLASMA_ALLOC_WORKSPACE_CGETRI_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *W, int *info)
{ *info = PLASMA_Alloc_Workspace_cgetri_Tile_Async(A, W); }

void PLASMA_ALLOC_WORKSPACE_CHEEV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cheev(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CHEEVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cheevd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CHEEVR(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_cheevr(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CHEGV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_chegv(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CHEGVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_chegvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_CHETRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_chetrd(*M, *N, descT); }



