/**
 *
 * @file plasma_sf77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *  This file is automatically generated by tools/genf77interface.pl
 *
 * @version 2.5.0
 * @author Bilel Hadri
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated s Thu Nov  8 11:44:41 2012
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef COMPLEX
#define REAL


/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
#define PLASMA_SLAPACK_TO_TILE PLASMA_FNAME(slapack_to_tile, SLAPACK_TO_TILE)
#define PLASMA_SLAPACK_TO_TILE_ASYNC PLASMA_FNAME(slapack_to_tile_async, SLAPACK_TO_TILE_ASYNC)
#define PLASMA_STILE_TO_LAPACK PLASMA_FNAME(stile_to_lapack, STILE_TO_LAPACK)
#define PLASMA_STILE_TO_LAPACK_ASYNC PLASMA_FNAME(stile_to_lapack_async, STILE_TO_LAPACK_ASYNC)
#define PLASMA_SGEBRD          PLASMA_FNAME(sgebrd       , SGEBRD       )
#define PLASMA_SGECFI          PLASMA_FNAME(sgecfi       , SGECFI       )
#define PLASMA_SGECFI_ASYNC    PLASMA_FNAME(sgecfi_async , SGECFI_ASYNC )
#define PLASMA_SGELQF          PLASMA_FNAME(sgelqf       , SGELQF       )
#define PLASMA_SGELQS          PLASMA_FNAME(sgelqs       , SGELQS       )
#define PLASMA_SGELS           PLASMA_FNAME(sgels        , SGELS        )
#define PLASMA_SGEMM           PLASMA_FNAME(sgemm        , SGEMM        )
#define PLASMA_SGEQRF          PLASMA_FNAME(sgeqrf       , SGEQRF       )
#define PLASMA_SGEQRS          PLASMA_FNAME(sgeqrs       , SGEQRS       )
#define PLASMA_SGESV           PLASMA_FNAME(sgesv        , SGESV        )
#define PLASMA_SGESV_INCPIV    PLASMA_FNAME(sgesv_incpiv , SGESV_INCPIV )
#define PLASMA_SGESVD          PLASMA_FNAME(sgesvd       , SGESVD       )
#define PLASMA_SGETMI          PLASMA_FNAME(sgetmi       , SGETMI       )
#define PLASMA_SGETMI_ASYNC    PLASMA_FNAME(sgetmi_async , SGETMI_ASYNC )
#define PLASMA_SGETRF          PLASMA_FNAME(sgetrf       , SGETRF       )
#define PLASMA_SGETRF_INCPIV   PLASMA_FNAME(sgetrf_incpiv, SGETRF_INCPIV)
#define PLASMA_SGETRI          PLASMA_FNAME(sgetri       , SGETRI       )
#define PLASMA_SGETRS          PLASMA_FNAME(sgetrs       , SGETRS       )
#define PLASMA_SGETRS_INCPIV   PLASMA_FNAME(sgetrs_incpiv, SGETRS_INCPIV)
#define PLASMA_SSYEV           PLASMA_FNAME(ssyev        , SSYEV        )
#define PLASMA_SSYEVD          PLASMA_FNAME(ssyevd       , SSYEVD       )
#define PLASMA_SSYGST          PLASMA_FNAME(ssygst       , SSYGST       )
#define PLASMA_SSYGV           PLASMA_FNAME(ssygv        , SSYGV        )
#define PLASMA_SSYGVD          PLASMA_FNAME(ssygvd       , SSYGVD       )
#ifdef COMPLEX
#define PLASMA_SSYMM           PLASMA_FNAME(ssymm        , SSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_SSYR2K          PLASMA_FNAME(ssyr2k       , SSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_SSYRK           PLASMA_FNAME(ssyrk        , SSYRK        )
#endif
#define PLASMA_SSYTRD          PLASMA_FNAME(ssytrd       , SSYTRD       )
#define PLASMA_SLACPY          PLASMA_FNAME(slacpy       , SLACPY       )
#define PLASMA_SLANGE          PLASMA_FNAME(slange       , SLANGE       )
#ifdef COMPLEX
#define PLASMA_SLANSY          PLASMA_FNAME(slansy       , SLANSY       )
#endif
#define PLASMA_SLANSY          PLASMA_FNAME(slansy       , SLANSY       )
#define PLASMA_SLASET          PLASMA_FNAME(slaset       , SLASET       )
#define PLASMA_SLASWP          PLASMA_FNAME(slaswp       , SLASWP       )
#define PLASMA_SLASWPC         PLASMA_FNAME(slaswpc      , SLASWPC      )
#define PLASMA_SLAUUM          PLASMA_FNAME(slauum       , SLAUUM       )
#ifdef COMPLEX
#define PLASMA_SPLGHE          PLASMA_FNAME(splgsy       , ZPLGHE       )
#endif
#define PLASMA_SPLGSY          PLASMA_FNAME(splgsy       , ZPLGSY       )
#define PLASMA_SPLRNT          PLASMA_FNAME(splrnt       , ZPLRNT       )
#define PLASMA_SPOSV           PLASMA_FNAME(sposv        , SPOSV        )
#define PLASMA_SPOTRF          PLASMA_FNAME(spotrf       , SPOTRF       )
#define PLASMA_SPOTRI          PLASMA_FNAME(spotri       , SPOTRI       )
#define PLASMA_SPOTRS          PLASMA_FNAME(spotrs       , SPOTRS       )
#define PLASMA_SSYMM           PLASMA_FNAME(ssymm        , SSYMM        )
#define PLASMA_SSYR2K          PLASMA_FNAME(ssyr2k       , SSYR2K       )
#define PLASMA_SSYRK           PLASMA_FNAME(ssyrk        , SSYRK        )
#define PLASMA_STRMM           PLASMA_FNAME(strmm        , STRMM        )
#define PLASMA_STRSM           PLASMA_FNAME(strsm        , STRSM        )
#define PLASMA_STRSMPL         PLASMA_FNAME(strsmpl      , STRSMPL      )
#define PLASMA_STRSMRV         PLASMA_FNAME(strsmrv      , STRSMRV      )
#define PLASMA_STRTRI          PLASMA_FNAME(strtri       , STRTRI       )
#define PLASMA_SORGLQ          PLASMA_FNAME(sorglq       , SORGLQ       )
#define PLASMA_SORGQR          PLASMA_FNAME(sorgqr       , SORGQR       )
#define PLASMA_SORMLQ          PLASMA_FNAME(sormlq       , SORMLQ       )
#define PLASMA_SORMQR          PLASMA_FNAME(sormqr       , SORMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
#define PLASMA_SGEBRD_TILE          PLASMA_TILE_FNAME(sgebrd       , SGEBRD       )
#define PLASMA_SGELQF_TILE          PLASMA_TILE_FNAME(sgelqf       , SGELQF       )
#define PLASMA_SGELQS_TILE          PLASMA_TILE_FNAME(sgelqs       , SGELQS       )
#define PLASMA_SGELS_TILE           PLASMA_TILE_FNAME(sgels        , SGELS        )
#define PLASMA_SGEMM_TILE           PLASMA_TILE_FNAME(sgemm        , SGEMM        )
#define PLASMA_SGEQRF_TILE          PLASMA_TILE_FNAME(sgeqrf       , SGEQRF       )
#define PLASMA_SGEQRS_TILE          PLASMA_TILE_FNAME(sgeqrs       , SGEQRS       )
#define PLASMA_SGESV_TILE           PLASMA_TILE_FNAME(sgesv        , SGESV        )
#define PLASMA_SGESV_INCPIV_TILE    PLASMA_TILE_FNAME(sgesv_incpiv , SGESV_INCPIV )
#define PLASMA_SGESVD_TILE          PLASMA_TILE_FNAME(sgesvd       , SGESVD       )
#define PLASMA_SGETRF_TILE          PLASMA_TILE_FNAME(sgetrf       , SGETRF       )
#define PLASMA_SGETRF_INCPIV_TILE   PLASMA_TILE_FNAME(sgetrf_incpiv, SGETRF_INCPIV)
#define PLASMA_SGETRI_TILE          PLASMA_TILE_FNAME(sgetri       , SGETRI       )
#define PLASMA_SGETRS_TILE          PLASMA_TILE_FNAME(sgetrs       , SGETRS       )
#define PLASMA_SGETRS_INCPIV_TILE   PLASMA_TILE_FNAME(sgetrs_incpiv, SGETRS_INCPIV)
#define PLASMA_SSYEV_TILE           PLASMA_TILE_FNAME(ssyev        , SSYEV        )
#define PLASMA_SSYEVD_TILE          PLASMA_TILE_FNAME(ssyevd       , SSYEVD       )
#define PLASMA_SSYGST_TILE          PLASMA_TILE_FNAME(ssygst       , SSYGST       )
#define PLASMA_SSYGV_TILE           PLASMA_TILE_FNAME(ssygv        , SSYGV        )
#define PLASMA_SSYGVD_TILE          PLASMA_TILE_FNAME(ssygvd       , SSYGVD       )
#ifdef COMPLEX
#define PLASMA_SSYMM_TILE           PLASMA_TILE_FNAME(ssymm        , SSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_SSYR2K_TILE          PLASMA_TILE_FNAME(ssyr2k       , SSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_SSYRK_TILE           PLASMA_TILE_FNAME(ssyrk        , SSYRK        )
#endif
#define PLASMA_SSYTRD_TILE          PLASMA_TILE_FNAME(ssytrd       , SSYTRD       )
#define PLASMA_SLACPY_TILE          PLASMA_TILE_FNAME(slacpy       , SLACPY       )
#define PLASMA_SLANGE_TILE          PLASMA_TILE_FNAME(slange       , SLANGE       )
#ifdef COMPLEX
#define PLASMA_SLANSY_TILE          PLASMA_TILE_FNAME(slansy       , SLANSY       )
#endif
#define PLASMA_SLANSY_TILE          PLASMA_TILE_FNAME(slansy       , SLANSY       )
#define PLASMA_SLASET_TILE          PLASMA_TILE_FNAME(slaset       , SLASET       )
#define PLASMA_SLASWP_TILE          PLASMA_TILE_FNAME(slaswp       , SLASWP       )
#define PLASMA_SLASWPC_TILE         PLASMA_TILE_FNAME(slaswpc      , SLASWPC      )
#define PLASMA_SLAUUM_TILE          PLASMA_TILE_FNAME(slauum       , SLAUUM       )
#ifdef COMPLEX
#define PLASMA_SPLGHE_TILE          PLASMA_TILE_FNAME(splgsy       , ZPLGHE       )
#endif
#define PLASMA_SPLGSY_TILE          PLASMA_TILE_FNAME(splgsy       , ZPLGSY       )
#define PLASMA_SPLRNT_TILE          PLASMA_TILE_FNAME(splrnt       , ZPLRNT       )
#define PLASMA_SPOSV_TILE           PLASMA_TILE_FNAME(sposv        , SPOSV        )
#define PLASMA_SPOTRF_TILE          PLASMA_TILE_FNAME(spotrf       , SPOTRF       )
#define PLASMA_SPOTRI_TILE          PLASMA_TILE_FNAME(spotri       , SPOTRI       )
#define PLASMA_SPOTRS_TILE          PLASMA_TILE_FNAME(spotrs       , SPOTRS       )
#define PLASMA_SSYMM_TILE           PLASMA_TILE_FNAME(ssymm        , SSYMM        )
#define PLASMA_SSYR2K_TILE          PLASMA_TILE_FNAME(ssyr2k       , SSYR2K       )
#define PLASMA_SSYRK_TILE           PLASMA_TILE_FNAME(ssyrk        , SSYRK        )
#define PLASMA_STRMM_TILE           PLASMA_TILE_FNAME(strmm        , STRMM        )
#define PLASMA_STRSM_TILE           PLASMA_TILE_FNAME(strsm        , STRSM        )
#define PLASMA_STRSMPL_TILE         PLASMA_TILE_FNAME(strsmpl      , STRSMPL      )
#define PLASMA_STRSMRV_TILE         PLASMA_TILE_FNAME(strsmrv      , STRSMRV      )
#define PLASMA_STRTRI_TILE          PLASMA_TILE_FNAME(strtri       , STRTRI       )
#define PLASMA_SORGLQ_TILE          PLASMA_TILE_FNAME(sorglq       , SORGLQ       )
#define PLASMA_SORGQR_TILE          PLASMA_TILE_FNAME(sorgqr       , SORGQR       )
#define PLASMA_SORMLQ_TILE          PLASMA_TILE_FNAME(sormlq       , SORMLQ       )
#define PLASMA_SORMQR_TILE          PLASMA_TILE_FNAME(sormqr       , SORMQR       )

/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
#define PLASMA_SGEBRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgebrd       , SGEBRD       )
#define PLASMA_SGELQF_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgelqf       , SGELQF       )
#define PLASMA_SGELQS_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgelqs       , SGELQS       )
#define PLASMA_SGELS_TILE_ASYNC           PLASMA_ASYNC_FNAME(sgels        , SGELS        )
#define PLASMA_SGEMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(sgemm        , SGEMM        )
#define PLASMA_SGEQRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgeqrf       , SGEQRF       )
#define PLASMA_SGEQRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgeqrs       , SGEQRS       )
#define PLASMA_SGESV_TILE_ASYNC           PLASMA_ASYNC_FNAME(sgesv        , SGESV        )
#define PLASMA_SGESV_INCPIV_TILE_ASYNC    PLASMA_ASYNC_FNAME(sgesv_incpiv , SGESV_INCPIV )
#define PLASMA_SGESVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgesvd       , SGESVD       )
#define PLASMA_SGETRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgetrf       , SGETRF       )
#define PLASMA_SGETRF_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(sgetrf_incpiv, SGETRF_INCPIV)
#define PLASMA_SGETRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgetri       , SGETRI       )
#define PLASMA_SGETRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(sgetrs       , SGETRS       )
#define PLASMA_SGETRS_INCPIV_TILE_ASYNC   PLASMA_ASYNC_FNAME(sgetrs_incpiv, SGETRS_INCPIV)
#define PLASMA_SSYEV_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssyev        , SSYEV        )
#define PLASMA_SSYEVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssyevd       , SSYEVD       )
#define PLASMA_SSYGST_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssygst       , SSYGST       )
#define PLASMA_SSYGV_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssygv        , SSYGV        )
#define PLASMA_SSYGVD_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssygvd       , SSYGVD       )
#ifdef COMPLEX
#define PLASMA_SSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssymm        , SSYMM        )
#endif
#ifdef COMPLEX
#define PLASMA_SSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssyr2k       , SSYR2K       )
#endif
#ifdef COMPLEX
#define PLASMA_SSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssyrk        , SSYRK        )
#endif
#define PLASMA_SSYTRD_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssytrd       , SSYTRD       )
#define PLASMA_SLACPY_TILE_ASYNC          PLASMA_ASYNC_FNAME(slacpy       , SLACPY       )
#define PLASMA_SLANGE_TILE_ASYNC          PLASMA_ASYNC_FNAME(slange       , SLANGE       )
#ifdef COMPLEX
#define PLASMA_SLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(slansy       , SLANSY       )
#endif
#define PLASMA_SLANSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(slansy       , SLANSY       )
#define PLASMA_SLASET_TILE_ASYNC          PLASMA_ASYNC_FNAME(slaset       , SLASET       )
#define PLASMA_SLASWP_TILE_ASYNC          PLASMA_ASYNC_FNAME(slaswp       , SLASWP       )
#define PLASMA_SLASWPC_TILE_ASYNC         PLASMA_ASYNC_FNAME(slaswpc      , SLASWPC      )
#define PLASMA_SLAUUM_TILE_ASYNC          PLASMA_ASYNC_FNAME(slauum       , SLAUUM       )
#ifdef COMPLEX
#define PLASMA_SPLGHE_TILE_ASYNC          PLASMA_ASYNC_FNAME(splgsy       , ZPLGHE       )
#endif
#define PLASMA_SPLGSY_TILE_ASYNC          PLASMA_ASYNC_FNAME(splgsy       , ZPLGSY       )
#define PLASMA_SPLRNT_TILE_ASYNC          PLASMA_ASYNC_FNAME(splrnt       , ZPLRNT       )
#define PLASMA_SPOSV_TILE_ASYNC           PLASMA_ASYNC_FNAME(sposv        , SPOSV        )
#define PLASMA_SPOTRF_TILE_ASYNC          PLASMA_ASYNC_FNAME(spotrf       , SPOTRF       )
#define PLASMA_SPOTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(spotri       , SPOTRI       )
#define PLASMA_SPOTRS_TILE_ASYNC          PLASMA_ASYNC_FNAME(spotrs       , SPOTRS       )
#define PLASMA_SSYMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssymm        , SSYMM        )
#define PLASMA_SSYR2K_TILE_ASYNC          PLASMA_ASYNC_FNAME(ssyr2k       , SSYR2K       )
#define PLASMA_SSYRK_TILE_ASYNC           PLASMA_ASYNC_FNAME(ssyrk        , SSYRK        )
#define PLASMA_STRMM_TILE_ASYNC           PLASMA_ASYNC_FNAME(strmm        , STRMM        )
#define PLASMA_STRSM_TILE_ASYNC           PLASMA_ASYNC_FNAME(strsm        , STRSM        )
#define PLASMA_STRSMPL_TILE_ASYNC         PLASMA_ASYNC_FNAME(strsmpl      , STRSMPL      )
#define PLASMA_STRSMRV_TILE_ASYNC         PLASMA_ASYNC_FNAME(strsmrv      , STRSMRV      )
#define PLASMA_STRTRI_TILE_ASYNC          PLASMA_ASYNC_FNAME(strtri       , STRTRI       )
#define PLASMA_SORGLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(sorglq       , SORGLQ       )
#define PLASMA_SORGQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(sorgqr       , SORGQR       )
#define PLASMA_SORMLQ_TILE_ASYNC          PLASMA_ASYNC_FNAME(sormlq       , SORMLQ       )
#define PLASMA_SORMQR_TILE_ASYNC          PLASMA_ASYNC_FNAME(sormqr       , SORMQR       )

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
#define PLASMA_ALLOC_WORKSPACE_SGEBRD              PLASMA_WS_FNAME(sgebrd            , SGEBRD            )
#define PLASMA_ALLOC_WORKSPACE_SGEEV               PLASMA_WS_FNAME(sgeev             , SGEEV             )
#define PLASMA_ALLOC_WORKSPACE_SGEHRD              PLASMA_WS_FNAME(sgehrd            , SGEHRD            )
#define PLASMA_ALLOC_WORKSPACE_SGELQF              PLASMA_WS_FNAME(sgelqf            , SGELQF            )
#define PLASMA_ALLOC_WORKSPACE_SGELQF_TILE         PLASMA_WS_FNAME(sgelqf_tile       , SGELQF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_SGELS               PLASMA_WS_FNAME(sgels             , SGELS             )
#define PLASMA_ALLOC_WORKSPACE_SGELS_TILE          PLASMA_WS_FNAME(sgels_tile        , SGELS_TILE        )
#define PLASMA_ALLOC_WORKSPACE_SGEQRF              PLASMA_WS_FNAME(sgeqrf            , SGEQRF            )
#define PLASMA_ALLOC_WORKSPACE_SGEQRF_TILE         PLASMA_WS_FNAME(sgeqrf_tile       , SGEQRF_TILE       )
#define PLASMA_ALLOC_WORKSPACE_SGESV_INCPIV        PLASMA_WS_FNAME(sgesv_incpiv      , SGESV_INCPIV      )
#define PLASMA_ALLOC_WORKSPACE_SGESV_INCPIV_TILE   PLASMA_WS_FNAME(sgesv_incpiv_tile , SGESV_INCPIV_TILE )
#define PLASMA_ALLOC_WORKSPACE_SGESVD              PLASMA_WS_FNAME(sgesvd            , SGESVD            )
#define PLASMA_ALLOC_WORKSPACE_SGETRF_INCPIV       PLASMA_WS_FNAME(sgetrf_incpiv     , SGETRF_INCPIV     )
#define PLASMA_ALLOC_WORKSPACE_SGETRF_INCPIV_TILE  PLASMA_WS_FNAME(sgetrf_incpiv_tile, SGETRF_INCPIV_TILE)
#define PLASMA_ALLOC_WORKSPACE_SGETRI_TILE_ASYNC   PLASMA_WS_FNAME(sgetri_tile_async , SGETRI_TILE_ASYNC )
#define PLASMA_ALLOC_WORKSPACE_SSYEV               PLASMA_WS_FNAME(ssyev             , SSYEV             )
#define PLASMA_ALLOC_WORKSPACE_SSYEVD              PLASMA_WS_FNAME(ssyevd            , SSYEVD            )
#define PLASMA_ALLOC_WORKSPACE_SSYGV               PLASMA_WS_FNAME(ssygv             , SSYGV             )
#define PLASMA_ALLOC_WORKSPACE_SSYGVD              PLASMA_WS_FNAME(ssygvd            , SSYGVD            )
#define PLASMA_ALLOC_WORKSPACE_SSYTRD              PLASMA_WS_FNAME(ssytrd            , SSYTRD            )



/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_SLAPACK_TO_TILE(float *Af77, int *LDA, PLASMA_desc *A, int *info)
{ *info = PLASMA_sLapack_to_Tile(Af77, *LDA, A); }

void PLASMA_SLAPACK_TO_TILE_ASYNC(float *Af77, int *LDA, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sLapack_to_Tile_Async(Af77, *LDA, A, sequence, request); }

void PLASMA_STILE_TO_LAPACK(PLASMA_desc *A, float *Af77, int *LDA, int *info)
{ *info = PLASMA_sTile_to_Lapack(A, Af77, *LDA); }

void PLASMA_STILE_TO_LAPACK_ASYNC(PLASMA_desc *A, float *Af77, int *LDA, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sTile_to_Lapack_Async(A, Af77, *LDA, sequence, request); }

void PLASMA_SGEBRD(int *M, int *N, float *A, int *LDA, float *D, float *E, PLASMA_desc **descT, int *info)
{ *info = PLASMA_sgebrd(*M, *N, A, *LDA, D, E, *descT); }

void PLASMA_SGECFI(int *m, int *n, float *A, PLASMA_enum *fin, int *imb, int *inb, PLASMA_enum *fout, int *omb, int *onb, int *info)
{ *info = PLASMA_sgecfi(*m, *n, A, *fin, *imb, *inb, *fout, *omb, *onb); }

void PLASMA_SGECFI_ASYNC(int *m, int *n, float *A, PLASMA_enum *f_in, int *imb, int *inb, PLASMA_enum *f_out, int *omb, int *onb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgecfi_Async(*m, *n, A, *f_in, *imb, *inb, *f_out, *omb, *onb, sequence, request); }

void PLASMA_SGELQF(int *M, int *N, float *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_sgelqf(*M, *N, A, *LDA, *descT); }

void PLASMA_SGELQS(int *M, int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sgelqs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_SGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sgels(*trans, *M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_SGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_sgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SGEQRF(int *M, int *N, float *A, int *LDA, PLASMA_desc **descT, int *info)
{ *info = PLASMA_sgeqrf(*M, *N, A, *LDA, *descT); }

void PLASMA_SGEQRS(int *M, int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sgeqrs(*M, *N, *NRHS, A, *LDA, *descT, B, *LDB); }

void PLASMA_SGESV(int *N, int *NRHS, float *A, int *LDA, int *IPIV, float *B, int *LDB, int *info)
{ *info = PLASMA_sgesv(*N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_SGESV_INCPIV(int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descL, int *IPIV, float *B, int *LDB, int *info)
{ *info = PLASMA_sgesv_incpiv(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_SGESVD(PLASMA_enum *jobu, PLASMA_enum *jobvt, int *M, int *N, float *A, int *LDA, float *S, float *U, int *LDU, float *VT, int *LDVT, PLASMA_desc **descT, int *info)
{ *info = PLASMA_sgesvd(*jobu, *jobvt, *M, *N, A, *LDA, S, U, *LDU, VT, *LDVT, *descT); }

void PLASMA_SGETMI(int *m, int *n, float *A, PLASMA_enum *fin, int *mb, int *nb, int *info)
{ *info = PLASMA_sgetmi(*m, *n, A, *fin, *mb, *nb); }

void PLASMA_SGETMI_ASYNC(int *m, int *n, float *A, PLASMA_enum *f_in, int *mb, int *inb, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetmi_Async(*m, *n, A, *f_in, *mb, *inb, sequence, request); }

void PLASMA_SGETRF(int *M, int *N, float *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_sgetrf(*M, *N, A, *LDA, IPIV); }

void PLASMA_SGETRF_INCPIV(int *M, int *N, float *A, int *LDA, PLASMA_desc **descL, int *IPIV, int *info)
{ *info = PLASMA_sgetrf_incpiv(*M, *N, A, *LDA, *descL, IPIV); }

void PLASMA_SGETRI(int *N, float *A, int *LDA, int *IPIV, int *info)
{ *info = PLASMA_sgetri(*N, A, *LDA, IPIV); }

void PLASMA_SGETRS(PLASMA_enum *trans, int *N, int *NRHS, float *A, int *LDA, int *IPIV, float *B, int *LDB, int *info)
{ *info = PLASMA_sgetrs(*trans, *N, *NRHS, A, *LDA, IPIV, B, *LDB); }

void PLASMA_SGETRS_INCPIV(PLASMA_enum *trans, int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descL, int *IPIV, float *B, int *LDB, int *info)
{ *info = PLASMA_sgetrs_incpiv(*trans, *N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_SSYEV(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *W, PLASMA_desc **descT, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssyev(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_SSYEVD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *W, PLASMA_desc **descT, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssyevd(*jobz, *uplo, *N, A, *LDA, W, *descT, Q, *LDQ); }

void PLASMA_SSYGST(PLASMA_enum *itype, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_ssygst(*itype, *uplo, *N, A, *LDA, B, *LDB); }

void PLASMA_SSYGV(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *B, int *LDB, float *W, PLASMA_desc **descT, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssygv(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

void PLASMA_SSYGVD(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *B, int *LDB, float *W, PLASMA_desc **descT, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssygvd(*itype, *jobz, *uplo, *N, A, *LDA, B, *LDB, W, *descT, Q, *LDQ); }

#ifdef COMPLEX
void PLASMA_SSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_SSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }
#endif

#ifdef COMPLEX
void PLASMA_SSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

void PLASMA_SSYTRD(PLASMA_enum *jobz, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *D, float *E, PLASMA_desc **descT, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssytrd(*jobz, *uplo, *N, A, *LDA, D, E, *descT, Q, *LDQ); }

void PLASMA_SLACPY(PLASMA_enum *uplo, int *M, int *N, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_slacpy(*uplo, *M, *N, A, *LDA, B, *LDB); }

void PLASMA_SLANGE(PLASMA_enum *norm, int *M, int *N, float *A, int *LDA, float *work, float *result)
{ *result = PLASMA_slange(*norm, *M, *N, A, *LDA, work); }

#ifdef COMPLEX
void PLASMA_SLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *work, float *result)
{ *result = PLASMA_slansy(*norm, *uplo, *N, A, *LDA, work); }
#endif

void PLASMA_SLANSY(PLASMA_enum *norm, PLASMA_enum *uplo, int *N, float *A, int *LDA, float *work, float *result)
{ *result = PLASMA_slansy(*norm, *uplo, *N, A, *LDA, work); }

void PLASMA_SLASET(PLASMA_enum *uplo, int *M, int *N, float *alpha, float *beta, float *A, int *LDA, int *info)
{ *info = PLASMA_slaset(*uplo, *M, *N, *alpha, *beta, A, *LDA); }

void PLASMA_SLASWP(int *N, float *A, int *LDA, int *K1, int *K2, int *IPIV, int *INCX, int *info)
{ *info = PLASMA_slaswp(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_SLASWPC(int *N, float *A, int *LDA, int *K1, int *K2, int *IPIV, int *INCX, int *info)
{ *info = PLASMA_slaswpc(*N, A, *LDA, *K1, *K2, IPIV, *INCX); }

void PLASMA_SLAUUM(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *info)
{ *info = PLASMA_slauum(*uplo, *N, A, *LDA); }

#ifdef COMPLEX
void PLASMA_SPLGHE(float *bump, int *N, float *A, int *LDA, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splgsy(*bump, *N, A, *LDA, *seed); }
#endif

void PLASMA_SPLGSY(float *bump, int *N, float *A, int *LDA, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splgsy(*bump, *N, A, *LDA, *seed); }

void PLASMA_SPLRNT(int *M, int *N, float *A, int *LDA, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splrnt(*M, *N, A, *LDA, *seed); }

void PLASMA_SPOSV(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_sposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_SPOTRF(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *info)
{ *info = PLASMA_spotrf(*uplo, *N, A, *LDA); }

void PLASMA_SPOTRI(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *info)
{ *info = PLASMA_spotri(*uplo, *N, A, *LDA); }

void PLASMA_SPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_spotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_SSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SSYR2K(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssyr2k(*uplo, *trans, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *beta, float *C, int *LDC, int *info)
{ *info = PLASMA_ssyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

void PLASMA_STRMM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, float *alpha, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_strmm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_STRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, float *alpha, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_strsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_STRSMPL(int *N, int *NRHS, float *A, int *LDA, PLASMA_desc **descL, int *IPIV, float *B, int *LDB, int *info)
{ *info = PLASMA_strsmpl(*N, *NRHS, A, *LDA, *descL, IPIV, B, *LDB); }

void PLASMA_STRSMRV(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, float *alpha, float *A, int *LDA, float *B, int *LDB, int *info)
{ *info = PLASMA_strsmrv(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_STRTRI(PLASMA_enum *uplo, PLASMA_enum *diag, int *N, float *A, int *LDA, int *info)
{ *info = PLASMA_strtri(*uplo, *diag, *N, A, *LDA); }

void PLASMA_SORGLQ(int *M, int *N, int *K, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sorglq(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_SORGQR(int *M, int *N, int *K, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sorgqr(*M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_SORMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sormlq(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }

void PLASMA_SORMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, PLASMA_desc **descT, float *B, int *LDB, int *info)
{ *info = PLASMA_sormqr(*side, *trans, *M, *N, *K, A, *LDA, *descT, B, *LDB); }


/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_SGEBRD_TILE(PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, int *info)
{ *info = PLASMA_sgebrd_Tile(A, D, E, T); }

void PLASMA_SGELQF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_sgelqf_Tile(A, T); }

void PLASMA_SGELQS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgelqs_Tile(A, T, B); }

void PLASMA_SGELS_TILE(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgels_Tile(*trans, A, T, B); }

void PLASMA_SGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_sgemm_Tile(*transA, *transB, *alpha, A, B, *beta, C); }

void PLASMA_SGEQRF_TILE(PLASMA_desc *A, PLASMA_desc *T, int *info)
{ *info = PLASMA_sgeqrf_Tile(A, T); }

void PLASMA_SGEQRS_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgeqrs_Tile(A, T, B); }

void PLASMA_SGESV_TILE(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgesv_Tile(A, IPIV, B); }

void PLASMA_SGESV_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgesv_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_SGESVD_TILE(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *U, PLASMA_desc *VT, PLASMA_desc *T, int *info)
{ *info = PLASMA_sgesvd_Tile(*jobu, *jobvt, A, S, U, VT, T); }

void PLASMA_SGETRF_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_sgetrf_Tile(A, IPIV); }

void PLASMA_SGETRF_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, int *info)
{ *info = PLASMA_sgetrf_incpiv_Tile(A, L, IPIV); }

void PLASMA_SGETRI_TILE(PLASMA_desc *A, int *IPIV, int *info)
{ *info = PLASMA_sgetri_Tile(A, IPIV); }

void PLASMA_SGETRS_TILE(PLASMA_enum *trans, PLASMA_desc *A, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgetrs_Tile(*trans, A, IPIV, B); }

void PLASMA_SGETRS_INCPIV_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_sgetrs_incpiv_Tile(A, L, IPIV, B); }

void PLASMA_SSYEV_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssyev_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_SSYEVD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssyevd_Tile(*jobz, *uplo, A, W, T, Q, *LDQ); }

void PLASMA_SSYGST_TILE(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_ssygst_Tile(*itype, *uplo, A, B); }

void PLASMA_SSYGV_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_ssygv_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

void PLASMA_SSYGVD_TILE(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, int *info)
{ *info = PLASMA_ssygvd_Tile(*itype, *jobz, *uplo, A, B, W, T, Q); }

#ifdef COMPLEX
void PLASMA_SSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssymm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_SSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssyr2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }
#endif

#ifdef COMPLEX
void PLASMA_SSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssyrk_Tile(*uplo, *trans, *alpha, A, *beta, C); }
#endif

void PLASMA_SSYTRD_TILE(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, float *Q, int *LDQ, int *info)
{ *info = PLASMA_ssytrd_Tile(*jobz, *uplo, A, D, E, T, Q, *LDQ); }

void PLASMA_SLACPY_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_slacpy_Tile(*uplo, A, B); }

void PLASMA_SLANGE_TILE(PLASMA_enum *norm, PLASMA_desc *A, float *work, float *result)
{ *result = PLASMA_slange_Tile(*norm, A, work); }

#ifdef COMPLEX
void PLASMA_SLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *work, float *result)
{ *result = PLASMA_slansy_Tile(*norm, *uplo, A, work); }
#endif

void PLASMA_SLANSY_TILE(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *work, float *result)
{ *result = PLASMA_slansy_Tile(*norm, *uplo, A, work); }

void PLASMA_SLASET_TILE(PLASMA_enum *uplo, float *alpha, float *beta, PLASMA_desc *A, int *info)
{ *info = PLASMA_slaset_Tile(*uplo, *alpha, *beta, A); }

void PLASMA_SLASWP_TILE(PLASMA_desc *A, int *K1, int *K2, int *IPIV, int *INCX, int *info)
{ *info = PLASMA_slaswp_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_SLASWPC_TILE(PLASMA_desc *A, int *K1, int *K2, int *IPIV, int *INCX, int *info)
{ *info = PLASMA_slaswpc_Tile(A, *K1, *K2, IPIV, *INCX); }

void PLASMA_SLAUUM_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_slauum_Tile(*uplo, A); }

#ifdef COMPLEX
void PLASMA_SPLGHE_TILE(float *bump, PLASMA_desc *A, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splgsy_Tile(*bump, A, *seed); }
#endif

void PLASMA_SPLGSY_TILE(float *bump, PLASMA_desc *A, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splgsy_Tile(*bump, A, *seed); }

void PLASMA_SPLRNT_TILE(PLASMA_desc *A, unsigned long long int  *seed, int *info)
{ *info = PLASMA_splrnt_Tile(A, *seed); }

void PLASMA_SPOSV_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_sposv_Tile(*uplo, A, B); }

void PLASMA_SPOTRF_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_spotrf_Tile(*uplo, A); }

void PLASMA_SPOTRI_TILE(PLASMA_enum *uplo, PLASMA_desc *A, int *info)
{ *info = PLASMA_spotri_Tile(*uplo, A); }

void PLASMA_SPOTRS_TILE(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_spotrs_Tile(*uplo, A, B); }

void PLASMA_SSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssymm_Tile(*side, *uplo, *alpha, A, B, *beta, C); }

void PLASMA_SSYR2K_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssyr2k_Tile(*uplo, *trans, *alpha, A, B, *beta, C); }

void PLASMA_SSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, int *info)
{ *info = PLASMA_ssyrk_Tile(*uplo, *trans, *alpha, A, *beta, C); }

void PLASMA_STRMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_strmm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_STRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_strsm_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_STRSMPL_TILE(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, int *info)
{ *info = PLASMA_strsmpl_Tile(A, L, IPIV, B); }

void PLASMA_STRSMRV_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, int *info)
{ *info = PLASMA_strsmrv_Tile(*side, *uplo, *transA, *diag, *alpha, A, B); }

void PLASMA_STRTRI_TILE(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, int *info)
{ *info = PLASMA_strtri_Tile(*uplo, *diag, A); }

void PLASMA_SORGLQ_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sorglq_Tile(A, T, B); }

void PLASMA_SORGQR_TILE(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sorgqr_Tile(A, T, B); }

void PLASMA_SORMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sormlq_Tile(*side, *trans, A, T, B); }

void PLASMA_SORMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, int *info)
{ *info = PLASMA_sormqr_Tile(*side, *trans, A, T, B); }


/***************************************************************************//**
 *  FORTRAN API - math functions (asynchronous interface)
 **/
void PLASMA_SGEBRD_TILE_ASYNC(PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgebrd_Tile_Async(A, D, E, T, sequence, request); }

void PLASMA_SGELQF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgelqf_Tile_Async(A, T, sequence, request); }

void PLASMA_SGELQS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgelqs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_SGELS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgels_Tile_Async(*trans, A, T, B, sequence, request); }

void PLASMA_SGEMM_TILE_ASYNC(PLASMA_enum *transA, PLASMA_enum *transB, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgemm_Tile_Async(*transA, *transB, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_SGEQRF_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgeqrf_Tile_Async(A, T, sequence, request); }

void PLASMA_SGEQRS_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgeqrs_Tile_Async(A, T, B, sequence, request); }

void PLASMA_SGESV_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgesv_Tile_Async(A, IPIV, B, sequence, request); }

void PLASMA_SGESV_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgesv_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_SGESVD_TILE_ASYNC(PLASMA_enum *jobu, PLASMA_enum *jobvt, PLASMA_desc *A, float *S, PLASMA_desc *U, PLASMA_desc *VT, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgesvd_Tile_Async(*jobu, *jobvt, A, S, U, VT, T, sequence, request); }

void PLASMA_SGETRF_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetrf_Tile_Async(A, IPIV, sequence, request); }

void PLASMA_SGETRF_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetrf_incpiv_Tile_Async(A, L, IPIV, sequence, request); }

void PLASMA_SGETRI_TILE_ASYNC(PLASMA_desc *A, int *IPIV, PLASMA_desc *W, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetri_Tile_Async(A, IPIV, W, sequence, request); }

void PLASMA_SGETRS_TILE_ASYNC(PLASMA_enum *trans, PLASMA_desc *A, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetrs_Tile_Async(*trans, A, IPIV, B, sequence, request); }

void PLASMA_SGETRS_INCPIV_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sgetrs_incpiv_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_SSYEV_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, float *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyev_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_SSYEVD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *W, PLASMA_desc *T, float *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyevd_Tile_Async(*jobz, *uplo, A, W, T, Q, *LDQ, sequence, request); }

void PLASMA_SSYGST_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssygst_Tile_Async(*itype, *uplo, A, B, sequence, request); }

void PLASMA_SSYGV_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssygv_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

void PLASMA_SSYGVD_TILE_ASYNC(PLASMA_enum *itype, PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, float *W, PLASMA_desc *T, PLASMA_desc *Q, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssygvd_Tile_Async(*itype, *jobz, *uplo, A, B, W, T, Q, sequence, request); }

#ifdef COMPLEX
void PLASMA_SSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssymm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_SSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyr2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }
#endif

#ifdef COMPLEX
void PLASMA_SSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyrk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }
#endif

void PLASMA_SSYTRD_TILE_ASYNC(PLASMA_enum *jobz, PLASMA_enum *uplo, PLASMA_desc *A, float *D, float *E, PLASMA_desc *T, float *Q, int *LDQ, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssytrd_Tile_Async(*jobz, *uplo, A, D, E, T, Q, *LDQ, sequence, request); }

void PLASMA_SLACPY_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slacpy_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_SLANGE_TILE_ASYNC(PLASMA_enum *norm, PLASMA_desc *A, float *work, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slange_Tile_Async(*norm, A, work, value, sequence, request); }

#ifdef COMPLEX
void PLASMA_SLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *work, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slansy_Tile_Async(*norm, *uplo, A, work, value, sequence, request); }
#endif

void PLASMA_SLANSY_TILE_ASYNC(PLASMA_enum *norm, PLASMA_enum *uplo, PLASMA_desc *A, float *work, float *value, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slansy_Tile_Async(*norm, *uplo, A, work, value, sequence, request); }

void PLASMA_SLASET_TILE_ASYNC(PLASMA_enum *uplo, float *alpha, float *beta, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slaset_Tile_Async(*uplo, *alpha, *beta, A, sequence, request); }

void PLASMA_SLASWP_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slaswp_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_SLASWPC_TILE_ASYNC(PLASMA_desc *A, int *K1, int *K2, int *IPIV, int *INCX, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slaswpc_Tile_Async(A, *K1, *K2, IPIV, *INCX, sequence, request); }

void PLASMA_SLAUUM_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_slauum_Tile_Async(*uplo, A, sequence, request); }

#ifdef COMPLEX
void PLASMA_SPLGHE_TILE_ASYNC(float *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request * *request, int *info)
{ *info = PLASMA_splgsy_Tile_Async(*bump, A, *seed, sequence, *request); }
#endif

void PLASMA_SPLGSY_TILE_ASYNC(float *bump, PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request * *request, int *info)
{ *info = PLASMA_splgsy_Tile_Async(*bump, A, *seed, sequence, *request); }

void PLASMA_SPLRNT_TILE_ASYNC(PLASMA_desc *A, unsigned long long int *seed, PLASMA_sequence *sequence, PLASMA_request * *request, int *info)
{ *info = PLASMA_splrnt_Tile_Async(A, *seed, sequence, *request); }

void PLASMA_SPOSV_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sposv_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_SPOTRF_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_spotrf_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_SPOTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_spotri_Tile_Async(*uplo, A, sequence, request); }

void PLASMA_SPOTRS_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_spotrs_Tile_Async(*uplo, A, B, sequence, request); }

void PLASMA_SSYMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssymm_Tile_Async(*side, *uplo, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_SSYR2K_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, PLASMA_desc *B, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyr2k_Tile_Async(*uplo, *trans, *alpha, A, B, *beta, C, sequence, request); }

void PLASMA_SSYRK_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, PLASMA_desc *A, float *beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_ssyrk_Tile_Async(*uplo, *trans, *alpha, A, *beta, C, sequence, request); }

void PLASMA_STRMM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_strmm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_STRSM_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_strsm_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_STRSMPL_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_strsmpl_Tile_Async(A, L, IPIV, B, sequence, request); }

void PLASMA_STRSMRV_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_strsmrv_Tile_Async(*side, *uplo, *transA, *diag, *alpha, A, B, sequence, request); }

void PLASMA_STRTRI_TILE_ASYNC(PLASMA_enum *uplo, PLASMA_enum *diag, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_strtri_Tile_Async(*uplo, *diag, A, sequence, request); }

void PLASMA_SORGLQ_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sorglq_Tile_Async(A, T, B, sequence, request); }

void PLASMA_SORGQR_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sorgqr_Tile_Async(A, T, B, sequence, request); }

void PLASMA_SORMLQ_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sormlq_Tile_Async(*side, *trans, A, T, B, sequence, request); }

void PLASMA_SORMQR_TILE_ASYNC(PLASMA_enum *side, PLASMA_enum *trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request, int *info)
{ *info = PLASMA_sormqr_Tile_Async(*side, *trans, A, T, B, sequence, request); }


/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_SGEBRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgebrd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGEEV(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgeev(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGEHRD(int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgehrd(*N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGELQF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_sgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGELQF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgelqf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGELS(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_sgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGELS_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgels_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGEQRF(int *M, int *N, PLASMA_desc **T, int *info)
{ *info = PLASMA_Alloc_Workspace_sgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGEQRF_TILE(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgeqrf_Tile(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGESV_INCPIV(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_sgesv_incpiv(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGESV_INCPIV_TILE (int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_sgesv_incpiv_Tile (*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGESVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_sgesvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SGETRF_INCPIV(int *M, int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_sgetrf_incpiv(*M, *N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGETRF_INCPIV_TILE(int *N, PLASMA_desc **descL, int **IPIV, int *info)
{ *info = PLASMA_Alloc_Workspace_sgetrf_incpiv_Tile(*N, descL, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGETRI_TILE_ASYNC(PLASMA_desc *A, PLASMA_desc *W, int *info)
{ *info = PLASMA_Alloc_Workspace_sgetri_Tile_Async(A, W); }

void PLASMA_ALLOC_WORKSPACE_SSYEV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_ssyev(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SSYEVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_ssyevd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SSYGV(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_ssygv(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SSYGVD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_ssygvd(*M, *N, descT); }

void PLASMA_ALLOC_WORKSPACE_SSYTRD(int *M, int *N, PLASMA_desc **descT, int *info)
{ *info = PLASMA_Alloc_Workspace_ssytrd(*M, *N, descT); }



