!
!     Copyright © 2011 The Numerical Algorithms Group Ltd. All rights reserved.
!   
!     Redistribution and use in source and binary forms, with or without
!     modification, are permitted provided that the following conditions are
!     met:
!     - Redistributions of source code must retain the above copyright notice,
!       this list of conditions, and the following disclaimer.
!     - Redistributions in binary form must reproduce the above copyright
!       notice, this list of conditions and the following disclaimer listed in
!       this license in the documentation and/or other materials provided with
!       the distribution.
!     - Neither the name of the copyright holders nor the names of its
!       contributors may be used to endorse or promote products derived from
!       this software without specific prior written permission.
!     
!     This software is provided by the copyright holders and contributors "as
!     is" and any express or implied warranties, including, but not limited
!     to, the implied warranties of merchantability and fitness for a
!     particular purpose are disclaimed. in no event shall the copyright owner
!     or contributors be liable for any direct, indirect, incidental, special,
!     exemplary, or consequential damages (including, but not limited to,
!     procurement of substitute goods or services; loss of use, data, or
!     profits; or business interruption) however caused and on any theory of
!     liability, whether in contract, strict liability, or tort (including
!     negligence or otherwise) arising in any way out of the use of this
!     software, even if advised of the possibility of such damage.
!
!
! @file plasma_cf90.F90
!
!  PLASMA Fortran 90 interfaces using Fortran 2003 ISO C bindings
!  PLASMA is a software package provided by Univ. of Tennessee,
!  Univ. of California Berkeley and Univ. of Colorado Denver
!
! @version 2.4.6
! @author Numerical Algorithms Group
! @author Mathieu Faverge
! @date 2011-12-15
! @generated c Thu Nov  8 11:44:41 2012
!
#define PRECISION_c

module plasma_c
    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (simple interface)
    !
      interface
         function PLASMA_cLapack_to_Tile_c(Af77,LDA,A) &
          & bind(c, name='PLASMA_cLapack_to_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cLapack_to_Tile_c
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: A
          end function PLASMA_cLapack_to_Tile_c
      end interface

      interface
         function PLASMA_cLapack_to_Tile_Async_c(Af77,LDA,A,sequence,request) &
          & bind(c, name='PLASMA_cLapack_to_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cLapack_to_Tile_Async_c
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cLapack_to_Tile_Async_c
      end interface

      interface
         function PLASMA_cTile_to_Lapack_c(A,Af77,LDA) &
          & bind(c, name='PLASMA_cTile_to_Lapack')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cTile_to_Lapack_c
            type(c_ptr), value :: A
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
          end function PLASMA_cTile_to_Lapack_c
      end interface

      interface
         function PLASMA_cTile_to_Lapack_Async_c(A,Af77,LDA,sequence,request) &
          & bind(c, name='PLASMA_cTile_to_Lapack_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cTile_to_Lapack_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: Af77
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cTile_to_Lapack_Async_c
      end interface

      interface
         function PLASMA_cgebrd_c(M,N,A,LDA,D,E,descT) &
          & bind(c, name='PLASMA_cgebrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgebrd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: descT
          end function PLASMA_cgebrd_c
      end interface

      interface
         function PLASMA_cgecfi_c(m,n,A,fin,imb,inb,fout,omb,onb) &
          & bind(c, name='PLASMA_cgecfi')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgecfi_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: fin
            integer(kind=c_int), value :: imb
            integer(kind=c_int), value :: inb
            integer(kind=c_int), value :: fout
            integer(kind=c_int), value :: omb
            integer(kind=c_int), value :: onb
          end function PLASMA_cgecfi_c
      end interface

      interface
         function PLASMA_cgecfi_Async_c(m,n,A,f_in,imb,inb,f_out,omb,onb,sequence,request) &
          & bind(c, name='PLASMA_cgecfi_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgecfi_Async_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: f_in
            integer(kind=c_int), value :: imb
            integer(kind=c_int), value :: inb
            integer(kind=c_int), value :: f_out
            integer(kind=c_int), value :: omb
            integer(kind=c_int), value :: onb
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgecfi_Async_c
      end interface

      interface
         function PLASMA_cgelqf_c(M,N,A,LDA,descT) &
          & bind(c, name='PLASMA_cgelqf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
          end function PLASMA_cgelqf_c
      end interface

      interface
         function PLASMA_cgelqs_c(M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cgelqs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqs_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgelqs_c
      end interface

      interface
         function PLASMA_cgels_c(trans,M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cgels')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgels_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgels_c
      end interface

      interface
         function PLASMA_cgemm_c(transA,transB,M,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_cgemm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgemm_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_cgemm_c
      end interface

      interface
         function PLASMA_cgeqrf_c(M,N,A,LDA,descT) &
          & bind(c, name='PLASMA_cgeqrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
          end function PLASMA_cgeqrf_c
      end interface

      interface
         function PLASMA_cgeqrs_c(M,N,NRHS,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cgeqrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrs_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgeqrs_c
      end interface

      interface
         function PLASMA_cgesv_c(N,NRHS,A,LDA,IPIV,B,LDB) &
          & bind(c, name='PLASMA_cgesv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgesv_c
      end interface

      interface
         function PLASMA_cgesv_incpiv_c(N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_cgesv_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_incpiv_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgesv_incpiv_c
      end interface

      interface
         function PLASMA_cgesvd_c(jobu,jobvt,M,N,A,LDA,S,U,LDU,VT,LDVT,descT) &
          & bind(c, name='PLASMA_cgesvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesvd_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: S
            type(c_ptr), value :: U
            integer(kind=c_int), value :: LDU
            type(c_ptr), value :: VT
            integer(kind=c_int), value :: LDVT
            type(c_ptr), value :: descT
          end function PLASMA_cgesvd_c
      end interface

      interface
         function PLASMA_cgetmi_c(m,n,A,fin,mb,nb) &
          & bind(c, name='PLASMA_cgetmi')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetmi_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: fin
            integer(kind=c_int), value :: mb
            integer(kind=c_int), value :: nb
          end function PLASMA_cgetmi_c
      end interface

      interface
         function PLASMA_cgetmi_Async_c(m,n,A,f_in,mb,inb,sequence,request) &
          & bind(c, name='PLASMA_cgetmi_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetmi_Async_c
            integer(kind=c_int), value :: m
            integer(kind=c_int), value :: n
            type(c_ptr), value :: A
            integer(kind=c_int), value :: f_in
            integer(kind=c_int), value :: mb
            integer(kind=c_int), value :: inb
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetmi_Async_c
      end interface

      interface
         function PLASMA_cgetrf_c(M,N,A,LDA,IPIV) &
          & bind(c, name='PLASMA_cgetrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetrf_c
      end interface

      interface
         function PLASMA_cgetrf_incpiv_c(M,N,A,LDA,descL,IPIV) &
          & bind(c, name='PLASMA_cgetrf_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_incpiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetrf_incpiv_c
      end interface

      interface
         function PLASMA_cgetri_c(N,A,LDA,IPIV) &
          & bind(c, name='PLASMA_cgetri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetri_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetri_c
      end interface

      interface
         function PLASMA_cgetrs_c(trans,N,NRHS,A,LDA,IPIV,B,LDB) &
          & bind(c, name='PLASMA_cgetrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgetrs_c
      end interface

      interface
         function PLASMA_cgetrs_incpiv_c(trans,N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_cgetrs_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_incpiv_c
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cgetrs_incpiv_c
      end interface

      interface
         function PLASMA_cheev_c(jobz,uplo,N,A,LDA,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_cheev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheev_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_cheev_c
      end interface

      interface
         function PLASMA_cheevd_c(jobz,uplo,N,A,LDA,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_cheevd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheevd_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_cheevd_c
      end interface

      interface
         function PLASMA_chegst_c(itype,uplo,N,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_chegst')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegst_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_chegst_c
      end interface

      interface
         function PLASMA_chegv_c(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_chegv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegv_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_chegv_c
      end interface

      interface
         function PLASMA_chegvd_c(itype,jobz,uplo,N,A,LDA,B,LDB,W,descT,Q,LDQ) &
          & bind(c, name='PLASMA_chegvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegvd_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            type(c_ptr), value :: W
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_chegvd_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_chemm_c(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_chemm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chemm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_chemm_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cher2k_c(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_cher2k')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cher2k_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_cher2k_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cherk_c(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC) &
          & bind(c, name='PLASMA_cherk')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cherk_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            real(kind=c_float), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_cherk_c
      end interface
#endif

      interface
         function PLASMA_chetrd_c(jobz,uplo,N,A,LDA,D,E,descT,Q,LDQ) &
          & bind(c, name='PLASMA_chetrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chetrd_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: descT
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_chetrd_c
      end interface

      interface
         function PLASMA_clacpy_c(uplo,M,N,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_clacpy')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clacpy_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_clacpy_c
      end interface

      interface
         function PLASMA_clange_c(norm,M,N,A,LDA,work) &
          & bind(c, name='PLASMA_clange')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clange_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: work
          end function PLASMA_clange_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_clanhe_c(norm,uplo,N,A,LDA,work) &
          & bind(c, name='PLASMA_clanhe')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clanhe_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: work
          end function PLASMA_clanhe_c
      end interface
#endif

      interface
         function PLASMA_clansy_c(norm,uplo,N,A,LDA,work) &
          & bind(c, name='PLASMA_clansy')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clansy_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: work
          end function PLASMA_clansy_c
      end interface

      interface
         function PLASMA_claset_c(uplo,M,N,alpha,beta,A,LDA) &
          & bind(c, name='PLASMA_claset')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claset_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            complex(kind=c_float_complex), value :: alpha
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_claset_c
      end interface

      interface
         function PLASMA_claswp_c(N,A,LDA,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_claswp')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswp_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_claswp_c
      end interface

      interface
         function PLASMA_claswpc_c(N,A,LDA,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_claswpc')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswpc_c
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_claswpc_c
      end interface

      interface
         function PLASMA_clauum_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_clauum')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clauum_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_clauum_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cplghe_c(bump,N,A,LDA,seed) &
          & bind(c, name='PLASMA_cplghe')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplghe_c
            real(kind=c_float), value :: bump
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplghe_c
      end interface
#endif

      interface
         function PLASMA_cplgsy_c(bump,N,A,LDA,seed) &
          & bind(c, name='PLASMA_cplgsy')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplgsy_c
            complex(kind=c_float_complex), value :: bump
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplgsy_c
      end interface

      interface
         function PLASMA_cplrnt_c(M,N,A,LDA,seed) &
          & bind(c, name='PLASMA_cplrnt')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplrnt_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplrnt_c
      end interface

      interface
         function PLASMA_cposv_c(uplo,N,NRHS,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_cposv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cposv_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cposv_c
      end interface

      interface
         function PLASMA_cpotrf_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_cpotrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrf_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_cpotrf_c
      end interface

      interface
         function PLASMA_cpotri_c(uplo,N,A,LDA) &
          & bind(c, name='PLASMA_cpotri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotri_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_cpotri_c
      end interface

      interface
         function PLASMA_cpotrs_c(uplo,N,NRHS,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_cpotrs')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrs_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cpotrs_c
      end interface

      interface
         function PLASMA_csymm_c(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_csymm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csymm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_csymm_c
      end interface

      interface
         function PLASMA_csyr2k_c(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC) &
          & bind(c, name='PLASMA_csyr2k')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyr2k_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_csyr2k_c
      end interface

      interface
         function PLASMA_csyrk_c(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC) &
          & bind(c, name='PLASMA_csyrk')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyrk_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            integer(kind=c_int), value :: LDC
          end function PLASMA_csyrk_c
      end interface

      interface
         function PLASMA_ctrmm_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_ctrmm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrmm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_ctrmm_c
      end interface

      interface
         function PLASMA_ctrsm_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_ctrsm')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsm_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_ctrsm_c
      end interface

      interface
         function PLASMA_ctrsmpl_c(N,NRHS,A,LDA,descL,IPIV,B,LDB) &
          & bind(c, name='PLASMA_ctrsmpl')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmpl_c
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descL
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_ctrsmpl_c
      end interface

      interface
         function PLASMA_ctrsmrv_c(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB) &
          & bind(c, name='PLASMA_ctrsmrv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmrv_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: NRHS
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_ctrsmrv_c
      end interface

      interface
         function PLASMA_ctrtri_c(uplo,diag,N,A,LDA) &
          & bind(c, name='PLASMA_ctrtri')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrtri_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            integer(kind=c_int), value :: N
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
          end function PLASMA_ctrtri_c
      end interface

      interface
         function PLASMA_cunglq_c(M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cunglq')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunglq_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cunglq_c
      end interface

      interface
         function PLASMA_cungqr_c(M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cungqr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cungqr_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cungqr_c
      end interface

      interface
         function PLASMA_cunmlq_c(side,trans,M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cunmlq')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmlq_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cunmlq_c
      end interface

      interface
         function PLASMA_cunmqr_c(side,trans,M,N,K,A,LDA,descT,B,LDB) &
          & bind(c, name='PLASMA_cunmqr')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmqr_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            integer(kind=c_int), value :: K
            type(c_ptr), value :: A
            integer(kind=c_int), value :: LDA
            type(c_ptr), value :: descT
            type(c_ptr), value :: B
            integer(kind=c_int), value :: LDB
          end function PLASMA_cunmqr_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (native interface)
    !
      interface
         function PLASMA_cgebrd_Tile_c(A,D,E,T) &
          & bind(c, name='PLASMA_cgebrd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgebrd_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
          end function PLASMA_cgebrd_Tile_c
      end interface

      interface
         function PLASMA_cgelqf_Tile_c(A,T) &
          & bind(c, name='PLASMA_cgelqf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
          end function PLASMA_cgelqf_Tile_c
      end interface

      interface
         function PLASMA_cgelqs_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_cgelqs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqs_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cgelqs_Tile_c
      end interface

      interface
         function PLASMA_cgels_Tile_c(trans,A,T,B) &
          & bind(c, name='PLASMA_cgels_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgels_Tile_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cgels_Tile_c
      end interface

      interface
         function PLASMA_cgemm_Tile_c(transA,transB,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_cgemm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgemm_Tile_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_cgemm_Tile_c
      end interface

      interface
         function PLASMA_cgeqrf_Tile_c(A,T) &
          & bind(c, name='PLASMA_cgeqrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
          end function PLASMA_cgeqrf_Tile_c
      end interface

      interface
         function PLASMA_cgeqrs_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_cgeqrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrs_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cgeqrs_Tile_c
      end interface

      interface
         function PLASMA_cgesv_Tile_c(A,IPIV,B) &
          & bind(c, name='PLASMA_cgesv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_cgesv_Tile_c
      end interface

      interface
         function PLASMA_cgesv_incpiv_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_cgesv_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_cgesv_incpiv_Tile_c
      end interface

      interface
         function PLASMA_cgesvd_Tile_c(jobu,jobvt,A,S,U,VT,T) &
          & bind(c, name='PLASMA_cgesvd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesvd_Tile_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: U
            type(c_ptr), value :: VT
            type(c_ptr), value :: T
          end function PLASMA_cgesvd_Tile_c
      end interface

      interface
         function PLASMA_cgetrf_Tile_c(A,IPIV) &
          & bind(c, name='PLASMA_cgetrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetrf_Tile_c
      end interface

      interface
         function PLASMA_cgetrf_incpiv_Tile_c(A,L,IPIV) &
          & bind(c, name='PLASMA_cgetrf_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetrf_incpiv_Tile_c
      end interface

      interface
         function PLASMA_cgetri_Tile_c(A,IPIV) &
          & bind(c, name='PLASMA_cgetri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetri_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
          end function PLASMA_cgetri_Tile_c
      end interface

      interface
         function PLASMA_cgetrs_Tile_c(trans,A,IPIV,B) &
          & bind(c, name='PLASMA_cgetrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_Tile_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_cgetrs_Tile_c
      end interface

      interface
         function PLASMA_cgetrs_incpiv_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_cgetrs_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_incpiv_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_cgetrs_incpiv_Tile_c
      end interface

      interface
         function PLASMA_cheev_Tile_c(jobz,uplo,A,W,T,Q,LDQ) &
          & bind(c, name='PLASMA_cheev_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheev_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_cheev_Tile_c
      end interface

      interface
         function PLASMA_cheevd_Tile_c(jobz,uplo,A,W,T,Q,LDQ) &
          & bind(c, name='PLASMA_cheevd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheevd_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_cheevd_Tile_c
      end interface

      interface
         function PLASMA_chegst_Tile_c(itype,uplo,A,B) &
          & bind(c, name='PLASMA_chegst_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegst_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_chegst_Tile_c
      end interface

      interface
         function PLASMA_chegv_Tile_c(itype,jobz,uplo,A,B,W,T,Q) &
          & bind(c, name='PLASMA_chegv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegv_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
          end function PLASMA_chegv_Tile_c
      end interface

      interface
         function PLASMA_chegvd_Tile_c(itype,jobz,uplo,A,B,W,T,Q) &
          & bind(c, name='PLASMA_chegvd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegvd_Tile_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
          end function PLASMA_chegvd_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_chemm_Tile_c(side,uplo,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_chemm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chemm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_chemm_Tile_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cher2k_Tile_c(uplo,trans,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_cher2k_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cher2k_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_cher2k_Tile_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cherk_Tile_c(uplo,trans,alpha,A,beta,C) &
          & bind(c, name='PLASMA_cherk_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cherk_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_float), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_cherk_Tile_c
      end interface
#endif

      interface
         function PLASMA_chetrd_Tile_c(jobz,uplo,A,D,E,T,Q,LDQ) &
          & bind(c, name='PLASMA_chetrd_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chetrd_Tile_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
          end function PLASMA_chetrd_Tile_c
      end interface

      interface
         function PLASMA_clacpy_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_clacpy_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clacpy_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_clacpy_Tile_c
      end interface

      interface
         function PLASMA_clange_Tile_c(norm,A,work) &
          & bind(c, name='PLASMA_clange_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clange_Tile_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
            type(c_ptr), value :: work
          end function PLASMA_clange_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_clanhe_Tile_c(norm,uplo,A,work) &
          & bind(c, name='PLASMA_clanhe_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clanhe_Tile_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: work
          end function PLASMA_clanhe_Tile_c
      end interface
#endif

      interface
         function PLASMA_clansy_Tile_c(norm,uplo,A,work) &
          & bind(c, name='PLASMA_clansy_Tile')
            use iso_c_binding
            implicit none
            real(kind=c_float) :: PLASMA_clansy_Tile_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: work
          end function PLASMA_clansy_Tile_c
      end interface

      interface
         function PLASMA_claset_Tile_c(uplo,alpha,beta,A) &
          & bind(c, name='PLASMA_claset_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claset_Tile_c
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: A
          end function PLASMA_claset_Tile_c
      end interface

      interface
         function PLASMA_claswp_Tile_c(A,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_claswp_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswp_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_claswp_Tile_c
      end interface

      interface
         function PLASMA_claswpc_Tile_c(A,K1,K2,IPIV,INCX) &
          & bind(c, name='PLASMA_claswpc_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswpc_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
          end function PLASMA_claswpc_Tile_c
      end interface

      interface
         function PLASMA_clauum_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_clauum_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clauum_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_clauum_Tile_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cplghe_Tile_c(bump,A,seed) &
          & bind(c, name='PLASMA_cplghe_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplghe_Tile_c
            real(kind=c_float), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplghe_Tile_c
      end interface
#endif

      interface
         function PLASMA_cplgsy_Tile_c(bump,A,seed) &
          & bind(c, name='PLASMA_cplgsy_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplgsy_Tile_c
            complex(kind=c_float_complex), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplgsy_Tile_c
      end interface

      interface
         function PLASMA_cplrnt_Tile_c(A,seed) &
          & bind(c, name='PLASMA_cplrnt_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplrnt_Tile_c
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
          end function PLASMA_cplrnt_Tile_c
      end interface

      interface
         function PLASMA_cposv_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_cposv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cposv_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_cposv_Tile_c
      end interface

      interface
         function PLASMA_cpotrf_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_cpotrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrf_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_cpotrf_Tile_c
      end interface

      interface
         function PLASMA_cpotri_Tile_c(uplo,A) &
          & bind(c, name='PLASMA_cpotri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotri_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
          end function PLASMA_cpotri_Tile_c
      end interface

      interface
         function PLASMA_cpotrs_Tile_c(uplo,A,B) &
          & bind(c, name='PLASMA_cpotrs_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrs_Tile_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_cpotrs_Tile_c
      end interface

      interface
         function PLASMA_csymm_Tile_c(side,uplo,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_csymm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csymm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_csymm_Tile_c
      end interface

      interface
         function PLASMA_csyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C) &
          & bind(c, name='PLASMA_csyr2k_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyr2k_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_csyr2k_Tile_c
      end interface

      interface
         function PLASMA_csyrk_Tile_c(uplo,trans,alpha,A,beta,C) &
          & bind(c, name='PLASMA_csyrk_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyrk_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
          end function PLASMA_csyrk_Tile_c
      end interface

      interface
         function PLASMA_ctrmm_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_ctrmm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrmm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_ctrmm_Tile_c
      end interface

      interface
         function PLASMA_ctrsm_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_ctrsm_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsm_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_ctrsm_Tile_c
      end interface

      interface
         function PLASMA_ctrsmpl_Tile_c(A,L,IPIV,B) &
          & bind(c, name='PLASMA_ctrsmpl_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmpl_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
          end function PLASMA_ctrsmpl_Tile_c
      end interface

      interface
         function PLASMA_ctrsmrv_Tile_c(side,uplo,transA,diag,alpha,A,B) &
          & bind(c, name='PLASMA_ctrsmrv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmrv_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
          end function PLASMA_ctrsmrv_Tile_c
      end interface

      interface
         function PLASMA_ctrtri_Tile_c(uplo,diag,A) &
          & bind(c, name='PLASMA_ctrtri_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrtri_Tile_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
          end function PLASMA_ctrtri_Tile_c
      end interface

      interface
         function PLASMA_cunglq_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_cunglq_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunglq_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cunglq_Tile_c
      end interface

      interface
         function PLASMA_cungqr_Tile_c(A,T,B) &
          & bind(c, name='PLASMA_cungqr_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cungqr_Tile_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cungqr_Tile_c
      end interface

      interface
         function PLASMA_cunmlq_Tile_c(side,trans,A,T,B) &
          & bind(c, name='PLASMA_cunmlq_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmlq_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cunmlq_Tile_c
      end interface

      interface
         function PLASMA_cunmqr_Tile_c(side,trans,A,T,B) &
          & bind(c, name='PLASMA_cunmqr_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmqr_Tile_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
          end function PLASMA_cunmqr_Tile_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - math functions (asynchronous interface)
    !
      interface
         function PLASMA_cgebrd_Tile_Async_c(A,D,E,T,sequence,request) &
          & bind(c, name='PLASMA_cgebrd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgebrd_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgebrd_Tile_Async_c
      end interface

      interface
         function PLASMA_cgelqf_Tile_Async_c(A,T,sequence,request) &
          & bind(c, name='PLASMA_cgelqf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgelqf_Tile_Async_c
      end interface

      interface
         function PLASMA_cgelqs_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cgelqs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgelqs_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgelqs_Tile_Async_c
      end interface

      interface
         function PLASMA_cgels_Tile_Async_c(trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cgels_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgels_Tile_Async_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgels_Tile_Async_c
      end interface

      interface
         function PLASMA_cgemm_Tile_Async_c(transA,transB,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_cgemm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgemm_Tile_Async_c
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: transB
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgemm_Tile_Async_c
      end interface

      interface
         function PLASMA_cgeqrf_Tile_Async_c(A,T,sequence,request) &
          & bind(c, name='PLASMA_cgeqrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgeqrf_Tile_Async_c
      end interface

      interface
         function PLASMA_cgeqrs_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cgeqrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgeqrs_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgeqrs_Tile_Async_c
      end interface

      interface
         function PLASMA_cgesv_Tile_Async_c(A,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_cgesv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgesv_Tile_Async_c
      end interface

      interface
         function PLASMA_cgesv_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_cgesv_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesv_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgesv_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_cgesvd_Tile_Async_c(jobu,jobvt,A,S,U,VT,T,sequence,request) &
          & bind(c, name='PLASMA_cgesvd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgesvd_Tile_Async_c
            integer(kind=c_int), value :: jobu
            integer(kind=c_int), value :: jobvt
            type(c_ptr), value :: A
            type(c_ptr), value :: S
            type(c_ptr), value :: U
            type(c_ptr), value :: VT
            type(c_ptr), value :: T
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgesvd_Tile_Async_c
      end interface

      interface
         function PLASMA_cgetrf_Tile_Async_c(A,IPIV,sequence,request) &
          & bind(c, name='PLASMA_cgetrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetrf_Tile_Async_c
      end interface

      interface
         function PLASMA_cgetrf_incpiv_Tile_Async_c(A,L,IPIV,sequence,request) &
          & bind(c, name='PLASMA_cgetrf_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrf_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetrf_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_cgetri_Tile_Async_c(A,IPIV,W,sequence,request) &
          & bind(c, name='PLASMA_cgetri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetri_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: W
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetri_Tile_Async_c
      end interface

      interface
         function PLASMA_cgetrs_Tile_Async_c(trans,A,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_cgetrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_Tile_Async_c
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetrs_Tile_Async_c
      end interface

      interface
         function PLASMA_cgetrs_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_cgetrs_incpiv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cgetrs_incpiv_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cgetrs_incpiv_Tile_Async_c
      end interface

      interface
         function PLASMA_cheev_Tile_Async_c(jobz,uplo,A,W,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_cheev_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheev_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cheev_Tile_Async_c
      end interface

      interface
         function PLASMA_cheevd_Tile_Async_c(jobz,uplo,A,W,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_cheevd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cheevd_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cheevd_Tile_Async_c
      end interface

      interface
         function PLASMA_chegst_Tile_Async_c(itype,uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_chegst_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegst_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_chegst_Tile_Async_c
      end interface

      interface
         function PLASMA_chegv_Tile_Async_c(itype,jobz,uplo,A,B,W,T,Q,sequence,request) &
          & bind(c, name='PLASMA_chegv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegv_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_chegv_Tile_Async_c
      end interface

      interface
         function PLASMA_chegvd_Tile_Async_c(itype,jobz,uplo,A,B,W,T,Q,sequence,request) &
          & bind(c, name='PLASMA_chegvd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chegvd_Tile_Async_c
            integer(kind=c_int), value :: itype
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: W
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_chegvd_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_chemm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_chemm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chemm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_chemm_Tile_Async_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cher2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_cher2k_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cher2k_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cher2k_Tile_Async_c
      end interface
#endif

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cherk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request) &
          & bind(c, name='PLASMA_cherk_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cherk_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            real(kind=c_float), value :: alpha
            type(c_ptr), value :: A
            real(kind=c_float), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cherk_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_chetrd_Tile_Async_c(jobz,uplo,A,D,E,T,Q,LDQ,sequence,request) &
          & bind(c, name='PLASMA_chetrd_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_chetrd_Tile_Async_c
            integer(kind=c_int), value :: jobz
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: D
            type(c_ptr), value :: E
            type(c_ptr), value :: T
            type(c_ptr), value :: Q
            integer(kind=c_int), value :: LDQ
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_chetrd_Tile_Async_c
      end interface

      interface
         function PLASMA_clacpy_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_clacpy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clacpy_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_clacpy_Tile_Async_c
      end interface

      interface
         function PLASMA_clange_Tile_Async_c(norm,A,work,value,sequence,request) &
          & bind(c, name='PLASMA_clange_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clange_Tile_Async_c
            integer(kind=c_int), value :: norm
            type(c_ptr), value :: A
            type(c_ptr), value :: work
            type(c_ptr), value :: value
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_clange_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_clanhe_Tile_Async_c(norm,uplo,A,work,value,sequence,request) &
          & bind(c, name='PLASMA_clanhe_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clanhe_Tile_Async_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: work
            type(c_ptr), value :: value
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_clanhe_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_clansy_Tile_Async_c(norm,uplo,A,work,value,sequence,request) &
          & bind(c, name='PLASMA_clansy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clansy_Tile_Async_c
            integer(kind=c_int), value :: norm
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: work
            type(c_ptr), value :: value
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_clansy_Tile_Async_c
      end interface

      interface
         function PLASMA_claset_Tile_Async_c(uplo,alpha,beta,A,sequence,request) &
          & bind(c, name='PLASMA_claset_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claset_Tile_Async_c
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_claset_Tile_Async_c
      end interface

      interface
         function PLASMA_claswp_Tile_Async_c(A,K1,K2,IPIV,INCX,sequence,request) &
          & bind(c, name='PLASMA_claswp_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswp_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_claswp_Tile_Async_c
      end interface

      interface
         function PLASMA_claswpc_Tile_Async_c(A,K1,K2,IPIV,INCX,sequence,request) &
          & bind(c, name='PLASMA_claswpc_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_claswpc_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_int), value :: K1
            integer(kind=c_int), value :: K2
            type(c_ptr), value :: IPIV
            integer(kind=c_int), value :: INCX
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_claswpc_Tile_Async_c
      end interface

      interface
         function PLASMA_clauum_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_clauum_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_clauum_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_clauum_Tile_Async_c
      end interface

#if defined(PRECISION_z) || defined(PRECISION_c)
      interface
         function PLASMA_cplghe_Tile_Async_c(bump,A,seed,sequence,request) &
          & bind(c, name='PLASMA_cplghe_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplghe_Tile_Async_c
            real(kind=c_float), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cplghe_Tile_Async_c
      end interface
#endif

      interface
         function PLASMA_cplgsy_Tile_Async_c(bump,A,seed,sequence,request) &
          & bind(c, name='PLASMA_cplgsy_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplgsy_Tile_Async_c
            complex(kind=c_float_complex), value :: bump
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cplgsy_Tile_Async_c
      end interface

      interface
         function PLASMA_cplrnt_Tile_Async_c(A,seed,sequence,request) &
          & bind(c, name='PLASMA_cplrnt_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cplrnt_Tile_Async_c
            type(c_ptr), value :: A
            integer(kind=c_long_long), value :: seed
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cplrnt_Tile_Async_c
      end interface

      interface
         function PLASMA_cposv_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_cposv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cposv_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cposv_Tile_Async_c
      end interface

      interface
         function PLASMA_cpotrf_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_cpotrf_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrf_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cpotrf_Tile_Async_c
      end interface

      interface
         function PLASMA_cpotri_Tile_Async_c(uplo,A,sequence,request) &
          & bind(c, name='PLASMA_cpotri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotri_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cpotri_Tile_Async_c
      end interface

      interface
         function PLASMA_cpotrs_Tile_Async_c(uplo,A,B,sequence,request) &
          & bind(c, name='PLASMA_cpotrs_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cpotrs_Tile_Async_c
            integer(kind=c_int), value :: uplo
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cpotrs_Tile_Async_c
      end interface

      interface
         function PLASMA_csymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_csymm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csymm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_csymm_Tile_Async_c
      end interface

      interface
         function PLASMA_csyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request) &
          & bind(c, name='PLASMA_csyr2k_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyr2k_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_csyr2k_Tile_Async_c
      end interface

      interface
         function PLASMA_csyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request) &
          & bind(c, name='PLASMA_csyrk_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_csyrk_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: trans
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            complex(kind=c_float_complex), value :: beta
            type(c_ptr), value :: C
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_csyrk_Tile_Async_c
      end interface

      interface
         function PLASMA_ctrmm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_ctrmm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrmm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_ctrmm_Tile_Async_c
      end interface

      interface
         function PLASMA_ctrsm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_ctrsm_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsm_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_ctrsm_Tile_Async_c
      end interface

      interface
         function PLASMA_ctrsmpl_Tile_Async_c(A,L,IPIV,B,sequence,request) &
          & bind(c, name='PLASMA_ctrsmpl_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmpl_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: L
            type(c_ptr), value :: IPIV
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_ctrsmpl_Tile_Async_c
      end interface

      interface
         function PLASMA_ctrsmrv_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request) &
          & bind(c, name='PLASMA_ctrsmrv_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrsmrv_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: transA
            integer(kind=c_int), value :: diag
            complex(kind=c_float_complex), value :: alpha
            type(c_ptr), value :: A
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_ctrsmrv_Tile_Async_c
      end interface

      interface
         function PLASMA_ctrtri_Tile_Async_c(uplo,diag,A,sequence,request) &
          & bind(c, name='PLASMA_ctrtri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_ctrtri_Tile_Async_c
            integer(kind=c_int), value :: uplo
            integer(kind=c_int), value :: diag
            type(c_ptr), value :: A
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_ctrtri_Tile_Async_c
      end interface

      interface
         function PLASMA_cunglq_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cunglq_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunglq_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cunglq_Tile_Async_c
      end interface

      interface
         function PLASMA_cungqr_Tile_Async_c(A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cungqr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cungqr_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cungqr_Tile_Async_c
      end interface

      interface
         function PLASMA_cunmlq_Tile_Async_c(side,trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cunmlq_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmlq_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cunmlq_Tile_Async_c
      end interface

      interface
         function PLASMA_cunmqr_Tile_Async_c(side,trans,A,T,B,sequence,request) &
          & bind(c, name='PLASMA_cunmqr_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_cunmqr_Tile_Async_c
            integer(kind=c_int), value :: side
            integer(kind=c_int), value :: trans
            type(c_ptr), value :: A
            type(c_ptr), value :: T
            type(c_ptr), value :: B
            type(c_ptr), value :: sequence
            type(c_ptr), value :: request
          end function PLASMA_cunmqr_Tile_Async_c
      end interface

    !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !  FORTRAN API - workspace allocation
    !
      interface
         function PLASMA_Alloc_Workspace_cgebrd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgebrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgebrd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgebrd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgeev_c(N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgeev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgeev_c
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgeev_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgehrd_c(N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgehrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgehrd_c
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgehrd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgelqf_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgelqf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgelqf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgelqf_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgelqf_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgelqf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgelqf_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgelqf_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgels_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgels')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgels_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgels_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgels_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgels_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgels_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgels_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgeqrf_c(M,N,T) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgeqrf')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgeqrf_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: T ! T is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgeqrf_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgeqrf_Tile_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgeqrf_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgeqrf_Tile_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgeqrf_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgesv_incpiv_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgesv_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgesv_incpiv_c
            integer(kind=c_int), value :: N
            type(c_ptr) :: descL ! descL is **, so pass by reference
            type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgesv_incpiv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgesv_incpiv_Tile_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgesv_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgesv_incpiv_Tile_c
            integer(kind=c_int), value :: N
            type(c_ptr) :: descL ! descL is **, so pass by reference
            type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgesv_incpiv_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgesvd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgesvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgesvd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgesvd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgetrf_incpiv_c(M,N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgetrf_incpiv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgetrf_incpiv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descL ! descL is **, so pass by reference
            type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgetrf_incpiv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile_c(N,descL,IPIV) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile_c
            integer(kind=c_int), value :: N
            type(c_ptr) :: descL ! descL is **, so pass by reference
            type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cgetri_Tile_Async_c(A,W) &
          & bind(c, name='PLASMA_Alloc_Workspace_cgetri_Tile_Async')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cgetri_Tile_Async_c
            type(c_ptr), value :: A
            type(c_ptr), value :: W
          end function PLASMA_Alloc_Workspace_cgetri_Tile_Async_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cheev_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cheev')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cheev_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cheev_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_cheevd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_cheevd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_cheevd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_cheevd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_chegv_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_chegv')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_chegv_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_chegv_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_chegvd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_chegvd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_chegvd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_chegvd_c
      end interface

      interface
         function PLASMA_Alloc_Workspace_chetrd_c(M,N,descT) &
          & bind(c, name='PLASMA_Alloc_Workspace_chetrd')
            use iso_c_binding
            implicit none
            integer(kind=c_int) :: PLASMA_Alloc_Workspace_chetrd_c
            integer(kind=c_int), value :: M
            integer(kind=c_int), value :: N
            type(c_ptr) :: descT ! descT is **, so pass by reference
          end function PLASMA_Alloc_Workspace_chetrd_c
      end interface

  contains

       subroutine PLASMA_cgebrd(M,N,A,LDA,D,E,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgebrd_c(M,N,c_loc(A),LDA,c_loc(D),c_loc(E),T)
      end subroutine PLASMA_cgebrd

      subroutine PLASMA_cgelqf(M,N,A,LDA,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqf_c(M,N,c_loc(A),LDA,T)
      end subroutine PLASMA_cgelqf

      subroutine PLASMA_cgelqs(M,N,NRHS,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqs_c(M,N,NRHS,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cgelqs

      subroutine PLASMA_cgels(trans,M,N,NRHS,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: trans
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgels_c(trans,M,N,NRHS,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cgels

      subroutine PLASMA_cgemm(transA,transB,M,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         info = PLASMA_cgemm_c(transA,transB,M,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_cgemm

      subroutine PLASMA_cgeqrf(M,N,A,LDA,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrf_c(M,N,c_loc(A),LDA,T)
      end subroutine PLASMA_cgeqrf

      subroutine PLASMA_cgeqrs(M,N,NRHS,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrs_c(M,N,NRHS,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cgeqrs

      subroutine PLASMA_cgesv(N,NRHS,A,LDA,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(out), target :: IPIV(*)
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cgesv_c(N,NRHS,c_loc(A),LDA,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_cgesv

      subroutine PLASMA_cgesv_incpiv(N,NRHS,A,LDA,L,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesv_incpiv_c(N,NRHS,c_loc(A),LDA,L,IPIV,c_loc(B),LDB)
      end subroutine PLASMA_cgesv_incpiv

      subroutine PLASMA_cgesvd(jobu,jobvt,M,N,A,LDA,S,U,LDU,VT,LDVT,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDU
         integer(kind=c_int), intent(in) :: LDVT
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(out), target :: U(LDU,*)
         complex(kind=c_float_complex), intent(out), target :: VT(LDVT,*)
         real(kind=c_float), intent(out), target :: S(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesvd_c(jobu,jobvt,M,N,c_loc(A),LDA,c_loc(S),c_loc(U),LDU,c_loc(VT),LDVT,T)
      end subroutine PLASMA_cgesvd

      subroutine PLASMA_cgetrf(M,N,A,LDA,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(out), target :: IPIV(*)
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_cgetrf_c(M,N,c_loc(A),LDA,c_loc(IPIV))
      end subroutine PLASMA_cgetrf

      subroutine PLASMA_cgetrf_incpiv(M,N,A,LDA,L,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L    ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrf_incpiv_c(M,N,c_loc(A),LDA,L,IPIV)
      end subroutine PLASMA_cgetrf_incpiv

      subroutine PLASMA_cgetrs(trans,N,NRHS,A,LDA,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in), target :: IPIV(*)
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cgetrs_c(trans,N,NRHS,c_loc(A),LDA,c_loc(IPIV),c_loc(B),LDB)
      end subroutine PLASMA_cgetrs

      subroutine PLASMA_cgetrs_incpiv(trans,N,NRHS,A,LDA,L,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: trans
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L    ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrs_incpiv_c(trans,N,NRHS,c_loc(A),LDA,L,IPIV,c_loc(B),LDB)
      end subroutine PLASMA_cgetrs_incpiv

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_chemm(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         info = PLASMA_chemm_c(side,uplo,M,N,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_chemm

      subroutine PLASMA_cherk(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         real(kind=c_float), intent(in) :: alpha
         real(kind=c_float), intent(in) :: beta
         info = PLASMA_cherk_c(uplo,trans,N,K,alpha,c_loc(A),LDA,beta,c_loc(C),LDC)
      end subroutine PLASMA_cherk

      subroutine PLASMA_cher2k(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         real(kind=c_float), intent(in) :: beta
         info = PLASMA_cher2k_c(uplo,trans,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_cher2k
#endif

      subroutine PLASMA_cheev(jobz,uplo,N,A,LDA,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDQ
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         real(kind=c_float), intent(out), target :: W(*)
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cheev_c(jobz,uplo,N,c_loc(A),LDA,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_cheev

      subroutine PLASMA_cheevd(jobz,uplo,N,A,LDA,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDQ
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         real(kind=c_float), intent(out), target :: W(*)
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cheevd_c(jobz,uplo,N,c_loc(A),LDA,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_cheevd

      subroutine PLASMA_chegv(itype,jobz,uplo,N,A,LDA,B,LDB,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDQ
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         real(kind=c_float), intent(out), target :: W(*)
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegv_c(itype,jobz,uplo,N,c_loc(A),LDA,c_loc(B),LDB,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_chegv

      subroutine PLASMA_chegvd(itype,jobz,uplo,N,A,LDA,B,LDB,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDQ
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         real(kind=c_float), intent(out), target :: W(*)
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegvd_c(itype,jobz,uplo,N,c_loc(A),LDA,c_loc(B),LDB,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_chegvd

      subroutine PLASMA_chegst(itype,uplo,N,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_chegst_c(itype,uplo,N,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_chegst

      subroutine PLASMA_chetrd(jobz,uplo,N,A,LDA,D,E,descT,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDQ
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: descT ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(inout), target :: Q(LDQ,*)
         info = PLASMA_chetrd_c(jobz,uplo,N,c_loc(A),LDA,c_loc(D),c_loc(E),descT,c_loc(Q),LDQ)
      end subroutine PLASMA_chetrd

      function PLASMA_clange(norm,M,N,A,LDA,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clange
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         PLASMA_clange = PLASMA_clange_c(norm,M,N,c_loc(A),LDA,c_loc(work))
      end function PLASMA_clange

#if defined(PRECISION_z) || defined(PRECISION_c)
      function PLASMA_clanhe(norm,uplo,N,A,LDA,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clanhe
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         PLASMA_clanhe = PLASMA_clanhe_c(norm,uplo,N,c_loc(A),LDA,c_loc(work))
      end function PLASMA_clanhe
#endif

      function PLASMA_clansy(norm,uplo,N,A,LDA,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clansy
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         PLASMA_clansy = PLASMA_clansy_c(norm,uplo,N,c_loc(A),LDA,c_loc(work))
      end function PLASMA_clansy

      subroutine PLASMA_claswp(N,A,LDA,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in), target :: IPIV(*)
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_claswp_c(N,c_loc(A),LDA,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_claswp

      subroutine PLASMA_clauum(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_clauum_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_clauum

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_cplghe(bump,N,A,LDA,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(in) :: bump
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         complex(kind=c_float_complex), intent(out), target :: A(LDA,*)
         info = PLASMA_cplghe_c(bump,N,c_loc(A),LDA,seed)
       end subroutine PLASMA_cplghe
#endif

      subroutine PLASMA_cplgsy(bump,N,A,LDA,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(in) :: bump
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         complex(kind=c_float_complex), intent(out), target :: A(LDA,*)
         info = PLASMA_cplgsy_c(bump,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_cplgsy
       
      subroutine PLASMA_cplrnt(M,N,A,LDA,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_long_long), intent(in) :: seed
         complex(kind=c_float_complex), intent(out), target :: A(LDA,*)
         info = PLASMA_cplrnt_c(M,N,c_loc(A),LDA,seed)
      end subroutine PLASMA_cplrnt
       
      subroutine PLASMA_cposv(uplo,N,NRHS,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cposv_c(uplo,N,NRHS,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_cposv

      subroutine PLASMA_cpotrf(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_cpotrf_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_cpotrf

      subroutine PLASMA_cpotri(uplo,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_cpotri_c(uplo,N,c_loc(A),LDA)
      end subroutine PLASMA_cpotri

      subroutine PLASMA_cpotrs(uplo,N,NRHS,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cpotrs_c(uplo,N,NRHS,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_cpotrs

      subroutine PLASMA_csymm(side,uplo,M,N,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         info = PLASMA_csymm_c(side,uplo,M,N,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_csymm

      subroutine PLASMA_csyrk(uplo,trans,N,K,alpha,A,LDA,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         info = PLASMA_csyrk_c(uplo,trans,N,K,alpha,c_loc(A),LDA,beta,c_loc(C),LDC)
      end subroutine PLASMA_csyrk

      subroutine PLASMA_csyr2k(uplo,trans,N,K,alpha,A,LDA,B,LDB,beta,C,LDC,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: LDC
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(in), target :: B(LDB,*)
         complex(kind=c_float_complex), intent(inout), target :: C(LDC,*)
         info = PLASMA_csyr2k_c(uplo,trans,N,K,alpha,c_loc(A),LDA,c_loc(B),LDB,beta,c_loc(C),LDC)
      end subroutine PLASMA_csyr2k

      subroutine PLASMA_ctrmm(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_ctrmm_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_ctrmm

      subroutine PLASMA_ctrsm(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_ctrsm_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_ctrsm

      subroutine PLASMA_ctrsmpl(N,NRHS,A,LDA,L,IPIV,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         type(c_ptr), value :: L    ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_ctrsmpl_c(N,NRHS,c_loc(A),LDA,L,IPIV,c_loc(B),LDB)
      end subroutine PLASMA_ctrsmpl

      subroutine PLASMA_ctrtri(uplo,diag,N,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_ctrtri_c(uplo,diag,N,c_loc(A),LDA)
      end subroutine PLASMA_ctrtri

      subroutine PLASMA_cunglq(M,N,K,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(out), target :: B(LDB,*)
         info = PLASMA_cunglq_c(M,N,K,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cunglq

      subroutine PLASMA_cungqr(M,N,K,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(out), target :: B(LDB,*)
         info = PLASMA_cungqr_c(M,N,K,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cungqr

      subroutine PLASMA_cunmlq(side,trans,M,N,K,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cunmlq_c(side,trans,M,N,K,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cunmlq

      subroutine PLASMA_cunmqr(side,trans,M,N,K,A,LDA,T,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in) :: K
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_cunmqr_c(side,trans,M,N,K,c_loc(A),LDA,T,c_loc(B),LDB)
      end subroutine PLASMA_cunmqr

      subroutine PLASMA_cgecfi(m,n,A,fin,imb,inb,fout,omb,onb,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: fout
         integer(kind=c_int), intent(in) :: imb
         integer(kind=c_int), intent(in) :: inb
         integer(kind=c_int), intent(in) :: omb
         integer(kind=c_int), intent(in) :: onb
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         info = PLASMA_cgecfi_c(m,n,c_loc(A),fin,imb,inb,fout,omb,onb)
      end subroutine PLASMA_cgecfi

      subroutine PLASMA_cgetmi(m,n,A,fin,mb,nb,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: mb
         integer(kind=c_int), intent(in) :: nb
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         info = PLASMA_cgetmi_c(m,n,c_loc(A),fin,mb,nb)
      end subroutine PLASMA_cgetmi

      subroutine PLASMA_cgetri(N,A,LDA,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in), target :: IPIV(*)
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_cgetri_c(N,c_loc(A),LDA,c_loc(IPIV))
      end subroutine PLASMA_cgetri

      subroutine PLASMA_clacpy(uplo,M,N,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(out), target :: B(LDB,*)
         info = PLASMA_clacpy_c(uplo,M,N,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_clacpy

      subroutine PLASMA_claset(uplo,M,N,alpha,beta,A,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_claset_c(uplo,M,N,alpha,beta,c_loc(A),LDA)
      end subroutine PLASMA_claset

      subroutine PLASMA_claswpc(N,A,LDA,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: N
         complex(kind=c_float_complex), intent(inout), target :: A(LDA,*)
         info = PLASMA_claswpc_c(N,c_loc(A),LDA,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_claswpc

      subroutine PLASMA_ctrsmrv(side,uplo,transA,diag,N,NRHS,alpha,A,LDA,B,LDB,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDA
         integer(kind=c_int), intent(in) :: LDB
         integer(kind=c_int), intent(in) :: N
         integer(kind=c_int), intent(in) :: NRHS
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in), target :: A(LDA,*)
         complex(kind=c_float_complex), intent(inout), target :: B(LDB,*)
         info = PLASMA_ctrsmrv_c(side,uplo,transA,diag,N,NRHS,alpha,c_loc(A),LDA,c_loc(B),LDB)
      end subroutine PLASMA_ctrsmrv

      subroutine PLASMA_cgebrd_Tile(A,D,E,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgebrd_Tile_c(A,c_loc(D),c_loc(E),T)
      end subroutine PLASMA_cgebrd_Tile

      subroutine PLASMA_cgelqf_Tile(A,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqf_Tile_c(A,T)
      end subroutine PLASMA_cgelqf_Tile

      subroutine PLASMA_cgelqs_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqs_Tile_c(A,T,B)
      end subroutine PLASMA_cgelqs_Tile

      subroutine PLASMA_cgels_Tile(trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgels_Tile_c(trans,A,T,B)
      end subroutine PLASMA_cgels_Tile

      subroutine PLASMA_cgemm_Tile(transA,transB,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgemm_Tile_c(transA,transB,alpha,A,B,beta,C)
      end subroutine PLASMA_cgemm_Tile

      subroutine PLASMA_cgeqrf_Tile(A,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrf_Tile_c(A,T)
      end subroutine PLASMA_cgeqrf_Tile

      subroutine PLASMA_cgeqrs_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrs_Tile_c(A,T,B)
      end subroutine PLASMA_cgeqrs_Tile

      subroutine PLASMA_cgesv_Tile(A,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(out), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesv_Tile_c(A,c_loc(IPIV),B)
      end subroutine PLASMA_cgesv_Tile

      subroutine PLASMA_cgesv_incpiv_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesv_incpiv_Tile_c(A,L,IPIV,B)
      end subroutine PLASMA_cgesv_incpiv_Tile

      subroutine PLASMA_cgesvd_Tile(jobu,jobvt,A,S,U,VT,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         real(kind=c_float), intent(out), target :: S(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: U ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: VT ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesvd_Tile_c(jobu,jobvt,A,c_loc(S),U,VT,T)
      end subroutine PLASMA_cgesvd_Tile

      subroutine PLASMA_cgetrf_Tile(A,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(out), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrf_Tile_c(A,c_loc(IPIV))
      end subroutine PLASMA_cgetrf_Tile

      subroutine PLASMA_cgetrf_incpiv_Tile(A,L,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrf_incpiv_Tile_c(A,L,IPIV)
      end subroutine PLASMA_cgetrf_incpiv_Tile

      subroutine PLASMA_cgetrs_Tile(trans,A,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrs_Tile_c(trans,A,c_loc(IPIV),B)
      end subroutine PLASMA_cgetrs_Tile

      subroutine PLASMA_cgetrs_incpiv_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrs_incpiv_Tile_c(A,L,IPIV,B)
      end subroutine PLASMA_cgetrs_incpiv_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_chemm_Tile(side,uplo,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chemm_Tile_c(side,uplo,alpha,A,B,beta,C)
      end subroutine PLASMA_chemm_Tile

      subroutine PLASMA_cherk_Tile(uplo,trans,alpha,A,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(in) :: alpha
         real(kind=c_float), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cherk_Tile_c(uplo,trans,alpha,A,beta,C)
      end subroutine PLASMA_cherk_Tile

      subroutine PLASMA_cher2k_Tile(uplo,trans,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         real(kind=c_float), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cher2k_Tile_c(uplo,trans,alpha,A,B,beta,C)
      end subroutine PLASMA_cher2k_Tile
#endif

      subroutine PLASMA_cheev_Tile(jobz,uplo,A,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         info = PLASMA_cheev_Tile_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_cheev_Tile

      subroutine PLASMA_cheevd_Tile(jobz,uplo,A,W,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         info = PLASMA_cheevd_Tile_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ)
      end subroutine PLASMA_cheevd_Tile

      subroutine PLASMA_chegv_Tile(itype,jobz,uplo,A,B,W,T,Q,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegv_Tile_c(itype,jobz,uplo,A,B,c_loc(W),T,Q)
      end subroutine PLASMA_chegv_Tile

      subroutine PLASMA_chegvd_Tile(itype,jobz,uplo,A,B,W,T,Q,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegvd_Tile_c(itype,jobz,uplo,A,B,c_loc(W),T,Q)
      end subroutine PLASMA_chegvd_Tile

      subroutine PLASMA_chegst_Tile(itype,uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegst_Tile_c(itype,uplo,A,B)
      end subroutine PLASMA_chegst_Tile

      subroutine PLASMA_chetrd_Tile(jobz,uplo,A,D,E,T,Q,LDQ,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ,*)
         info = PLASMA_chetrd_Tile_c(jobz,uplo,A,c_loc(D),c_loc(E),T,c_loc(Q),LDQ)
      end subroutine PLASMA_chetrd_Tile

      function PLASMA_clange_Tile(norm,A,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clange_Tile
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_float), intent(inout), target :: work(*)
         PLASMA_clange_Tile = PLASMA_clange_Tile_c(norm,A,c_loc(work))
       end function PLASMA_clange_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)
      function PLASMA_clanhe_Tile(norm,uplo,A,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clanhe_Tile
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         PLASMA_clanhe_Tile = PLASMA_clanhe_Tile_c(norm,uplo,A,c_loc(work))
      end function PLASMA_clanhe_Tile
#endif

      function PLASMA_clansy_Tile(norm,uplo,A,work)
         use iso_c_binding
         implicit none
         real(kind=c_float) :: PLASMA_clansy_Tile
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         PLASMA_clansy_Tile = PLASMA_clansy_Tile_c(norm,uplo,A,c_loc(work))
      end function PLASMA_clansy_Tile

      subroutine PLASMA_claswp_Tile(A,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claswp_Tile_c(A,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_claswp_Tile

      subroutine PLASMA_clauum_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clauum_Tile_c(uplo,A)
      end subroutine PLASMA_clauum_Tile

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_cplghe_Tile(bump,A,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(in) :: bump
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplghe_Tile_c(bump,A,seed)
      end subroutine PLASMA_cplghe_Tile
#endif

      subroutine PLASMA_cplgsy_Tile(bump,A,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(in) :: bump
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplgsy_Tile_c(bump,A,seed)
      end subroutine PLASMA_cplgsy_Tile
       
      subroutine PLASMA_cplrnt_Tile(A,seed,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplrnt_Tile_c(A,seed)
      end subroutine PLASMA_cplrnt_Tile
       
      subroutine PLASMA_cposv_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cposv_Tile_c(uplo,A,B)
      end subroutine PLASMA_cposv_Tile

      subroutine PLASMA_cpotrf_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotrf_Tile_c(uplo,A)
      end subroutine PLASMA_cpotrf_Tile

      subroutine PLASMA_cpotri_Tile(uplo,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotri_Tile_c(uplo,A)
      end subroutine PLASMA_cpotri_Tile

      subroutine PLASMA_cpotrs_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotrs_Tile_c(uplo,A,B)
      end subroutine PLASMA_cpotrs_Tile

      subroutine PLASMA_csymm_Tile(side,uplo,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csymm_Tile_c(side,uplo,alpha,A,B,beta,C)
      end subroutine PLASMA_csymm_Tile

      subroutine PLASMA_csyrk_Tile(uplo,trans,alpha,A,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csyrk_Tile_c(uplo,trans,alpha,A,beta,C)
      end subroutine PLASMA_csyrk_Tile

      subroutine PLASMA_csyr2k_Tile(uplo,trans,alpha,A,B,beta,C,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csyr2k_Tile_c(uplo,trans,alpha,A,B,beta,C)
      end subroutine PLASMA_csyr2k_Tile

      subroutine PLASMA_ctrmm_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrmm_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_ctrmm_Tile

      subroutine PLASMA_ctrsm_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsm_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_ctrsm_Tile

      subroutine PLASMA_ctrsmpl_Tile(A,L,IPIV,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsmpl_Tile_c(A,L,IPIV,B)
      end subroutine PLASMA_ctrsmpl_Tile

      subroutine PLASMA_ctrtri_Tile(uplo,diag,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrtri_Tile_c(uplo,diag,A)
      end subroutine PLASMA_ctrtri_Tile

      subroutine PLASMA_cunglq_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunglq_Tile_c(A,T,B)
      end subroutine PLASMA_cunglq_Tile

      subroutine PLASMA_cungqr_Tile(A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cungqr_Tile_c(A,T,B)
      end subroutine PLASMA_cungqr_Tile

      subroutine PLASMA_cunmlq_Tile(side,trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunmlq_Tile_c(side,trans,A,T,B)
      end subroutine PLASMA_cunmlq_Tile

      subroutine PLASMA_cunmqr_Tile(side,trans,A,T,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunmqr_Tile_c(side,trans,A,T,B)
      end subroutine PLASMA_cunmqr_Tile

      subroutine PLASMA_cgetri_Tile(A,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetri_Tile_c(A,c_loc(IPIV))
      end subroutine PLASMA_cgetri_Tile

      subroutine PLASMA_clacpy_Tile(uplo,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clacpy_Tile_c(uplo,A,B)
      end subroutine PLASMA_clacpy_Tile

      subroutine PLASMA_claset_Tile(uplo,alpha,beta,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claset_Tile_c(uplo,alpha,beta,A)
      end subroutine PLASMA_claset_Tile

      subroutine PLASMA_claswpc_Tile(A,K1,K2,IPIV,INCX,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claswpc_Tile_c(A,K1,K2,c_loc(IPIV),INCX)
      end subroutine PLASMA_claswpc_Tile

      subroutine PLASMA_ctrsmrv_Tile(side,uplo,transA,diag,alpha,A,B,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsmrv_Tile_c(side,uplo,transA,diag,alpha,A,B)
      end subroutine PLASMA_ctrsmrv_Tile

      subroutine PLASMA_cgetri_Tile_Async(A,IPIV,W,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetri_Tile_Async_c(A,c_loc(IPIV),W,sequence,request)
      end subroutine PLASMA_cgetri_Tile_Async

      subroutine PLASMA_clange_Tile_Async(norm,A,work,value,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int) :: info
         real(kind=c_float), intent(out), target :: value
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clange_Tile_Async_c(norm,A,c_loc(work),c_loc(value),sequence,request)
      end subroutine PLASMA_clange_Tile_Async

      subroutine PLASMA_clansy_Tile_Async(norm,uplo,A,work,value,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int) :: info
         real(kind=c_float), intent(out), target :: value
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clansy_Tile_Async_c(norm,uplo,A,c_loc(work),c_loc(value),sequence,request)
      end subroutine PLASMA_clansy_Tile_Async

      subroutine PLASMA_cgebrd_Tile_Async(A,D,E,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgebrd_Tile_Async_c(A,c_loc(D),c_loc(E),T,sequence,request)
      end subroutine PLASMA_cgebrd_Tile_Async

      subroutine PLASMA_cgecfi_Async(m,n,A,fin,imb,inb,fout,omb,onb,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: fout
         integer(kind=c_int), intent(in) :: imb
         integer(kind=c_int), intent(in) :: inb
         integer(kind=c_int), intent(in) :: omb
         integer(kind=c_int), intent(in) :: onb
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgecfi_Async_c(m,n,c_loc(A),fin,imb,inb,fout,omb,onb,sequence,request)
      end subroutine PLASMA_cgecfi_Async

      subroutine PLASMA_cgelqf_Tile_Async(A,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqf_Tile_Async_c(A,T,sequence,request)
      end subroutine PLASMA_cgelqf_Tile_Async

      subroutine PLASMA_cgelqs_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgelqs_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_cgelqs_Tile_Async

      subroutine PLASMA_cgels_Tile_Async(trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgels_Tile_Async_c(trans,A,T,B,sequence,request)
      end subroutine PLASMA_cgels_Tile_Async

      subroutine PLASMA_cgemm_Tile_Async(transA,transB,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: transB
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgemm_Tile_Async_c(transA,transB,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_cgemm_Tile_Async

      subroutine PLASMA_cgeqrf_Tile_Async(A,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrf_Tile_Async_c(A,T,sequence,request)
      end subroutine PLASMA_cgeqrf_Tile_Async

      subroutine PLASMA_cgeqrs_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgeqrs_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_cgeqrs_Tile_Async

      subroutine PLASMA_cgesv_Tile_Async(A,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(out), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesv_Tile_Async_c(A,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_cgesv_Tile_Async

      subroutine PLASMA_cgesv_incpiv_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesv_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request)
      end subroutine PLASMA_cgesv_incpiv_Tile_Async

      subroutine PLASMA_cgesvd_Tile_Async(jobu,jobvt,A,S,U,VT,T,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobu
         integer(kind=c_int), intent(in) :: jobvt
         real(kind=c_float), intent(out), target :: S(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: U ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: VT ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgesvd_Tile_Async_c(jobu,jobvt,A,c_loc(S),U,VT,T,sequence,request)
      end subroutine PLASMA_cgesvd_Tile_Async

      subroutine PLASMA_cgetmi_Async(m,n,A,fin,mb,nb,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(inout), target :: A(*)
         integer(kind=c_int), intent(in) :: fin
         integer(kind=c_int), intent(in) :: mb
         integer(kind=c_int), intent(in) :: nb
         integer(kind=c_int), intent(in) :: m
         integer(kind=c_int), intent(in) :: n
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetmi_Async_c(m,n,c_loc(A),fin,mb,nb,sequence,request)
      end subroutine PLASMA_cgetmi_Async

      subroutine PLASMA_cgetrf_Tile_Async(A,IPIV,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(out), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrf_Tile_Async_c(A,c_loc(IPIV),sequence,request)
      end subroutine PLASMA_cgetrf_Tile_Async

      subroutine PLASMA_cgetrf_incpiv_Tile_Async(A,L,IPIV,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrf_incpiv_Tile_Async_c(A,L,IPIV,sequence,request)
      end subroutine PLASMA_cgetrf_incpiv_Tile_Async

      subroutine PLASMA_cgetrs_Tile_Async(trans,A,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrs_Tile_Async_c(trans,A,c_loc(IPIV),B,sequence,request)
      end subroutine PLASMA_cgetrs_Tile_Async

      subroutine PLASMA_cgetrs_incpiv_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cgetrs_incpiv_Tile_Async_c(A,L,IPIV,B,sequence,request)
      end subroutine PLASMA_cgetrs_incpiv_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_chemm_Tile_Async(side,uplo,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chemm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_chemm_Tile_Async

      subroutine PLASMA_cherk_Tile_Async(uplo,trans,alpha,A,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(in) :: alpha
         real(kind=c_float), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cherk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request)
      end subroutine PLASMA_cherk_Tile_Async

      subroutine PLASMA_cher2k_Tile_Async(uplo,trans,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         real(kind=c_float), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cher2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_cher2k_Tile_Async
#endif

      subroutine PLASMA_cheev_Tile_Async(jobz,uplo,A,W,T,Q,LDQ,sequence,request,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ, *)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cheev_Tile_Async_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_cheev_Tile_Async

      subroutine PLASMA_cheevd_Tile_Async(jobz,uplo,A,W,T,Q,LDQ,sequence,request,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ, *)
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cheevd_Tile_Async_c(jobz,uplo,A,c_loc(W),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_cheevd_Tile_Async

      subroutine PLASMA_chegv_Tile_Async(itype,jobz,uplo,A,B,W,T,Q,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegv_Tile_Async_c(itype,jobz,uplo,A,B,c_loc(W),T,Q,sequence,request)
      end subroutine PLASMA_chegv_Tile_Async

      subroutine PLASMA_chegvd_Tile_Async(itype,jobz,uplo,A,B,W,T,Q,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         real(kind=c_float), intent(out), target :: W(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: Q ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegvd_Tile_Async_c(itype,jobz,uplo,A,B,c_loc(W),T,Q,sequence,request)
      end subroutine PLASMA_chegvd_Tile_Async

      subroutine PLASMA_chegst_Tile_Async(itype,uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: itype
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chegst_Tile_Async_c(itype,uplo,A,B,sequence,request)
      end subroutine PLASMA_chegst_Tile_Async

      subroutine PLASMA_chetrd_Tile_Async(jobz,uplo,A,D,E,T,Q,LDQ,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: jobz
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(in) :: LDQ
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         real(kind=c_float), intent(out), target :: D(*)
         real(kind=c_float), intent(out), target :: E(*)
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         complex(kind=c_float_complex), intent(out), target :: Q(LDQ, *)
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_chetrd_Tile_Async_c(jobz,uplo,A,c_loc(D),c_loc(E),T,c_loc(Q),LDQ,sequence,request)
      end subroutine PLASMA_chetrd_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_clanhe_Tile_Async(norm,uplo,A,work,value,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(inout), target :: work(*)
         integer(kind=c_int), intent(in) :: norm
         integer(kind=c_int), intent(in) :: uplo
         integer(kind=c_int), intent(out), target :: value
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clanhe_Tile_Async_c(norm,uplo,A,c_loc(work),c_loc(value),sequence,request)
      end subroutine PLASMA_clanhe_Tile_Async
#endif

      subroutine PLASMA_claswp_Tile_Async(A,K1,K2,IPIV,INCX,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         integer(kind=c_int), intent(in), target :: IPIV(*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claswp_Tile_Async_c(A,K1,K2,c_loc(IPIV),INCX,sequence,request)
      end subroutine PLASMA_claswp_Tile_Async

      subroutine PLASMA_clauum_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clauum_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_clauum_Tile_Async

#if defined(PRECISION_z) || defined(PRECISION_c)
      subroutine PLASMA_cplghe_Tile_Async(bump,A,seed,sequence,request,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         real(kind=c_float), intent(in) :: bump
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplghe_Tile_Async_c(bump,A,seed,sequence,request)
      end subroutine PLASMA_cplghe_Tile_Async
#endif

      subroutine PLASMA_cplgsy_Tile_Async(bump,A,seed,sequence,request,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         complex(kind=c_float_complex), intent(in) :: bump
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplgsy_Tile_Async_c(bump,A,seed,sequence,request)
      end subroutine PLASMA_cplgsy_Tile_Async
       
      subroutine PLASMA_cplrnt_Tile_Async(A,seed,sequence,request,info) 
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_long_long), intent(in) :: seed
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cplrnt_Tile_Async_c(A,seed,sequence,request)
      end subroutine PLASMA_cplrnt_Tile_Async

      subroutine PLASMA_cposv_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cposv_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_cposv_Tile_Async

      subroutine PLASMA_cpotrf_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotrf_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_cpotrf_Tile_Async

      subroutine PLASMA_cpotri_Tile_Async(uplo,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotri_Tile_Async_c(uplo,A,sequence,request)
      end subroutine PLASMA_cpotri_Tile_Async

      subroutine PLASMA_cpotrs_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cpotrs_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_cpotrs_Tile_Async

      subroutine PLASMA_csymm_Tile_Async(side,uplo,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csymm_Tile_Async_c(side,uplo,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_csymm_Tile_Async

      subroutine PLASMA_csyrk_Tile_Async(uplo,trans,alpha,A,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csyrk_Tile_Async_c(uplo,trans,alpha,A,beta,C,sequence,request)
      end subroutine PLASMA_csyrk_Tile_Async

      subroutine PLASMA_csyr2k_Tile_Async(uplo,trans,alpha,A,B,beta,C,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: trans
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: C ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_csyr2k_Tile_Async_c(uplo,trans,alpha,A,B,beta,C,sequence,request)
      end subroutine PLASMA_csyr2k_Tile_Async

      subroutine PLASMA_ctrmm_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrmm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_ctrmm_Tile_Async

      subroutine PLASMA_ctrsm_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsm_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_ctrsm_Tile_Async

      subroutine PLASMA_ctrsmpl_Tile_Async(A,L,IPIV,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: L ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: IPIV ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsmpl_Tile_Async_c(A,L,IPIV,B,sequence,request)
      end subroutine PLASMA_ctrsmpl_Tile_Async

      subroutine PLASMA_ctrtri_Tile_Async(uplo,diag,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrtri_Tile_Async_c(uplo,diag,A,sequence,request)
      end subroutine PLASMA_ctrtri_Tile_Async

      subroutine PLASMA_cunglq_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunglq_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_cunglq_Tile_Async

      subroutine PLASMA_cungqr_Tile_Async(A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cungqr_Tile_Async_c(A,T,B,sequence,request)
      end subroutine PLASMA_cungqr_Tile_Async

      subroutine PLASMA_cunmlq_Tile_Async(side,trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunmlq_Tile_Async_c(side,trans,A,T,B,sequence,request)
      end subroutine PLASMA_cunmlq_Tile_Async

      subroutine PLASMA_cunmqr_Tile_Async(side,trans,A,T,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: trans
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: T ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cunmqr_Tile_Async_c(side,trans,A,T,B,sequence,request)
      end subroutine PLASMA_cunmqr_Tile_Async

      subroutine PLASMA_clacpy_Tile_Async(uplo,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_clacpy_Tile_Async_c(uplo,A,B,sequence,request)
      end subroutine PLASMA_clacpy_Tile_Async

      subroutine PLASMA_claset_Tile_Async(uplo,alpha,beta,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         complex(kind=c_float_complex), intent(in) :: beta
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claset_Tile_Async_c(uplo,alpha,beta,A,sequence,request)
      end subroutine PLASMA_claset_Tile_Async

      subroutine PLASMA_claswpc_Tile_Async(A,K1,K2,IPIV,INCX,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in), target :: IPIV(*)
         integer(kind=c_int), intent(in) :: INCX
         integer(kind=c_int), intent(in) :: K1
         integer(kind=c_int), intent(in) :: K2
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_claswpc_Tile_Async_c(A,K1,K2,c_loc(IPIV),INCX,sequence,request)
      end subroutine PLASMA_claswpc_Tile_Async

      subroutine PLASMA_ctrsmrv_Tile_Async(side,uplo,transA,diag,alpha,A,B,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: diag
         integer(kind=c_int), intent(in) :: side
         integer(kind=c_int), intent(in) :: transA
         integer(kind=c_int), intent(in) :: uplo
         complex(kind=c_float_complex), intent(in) :: alpha
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: B ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_ctrsmrv_Tile_Async_c(side,uplo,transA,diag,alpha,A,B,sequence,request)
      end subroutine PLASMA_ctrsmrv_Tile_Async

      subroutine PLASMA_Alloc_Workspace_cgelqf(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgelqf_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cgelqf

      subroutine PLASMA_Alloc_Workspace_cgels(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgels_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cgels

      subroutine PLASMA_Alloc_Workspace_cgeqrf(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgeqrf_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cgeqrf

      subroutine PLASMA_Alloc_Workspace_cgesv_incpiv(N,L,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
         type(c_ptr) :: L ! L is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgesv_incpiv_c(N,L,IPIV)
      end subroutine PLASMA_Alloc_Workspace_cgesv_incpiv

      subroutine PLASMA_Alloc_Workspace_cgetrf_incpiv(M,N,L,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
         type(c_ptr) :: L ! L is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgetrf_incpiv_c(M,N,L,IPIV)
      end subroutine PLASMA_Alloc_Workspace_cgetrf_incpiv

      subroutine PLASMA_Alloc_Workspace_cgeev(N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgeev_c(N,T)
      end subroutine PLASMA_Alloc_Workspace_cgeev

      subroutine PLASMA_Alloc_Workspace_cgebrd(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgebrd_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cgebrd

      subroutine PLASMA_Alloc_Workspace_cgehrd(N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgehrd_c(N,T)
      end subroutine PLASMA_Alloc_Workspace_cgehrd

      subroutine PLASMA_Alloc_Workspace_cgesvd(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgesvd_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cgesvd

      subroutine PLASMA_Alloc_Workspace_cheev(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cheev_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cheev

      subroutine PLASMA_Alloc_Workspace_cheevd(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cheevd_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_cheevd

      subroutine PLASMA_Alloc_Workspace_chegv(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_chegv_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_chegv

      subroutine PLASMA_Alloc_Workspace_chegvd(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_chegvd_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_chegvd

      subroutine PLASMA_Alloc_Workspace_chetrd(M,N,T,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: T ! T is **, so pass by reference
         info = PLASMA_Alloc_Workspace_chetrd_c(M,N,T)
      end subroutine PLASMA_Alloc_Workspace_chetrd

      subroutine PLASMA_Alloc_Workspace_cgelqf_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgelqf_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_cgelqf_Tile

      subroutine PLASMA_Alloc_Workspace_cgels_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgels_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_cgels_Tile

      subroutine PLASMA_Alloc_Workspace_cgeqrf_Tile(M,N,descT,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: M
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: descT ! descT is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgeqrf_Tile_c(M,N,descT)
      end subroutine PLASMA_Alloc_Workspace_cgeqrf_Tile

      subroutine PLASMA_Alloc_Workspace_cgesv_incpiv_Tile(N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
         type(c_ptr) :: descL ! descL is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgesv_incpiv_Tile_c(N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_cgesv_incpiv_Tile

      subroutine PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile(N,descL,IPIV,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: N
         type(c_ptr) :: IPIV ! IPIV is **, so pass by reference
         type(c_ptr) :: descL ! descL is **, so pass by reference
         info = PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile_c(N,descL,IPIV)
      end subroutine PLASMA_Alloc_Workspace_cgetrf_incpiv_Tile

      subroutine PLASMA_Alloc_Workspace_cgetri_Tile_Async(A,W,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: W ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_Alloc_Workspace_cgetri_Tile_Async_c(A,W)
      end subroutine PLASMA_Alloc_Workspace_cgetri_Tile_Async

      subroutine PLASMA_cLapack_to_Tile(Af77,LDA,A,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         complex(kind=c_float_complex), intent(in), target :: Af77(LDA,*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cLapack_to_Tile_c(c_loc(Af77),LDA,A)
      end subroutine PLASMA_cLapack_to_Tile

      subroutine PLASMA_cTile_to_Lapack(A,Af77,LDA,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         complex(kind=c_float_complex), intent(out), target :: Af77(LDA,*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cTile_to_Lapack_c(A,c_loc(Af77),LDA)
      end subroutine PLASMA_cTile_to_Lapack

      subroutine PLASMA_cLapack_to_Tile_Async(Af77,LDA,A,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         complex(kind=c_float_complex), intent(in), target :: Af77(LDA,*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cLapack_to_Tile_Async_c(c_loc(Af77),LDA,A,sequence,request)
      end subroutine PLASMA_cLapack_to_Tile_Async

      subroutine PLASMA_cTile_to_Lapack_Async(A,Af77,LDA,sequence,request,info)
         use iso_c_binding
         implicit none
         integer(kind=c_int), intent(out) :: info
         integer(kind=c_int), intent(in) :: LDA
         complex(kind=c_float_complex), intent(out), target :: Af77(LDA,*)
         type(c_ptr), value :: A ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: request ! Arg managed by PLASMA: opaque to Fortran
         type(c_ptr), value :: sequence ! Arg managed by PLASMA: opaque to Fortran
         info = PLASMA_cTile_to_Lapack_Async_c(A,c_loc(Af77),LDA,sequence,request)
      end subroutine PLASMA_cTile_to_Lapack_Async

end module plasma_c
