/**                                                               
 *                                                                
 * @file coreblas_z.c                                             
 *                                                                
 *  PLASMA core_blas tracing kernel                               
 *  PLASMA is a software package provided by Univ. of Tennessee,  
 *  Univ. of California Berkeley and Univ. of Colorado Denver     
 *                                                                
 *  This file provides the wrapper for each function of the       
 *  core_blas library which will generate an event before and     
 *  after the execution of the kernel.                            
 *  This file is automatically generated with convert2eztrace.pl  
 *  script.                                                       
 *                                                                
 * @version 2.4.0                                                 
 * @author Mathieu Faverge                                        
 * @date 2010-11-15                                               
 * @precisions normal z -> c d s                                  
 *                                                                
 **/                                                              
#include <eztrace.h>           
#include <ev_codes.h>          
#include "common.h"            
#include "coreblas_ev_codes.h" 
#include "coreblas_macros.h"   
#undef REAL                    
#define COMPLEX                

/*****************************************************************
 *        Core functions                                          
 */

FUNCTION_VOID( CORE_dzasum, ASUM, void ,
          (int storev, int uplo, int M, int N, PLASMA_Complex64_t *A, int lda, double *work),
          (storev, uplo, M, N, A, lda, work) )
FUNCTION_VOID( CORE_zaxpy, AXPY, void ,
          (int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB),
          (M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_zbrdalg, BRDALG, void ,
          (PLASMA_enum uplo, int N, int NB, PLASMA_desc *pA, PLASMA_Complex64_t *V, PLASMA_Complex64_t *TAU, int i, int j, int m, int grsiz),
          (uplo, N, NB, pA, V, TAU, i, j, m, grsiz) )
FUNCTION_TYPE( CORE_zgelqt, GELQT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_VOID( CORE_zgemm, GEMM, void ,
          (int transA, int transB, int M, int N, int K, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC),
          (transA, transB, M, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_TYPE( CORE_zgeqrt, GEQRT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A, LDA, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_zgessm, GESSM, int ,
          (int M, int N, int K, int IB, int *IPIV, PLASMA_Complex64_t *L, int LDL, PLASMA_Complex64_t *A, int LDA),
          (M, N, K, IB, IPIV, L, LDL, A, LDA) )
FUNCTION_TYPE( CORE_zgetrf, GETRF, int ,
          (int m, int n, PLASMA_Complex64_t *A, int lda, int *IPIV, int *info),
          (m, n, A, lda, IPIV, info) )
FUNCTION_TYPE( CORE_zgetrf_incpiv, GETRF, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A, int LDA, int *IPIV, int *INFO),
          (M, N, IB, A, LDA, IPIV, INFO) )
FUNCTION_TYPE( CORE_zgetrf_reclap, GETRF, int ,
          (int M, int N, PLASMA_Complex64_t *A, int LDA, int *IPIV, int *info),
          (M, N, A, LDA, IPIV, info) )
FUNCTION_TYPE( CORE_zgetrf_rectil, GETRF, int ,
          (const PLASMA_desc A, int *IPIV, int *info),
          (A, IPIV, info) )
FUNCTION_VOID( CORE_zgetrip, GETRIP, void ,
          (int m, int n, PLASMA_Complex64_t *A, PLASMA_Complex64_t *W) ,
          (m, n, A, W)  )
FUNCTION_VOID( CORE_zhegst, HEGST, void ,
          (int itype, PLASMA_enum uplo, int N, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, int *INFO),
          (itype, uplo, N, A, LDA, B, LDB, INFO) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_zhemm, HEMM, void ,
          (int side, int uplo, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
#ifdef COMPLEX
FUNCTION_VOID( CORE_zher2k, HER2K, void ,
          (int uplo, int trans, int N, int K, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, double beta, PLASMA_Complex64_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
#endif
FUNCTION_TYPE( CORE_zherfb, HERFB, int ,
          ( PLASMA_enum uplo, int n, int k, int ib, int nb, PLASMA_Complex64_t *A, int lda, PLASMA_Complex64_t *T, int ldt, PLASMA_Complex64_t *C, int ldc, PLASMA_Complex64_t *WORK, int ldwork ),
          (uplo, n, k, ib, nb, A, lda, T, ldt, C, ldc, WORK, ldwork) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_zherk, HERK, void ,
          (int uplo, int trans, int N, int K, double alpha, PLASMA_Complex64_t *A, int LDA, double beta, PLASMA_Complex64_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
#endif
FUNCTION_VOID( CORE_zlacpy, LACPY, void ,
          (PLASMA_enum uplo, int M, int N, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB),
          (uplo, M, N, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_zlange, LANGE, void ,
          (int norm, int M, int N, PLASMA_Complex64_t *A, int LDA, double *work, double *normA),
          (norm, M, N, A, LDA, work, normA) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_zlanhe, LANHE, void ,
          (int norm, int uplo, int N, PLASMA_Complex64_t *A, int LDA, double *work, double *normA),
          (norm, uplo, N, A, LDA, work, normA) )
#endif
FUNCTION_VOID( CORE_zlansy, LANSY, void ,
          (int norm, int uplo, int N, PLASMA_Complex64_t *A, int LDA, double *work, double *normA),
          (norm, uplo, N, A, LDA, work, normA) )
FUNCTION_VOID( CORE_zlaset2, LASET, void ,
          (PLASMA_enum uplo, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA),
          (uplo, M, N, alpha, A, LDA) )
FUNCTION_VOID( CORE_zlaset, LASET, void ,
          (PLASMA_enum uplo, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t beta, PLASMA_Complex64_t *A, int LDA),
          (uplo, M, N, alpha, beta, A, LDA) )
FUNCTION_VOID( CORE_zlaswp, LASWP, void ,
          (int N, PLASMA_Complex64_t *A, int LDA, int I1, int I2, int *IPIV, int INC),
          (N, A, LDA, I1, I2, IPIV, INC) )
FUNCTION_TYPE( CORE_zlaswp_ontile, LASWP, int ,
          (PLASMA_desc descA, int i1, int i2, int *ipiv, int inc),
          (descA, i1, i2, ipiv, inc) )
FUNCTION_TYPE( CORE_zswptr_ontile, TRSM, int ,
          (PLASMA_desc descA, int i1, int i2, int *ipiv, int inc, PLASMA_Complex64_t *Akk, int ldak),
          (descA, i1, i2, ipiv, inc, Akk, ldak) )
FUNCTION_VOID( CORE_zlauum, LAUUM, void ,
          (int uplo, int N, PLASMA_Complex64_t *A, int LDA),
          (uplo, N, A, LDA) )
#ifdef COMPLEX
FUNCTION_VOID( CORE_zplghe, PLGHE, void ,
          ( double bump, int m, int n, PLASMA_Complex64_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
#endif
FUNCTION_VOID( CORE_zplgsy, PLGSY, void ,
          ( PLASMA_Complex64_t bump, int m, int n, PLASMA_Complex64_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (bump, m, n, A, lda, bigM, m0, n0, seed) )
FUNCTION_VOID( CORE_zplrnt, PLRNT, void ,
          ( int m, int n, PLASMA_Complex64_t *A, int lda, int bigM, int m0, int n0, unsigned long long int seed ),
          (m, n, A, lda, bigM, m0, n0, seed) )
FUNCTION_VOID( CORE_zpotrf, POTRF, void ,
          (int uplo, int N, PLASMA_Complex64_t *A, int LDA, int *INFO),
          (uplo, N, A, LDA, INFO) )
FUNCTION_VOID( CORE_zshiftw, SHIFTW, void ,
          (int s, int cl, int m, int n, int L, PLASMA_Complex64_t *A, PLASMA_Complex64_t *W) ,
          (s, cl, m, n, L, A, W)  )
FUNCTION_VOID( CORE_zshift, SHIFT, void ,
          (int s, int m, int n, int L, PLASMA_Complex64_t *A) ,
          (s, m, n, L, A)  )
FUNCTION_TYPE( CORE_zssssm, SSSSM, int ,
          (int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *L1, int LDL1, PLASMA_Complex64_t *L2, int LDL2, int *IPIV),
          (M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, L1, LDL1, L2, LDL2, IPIV) )
FUNCTION_VOID( CORE_zswpab, SWPAB, void ,
          (int i, int n1, int n2, PLASMA_Complex64_t *A, PLASMA_Complex64_t *work) ,
          (i, n1, n2, A, work)  )
FUNCTION_VOID( CORE_zsymm, SYMM, void ,
          (int side, int uplo, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC),
          (side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_zsyr2k, SYR2K, void ,
          (int uplo, int trans, int N, int K, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, B, LDB, beta, C, LDC) )
FUNCTION_VOID( CORE_zsyrk, SYRK, void ,
          (int uplo, int trans, int N, int K, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC),
          (uplo, trans, N, K, alpha, A, LDA, beta, C, LDC) )
FUNCTION_VOID( CORE_ztrdalg, TRDALG, void ,
          (PLASMA_enum uplo, int N, int NB, PLASMA_desc *pA, PLASMA_Complex64_t *V, PLASMA_Complex64_t *TAU, int i, int j, int m, int grsiz),
          (uplo, N, NB, pA, V, TAU, i, j, m, grsiz) )
FUNCTION_VOID( CORE_ztrmm, TRMM, void ,
          (int side, int uplo, int transA, int diag, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_ztrsm, TRSM, void ,
          (int side, int uplo, int transA, int diag, int M, int N, PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB),
          (side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB) )
FUNCTION_VOID( CORE_ztrtri, TRTRI, void ,
          (int uplo, int diag, int N, PLASMA_Complex64_t *A, int LDA, int *info),
          (uplo, diag, N, A, LDA, info) )
FUNCTION_TYPE( CORE_ztslqt, TSLQT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_ztsmlq, TSMLQ, int ,
          (int side, int trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_ztsmlq_corner, TSMLQ, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, PLASMA_Complex64_t *A1, int lda1, PLASMA_Complex64_t *A2, int lda2, PLASMA_Complex64_t *A3, int lda3, PLASMA_Complex64_t *V, int ldv, PLASMA_Complex64_t *T, int ldt, PLASMA_Complex64_t *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ztsmlq_hetra1, TSMLQ, int ,
          ( int side, int trans, int m1, int n1, int m2, int n2, int k, int ib, PLASMA_Complex64_t *A1, int lda1, PLASMA_Complex64_t *A2, int lda2, PLASMA_Complex64_t *V, int ldv, PLASMA_Complex64_t *T, int ldt, PLASMA_Complex64_t *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ztsmqr, TSMQR, int ,
          (int side, int trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_ztsmqr_corner, TSMQR, int ,
          ( int m1, int n1, int m2, int n2, int m3, int n3, int k, int ib, int nb, PLASMA_Complex64_t *A1, int lda1, PLASMA_Complex64_t *A2, int lda2, PLASMA_Complex64_t *A3, int lda3, PLASMA_Complex64_t *V, int ldv, PLASMA_Complex64_t *T, int ldt, PLASMA_Complex64_t *WORK, int ldwork),
          (m1, n1, m2, n2, m3, n3, k, ib, nb, A1, lda1, A2, lda2, A3, lda3, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ztsmqr_hetra1, TSMQR, int ,
          ( int side, int trans, int m1, int n1, int m2, int n2, int k, int ib, PLASMA_Complex64_t *A1, int lda1, PLASMA_Complex64_t *A2, int lda2, PLASMA_Complex64_t *V, int ldv, PLASMA_Complex64_t *T, int ldt, PLASMA_Complex64_t *WORK, int ldwork),
          (side, trans, m1, n1, m2, n2, k, ib, A1, lda1, A2, lda2, V, ldv, T, ldt, WORK, ldwork) )
FUNCTION_TYPE( CORE_ztsqrt, TSQRT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_ztsrfb, TSRFB, int ,
          (int side, int trans, int direct, int storev, int M1, int N1, int M2, int N2, int K, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, direct, storev, M1, N1, M2, N2, K, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_ztstrf, TSTRF, int ,
          (int M, int N, int IB, int NB, PLASMA_Complex64_t *U, int LDU, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *L, int LDL, int *IPIV, PLASMA_Complex64_t *WORK, int LDWORK, int *INFO),
          (M, N, IB, NB, U, LDU, A, LDA, L, LDL, IPIV, WORK, LDWORK, INFO) )
FUNCTION_TYPE( CORE_zttlqt, TTLQT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_zttmlq, TTMLQ, int ,
          (int side, int trans, int M1, int N1, int M2, int N2, int K, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, K, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_zttmqr, TTMQR, int ,
          (int side, int trans, int M1, int N1, int M2, int N2, int KK, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M1, N1, M2, N2, KK, IB, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_zttqrt, TTQRT, int ,
          (int M, int N, int IB, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK),
          (M, N, IB, A1, LDA1, A2, LDA2, T, LDT, TAU, WORK) )
FUNCTION_TYPE( CORE_zttrfb, TTRFB, int ,
          (int side, int trans, int direct, int storev, int M1, int N1, int M2, int N2, int K, PLASMA_Complex64_t *A1, int LDA1, PLASMA_Complex64_t *A2, int LDA2, PLASMA_Complex64_t *V, int LDV, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, direct, storev, M1, N1, M2, N2, K, A1, LDA1, A2, LDA2, V, LDV, T, LDT, WORK, LDWORK) )
FUNCTION_TYPE( CORE_zunmlq, UNMLQ, int ,
          (int side, int trans, int M, int N, int K, int IB, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *C, int LDC, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )
FUNCTION_TYPE( CORE_zunmqr, UNMQR, int ,
          (int side, int trans, int M, int N, int K, int IB, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *T, int LDT, PLASMA_Complex64_t *C, int LDC, PLASMA_Complex64_t *WORK, int LDWORK),
          (side, trans, M, N, K, IB, A, LDA, T, LDT, C, LDC, WORK, LDWORK) )

/*****************************************************************
 *        QUARK Wrapper functions                                 
 */

FUNCTION_QUARK( CORE_dzasum_quark, ASUM )
FUNCTION_QUARK( CORE_dzasum_f1_quark, ASUM )
FUNCTION_QUARK( CORE_zaxpy_quark, AXPY )
FUNCTION_QUARK( CORE_zbrdalg_quark, BRDALG )
FUNCTION_QUARK( CORE_zgelqt_quark, GELQT )
FUNCTION_QUARK( CORE_zgemm_quark, GEMM )
FUNCTION_QUARK( CORE_zgemm_f2_quark, GEMM )
FUNCTION_QUARK( CORE_zgemm_p2_quark, GEMM )
FUNCTION_QUARK( CORE_zgemm_p3_quark, GEMM )
FUNCTION_QUARK( CORE_zgemm_p2f1_quark, GEMM )
FUNCTION_QUARK( CORE_zgeqrt_quark, GEQRT )
FUNCTION_QUARK( CORE_zgessm_quark, GESSM )
FUNCTION_QUARK( CORE_zgetrf_quark, GETRF )
FUNCTION_QUARK( CORE_zgetrf_incpiv_quark, GETRF )
FUNCTION_QUARK( CORE_zgetrf_reclap_quark, GETRF )
FUNCTION_QUARK( CORE_zgetrf_rectil_quark, GETRF )
FUNCTION_QUARK( CORE_zgetrip_quark, GETRIP )
FUNCTION_QUARK( CORE_zgetrip_f1_quark, GETRIP )
FUNCTION_QUARK( CORE_zgetrip_f2_quark, GETRIP )
FUNCTION_QUARK( CORE_zhegst_quark, HEGST )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_zhemm_quark, HEMM )
#endif
#ifdef COMPLEX
FUNCTION_QUARK( CORE_zher2k_quark, HER2K )
#endif
FUNCTION_QUARK( CORE_zherfb_quark, HERFB )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_zherk_quark, HERK )
#endif
FUNCTION_QUARK( CORE_zlacpy_quark, LACPY )
FUNCTION_QUARK( CORE_zlange_quark, LANGE )
FUNCTION_QUARK( CORE_zlange_f1_quark, LANGE )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_zlanhe_quark, LANHE )
FUNCTION_QUARK( CORE_zlanhe_f1_quark, LANHE )
#endif
FUNCTION_QUARK( CORE_zlansy_quark, LANSY )
FUNCTION_QUARK( CORE_zlansy_f1_quark, LANSY )
FUNCTION_QUARK( CORE_zlaset2_quark, LASET )
FUNCTION_QUARK( CORE_zlaset_quark, LASET )
FUNCTION_QUARK( CORE_zlaswp_quark, LASWP )
FUNCTION_QUARK( CORE_zlaswp_f2_quark, LASWP )
FUNCTION_QUARK( CORE_zlaswp_ontile_quark, LASWP )
FUNCTION_QUARK( CORE_zlaswp_ontile_f2_quark, LASWP )
FUNCTION_QUARK( CORE_zswptr_ontile_quark, TRSM )
FUNCTION_QUARK( CORE_zlauum_quark, LAUUM )
#ifdef COMPLEX
FUNCTION_QUARK( CORE_zplghe_quark, PLGHE )
#endif
FUNCTION_QUARK( CORE_zplgsy_quark, PLGSY )
FUNCTION_QUARK( CORE_zplrnt_quark, PLRNT )
FUNCTION_QUARK( CORE_zpotrf_quark, POTRF )
FUNCTION_QUARK( CORE_zshiftw_quark, SHIFTW )
FUNCTION_QUARK( CORE_zshift_quark, SHIFT )
FUNCTION_QUARK( CORE_zssssm_quark, SSSSM )
FUNCTION_QUARK( CORE_zswpab_quark, SWPAB )
FUNCTION_QUARK( CORE_zsymm_quark, SYMM )
FUNCTION_QUARK( CORE_zsyr2k_quark, SYR2K )
FUNCTION_QUARK( CORE_zsyrk_quark, SYRK )
FUNCTION_QUARK( CORE_ztrdalg_quark, TRDALG )
FUNCTION_QUARK( CORE_ztrmm_quark, TRMM )
FUNCTION_QUARK( CORE_ztrmm_p2_quark, TRMM )
FUNCTION_QUARK( CORE_ztrsm_quark, TRSM )
FUNCTION_QUARK( CORE_ztrtri_quark, TRTRI )
FUNCTION_QUARK( CORE_ztslqt_quark, TSLQT )
FUNCTION_QUARK( CORE_ztsmlq_quark, TSMLQ )
FUNCTION_QUARK( CORE_ztsmlq_corner_quark, TSMLQ )
FUNCTION_QUARK( CORE_ztsmlq_hetra1_quark, TSMLQ )
FUNCTION_QUARK( CORE_ztsmqr_quark, TSMQR )
FUNCTION_QUARK( CORE_ztsmqr_corner_quark, TSMQR )
FUNCTION_QUARK( CORE_ztsmqr_hetra1_quark, TSMQR )
FUNCTION_QUARK( CORE_ztsqrt_quark, TSQRT )
FUNCTION_QUARK( CORE_ztstrf_quark, TSTRF )
FUNCTION_QUARK( CORE_zttlqt_quark, TTLQT )
FUNCTION_QUARK( CORE_zttmlq_quark, TTMLQ )
FUNCTION_QUARK( CORE_zttmqr_quark, TTMQR )
FUNCTION_QUARK( CORE_zttqrt_quark, TTQRT )
FUNCTION_QUARK( CORE_zunmlq_quark, UNMLQ )
FUNCTION_QUARK( CORE_zunmqr_quark, UNMQR )

