/**
 *
 * @generated s
 *
 **/
#define _TYPE  float
#define _PREC  float
#define _LAMCH LAPACKE_slamch_work

#define _NAME  "PLASMA_spotri_Tile"
/* See Lawn 41 page 120 */
#define _FMULS (n * (float)(1.0 / 2.0 * n + 1.5) * n)
#define _FADDS (n * (float)(1.0 / 2.0 * n - 0.5) * n)

#include "./timing.c"

static int
RunTest(int *iparam, float *dparam, real_Double_t *t_) 
{
    float *AT;
    real_Double_t       t;
    PLASMA_desc        *descA;
    int nb, nb2, nt;
    int n     = iparam[TIMING_N];
    int check = iparam[TIMING_CHECK];
    PLASMA_enum uplo = PlasmaLower;

    /* Initialize Plasma */ 
    PLASMA_Init( iparam[TIMING_THRDNBR] );
    if ( iparam[TIMING_SCHEDULER] )
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_DYNAMIC_SCHEDULING );
    else
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_STATIC_SCHEDULING );

    /*if ( !iparam[TIMING_AUTOTUNING] ) {*/
        PLASMA_Disable(PLASMA_AUTOTUNING);
        PLASMA_Set(PLASMA_TILE_SIZE,        iparam[TIMING_NB] );
    /* } else { */
    /*     PLASMA_Get(PLASMA_TILE_SIZE,        &iparam[TIMING_NB] ); */
    /* }  */
    nb  = iparam[TIMING_NB];
    nb2 = nb * nb;
    nt  = n / nb + ((n % nb == 0) ? 0 : 1);
    
    /* Allocate Data */
    AT = (float *)malloc(nt*nt*nb2*sizeof(float));

    /* Check if unable to allocate memory */
    if ( !AT ){
        printf("Out of Memory \n ");
        exit(0);
    }

    /* Initialiaze Data */
    PLASMA_Desc_Create(&descA, AT, PlasmaRealFloat, nb, nb, nb*nb, n, n, 0, 0, n, n);
    PLASMA_splgsy_Tile( (float)n, descA, 51 );

    /* Save AT in lapack layout for check */
    if ( check ) {
    }

    /* PLASMA SPOTRF / ZTRTRI / ZLAUUM  */
    {
      PLASMA_sequence *sequence = NULL;
      PLASMA_request request[2] = { PLASMA_REQUEST_INITIALIZER, 
                                    PLASMA_REQUEST_INITIALIZER };

      PLASMA_Sequence_Create(&sequence);

      t = -cWtime();
      PLASMA_spotrf_Tile_Async(uplo, descA, sequence, &request[0]);
      PLASMA_spotri_Tile_Async(uplo, descA, sequence, &request[1]);
      PLASMA_Sequence_Wait(sequence);
      t += cWtime();
      *t_ = t;

      PLASMA_Sequence_Destroy(sequence);
    }


    /* Check the solution */
    if ( check )
    {
        dparam[TIMING_ANORM] = 0.0;
        dparam[TIMING_XNORM] = 0.0;
        dparam[TIMING_BNORM] = 0.0;
        dparam[TIMING_RES]   = 0.0;
    }

    PLASMA_Desc_Destroy(&descA);
    PLASMA_Finalize();
    free(AT);

    return 0;
}
