/**
 *
 * @generated c
 *
 **/
#define _TYPE  PLASMA_Complex32_t
#define _PREC  float
#define _LAMCH LAPACKE_slamch_work

#define _NAME  "PLASMA_cpotrf"
/* See Lawn 41 page 120 */
#define _FMULS (n * (1.0 / 6.0 * n + 0.5) * n)
#define _FADDS (n * (1.0 / 6.0 * n )      * n)

#include "./timing.c"

static int
RunTest(int *iparam, float *dparam, real_Double_t *t_) 
{
    PLASMA_Complex32_t *A, *Acpy, *b, *x;
    real_Double_t       t;
    int n     = iparam[TIMING_N];
    int nrhs  = iparam[TIMING_NRHS];
    int check = iparam[TIMING_CHECK];
    int lda = n;
    int ldb = n;
    int uplo = PlasmaLower;

    /* Allocate Data */
    A = (PLASMA_Complex32_t *)malloc(lda*n*   sizeof(PLASMA_Complex32_t));

    /* Check if unable to allocate memory */
    if ( !A ) {
        printf("Out of Memory \n ");
        exit(0);
    }
    
    /* Initialize Plasma */ 
    PLASMA_Init( iparam[TIMING_THRDNBR] );
    if ( iparam[TIMING_SCHEDULER] )
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_DYNAMIC_SCHEDULING );
    else
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_STATIC_SCHEDULING );

    /*if ( !iparam[TIMING_AUTOTUNING] ) {*/
    PLASMA_Disable(PLASMA_AUTOTUNING);
    PLASMA_Set(PLASMA_TILE_SIZE, iparam[TIMING_NB] );
    /* } */

    /* Initialiaze Data */
    PLASMA_cplghe( (float)n, n, A, lda, 51 );

    /* Save A and b  */
    if (check) {
        Acpy = (PLASMA_Complex32_t *)malloc(lda*n*sizeof(PLASMA_Complex32_t));
        LAPACKE_clacpy_work(LAPACK_COL_MAJOR,' ', n, n, A, lda, Acpy, lda);
    }

    /* PLASMA CPOSV */
    t = -cWtime();
    PLASMA_cpotrf(uplo, n, A, lda);
    t += cWtime();
    *t_ = t;

    /* Check the solution */
    if (check)
      {
        b = (PLASMA_Complex32_t *)malloc(ldb*nrhs*sizeof(PLASMA_Complex32_t));
        x = (PLASMA_Complex32_t *)malloc(ldb*nrhs*sizeof(PLASMA_Complex32_t));
        LAPACKE_clarnv_work(1, ISEED, n*nrhs, x);
        LAPACKE_clacpy_work(LAPACK_COL_MAJOR, 'A', n, nrhs, x, ldb, b, ldb);

        PLASMA_cpotrs(uplo, n, nrhs, A, lda, x, ldb);

        dparam[TIMING_RES] = ccheck_solution(n, n, nrhs, Acpy, lda, b, x, ldb,
                                             &(dparam[TIMING_ANORM]), 
                                             &(dparam[TIMING_BNORM]),
                                             &(dparam[TIMING_XNORM]));

        free(Acpy); free(b); free(x);
      }

    free(A);

    PLASMA_Finalize();

    return 0;
}
