/**
 *
 * @file workspace_s.h
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.1
 * @author Jakub Kurzak
 * @date 2010-11-15
 * @generated s
 *
 **/
#ifndef _WORKSPACE_Z_H_
#define _WORKSPACE_Z_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  User routines
 **/
int PLASMA_Alloc_Workspace_sgels(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgeqrf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgelqf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgesv(int N, float **L, int **IPIV);
int PLASMA_Alloc_Workspace_sgetrf(int M, int N, float **L, int **IPIV);

int PLASMA_Alloc_Workspace_sgels_Tile (int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgeqrf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgelqf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgesv_Tile (int N, PLASMA_desc **descL, int **IPIV);
int PLASMA_Alloc_Workspace_sgetrf_Tile(int N, PLASMA_desc **descL, int **IPIV);
#ifdef __cplusplus
}
#endif

#endif
