/**
 *
 * @file plasma_df77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.1
 * @author Bilel Hadri
 * @date 2010-11-15
 * @generated d
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef COMPLEX
#define REAL

#ifdef ADD_
    #define PLASMA_DGELQF       plasma_dgelqf_
    #define PLASMA_DGELQS       plasma_dgelqs_
    #define PLASMA_DGELS        plasma_dgels_
    #define PLASMA_DGEQRF       plasma_dgeqrf_
    #define PLASMA_DGEQRS       plasma_dgeqrs_
    #define PLASMA_DGESV        plasma_dgesv_
    #define PLASMA_DGETRF       plasma_dgetrf_
    #define PLASMA_DGETRS       plasma_dgetrs_
    #define PLASMA_DPOSV        plasma_dposv_
    #define PLASMA_DPOTRF       plasma_dpotrf_
    #define PLASMA_DPOTRI       plasma_dpotri_
    #define PLASMA_DPOTRS       plasma_dpotrs_
    #define PLASMA_DTRSMPL      plasma_dtrsmpl_
    #define PLASMA_DORGLQ       plasma_dorglq_
    #define PLASMA_DORGQR       plasma_dorgqr_
    #define PLASMA_DORMLQ       plasma_dormlq_
    #define PLASMA_DORMQR       plasma_dormqr_
    #define PLASMA_DTRSM        plasma_dtrsm_
    #define PLASMA_DGEMM        plasma_dgemm_
    #define PLASMA_DSYMM        plasma_dsymm_
    #define PLASMA_DSYRK        plasma_dsyrk_
#ifdef COMPLEX
    #define PLASMA_DSYMM        plasma_dsymm_
    #define PLASMA_DSYRK        plasma_dsyrk_
#endif

    #define PLASMA_DGELQF_TILE      plasma_dgelqf_tile_
    #define PLASMA_DGELQS_TILE      plasma_dgelqs_tile_
    #define PLASMA_DGELS_TILE       plasma_dgels_tile_
    #define PLASMA_DGEQRF_TILE      plasma_dgeqrf_tile_
    #define PLASMA_DGEQRS_TILE      plasma_dgeqrs_tile_
    #define PLASMA_DGESV_TILE       plasma_dgesv_tile_
    #define PLASMA_DGETRF_TILE      plasma_dgetrf_tile_
    #define PLASMA_DGETRS_TILE      plasma_dgetrs_tile_
    #define PLASMA_DPOSV_TILE       plasma_dposv_tile_
    #define PLASMA_DPOTRF_TILE      plasma_dpotrf_tile_
    #define PLASMA_DPOTRI_TILE      plasma_dpotri_tile_
    #define PLASMA_DPOTRS_TILE      plasma_dpotrs_tile_
    #define PLASMA_DTRSM_TILE       plasma_dtrsm_tile_
    #define PLASMA_DTRSMPL_TILE     plasma_dtrsmpl_tile_
    #define PLASMA_DORGLQ_TILE      plasma_dorglq_tile_
    #define PLASMA_DORGQR_TILE      plasma_dorgqr_tile_
    #define PLASMA_DORMLQ_TILE      plasma_dormlq_tile_
    #define PLASMA_DORMQR_TILE      plasma_dormqr_tile_
    #define PLASMA_DGEMM_TILE       plasma_dgemm_tile_
    #define PLASMA_DSYMM_TILE       plasma_dsymm_tile_
    #define PLASMA_DSYRK_TILE       plasma_dsyrk_tile_
#ifdef COMPLEX
    #define PLASMA_DSYMM_TILE       plasma_dsymm_tile_
    #define PLASMA_DSYRK_TILE       plasma_dsyrk_tile_
#endif

    #define PLASMA_ALLOC_WORKSPACE_DGELQF       plasma_alloc_workspace_dgelqf_
    #define PLASMA_ALLOC_WORKSPACE_DGELS        plasma_alloc_workspace_dgels_
    #define PLASMA_ALLOC_WORKSPACE_DGEQRF       plasma_alloc_workspace_dgeqrf_
    #define PLASMA_ALLOC_WORKSPACE_DGESV        plasma_alloc_workspace_dgesv_
    #define PLASMA_ALLOC_WORKSPACE_DGETRF       plasma_alloc_workspace_dgetrf_
    #define PLASMA_ALLOC_WORKSPACE_DGELQF       plasma_alloc_workspace_dgelqf_

    #define PLASMA_DLAPACK_TO_TILE   plasma_dlapack_to_tile_
    #define PLASMA_DTILE_TO_LAPACK   plasma_dtile_to_lapack_

#elif defined (NOCHANGE)
    #define PLASMA_DGELQF       plasma_dgelqf
    #define PLASMA_DGELQS       plasma_dgelqs
    #define PLASMA_DGELS        plasma_dgels
    #define PLASMA_DGEQRF       plasma_dgeqrf
    #define PLASMA_DGEQRS       plasma_dgeqrs
    #define PLASMA_DGESV        plasma_dgesv
    #define PLASMA_DGETRF       plasma_dgetrf
    #define PLASMA_DGETRS       plasma_dgetrs
    #define PLASMA_DPOSV        plasma_dposv
    #define PLASMA_DPOTRF       plasma_dpotrf
    #define PLASMA_DPOTRI       plasma_dpotri
    #define PLASMA_DPOTRS       plasma_dpotrs
    #define PLASMA_DTRSM        plasma_dtrsm
    #define PLASMA_DTRSMPL      plasma_dtrsmpl
    #define PLASMA_DORGLQ       plasma_dorglq
    #define PLASMA_DORGQR       plasma_dorgqr
    #define PLASMA_DORMLQ       plasma_dormlq
    #define PLASMA_DORMQR       plasma_dormqr
    #define PLASMA_DGEMM        plasma_dgemm
    #define PLASMA_DSYMM        plasma_dsymm
    #define PLASMA_DSYRK        plasma_dsyrk
#ifdef COMPLEX
    #define PLASMA_DSYMM        plasma_dsymm
    #define PLASMA_DSYRK        plasma_dsyrk
#endif

    #define PLASMA_DGELQF_TILE      plasma_dgelqf_tile
    #define PLASMA_DGELQS_TILE      plasma_dgelqs_tile
    #define PLASMA_DGELS_TILE       plasma_dgels_tile
    #define PLASMA_DGEQRF_TILE      plasma_dgeqrf_tile
    #define PLASMA_DGEQRS_TILE      plasma_dgeqrs_tile
    #define PLASMA_DGESV_TILE       plasma_dgesv_tile
    #define PLASMA_DGETRF_TILE      plasma_dgetrf_tile
    #define PLASMA_DGETRS_TILE      plasma_dgetrs_tile
    #define PLASMA_DPOSV_TILE       plasma_dposv_tile
    #define PLASMA_DPOTRF_TILE      plasma_dpotrf_tile
    #define PLASMA_DPOTRI_TILE      plasma_dpotri_tile
    #define PLASMA_DPOTRS_TILE      plasma_dpotrs_tile
    #define PLASMA_DTRSM_TILE       plasma_dtrsm_tile
    #define PLASMA_DTRSMPL_TILE     plasma_dtrsmpl_tile
    #define PLASMA_DORGLQ_TILE      plasma_dorglq_tile
    #define PLASMA_DORGQR_TILE      plasma_dorgqr_tile
    #define PLASMA_DORMLQ_TILE      plasma_dormlq_tile
    #define PLASMA_DORMQR_TILE      plasma_dormqr_tile
    #define PLASMA_DGEMM_TILE       plasma_dgemm_tile
    #define PLASMA_DSYMM_TILE       plasma_dsymm_tile
    #define PLASMA_DSYRK_TILE       plasma_dsyrk_tile
#ifdef COMPLEX
    #define PLASMA_DSYMM_TILE       plasma_dsymm_tile
    #define PLASMA_DSYRK_TILE       plasma_dsyrk_tile
#endif

    #define PLASMA_ALLOC_WORKSPACE_DGELQF       plasma_alloc_workspace_dgelqf
    #define PLASMA_ALLOC_WORKSPACE_DGELS        plasma_alloc_workspace_dgels
    #define PLASMA_ALLOC_WORKSPACE_DGEQRF       plasma_alloc_workspace_dgeqrf
    #define PLASMA_ALLOC_WORKSPACE_DGESV        plasma_alloc_workspace_dgesv
    #define PLASMA_ALLOC_WORKSPACE_DGETRF       plasma_alloc_workspace_dgetrf

    #define PLASMA_DLAPACK_TO_TILE   plasma_dlapack_to_tile
    #define PLASMA_DTILE_TO_LAPACK   plasma_dtile_to_lapack
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_DGELQF(int *M, int *N, double *A, int *LDA, double **T, int *INFO)
{   *INFO = PLASMA_dgelqf(*M, *N, A, *LDA, *T); }

void PLASMA_DGELQS(int *M, int *N, int *NRHS, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dgelqs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_DGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dgels(*trans, *M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_DGEQRF(int *M, int *N, double *A, int *LDA, double **T, int *INFO)
{   *INFO = PLASMA_dgeqrf(*M, *N, A, *LDA, *T); }

void PLASMA_DGEQRS(int *M, int *N, int *NRHS, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dgeqrs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_DGESV(int *N, int *NRHS, double *A, int *LDA, double **LH, int **IPIVH, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dgesv(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_DGETRF(int *M, int *N, double *A, int *LDA, double **LH, int **IPIVH, int *INFO)
{   *INFO = PLASMA_dgetrf(*M, *N, A, *LDA, *LH, *IPIVH); }

void PLASMA_DGETRS(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double **LH, int **IPIVH, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dgetrs(*uplo, *N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_DPOSV(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_DPOTRF(PLASMA_enum *uplo, int *N, double *A, int *LDA, int *INFO)
{   *INFO = PLASMA_dpotrf(*uplo, *N, A, *LDA); }

void PLASMA_DPOTRI(PLASMA_enum *uplo, int *N, double *A, int *LDA, int *INFO)
{   *INFO = PLASMA_dpotri(*uplo, *N, A, *LDA); }

void PLASMA_DPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double *B, int* LDB, int * INFO)
{   *INFO = PLASMA_dpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_DTRSMPL(int *N, int *NRHS, double *A, int *LDA, double **LH, int **IPIVH, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dtrsmpl(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_DORGLQ(int *M, int *N, int *K, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dorglq(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_DORGQR(int *M, int *N, int *K, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dorgqr(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_DORMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dormlq(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_DORMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, double *A, int *LDA, double **T, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dormqr(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_DTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, double *alpha, double *A, int *LDA, double *B, int *LDB, int *INFO)
{   *INFO = PLASMA_dtrsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_DGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *INFO)
{   *INFO = PLASMA_dgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *INFO)
{   *INFO = PLASMA_dsymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *beta, double *C, int *LDC, int *INFO)
{   *INFO = PLASMA_dsyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

#ifdef COMPLEX
void PLASMA_DSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, double *alpha, double *A, int *LDA, double *B, int *LDB, double *beta, double *C, int *LDC, int *INFO)
{   *INFO = PLASMA_dsymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_DSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, double *alpha, double *A, int *LDA, double *beta, double *C, int *LDC, int *INFO)
{   *INFO = PLASMA_dsyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_DGELQF_TILE(intptr_t *A, intptr_t *T,int *INFO)
{   *INFO = PLASMA_dgelqf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_DGELQS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_dgelqs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_DGELS_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_dgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_DGEQRF_TILE(intptr_t *A, intptr_t *T, int *INFO)
{   *INFO = PLASMA_dgeqrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_DGEQRS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_dgeqrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_DGESV_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_DGETRF_TILE(intptr_t *A, intptr_t *L, int **IPIVH, int *INFO)
{   *INFO = PLASMA_dgetrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH); }

void PLASMA_DGETRS_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dgetrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_DPOSV_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_DPOTRF_TILE(PLASMA_enum *uplo, intptr_t *A, int *INFO)
{   *INFO = PLASMA_dpotrf_Tile(*uplo, (PLASMA_desc *)(*A)); }

void PLASMA_DPOTRS_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dpotrs_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_DTRSMPL_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dtrsmpl_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_DUNQLQ_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dorglq_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_DORGQR_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dorgqr_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_DORMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dormlq_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_DORMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dormqr_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_DTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, double *alpha, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_dtrsm_Tile(*side, *uplo, *transA, *diag, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_DGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, int *alpha, intptr_t *A, intptr_t *B, int *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_dgemm_Tile(*transA, *transB, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

  void PLASMA_DSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, intptr_t *A, intptr_t *B, double *beta, intptr_t *C, int *INFO)
  {   *INFO = PLASMA_dsymm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_DSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, intptr_t *A, double *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_dsyrk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }

#ifdef COMPLEX
void PLASMA_DSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, double *alpha, intptr_t *A, intptr_t *B, double *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_dsymm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_DSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, double *alpha, intptr_t *A, double *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_dsyrk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }
#endif

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_DGELQF(int *M, int *N, double **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_dgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGELS(int *M, int *N, double **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_dgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGEQRF(int *M, int *N, double **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_dgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_DGESV(int *N, double **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_dgesv(*N, L, IPIV); }

void PLASMA_ALLOC_WORKSPACE_DGETRF(int *M, int *N, double **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_dgetrf(*M, *N, L, IPIV); }

/***************************************************************************//**
 *  FORTRAN API - conversion from LAPACK F77 matrix layout to tile layout
 **/
void PLASMA_DLAPACK_TO_TILE(double **Af77, int *LDA, intptr_t *A, int *INFO)
{   *INFO = PLASMA_dLapack_to_Tile( *Af77, *LDA, (PLASMA_desc *)(*A) ); }

void PLASMA_DTILE_TO_LAPACK(intptr_t *A, double **Af77, int *LDA, int *INFO)
{   *INFO = PLASMA_dTile_to_Lapack( (PLASMA_desc *)(*A), *Af77, *LDA ); }

#ifdef __cplusplus
}
#endif
