/**
 *
 * @file psormlqrh.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.1
 * @author Hatem Ltaief
 * @author Jakub Kurzak
 * @date 2010-11-15
 * @generated s
 *
 **/
#include "common.h"

#define A(m,n) BLKADDR(A, float, m, n)
#define B(m,n) BLKADDR(B, float, m, n)
#define T(m,n) BLKADDR(T, float, m, n)
/***************************************************************************//**
 *  Parallel application of Q using tile V - LQ factorization - dynamic scheduling
 **/
void plasma_psormlqrh_quark(PLASMA_desc A, PLASMA_desc B, PLASMA_desc T, int block_size,
                            PLASMA_sequence *sequence, PLASMA_request *request)
{
    plasma_context_t *plasma;
    Quark_Task_Flags task_flags = Quark_Task_Flags_Initializer;

    int k, m, n;
    int ldak, ldbk, ldbm;
    int tempmm, tempnn, tempkm, tempkn, tempkmin;
    int ib;

    plasma = plasma_context_self();
    if (sequence->status != PLASMA_SUCCESS)
        return;
    QUARK_Task_Flag_Set(&task_flags, TASK_SEQUENCE, (intptr_t)sequence->quark_sequence);

    ib = PLASMA_IB;
    for (k = min(A.mt, A.nt)-1; k >= 0; k--) {
        tempkm = k == A.mt-1 ? A.m-k*A.mb : A.mb;
        tempkn = k == A.nt-1 ? A.n-k*A.nb : A.nb;
        ldak = BLKLDD(A, k);
        ldbk = BLKLDD(B, k);
        for (n = 0; n < B.nt; n++) {
            tempnn   = n == B.nt-1 ? B.n-n*B.nb : B.nb;
            tempkmin = k == min(A.mt, A.nt)-1 ? min(A.m, A.n)-k*A.nb : A.nb;
            for (m = B.mt-1; m > k; m--) {
                tempmm = m == B.mt-1 ? B.m-m*B.mb : B.mb;
                ldbm = BLKLDD(B, m);
                QUARK_CORE_stsmlq(
                    plasma->quark, &task_flags,
                    PlasmaLeft, PlasmaTrans,
                    tempnn, A.nb, tempnn, tempmm, tempkm, ib, T.nb,
                    B(k, n), ldbk,
                    B(m, n), ldbm,
                    A(k, m), ldak,
                    T(k, m), T.mb);
            }
            QUARK_CORE_sormlq(
                plasma->quark, &task_flags,
                PlasmaLeft, PlasmaTrans,
                tempkn, tempnn, tempkmin, ib, T.nb,
                A(k, k), ldak,
                T(k, k), T.mb,
                B(k, n), ldbk);
        }
    }
}
