/**
 *
 * @file pdormlq.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.1
 * @author Hatem Ltaief
 * @author Jakub Kurzak
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated d
 *
 **/
#include "common.h"

#define A(m,n) BLKADDR(A, double, m, n)
#define B(m,n) BLKADDR(B, double, m, n)
#define T(m,n) BLKADDR(T, double, m, n)
/***************************************************************************//**
 *  Parallel application of Q using tile V - LQ factorization - static scheduling
 **/
void plasma_pdormlq(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc B;
    PLASMA_desc T;
    PLASMA_sequence *sequence;
    PLASMA_request *request;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;
    int ldak, ldbk, ldbm;
    int tempmm, tempnn, tempkm, tempkn, tempkmin;
    int ib = PLASMA_IB;
    double *work;

    plasma_unpack_args_5(A, B, T, sequence, request);
    if (sequence->status != PLASMA_SUCCESS)
        return;
    work = (double*)plasma_private_alloc(plasma, ib*T.nb, T.dtyp);
    ss_init(B.mt, B.nt, min(A.mt, A.nt));

    k = min(A.mt, A.nt)-1;
    n = PLASMA_RANK;
    while (n >= B.nt) {
        k--;
        n = n-B.nt;
    }
    m = B.mt-1;

    while (k >= 0 && n < B.nt) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m--;
        if (next_m == k-1) {
            next_n += PLASMA_SIZE;
            while (next_n >= B.nt && next_k >= 0) {
                next_k--;
                next_n = next_n-B.nt;
            }
            next_m = B.mt-1;
        }

        tempkm   = k == A.mt-1 ? A.m-k*A.mb : A.mb;
        tempkn   = k == A.nt-1 ? A.n-k*A.nb : A.nb;
        tempnn   = n == B.nt-1 ? B.n-n*B.nb : B.nb;
        tempkmin = k == min(A.mt, A.nt)-1 ? min(A.m, A.n)-k*A.nb : A.nb;
        tempmm   = m == B.mt-1 ? B.m-m*B.mb : B.mb;

        ldak = BLKLDD(A, k);
        ldbk = BLKLDD(B, k);
        ldbm = BLKLDD(B, m);

        if (m == k) {
            CORE_dormlq(
                PlasmaLeft, PlasmaTrans,
                tempkn, tempnn, tempkmin, ib,
                A(k, k), ldak,
                T(k, k), T.mb,
                B(k, n), ldbk,
                work, T.nb);
            ss_cond_set(k, n, k);
        }
        else {
            ss_cond_wait(m, n, k+1);
            CORE_dtsmlq(
                PlasmaLeft, PlasmaTrans,
                tempnn, A.nb, tempnn, tempmm, tempkm, ib,
                B(k, n), ldbk,
                B(m, n), ldbm,
                A(k, m), ldak,
                T(k, m), T.mb,
                work, ib);
            ss_cond_set(m, n, k);
        }
        m = next_m;
        n = next_n;
        k = next_k;
    }
    plasma_private_free(plasma, work);
    ss_finalize();
}

/***************************************************************************//**
 *  Parallel application of Q using tile V - LQ factorization - dynamic scheduling
 **/
void plasma_pdormlq_quark(PLASMA_desc A, PLASMA_desc B, PLASMA_desc T,
                          PLASMA_sequence *sequence, PLASMA_request *request)
{
    plasma_context_t *plasma;
    Quark_Task_Flags task_flags = Quark_Task_Flags_Initializer;

    int k, m, n;
    int ldak, ldbk, ldbm;
    int tempmm, tempnn, tempkm, tempkn, tempkmin;
    int ib;

    plasma = plasma_context_self();
    if (sequence->status != PLASMA_SUCCESS)
        return;
    QUARK_Task_Flag_Set(&task_flags, TASK_SEQUENCE, (intptr_t)sequence->quark_sequence);

    ib = PLASMA_IB;
    for (k = min(A.mt, A.nt)-1; k >= 0; k--) {
        tempkm = k == A.mt-1 ? A.m-k*A.mb : A.mb;
        tempkn = k == A.nt-1 ? A.n-k*A.nb : A.nb;
        ldak = BLKLDD(A, k);
        ldbk = BLKLDD(B, k);
        for (n = 0; n < B.nt; n++) {
            tempnn   = n == B.nt-1 ? B.n-n*B.nb : B.nb;
            tempkmin = k == min(A.mt, A.nt)-1 ? min(A.m, A.n)-k*A.nb : A.nb;
            for (m = B.mt-1; m > k; m--) {
                tempmm = m == B.mt-1 ? B.m-m*B.mb : B.mb;
                ldbm = BLKLDD(B, m);
                QUARK_CORE_dtsmlq(
                    plasma->quark, &task_flags,
                    PlasmaLeft, PlasmaTrans,
                    tempnn, A.nb, tempnn, tempmm, tempkm, ib, T.nb,
                    B(k, n), ldbk,
                    B(m, n), ldbm,
                    A(k, m), ldak,
                    T(k, m), T.mb);
            }
            QUARK_CORE_dormlq(
                plasma->quark, &task_flags,
                PlasmaLeft, PlasmaTrans,
                tempkn, tempnn, tempkmin, ib, T.nb,
                A(k, k), ldak,
                T(k, k), T.mb,
                B(k, n), ldbk);
        }
    }
}
