/**
 *
 * @file pcunmqrrh.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.1
 * @author Hatem Ltaief
 * @author Jakub Kurzak
 * @date 2010-11-15
 * @generated c
 *
 **/
#include "common.h"

#define A(m,n)  BLKADDR(A, PLASMA_Complex32_t, (m), (n))
#define B(m,n)  BLKADDR(B, PLASMA_Complex32_t, (m), (n))
#define T(m,n)  BLKADDR(T, PLASMA_Complex32_t, (m), (n))
#define T2(m,n) BLKADDR(T, PLASMA_Complex32_t, (m), (n)+A.nt)
/***************************************************************************//**
 *  Parallel application of Q using tile V - QR factorization (reduction Householder)
 *  - dynamic scheduling
 **/
void plasma_pcunmqrrh_quark(PLASMA_desc A, PLASMA_desc B, PLASMA_desc T, int BS,
                            PLASMA_sequence *sequence, PLASMA_request *request)
{
    plasma_context_t *plasma;
    Quark_Task_Flags task_flags = Quark_Task_Flags_Initializer;

    int k, m, n;
    int K, M, RD;
    int ldaM, ldam, ldaMRD;
    int ldbM, ldbm, ldbMRD;
    int tempkn, tempMm, tempMmin, tempnn, tempmm, tempMRDm;
    int ib;

    plasma = plasma_context_self();
    if (sequence->status != PLASMA_SUCCESS)
        return;
    QUARK_Task_Flag_Set(&task_flags, TASK_SEQUENCE, (intptr_t)sequence->quark_sequence);

    ib = PLASMA_IB;
    K = min(A.mt, A.nt);

    for (k = 0; k < K; k++) {
        tempkn = k == A.nt-1 ? A.n-k*A.nb : A.nb;
//      for (M = k; M < A.mt; M += BS) {
        for (M = k;
             M < A.mt-1 || M == k;  // No bottom single-row subdomain
             M += BS) {
            tempMm   = M == A.mt-1 ? A.m-M*A.mb : A.mb;
            tempMmin = M == min(A.mt, A.nt)-1 ? min(A.m, A.n)-M*A.mb : A.mb;
            ldaM = BLKLDD(A, M);
            ldbM = BLKLDD(B, M);
            for (n = 0; n < B.nt; n++) {
                tempnn = n == B.nt-1 ? B.n-n*B.nb : B.nb;
                QUARK_CORE_cunmqr(
                    plasma->quark, &task_flags,
                    PlasmaLeft, PlasmaConjTrans,
                    tempMm, tempnn, tempMmin, ib, T.nb,
                    A(M, k), ldaM,
                    T(M, k), T.mb,
                    B(M, n), ldbM);
            }
//          for (m = M+1; m < M+BS && m < A.mt; m++) {
            for (m = M+1;
                 (m < M+BS && m < A.mt) || m == A.mt-1; // Suck in bottom single-row domain
                 m++) {
                tempmm = m == A.mt-1 ? A.m-m*A.mb : A.mb;
                ldbm = BLKLDD(B, m);
                ldam = BLKLDD(A, m);
                for (n = 0; n < B.nt; n++) {
                    tempnn = n == B.nt-1 ? B.n-n*B.nb : B.nb;
                    QUARK_CORE_ctsmqr(
                        plasma->quark, &task_flags,
                        PlasmaLeft, PlasmaConjTrans,
                        A.nb, tempnn, tempmm, tempnn, tempkn, ib, T.nb,
                        B(M, n), ldbM,
                        B(m, n), ldbm,
                        A(m, k), ldam,
                        T(m, k), T.mb);
                }
            }
        }
        for (RD = BS; RD < A.mt-k; RD *= 2) {
//          for (M = k; M+RD < A.mt; M += 2*RD) {
            for (M = k;
                 M+RD < A.mt-1; // No reduction with bottom single-row subdomain
                 M += 2*RD) {
                tempMRDm = M+RD == A.mt-1 ? A.m-(M+RD)*A.mb : A.mb;
                ldbM   = BLKLDD(B, M   );
                ldbMRD = BLKLDD(B, M+RD);
                ldaMRD = BLKLDD(A, M+RD);
                for (n = 0; n < B.nt; n++) {
                    tempnn = n == B.nt-1 ? B.n-n*B.nb : B.nb;
                    QUARK_CORE_cttmqr(
                        plasma->quark, &task_flags,
                        PlasmaLeft, PlasmaConjTrans,
                        A.nb, tempnn, tempMRDm, tempnn, tempkn, ib, T.nb,
                        B (M,    n), ldbM,
                        B (M+RD, n), ldbMRD,
                        A (M+RD, k), ldaMRD,
                        T2(M+RD, k), T.mb);
                }
            }
        }
    }
}
