/**
 *
 * @file plasma_sf77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.0
 * @author Bilel Hadri
 * @date 2010-11-15
 * @generated s
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef COMPLEX
#define REAL

#ifdef ADD_
    #define PLASMA_SGELQF       plasma_sgelqf_
    #define PLASMA_SGELQS       plasma_sgelqs_
    #define PLASMA_SGELS        plasma_sgels_
    #define PLASMA_SGEQRF       plasma_sgeqrf_
    #define PLASMA_SGEQRS       plasma_sgeqrs_
    #define PLASMA_SGESV        plasma_sgesv_
    #define PLASMA_SGETRF       plasma_sgetrf_
    #define PLASMA_SGETRS       plasma_sgetrs_
    #define PLASMA_SPOSV        plasma_sposv_
    #define PLASMA_SPOTRF       plasma_spotrf_
    #define PLASMA_SPOTRI       plasma_spotri_
    #define PLASMA_SPOTRS       plasma_spotrs_
    #define PLASMA_STRSMPL      plasma_strsmpl_
    #define PLASMA_SORGLQ       plasma_sorglq_
    #define PLASMA_SORGQR       plasma_sorgqr_
    #define PLASMA_SORMLQ       plasma_sormlq_
    #define PLASMA_SORMQR       plasma_sormqr_
    #define PLASMA_STRSM        plasma_strsm_
    #define PLASMA_SGEMM        plasma_sgemm_
    #define PLASMA_SSYMM        plasma_ssymm_
    #define PLASMA_SSYRK        plasma_ssyrk_
#ifdef COMPLEX
    #define PLASMA_SSYMM        plasma_ssymm_
    #define PLASMA_SSYRK        plasma_ssyrk_
#endif

    #define PLASMA_SGELQF_TILE      plasma_sgelqf_tile_
    #define PLASMA_SGELQS_TILE      plasma_sgelqs_tile_
    #define PLASMA_SGELS_TILE       plasma_sgels_tile_
    #define PLASMA_SGEQRF_TILE      plasma_sgeqrf_tile_
    #define PLASMA_SGEQRS_TILE      plasma_sgeqrs_tile_
    #define PLASMA_SGESV_TILE       plasma_sgesv_tile_
    #define PLASMA_SGETRF_TILE      plasma_sgetrf_tile_
    #define PLASMA_SGETRS_TILE      plasma_sgetrs_tile_
    #define PLASMA_SPOSV_TILE       plasma_sposv_tile_
    #define PLASMA_SPOTRF_TILE      plasma_spotrf_tile_
    #define PLASMA_SPOTRI_TILE      plasma_spotri_tile_
    #define PLASMA_SPOTRS_TILE      plasma_spotrs_tile_
    #define PLASMA_STRSM_TILE       plasma_strsm_tile_
    #define PLASMA_STRSMPL_TILE     plasma_strsmpl_tile_
    #define PLASMA_SORGLQ_TILE      plasma_sorglq_tile_
    #define PLASMA_SORGQR_TILE      plasma_sorgqr_tile_
    #define PLASMA_SORMLQ_TILE      plasma_sormlq_tile_
    #define PLASMA_SORMQR_TILE      plasma_sormqr_tile_
    #define PLASMA_SGEMM_TILE       plasma_sgemm_tile_
    #define PLASMA_SSYMM_TILE       plasma_ssymm_tile_
    #define PLASMA_SSYRK_TILE       plasma_ssyrk_tile_
#ifdef COMPLEX
    #define PLASMA_SSYMM_TILE       plasma_ssymm_tile_
    #define PLASMA_SSYRK_TILE       plasma_ssyrk_tile_
#endif

    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf_
    #define PLASMA_ALLOC_WORKSPACE_SGELS        plasma_alloc_workspace_sgels_
    #define PLASMA_ALLOC_WORKSPACE_SGEQRF       plasma_alloc_workspace_sgeqrf_
    #define PLASMA_ALLOC_WORKSPACE_SGESV        plasma_alloc_workspace_sgesv_
    #define PLASMA_ALLOC_WORKSPACE_SGETRF       plasma_alloc_workspace_sgetrf_
    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf_

    #define PLASMA_SLAPACK_TO_TILE   plasma_slapack_to_tile_
    #define PLASMA_STILE_TO_LAPACK   plasma_stile_to_lapack_

#elif defined (NOCHANGE)
    #define PLASMA_SGELQF       plasma_sgelqf
    #define PLASMA_SGELQS       plasma_sgelqs
    #define PLASMA_SGELS        plasma_sgels
    #define PLASMA_SGEQRF       plasma_sgeqrf
    #define PLASMA_SGEQRS       plasma_sgeqrs
    #define PLASMA_SGESV        plasma_sgesv
    #define PLASMA_SGETRF       plasma_sgetrf
    #define PLASMA_SGETRS       plasma_sgetrs
    #define PLASMA_SPOSV        plasma_sposv
    #define PLASMA_SPOTRF       plasma_spotrf
    #define PLASMA_SPOTRI       plasma_spotri
    #define PLASMA_SPOTRS       plasma_spotrs
    #define PLASMA_STRSM        plasma_strsm
    #define PLASMA_STRSMPL      plasma_strsmpl
    #define PLASMA_SORGLQ       plasma_sorglq
    #define PLASMA_SORGQR       plasma_sorgqr
    #define PLASMA_SORMLQ       plasma_sormlq
    #define PLASMA_SORMQR       plasma_sormqr
    #define PLASMA_SGEMM        plasma_sgemm
    #define PLASMA_SSYMM        plasma_ssymm
    #define PLASMA_SSYRK        plasma_ssyrk
#ifdef COMPLEX
    #define PLASMA_SSYMM        plasma_ssymm
    #define PLASMA_SSYRK        plasma_ssyrk
#endif

    #define PLASMA_SGELQF_TILE      plasma_sgelqf_tile
    #define PLASMA_SGELQS_TILE      plasma_sgelqs_tile
    #define PLASMA_SGELS_TILE       plasma_sgels_tile
    #define PLASMA_SGEQRF_TILE      plasma_sgeqrf_tile
    #define PLASMA_SGEQRS_TILE      plasma_sgeqrs_tile
    #define PLASMA_SGESV_TILE       plasma_sgesv_tile
    #define PLASMA_SGETRF_TILE      plasma_sgetrf_tile
    #define PLASMA_SGETRS_TILE      plasma_sgetrs_tile
    #define PLASMA_SPOSV_TILE       plasma_sposv_tile
    #define PLASMA_SPOTRF_TILE      plasma_spotrf_tile
    #define PLASMA_SPOTRI_TILE      plasma_spotri_tile
    #define PLASMA_SPOTRS_TILE      plasma_spotrs_tile
    #define PLASMA_STRSM_TILE       plasma_strsm_tile
    #define PLASMA_STRSMPL_TILE     plasma_strsmpl_tile
    #define PLASMA_SORGLQ_TILE      plasma_sorglq_tile
    #define PLASMA_SORGQR_TILE      plasma_sorgqr_tile
    #define PLASMA_SORMLQ_TILE      plasma_sormlq_tile
    #define PLASMA_SORMQR_TILE      plasma_sormqr_tile
    #define PLASMA_SGEMM_TILE       plasma_sgemm_tile
    #define PLASMA_SSYMM_TILE       plasma_ssymm_tile
    #define PLASMA_SSYRK_TILE       plasma_ssyrk_tile
#ifdef COMPLEX
    #define PLASMA_SSYMM_TILE       plasma_ssymm_tile
    #define PLASMA_SSYRK_TILE       plasma_ssyrk_tile
#endif

    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf
    #define PLASMA_ALLOC_WORKSPACE_SGELS        plasma_alloc_workspace_sgels
    #define PLASMA_ALLOC_WORKSPACE_SGEQRF       plasma_alloc_workspace_sgeqrf
    #define PLASMA_ALLOC_WORKSPACE_SGESV        plasma_alloc_workspace_sgesv
    #define PLASMA_ALLOC_WORKSPACE_SGETRF       plasma_alloc_workspace_sgetrf

    #define PLASMA_SLAPACK_TO_TILE   plasma_slapack_to_tile
    #define PLASMA_STILE_TO_LAPACK   plasma_stile_to_lapack
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_SGELQF(int *M, int *N, float *A, int *LDA, float **T, int *INFO)
{   *INFO = PLASMA_sgelqf(*M, *N, A, *LDA, *T); }

void PLASMA_SGELQS(int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgelqs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgels(*trans, *M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGEQRF(int *M, int *N, float *A, int *LDA, float **T, int *INFO)
{   *INFO = PLASMA_sgeqrf(*M, *N, A, *LDA, *T); }

void PLASMA_SGEQRS(int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgeqrs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGESV(int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgesv(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SGETRF(int *M, int *N, float *A, int *LDA, float **LH, int **IPIVH, int *INFO)
{   *INFO = PLASMA_sgetrf(*M, *N, A, *LDA, *LH, *IPIVH); }

void PLASMA_SGETRS(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgetrs(*uplo, *N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SPOSV(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_SPOTRF(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *INFO)
{   *INFO = PLASMA_spotrf(*uplo, *N, A, *LDA); }

void PLASMA_SPOTRI(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *INFO)
{   *INFO = PLASMA_spotri(*uplo, *N, A, *LDA); }

void PLASMA_SPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int* LDB, int * INFO)
{   *INFO = PLASMA_spotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_STRSMPL(int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_strsmpl(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SORGLQ(int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sorglq(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORGQR(int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sorgqr(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sormlq(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sormqr(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_STRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, float *alpha, float *A, int *LDA, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_strsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_SGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_sgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_ssymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_ssyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

#ifdef COMPLEX
void PLASMA_SSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_ssymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_SSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, float *alpha, float *A, int *LDA, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_ssyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_SGELQF_TILE(intptr_t *A, intptr_t *T,int *INFO)
{   *INFO = PLASMA_sgelqf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_SGELQS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_sgelqs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGELS_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_sgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGEQRF_TILE(intptr_t *A, intptr_t *T, int *INFO)
{   *INFO = PLASMA_sgeqrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_SGEQRS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_sgeqrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGESV_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SGETRF_TILE(intptr_t *A, intptr_t *L, int **IPIVH, int *INFO)
{   *INFO = PLASMA_sgetrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH); }

void PLASMA_SGETRS_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sgetrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SPOSV_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_SPOTRF_TILE(PLASMA_enum *uplo, intptr_t *A, int *INFO)
{   *INFO = PLASMA_spotrf_Tile(*uplo, (PLASMA_desc *)(*A)); }

void PLASMA_SPOTRS_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_spotrs_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_STRSMPL_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_strsmpl_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SUNQLQ_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sorglq_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORGQR_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sorgqr_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sormlq_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_sormqr_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_STRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, float *alpha, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_strsm_Tile(*side, *uplo, *transA, *diag, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_SGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, int *alpha, intptr_t *A, intptr_t *B, int *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_sgemm_Tile(*transA, *transB, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

  void PLASMA_SSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, intptr_t *A, intptr_t *B, float *beta, intptr_t *C, int *INFO)
  {   *INFO = PLASMA_ssymm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_SSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, intptr_t *A, float *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_ssyrk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }

#ifdef COMPLEX
void PLASMA_SSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, float *alpha, intptr_t *A, intptr_t *B, float *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_ssymm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_SSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, float *alpha, intptr_t *A, float *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_ssyrk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }
#endif

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_SGELQF(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGELS(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGEQRF(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGESV(int *N, float **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgesv(*N, L, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGETRF(int *M, int *N, float **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgetrf(*M, *N, L, IPIV); }

/***************************************************************************//**
 *  FORTRAN API - conversion from LAPACK F77 matrix layout to tile layout
 **/
void PLASMA_SLAPACK_TO_TILE(float **Af77, int *LDA, intptr_t *A, int *INFO)
{   *INFO = PLASMA_sLapack_to_Tile( *Af77, *LDA, (PLASMA_desc *)(*A) ); }

void PLASMA_STILE_TO_LAPACK(intptr_t *A, float **Af77, int *LDA, int *INFO)
{   *INFO = PLASMA_sTile_to_Lapack( (PLASMA_desc *)(*A), *Af77, *LDA ); }

#ifdef __cplusplus
}
#endif
