/**
 *
 * @file plasma_mf77.c
 *
 *  PLASMA mixed-precision computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.0
 * @author Bilel Hadri
 * @date 2010-11-15
 *
 **/
#include <stdlib.h>
#include "common.h"

#ifdef ADD_
    #define PLASMA_ZCGESV           plasma_zcgesv_
    #define PLASMA_DSGESV           plasma_dsgesv_
    #define PLASMA_ZCPOSV           plasma_zcposv_
    #define PLASMA_DSPOSV           plasma_dsposv_
    #define PLASMA_ZCGELS           plasma_zcgels_
    #define PLASMA_DSGELS           plasma_dsgels_
    #define PLASMA_ZCUNGESV         plasma_zcungesv_
    #define PLASMA_DSUNGESV         plasma_dsungesv_

    #define PLASMA_ZCGESV_TILE       plasma_zcgesv_tile_
    #define PLASMA_DSGESV_TILE       plasma_dsgesv_tile_
    #define PLASMA_ZCPOSV_TILE       plasma_zcposv_tile_
    #define PLASMA_DSPOSV_TILE       plasma_dsposv_tile_
    #define PLASMA_ZCGELS_TILE       plasma_zcgels_tile_
    #define PLASMA_DSGELS_TILE       plasma_dsgels_tile_
    #define PLASMA_ZCUNGESV_TILE     plasma_zcungesv_tile_
    #define PLASMA_DSUNGESV_TILE     plasma_dsungesv_tile_


#elif defined (NOCHANGE)
    #define PLASMA_ZCGESV           plasma_zcgesv
    #define PLASMA_DSGESV           plasma_dsgesv
    #define PLASMA_ZCPOSV           plasma_zcpssv
    #define PLASMA_DSPOSV           plasma_dsposv
    #define PLASMA_ZCGELS           plasma_zcgels
    #define PLASMA_DSGELS           plasma_dsgels
    #define PLASMA_ZCUNGESV         plasma_zcungesv
    #define PLASMA_DSUNGESV         plasma_dsungesv

    #define PLASMA_ZCGESV_TILE       plasma_zcgesv_tile
    #define PLASMA_DSGESV_TILE       plasma_dsgesv_tile
    #define PLASMA_ZCPOSV_TILE       plasma_zcposv_tile
    #define PLASMA_DSPOSV_TILE       plasma_dsposv_tile
    #define PLASMA_ZCGELS_TILE       plasma_zcgels_tile
    #define PLASMA_DSGELS_TILE       plasma_dsgels_tile
    #define PLASMA_ZCUNGESV_TILE     plasma_zcungesv_tile
    #define PLASMA_DSUNGESV_TILE     plasma_dsungesv_tile
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_ZCGESV(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv(*N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

void PLASMA_DSGESV(int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, double *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_dsgesv(*N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

void PLASMA_ZCPOSV(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_zcposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

void PLASMA_DSPOSV(PLASMA_enum *uplo, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, double *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_dsposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

/* void PLASMA_ZCGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *X, int *LDX, int *ITER, int *INFO) */
/* {   *INFO = PLASMA_zcgels(*trans, *M, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); } */

/* void PLASMA_DSGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, double *X, int *LDX, int *ITER, int *INFO) */
/* {   *INFO = PLASMA_dsgels(*trans, *M, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); } */

void PLASMA_ZCUNGESV(PLASMA_enum *trans, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_zcungesv(*trans, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

void PLASMA_DSUNGESV(PLASMA_enum *trans, int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, double *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_dsungesv(*trans, *N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

#ifdef __cplusplus
}
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_ZCGESV_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

void PLASMA_DSGESV_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

void PLASMA_ZCPOSV_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

void PLASMA_DSPOSV_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_dsposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

/* void PLASMA_ZCGELS_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *B, intptr_t *T, intptr_t *X, int *ITER, int *INFO) */
/* {   *INFO = PLASMA_zcgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T), (PLASMA_desc *)(*X), ITER); } */

/* void PLASMA_DSGELS_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *B, intptr_t *T, intptr_t *X, int *ITER, int *INFO) */
/* {   *INFO = PLASMA_dsgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T), (PLASMA_desc *)(*X), ITER); } */

void PLASMA_ZCUNGESV_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcungesv_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

void PLASMA_DSUNGESV_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, intptr_t *X, int *ITER, int *INFO)
{   *INFO = PLASMA_dsungesv_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }
