/**
 *
 * @file plasma_cf77.c
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.0
 * @author Bilel Hadri
 * @date 2010-11-15
 * @generated c
 *
 **/
#include <stdlib.h>
#include "common.h"
#undef REAL
#define COMPLEX

#ifdef ADD_
    #define PLASMA_CGELQF       plasma_cgelqf_
    #define PLASMA_CGELQS       plasma_cgelqs_
    #define PLASMA_CGELS        plasma_cgels_
    #define PLASMA_CGEQRF       plasma_cgeqrf_
    #define PLASMA_CGEQRS       plasma_cgeqrs_
    #define PLASMA_CGESV        plasma_cgesv_
    #define PLASMA_CGETRF       plasma_cgetrf_
    #define PLASMA_CGETRS       plasma_cgetrs_
    #define PLASMA_CPOSV        plasma_cposv_
    #define PLASMA_CPOTRF       plasma_cpotrf_
    #define PLASMA_CPOTRI       plasma_cpotri_
    #define PLASMA_CPOTRS       plasma_cpotrs_
    #define PLASMA_CTRSMPL      plasma_ctrsmpl_
    #define PLASMA_CUNGLQ       plasma_cunglq_
    #define PLASMA_CUNGQR       plasma_cungqr_
    #define PLASMA_CUNMLQ       plasma_cunmlq_
    #define PLASMA_CUNMQR       plasma_cunmqr_
    #define PLASMA_CTRSM        plasma_ctrsm_
    #define PLASMA_CGEMM        plasma_cgemm_
    #define PLASMA_CSYMM        plasma_csymm_
    #define PLASMA_CSYRK        plasma_csyrk_
#ifdef COMPLEX
    #define PLASMA_CHEMM        plasma_chemm_
    #define PLASMA_CHERK        plasma_cherk_
#endif

    #define PLASMA_CGELQF_TILE      plasma_cgelqf_tile_
    #define PLASMA_CGELQS_TILE      plasma_cgelqs_tile_
    #define PLASMA_CGELS_TILE       plasma_cgels_tile_
    #define PLASMA_CGEQRF_TILE      plasma_cgeqrf_tile_
    #define PLASMA_CGEQRS_TILE      plasma_cgeqrs_tile_
    #define PLASMA_CGESV_TILE       plasma_cgesv_tile_
    #define PLASMA_CGETRF_TILE      plasma_cgetrf_tile_
    #define PLASMA_CGETRS_TILE      plasma_cgetrs_tile_
    #define PLASMA_CPOSV_TILE       plasma_cposv_tile_
    #define PLASMA_CPOTRF_TILE      plasma_cpotrf_tile_
    #define PLASMA_CPOTRI_TILE      plasma_cpotri_tile_
    #define PLASMA_CPOTRS_TILE      plasma_cpotrs_tile_
    #define PLASMA_CTRSM_TILE       plasma_ctrsm_tile_
    #define PLASMA_CTRSMPL_TILE     plasma_ctrsmpl_tile_
    #define PLASMA_CUNGLQ_TILE      plasma_cunglq_tile_
    #define PLASMA_CUNGQR_TILE      plasma_cungqr_tile_
    #define PLASMA_CUNMLQ_TILE      plasma_cunmlq_tile_
    #define PLASMA_CUNMQR_TILE      plasma_cunmqr_tile_
    #define PLASMA_CGEMM_TILE       plasma_cgemm_tile_
    #define PLASMA_CSYMM_TILE       plasma_csymm_tile_
    #define PLASMA_CSYRK_TILE       plasma_csyrk_tile_
#ifdef COMPLEX
    #define PLASMA_CHEMM_TILE       plasma_chemm_tile_
    #define PLASMA_CHERK_TILE       plasma_cherk_tile_
#endif

    #define PLASMA_ALLOC_WORKSPACE_CGELQF       plasma_alloc_workspace_cgelqf_
    #define PLASMA_ALLOC_WORKSPACE_CGELS        plasma_alloc_workspace_cgels_
    #define PLASMA_ALLOC_WORKSPACE_CGEQRF       plasma_alloc_workspace_cgeqrf_
    #define PLASMA_ALLOC_WORKSPACE_CGESV        plasma_alloc_workspace_cgesv_
    #define PLASMA_ALLOC_WORKSPACE_CGETRF       plasma_alloc_workspace_cgetrf_
    #define PLASMA_ALLOC_WORKSPACE_CGELQF       plasma_alloc_workspace_cgelqf_

    #define PLASMA_CLAPACK_TO_TILE   plasma_clapack_to_tile_
    #define PLASMA_CTILE_TO_LAPACK   plasma_ctile_to_lapack_

#elif defined (NOCHANGE)
    #define PLASMA_CGELQF       plasma_cgelqf
    #define PLASMA_CGELQS       plasma_cgelqs
    #define PLASMA_CGELS        plasma_cgels
    #define PLASMA_CGEQRF       plasma_cgeqrf
    #define PLASMA_CGEQRS       plasma_cgeqrs
    #define PLASMA_CGESV        plasma_cgesv
    #define PLASMA_CGETRF       plasma_cgetrf
    #define PLASMA_CGETRS       plasma_cgetrs
    #define PLASMA_CPOSV        plasma_cposv
    #define PLASMA_CPOTRF       plasma_cpotrf
    #define PLASMA_CPOTRI       plasma_cpotri
    #define PLASMA_CPOTRS       plasma_cpotrs
    #define PLASMA_CTRSM        plasma_ctrsm
    #define PLASMA_CTRSMPL      plasma_ctrsmpl
    #define PLASMA_CUNGLQ       plasma_cunglq
    #define PLASMA_CUNGQR       plasma_cungqr
    #define PLASMA_CUNMLQ       plasma_cunmlq
    #define PLASMA_CUNMQR       plasma_cunmqr
    #define PLASMA_CGEMM        plasma_cgemm
    #define PLASMA_CSYMM        plasma_csymm
    #define PLASMA_CSYRK        plasma_csyrk
#ifdef COMPLEX
    #define PLASMA_CHEMM        plasma_chemm
    #define PLASMA_CHERK        plasma_cherk
#endif

    #define PLASMA_CGELQF_TILE      plasma_cgelqf_tile
    #define PLASMA_CGELQS_TILE      plasma_cgelqs_tile
    #define PLASMA_CGELS_TILE       plasma_cgels_tile
    #define PLASMA_CGEQRF_TILE      plasma_cgeqrf_tile
    #define PLASMA_CGEQRS_TILE      plasma_cgeqrs_tile
    #define PLASMA_CGESV_TILE       plasma_cgesv_tile
    #define PLASMA_CGETRF_TILE      plasma_cgetrf_tile
    #define PLASMA_CGETRS_TILE      plasma_cgetrs_tile
    #define PLASMA_CPOSV_TILE       plasma_cposv_tile
    #define PLASMA_CPOTRF_TILE      plasma_cpotrf_tile
    #define PLASMA_CPOTRI_TILE      plasma_cpotri_tile
    #define PLASMA_CPOTRS_TILE      plasma_cpotrs_tile
    #define PLASMA_CTRSM_TILE       plasma_ctrsm_tile
    #define PLASMA_CTRSMPL_TILE     plasma_ctrsmpl_tile
    #define PLASMA_CUNGLQ_TILE      plasma_cunglq_tile
    #define PLASMA_CUNGQR_TILE      plasma_cungqr_tile
    #define PLASMA_CUNMLQ_TILE      plasma_cunmlq_tile
    #define PLASMA_CUNMQR_TILE      plasma_cunmqr_tile
    #define PLASMA_CGEMM_TILE       plasma_cgemm_tile
    #define PLASMA_CSYMM_TILE       plasma_csymm_tile
    #define PLASMA_CSYRK_TILE       plasma_csyrk_tile
#ifdef COMPLEX
    #define PLASMA_CHEMM_TILE       plasma_chemm_tile
    #define PLASMA_CHERK_TILE       plasma_cherk_tile
#endif

    #define PLASMA_ALLOC_WORKSPACE_CGELQF       plasma_alloc_workspace_cgelqf
    #define PLASMA_ALLOC_WORKSPACE_CGELS        plasma_alloc_workspace_cgels
    #define PLASMA_ALLOC_WORKSPACE_CGEQRF       plasma_alloc_workspace_cgeqrf
    #define PLASMA_ALLOC_WORKSPACE_CGESV        plasma_alloc_workspace_cgesv
    #define PLASMA_ALLOC_WORKSPACE_CGETRF       plasma_alloc_workspace_cgetrf

    #define PLASMA_CLAPACK_TO_TILE   plasma_clapack_to_tile
    #define PLASMA_CTILE_TO_LAPACK   plasma_ctile_to_lapack
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (simple interface)
 **/
void PLASMA_CGELQF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, int *INFO)
{   *INFO = PLASMA_cgelqf(*M, *N, A, *LDA, *T); }

void PLASMA_CGELQS(int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cgelqs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_CGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cgels(*trans, *M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_CGEQRF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, int *INFO)
{   *INFO = PLASMA_cgeqrf(*M, *N, A, *LDA, *T); }

void PLASMA_CGEQRS(int *M, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cgeqrs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_CGESV(int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **LH, int **IPIVH, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cgesv(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_CGETRF(int *M, int *N, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **LH, int **IPIVH, int *INFO)
{   *INFO = PLASMA_cgetrf(*M, *N, A, *LDA, *LH, *IPIVH); }

void PLASMA_CGETRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **LH, int **IPIVH, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cgetrs(*uplo, *N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_CPOSV(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_CPOTRF(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, int *INFO)
{   *INFO = PLASMA_cpotrf(*uplo, *N, A, *LDA); }

void PLASMA_CPOTRI(PLASMA_enum *uplo, int *N, PLASMA_Complex32_t *A, int *LDA, int *INFO)
{   *INFO = PLASMA_cpotri(*uplo, *N, A, *LDA); }

void PLASMA_CPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int* LDB, int * INFO)
{   *INFO = PLASMA_cpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_CTRSMPL(int *N, int *NRHS, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **LH, int **IPIVH, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_ctrsmpl(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_CUNGLQ(int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cunglq(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_CUNGQR(int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cungqr(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_CUNMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cunmlq(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_CUNMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t **T, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_cunmqr(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_CTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_ctrsm(*side, *uplo, *transA, *diag, *N, *NRHS, *alpha, A, *LDA, B, *LDB); }

void PLASMA_CGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *INFO)
{   *INFO = PLASMA_cgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CSYMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *INFO)
{   *INFO = PLASMA_csymm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CSYRK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *INFO)
{   *INFO = PLASMA_csyrk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }

#ifdef COMPLEX
void PLASMA_CHEMM(PLASMA_enum *side, PLASMA_enum *uplo, int *M, int *N, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, PLASMA_Complex32_t *B, int *LDB, PLASMA_Complex32_t *beta, PLASMA_Complex32_t *C, int *LDC, int *INFO)
{   *INFO = PLASMA_chemm(*side, *uplo, *M, *N, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }

void PLASMA_CHERK(PLASMA_enum *uplo, PLASMA_enum *trans, int *N, int *K, PLASMA_Complex32_t *alpha, PLASMA_Complex32_t *A, int *LDA, float *beta, PLASMA_Complex32_t *C, int *LDC, int *INFO)
{   *INFO = PLASMA_cherk(*uplo, *trans, *N, *K, *alpha, A, *LDA, *beta, C, *LDC); }
#endif

/***************************************************************************//**
 *  FORTRAN API - math functions (native interface)
 **/
void PLASMA_CGELQF_TILE(intptr_t *A, intptr_t *T,int *INFO)
{   *INFO = PLASMA_cgelqf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_CGELQS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_cgelqs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_CGELS_TILE(PLASMA_enum *trans, intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_cgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_CGEQRF_TILE(intptr_t *A, intptr_t *T, int *INFO)
{   *INFO = PLASMA_cgeqrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_CGEQRS_TILE(intptr_t *A, intptr_t *B, intptr_t *T, int *INFO)
{   *INFO = PLASMA_cgeqrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_CGESV_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_CGETRF_TILE(intptr_t *A, intptr_t *L, int **IPIVH, int *INFO)
{   *INFO = PLASMA_cgetrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH); }

void PLASMA_CGETRS_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cgetrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_CPOSV_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_CPOTRF_TILE(PLASMA_enum *uplo, intptr_t *A, int *INFO)
{   *INFO = PLASMA_cpotrf_Tile(*uplo, (PLASMA_desc *)(*A)); }

void PLASMA_CPOTRS_TILE(PLASMA_enum *uplo, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cpotrs_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_CTRSMPL_TILE(intptr_t *A, intptr_t *L, int **IPIVH, intptr_t *B, int *INFO)
{   *INFO = PLASMA_ctrsmpl_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_CUNQLQ_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cunglq_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_CUNGQR_TILE(intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cungqr_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_CUNMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cunmlq_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_CUNMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, intptr_t *A, intptr_t *T, intptr_t *B, int *INFO)
{   *INFO = PLASMA_cunmqr_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_CTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, PLASMA_Complex32_t *alpha, intptr_t *A, intptr_t *B, int *INFO)
{   *INFO = PLASMA_ctrsm_Tile(*side, *uplo, *transA, *diag, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_CGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, int *alpha, intptr_t *A, intptr_t *B, int *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_cgemm_Tile(*transA, *transB, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

  void PLASMA_CSYMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, intptr_t *A, intptr_t *B, PLASMA_Complex32_t *beta, intptr_t *C, int *INFO)
  {   *INFO = PLASMA_csymm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_CSYRK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, intptr_t *A, PLASMA_Complex32_t *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_csyrk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }

#ifdef COMPLEX
void PLASMA_CHEMM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_Complex32_t *alpha, intptr_t *A, intptr_t *B, PLASMA_Complex32_t *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_chemm_Tile(*side, *uplo, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); }

void PLASMA_CHERK_TILE(PLASMA_enum *uplo, PLASMA_enum *trans, PLASMA_Complex32_t *alpha, intptr_t *A, float *beta, intptr_t *C, int *INFO)
{   *INFO = PLASMA_cherk_Tile(*uplo, *trans, *alpha, (PLASMA_desc *)(*A), *beta, (PLASMA_desc *)(*C)); }
#endif

/***************************************************************************//**
 *  FORTRAN API - workspace allocation
 **/
void PLASMA_ALLOC_WORKSPACE_CGELQF(int *M, int *N, PLASMA_Complex32_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_cgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGELS(int *M, int *N, PLASMA_Complex32_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_cgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGEQRF(int *M, int *N, PLASMA_Complex32_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_cgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_CGESV(int *N, PLASMA_Complex32_t **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_cgesv(*N, L, IPIV); }

void PLASMA_ALLOC_WORKSPACE_CGETRF(int *M, int *N, PLASMA_Complex32_t **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_cgetrf(*M, *N, L, IPIV); }

/***************************************************************************//**
 *  FORTRAN API - conversion from LAPACK F77 matrix layout to tile layout
 **/
void PLASMA_CLAPACK_TO_TILE(PLASMA_Complex32_t **Af77, int *LDA, intptr_t *A, int *INFO)
{   *INFO = PLASMA_cLapack_to_Tile( *Af77, *LDA, (PLASMA_desc *)(*A) ); }

void PLASMA_CTILE_TO_LAPACK(intptr_t *A, PLASMA_Complex32_t **Af77, int *LDA, int *INFO)
{   *INFO = PLASMA_cTile_to_Lapack( (PLASMA_desc *)(*A), *Af77, *LDA ); }

#ifdef __cplusplus
}
#endif
