/**
 *
 * @file pcunglq.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.3.0
 * @author Hatem Ltaief
 * @author Jakub Kurzak
 * @author Mathieu Faverge
 * @date 2010-11-15
 * @generated c
 *
 **/
#include "common.h"

#define A(m,n) BLKADDR(A, PLASMA_Complex32_t, m, n)
#define Q(m,n) BLKADDR(Q, PLASMA_Complex32_t, m, n)
#define T(m,n) BLKADDR(T, PLASMA_Complex32_t, m, n)
/***************************************************************************//**
 *  Parallel construction of Q using tile V (application to identity) - dynamic scheduling
 **/
void plasma_pcunglq_quark(PLASMA_desc A, PLASMA_desc Q, PLASMA_desc T,
                          PLASMA_sequence *sequence, PLASMA_request *request)
{
    plasma_context_t *plasma;
    Quark_Task_Flags task_flags = Quark_Task_Flags_Initializer;

    int k, m, n;
    int ldak, ldqm;
    int tempnn, tempmm, tempkm, tempkn;

    plasma = plasma_context_self();
    if (sequence->status != PLASMA_SUCCESS)
        return;
    QUARK_Task_Flag_Set(&task_flags, TASK_SEQUENCE, (intptr_t)sequence->quark_sequence);

    for (k = min(A.mt, A.nt)-1; k >= 0; k--) {
        tempkm = k == A.mt-1 ? A.m-k*A.mb : A.mb;
        tempkn = k == A.nt-1 ? A.n-k*A.nb : A.nb;
        ldak = BLKLDD(A, k);
        for (n = Q.nt-1; n > k; n--) {
            tempnn = n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb;
            for (m = 0; m < Q.mt; m++) {
                tempmm = m == Q.mt-1 ? Q.m-m*Q.mb : Q.mb;
                ldqm = BLKLDD(Q, m);
                QUARK_CORE_ctsmlq(
                    plasma->quark, &task_flags,
                    PlasmaRight, PlasmaNoTrans,
                    tempmm, A.nb, tempmm, tempnn, tempkm, T.mb, T.nb,
                    Q(m, k), ldqm,
                    Q(m, n), ldqm,
                    A(k, n), ldak,
                    T(k, n), T.mb);
            }
        }
        for (m = 0; m < Q.mt; m++) {
            tempmm = m == Q.mt-1 ? Q.m-m*Q.mb : Q.mb;
            ldqm = BLKLDD(Q, m);
            QUARK_CORE_cunmlq(
                plasma->quark, &task_flags,
                PlasmaRight, PlasmaNoTrans,
                tempmm, tempkn, tempkm, T.mb, T.nb,
                A(k, k), ldak,
                T(k, k), T.mb,
                Q(m, k), ldqm);
        }
    }
}
