#define _TYPE  float
#define _PREC  float
#define _LAMCH lapack_slamch

#define _NAME  "PLASMA_spotrf"
/* See Lawn 41 page 120 */
#define _FMULS (n * (1.0 / 6.0 * n + 0.5) * n)
#define _FADDS (n * (1.0 / 6.0 * n )      * n)

#include "./timing.c"

static int
RunTest(int *iparam, float *dparam, real_Double_t *t_) 
{
    float *A, *Acpy, *b, *x;
    real_Double_t       t;
    int n     = iparam[TIMING_N];
    int nrhs  = iparam[TIMING_NRHS];
    int check = iparam[TIMING_CHECK];
    int lda = n;
    int ldb = n;

    /* Allocate Data */
    A = (float *)malloc(lda*n*   sizeof(float));

    /* Check if unable to allocate memory */
    if ( !A ) {
        printf("Out of Memory \n ");
        exit(0);
    }
    
    /* Initialize Plasma */ 
    PLASMA_Init( iparam[TIMING_THRDNBR] );
    if ( iparam[TIMING_SCHEDULER] )
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_DYNAMIC_SCHEDULING );
    else
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_STATIC_SCHEDULING );

    /*if ( !iparam[TIMING_AUTOTUNING] ) {*/
        PLASMA_Disable(PLASMA_AUTOTUNING);
        PLASMA_Set(PLASMA_TILE_SIZE, iparam[TIMING_NB] );
    /* } */

     /* Initialiaze Data */
    PLASMA_splghe(n, A, lda, ISEED);

    /* Save A and b  */
    if (check) {
        Acpy = (float *)malloc(lda*n*sizeof(float));
        lapack_slacpy(lapack_upper_lower, n, n, A, lda, Acpy, lda);
      }

    /* PLASMA SPOSV */
    t = -cWtime();
    PLASMA_spotrf(PlasmaUpper, n, A, lda);
    t += cWtime();
    *t_ = t;

    /* Check the solution */
    if (check)
      {
        b = (float *)malloc(ldb*nrhs*sizeof(float));
        x = (float *)malloc(ldb*nrhs*sizeof(float));
        lapack_slarnv(1, ISEED, n*nrhs, x);
        lapack_slacpy(lapack_upper_lower, n, nrhs, x, ldb, b, ldb);

        PLASMA_spotrs(PlasmaUpper, n, nrhs, A, lda, x, ldb);

        dparam[TIMING_RES] = scheck_solution(n, n, nrhs, Acpy, lda, b, x, ldb,
                                             &(dparam[TIMING_ANORM]), 
                                             &(dparam[TIMING_BNORM]),
                                             &(dparam[TIMING_XNORM]));

        free(Acpy); free(b); free(x);
      }

    free(A);

    PLASMA_Finalize();

    return 0;
}
