#define _TYPE  double
#define _PREC  double
#define _LAMCH lapack_dlamch

#define _NAME  "PLASMA_dgels"
/* See Lawn 41 page 120 */
#define _FMULS (n * (2.0 / 3.0 * n + 1.5 * (1.0 + nrhs)) * n)
#define _FADDS (n * (2.0 / 3.0 * n + 0.5 +  1.5 * nrhs)  * n)

#include "./timing.c"

static int
RunTest(int *iparam, double *dparam, real_Double_t *t_) 
{
    double *A, *Acpy, *b, *x, *T;
    real_Double_t       t;
    int n       = iparam[TIMING_N];
    int nrhs    = iparam[TIMING_NRHS];
    int check   = iparam[TIMING_CHECK];
    int lda     = n;
    int ldb     = n;
    
    /* Allocate Data */
    A = (double *)malloc(lda*n*   sizeof(double));
    x = (double *)malloc(ldb*nrhs*sizeof(double));

    /* Check if unable to allocate memory */
    if ( (!A) || (!x) ) {
        printf("Out of Memory \n ");
        exit(0);
    }
    
    /* Initialize Plasma */ 
    PLASMA_Init( iparam[TIMING_THRDNBR] );
    if ( iparam[TIMING_SCHEDULER] )
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_DYNAMIC_SCHEDULING );
    else
        PLASMA_Set(PLASMA_SCHEDULING_MODE, PLASMA_STATIC_SCHEDULING );

    /*if ( !iparam[TIMING_AUTOTUNING] ) {*/
        PLASMA_Disable(PLASMA_AUTOTUNING);
        PLASMA_Set(PLASMA_TILE_SIZE,        iparam[TIMING_NB] );
        PLASMA_Set(PLASMA_INNER_BLOCK_SIZE, iparam[TIMING_IB] );
    /* } */

     /* Initialiaze Data */
    lapack_dlarnv(1, ISEED, n*lda,  A);
    lapack_dlarnv(1, ISEED, n*nrhs, x);

    PLASMA_Alloc_Workspace_dgels(n, n, &T);

    /* Save A and b  */
    if (check) {
        Acpy = (double *)malloc(lda*n*   sizeof(double));
        b    = (double *)malloc(ldb*nrhs*sizeof(double));
        lapack_dlacpy(lapack_upper_lower, n, n,    A, lda, Acpy, lda);
        lapack_dlacpy(lapack_upper_lower, n, nrhs, x, ldb, b,    ldb);
      }

    t = -cWtime();
    PLASMA_dgels( PlasmaNoTrans, n, n, nrhs, A, lda, T, x, ldb );
    t += cWtime();
    *t_ = t;
    
    /* Check the solution */
    if (check)
      {
        dparam[TIMING_RES] = dcheck_solution(n, n, nrhs, Acpy, lda, b, x, ldb,
                                             &(dparam[TIMING_ANORM]), &(dparam[TIMING_BNORM]), 
                                             &(dparam[TIMING_XNORM]));
        free(Acpy); free(b);
      }

    free( T );
    free( A );
    free( x );

    PLASMA_Finalize();

    return 0;
}
