/**
 *
 * @file ztesting.c
 *
 *  PLASMA testing routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Mathieu Faverge
 * @date 2009-11-15
 *
 **/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <plasma.h>
#include "testing_zmain.h"

int   IONE     = 1;
int   ISEED[4] = {0,0,0,1};   /* initial seed for zlarnv() */

int   side[2]  = { PlasmaLeft,  PlasmaRight };
int   uplo[2]  = { PlasmaUpper, PlasmaLower };
int   trans[3] = { PlasmaNoTrans,  PlasmaTrans, PlasmaConjTrans };

char *sidestr[2]  = { "Left",  "Right" };
char *uplostr[2]  = { "Upper", "Lower" };
char *transstr[3] = { "N",  "T", "H" };

int main (int argc, char **argv)
{
    int ncores, sched;
    int info;
    char func[32];
    
    /* Check for number of arguments*/
    if ( argc < 4) {
        printf(" Proper Usage is : ./ztesting ncores sched FUNC ...\n"
               "   - ncores : number of cores \n"
               "   - sched  : 0 for static, 1 for dynamic\n"
               "   - FUNC   : name of function to test\n");
        exit(1);
    }

    sscanf( argv[1], "%d", &ncores );
    sscanf( argv[2], "%d", &sched  );
    sscanf( argv[3], "%s", func   );

    PLASMA_Init(ncores);
    if ( sched == 0 )
        PLASMA_Set( PLASMA_SCHEDULING_MODE, PLASMA_STATIC_SCHEDULING );
    else
        PLASMA_Set( PLASMA_SCHEDULING_MODE, PLASMA_DYNAMIC_SCHEDULING );

    argc -= 4;
    argv += 4;
    info  = 0;

    /* Blas Level 3 */
    if ( strcmp(func, "GEMM") == 0 ) {
        info = testing_zgemm( argc, argv );
    } else if ( strcmp(func, "HEMM") == 0 ) {
            info = testing_zhemm( argc, argv );
    } else if ( strcmp(func, "SYMM") == 0 ) {
            info = testing_zsymm( argc, argv );
    } else if ( strcmp(func, "HERK") == 0 ) {
            info = testing_zherk( argc, argv );
    } else if ( strcmp(func, "SYRK") == 0 ) {
        info = testing_zsyrk( argc, argv );
    /* } else if ( strcmp(func, "HER2K") == 0 ) { */
    /*         info = testing_zher2k( argc, argv ); */
    /* } else if ( strcmp(func, "SYR2K") == 0 ) { */
    /*         info = testing_zsyr2k( argc, argv ); */
    /* } else if ( strcmp(func, "TRMM") == 0 ) { */
    /*         info = testing_ztrmm( argc, argv ); */
    /* } else if ( strcmp(func, "TRSM") == 0 ) { */
    /*         info = testing_ztrsm( argc, argv ); */
    /* Linear system */
    } else if ( strcmp(func, "POSV") == 0 ) {
            info = testing_zposv( argc, argv );
    } else if ( strcmp(func, "GELS") == 0 ) {
            info = testing_zgels( argc, argv );
    } else if ( strcmp(func, "GESV") == 0 ) {
            info = testing_zgesv( argc, argv );
    } else {
        fprintf(stderr, "Function unknown\n");
    }

    if ( info == -1 ) {
        printf( "TESTING %s FAILED : incorrect number of arguments\n", func);
    } else if ( info == -2 ) {
        printf( "TESTING %s FAILED : not enough memory\n", func);
    }
    
    PLASMA_Finalize();

    return EXIT_SUCCESS;
}
