/**
 *
 * @file dtesting.h
 *
 *  PLASMA testing routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Mathieu Faverge
 * @date 2009-11-15
 *
 **/
#ifndef TESTINGS_H
#define TESTINGS_H

#define USAGE(name, args, details)                       \
  printf(" Proper Usage is : ./dtesting ncores sched " name " " args " with\n" \
         "   - ncores : number of cores \n"              \
         "   - sched  : 0 for static, 1 for dynamic\n"   \
         "   - " name "  : name of function to test\n"   \
         details);

#ifdef WIN32
#include <float.h>
#define isnan _isnan
#endif

#ifndef max
#define max(a, b) ((a) > (b) ? (a) : (b))
#endif
#ifndef min
#define min(a, b) ((a) < (b) ? (a) : (b))
#endif

extern int IONE;
extern int ISEED[4];

extern int trans[3];
extern int uplo[2];
extern int side[2];
extern char *transstr[3];
extern char *uplostr[2];
extern char *sidestr[2];

int testing_dgemm(int argc, char **argv);
int testing_dsymm(int argc, char **argv);
int testing_dsymm(int argc, char **argv);
int testing_dsyrk(int argc, char **argv);
int testing_dsyrk(int argc, char **argv);
int testing_dher2k(int argc, char **argv);
int testing_dsyr2k(int argc, char **argv);
int testing_dtrmm(int argc, char **argv);
int testing_dtrsm(int argc, char **argv);

int testing_dposv(int argc, char **argv);
int testing_dgels(int argc, char **argv);
int testing_dgesv(int argc, char **argv);

#endif /* TESTINGS_H */
