/**
 *
 * @file ctesting.h
 *
 *  PLASMA testing routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Mathieu Faverge
 * @date 2009-11-15
 *
 **/
#ifndef TESTINGS_H
#define TESTINGS_H

#define USAGE(name, args, details)                       \
  printf(" Proper Usage is : ./ctesting ncores sched " name " " args " with\n" \
         "   - ncores : number of cores \n"              \
         "   - sched  : 0 for static, 1 for dynamic\n"   \
         "   - " name "  : name of function to test\n"   \
         details);

#ifdef WIN32
#include <float.h>
#define isnan _isnan
#endif

#ifndef max
#define max(a, b) ((a) > (b) ? (a) : (b))
#endif
#ifndef min
#define min(a, b) ((a) < (b) ? (a) : (b))
#endif

extern int IONE;
extern int ISEED[4];

extern int trans[3];
extern int uplo[2];
extern int side[2];
extern char *transstr[3];
extern char *uplostr[2];
extern char *sidestr[2];

int testing_cgemm(int argc, char **argv);
int testing_chemm(int argc, char **argv);
int testing_csymm(int argc, char **argv);
int testing_cherk(int argc, char **argv);
int testing_csyrk(int argc, char **argv);
int testing_cher2k(int argc, char **argv);
int testing_csyr2k(int argc, char **argv);
int testing_ctrmm(int argc, char **argv);
int testing_ctrsm(int argc, char **argv);

int testing_cposv(int argc, char **argv);
int testing_cgels(int argc, char **argv);
int testing_cgesv(int argc, char **argv);

#endif /* TESTINGS_H */
