#! /usr/bin/env python
# -*- coding: utf-8 -*-


###############################################################################
# plasma_testing.py  [nbcores] 
#  nbcores is a optional argument to give the number of cores to run the testing
# Example:
#     ./plasma_testing.py 
#                 No argument, so will run on half of the core if the machine has more than 2 cores
#     ./plama_testing.py nbcores
#                 Will run on nbcores 
###############################################################################

import os, sys, math
import getopt

# Linux Unix and MacOS: 
if hasattr(os, "sysconf"):
   if os.sysconf_names.has_key("SC_NPROCESSORS_ONLN"):
	   ncpus_av = os.sysconf("SC_NPROCESSORS_ONLN")
# Windows:
if os.environ.has_key("NUMBER_OF_PROCESSORS"):
   ncpus_av = int(os.environ["NUMBER_OF_PROCESSORS"]);

# we are going to run on half of the cores by default if we have more than 2 cores
if (ncpus_av > 2):
   ncpus=int(math.floor(ncpus_av/2))
else:
   ncpus=ncpus_av

try:
   opts, args = getopt.getopt(sys.argv[1:], "hc:s:", 
                              ["help", "cores=", "sched="])
   
except getopt.error, msg:
   print msg
   print "for help use --help"
   sys.exit(2)

# process options
sched=0;
for o, a in opts:
   if o in ("-h", "--help"):
      print sys.argv[0]+" [-h|--help] [-c n|--cores=n] [-s s|--sched=s]"
      print "  - n is the number of cores"
      print "  - s is the scheduling mode: 0 for static, 1 for dynamic"
      sys.exit(0)
   else:
      if o in ( '-c', '--ncores' ):
         ncpus = a
      elif o in ( '-s' , '--sched' ): 
         if a == "0" :
            sched = 0
         else:
            sched = 1

# Add current directory to the path for subshells of this shell
# Allows the popen to find local files in both windows and unixes
os.environ["PATH"] = os.environ["PATH"]+":."

# Define a function to open the executable (different filenames on unix and Windows)
def local_popen( cmdline ):
   if os.name == 'nt':
     pipe=os.popen( cmdline )
   else:
     pipe=os.popen( "./" + cmdline )
   return pipe


# If filename cannot be opened, send output to sys.stderr
filename = "testing_results.txt"
try:
     f = open(filename, 'w')
except IOError:
     f = sys.stdout

print " "
print "---------------- Testing PLASMA Routines ----------------"
print " "
print "-- Number of cores available =", ncpus_av
print "-- Number of cores used for testing =", ncpus
print "-- Detailed results are stored in", filename
print "-- Scheduling mode: ",
if (sched == 0):
   print "Static"
else:
   print "Dynamic" 

dtypes = (
("s", "d", "c", "z"),
("Single", "Double", "Complex", "Double Complex"),
)

for dtype in range(4):
  letter = dtypes[0][dtype]
  name = dtypes[1][dtype]
  print " "
  print "------------------------- %s ------------------------" % name
  print " "
  sys.stdout.flush()

  test1 = local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " POSV" + " 500 600 25 700")
  for line in test1.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test2=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " GELS" + " 800 400 825 25 810")
  for line in test2.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test3=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " GELS" + " 400 800 825 25 810")
  for line in test3.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test4=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " GESV" + " 800 825 25 810")
  for line in test4.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test5=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " GEMM" + " 1.0 -2.0 600 500 550 650 625 700")
  for line in test5.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()

  test6=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " SYMM" + " 1.0 -2.0 600 500 650 625 700")
  for line in test6.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()

  test7=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " SYRK" + " 1.0 -2.0 600 500 650 625")
  for line in test7.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()

  if letter in ( "c", "z" ) :
     test8=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " HEMM" + " 1.0 -2.0 600 500 650 625 600")
     for line in test8.readlines():
        f.write(str(line))
        if "TESTING" in line : print line,
     f.flush()

     test9=local_popen("%stesting " % letter + str(ncpus) + " " + str(sched) + " HERK" + " 1.0 -2.0 600 500 650 625")
     for line in test9.readlines():
        f.write(str(line))
        if "TESTING" in line : print line,
     f.flush()

print " "
print "--------------------- Mixed Precision -------------------"
print " "

for substr in ("zc", "ds"):
  test17=local_popen("testing_%sgesv " % substr +str(ncpus)+ " 800 825 25 810")
  for line in test17.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test18=local_popen("testing_%sungesv " % substr +str(ncpus)+ " 800 825 25 810")
  for line in test18.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test19=local_popen("testing_%sposv " % substr +str(ncpus)+ " 800 825 25 810")
  for line in test19.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()



# This may close the sys.stdout stream, so make it the last statement
f.close()
