/**
 *
 * @file plasma_s.c
 *
 *  PLASMA header file for float routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_S_H_
#define _PLASMA_S_H_
#undef COMPLEX
#define REAL

#ifdef __cplusplus
extern "C" {
#endif

/** ****************************************************************************
 *  Math functions (simple interface)
 **/
int PLASMA_sgelqf(int M, int N, float *A, int LDA, float *T);
int PLASMA_sgelqs(int M, int N, int NRHS, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sgels(PLASMA_enum trans, int M, int N, int NRHS, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sgeqrf(int M, int N, float *A, int LDA, float *T);
int PLASMA_sgeqrs(int M, int N, int NRHS, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sgesv(int N, int NRHS, float *A, int LDA, float *L, int *IPIV, float *B, int LDB);
int PLASMA_sgetrf(int M, int N, float *A, int LDA, float *L, int *IPIV);
int PLASMA_sgetrs(PLASMA_enum uplo, int N, int NRHS, float *A, int LDA, float *L, int *IPIV, float *B, int LDB);
int PLASMA_sposv(PLASMA_enum uplo, int N, int NRHS, float *A, int LDA, float *B, int LDB);
int PLASMA_spotrf(PLASMA_enum uplo, int N, float *A, int LDA);
int PLASMA_spotrs(PLASMA_enum uplo, int N, int NRHS, float *A, int LDA, float *B, int LDB);
int PLASMA_strsm(PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, int N, int NRHS, float *A, int LDA, float *B, int LDB);
int PLASMA_strsmpl(int N, int NRHS, float *A, int LDA, float *L, int *IPIV, float *B, int LDB);
int PLASMA_sorglq(int M, int N, int K, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sorgqr(int M, int N, int K, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sormlq(PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sormqr(PLASMA_enum side, PLASMA_enum trans, int M, int N, int K, float *A, int LDA, float *T, float *B, int LDB);
int PLASMA_sgemm(PLASMA_enum transA, PLASMA_enum transB, int M, int N, int K, float alpha, float *A, int LDA, float *B, int LDB, float beta, float *C, int LDC);
int PLASMA_ssymm(PLASMA_enum side, PLASMA_enum uplo, int M, int N, float alpha, float *A, int LDA, float *B, int LDB, float beta, float *C, int LDC);
int PLASMA_ssyrk(PLASMA_enum uplo, PLASMA_enum trans, int N, int K, float alpha, float *A, int LDA, float beta, float *C, int LDC);
#ifdef COMPLEX
int PLASMA_ssymm(PLASMA_enum side, PLASMA_enum uplo, int M, int N, float alpha, float *A, int LDA, float *B, int LDB, float beta, float *C, int LDC);
int PLASMA_ssyrk(PLASMA_enum uplo, PLASMA_enum trans, int N, int K, float alpha, float *A, int LDA, float beta, float *C, int LDC);
#endif
/** ****************************************************************************
 *  Math functions (native interface)
 **/
int PLASMA_sgelqf_Tile(PLASMA_desc *A, PLASMA_desc *T);
int PLASMA_sgelqs_Tile(PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T);
int PLASMA_sgels_Tile(PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T);
int PLASMA_sgeqrf_Tile(PLASMA_desc *A, PLASMA_desc *T);
int PLASMA_sgeqrs_Tile(PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T);
int PLASMA_sgesv_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B);
int PLASMA_sgetrf_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV);
int PLASMA_sgetrs_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B);
int PLASMA_sposv_Tile(PLASMA_enum uplo, PLASMA_desc *A, PLASMA_desc *B);
int PLASMA_spotrf_Tile(PLASMA_enum uplo, PLASMA_desc *A);
int PLASMA_spotrs_Tile(PLASMA_enum uplo, PLASMA_desc *A, PLASMA_desc *B);
int PLASMA_strsm_Tile(PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, PLASMA_desc *A, PLASMA_desc *B);
int PLASMA_strsmpl_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B);
int PLASMA_sorglq_Tile(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B);
int PLASMA_sorgqr_Tile(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B);
int PLASMA_sormlq_Tile(PLASMA_enum side, PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B);
int PLASMA_sormqr_Tile(PLASMA_enum side, PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B);
int PLASMA_sgemm_Tile(PLASMA_enum transA, PLASMA_enum transB, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C);
int PLASMA_ssymm_Tile(PLASMA_enum side, PLASMA_enum uplo, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C);
int PLASMA_ssyrk_Tile(PLASMA_enum uplo, PLASMA_enum trans, float alpha, PLASMA_desc *A, float beta, PLASMA_desc *C);
#ifdef COMPLEX
int PLASMA_ssymm_Tile(PLASMA_enum side, PLASMA_enum uplo, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C);
int PLASMA_ssyrk_Tile(PLASMA_enum uplo, PLASMA_enum trans, float alpha, PLASMA_desc *A, float beta, PLASMA_desc *C);
#endif
/** ****************************************************************************
 *  Math functions (native interface, asynchronous execution)
 **/
int PLASMA_sgelqf_Tile_Async(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgelqs_Tile_Async(PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgels_Tile_Async(PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgeqrf_Tile_Async(PLASMA_desc *A, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgeqrs_Tile_Async(PLASMA_desc *A, PLASMA_desc *B, PLASMA_desc *T, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgesv_Tile_Async(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgetrf_Tile_Async(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgetrs_Tile_Async(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sposv_Tile_Async(PLASMA_enum uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_spotrf_Tile_Async(PLASMA_enum uplo, PLASMA_desc *A, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_spotrs_Tile_Async(PLASMA_enum uplo, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_strsm_Tile_Async(PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag, PLASMA_desc *A, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_strsmpl_Tile_Async(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sorglq_Tile_Async(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sorgqr_Tile_Async(PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sormlq_Tile_Async(PLASMA_enum side, PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sormqr_Tile_Async(PLASMA_enum side, PLASMA_enum trans, PLASMA_desc *A, PLASMA_desc *T, PLASMA_desc *B, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_sgemm_Tile_Async(PLASMA_enum transA, PLASMA_enum transB, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_ssymm_Tile_Async(PLASMA_enum side, PLASMA_enum uplo, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_ssyrk_Tile_Async(PLASMA_enum uplo, PLASMA_enum trans, float alpha, PLASMA_desc *A, float beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request);
#ifdef COMPLEX
int PLASMA_ssymm_Tile_Async(PLASMA_enum side, PLASMA_enum uplo, float alpha, PLASMA_desc *A, PLASMA_desc *B, float beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request);
int PLASMA_ssyrk_Tile_Async(PLASMA_enum uplo, PLASMA_enum trans, float alpha, PLASMA_desc *A, float beta, PLASMA_desc *C, PLASMA_sequence *sequence, PLASMA_request *request);
#endif
/** ****************************************************************************
 *  Workspace allocation
 **/
int PLASMA_Alloc_Workspace_sgels(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgeqrf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgelqf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgesv(int N, float **L, int **IPIV);
int PLASMA_Alloc_Workspace_sgetrf(int M, int N, float **L, int **IPIV);

int PLASMA_Alloc_Workspace_sgels_Tile (int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgeqrf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgelqf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_sgesv_Tile (int N, PLASMA_desc **descL, int **IPIV);
int PLASMA_Alloc_Workspace_sgetrf_Tile(int N, PLASMA_desc **descL, int **IPIV);

#ifdef __cplusplus
}
#endif

#endif
