/**
 *
 * @file core_zblas.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @author Hatem Ltaief
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_CORE_ZBLAS_H_
#define _PLASMA_CORE_ZBLAS_H_
#define COMPLEX

#ifdef __cplusplus
extern "C" {
#endif

/** ****************************************************************************
 *  Function prototypes
 **/
int  CORE_zgelqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
void CORE_zgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
void CORE_zsymm(int side, int uplo,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
int  CORE_zgeqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
int  CORE_zgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex64_t *L, int LDL,
                 PLASMA_Complex64_t *A, int LDA);
int  CORE_zgetrf(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_zpotrf(int uplo, int N, PLASMA_Complex64_t *A, int LDA, int *INFO);
int  CORE_zssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zttmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1,   int LDA1,
                 PLASMA_Complex64_t *A2,   int LDA2,
                 PLASMA_Complex64_t *V,    int LDV,
                 PLASMA_Complex64_t *T,    int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zssrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 PLASMA_Complex64_t *A1,   int LDA1,
                 PLASMA_Complex64_t *A2,   int LDA2,
                 PLASMA_Complex64_t *V,    int LDV,
                 PLASMA_Complex64_t *T,    int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zttrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 PLASMA_Complex64_t *A1,   int LDA1,
                 PLASMA_Complex64_t *A2,   int LDA2,
                 PLASMA_Complex64_t *V,    int LDV,
                 PLASMA_Complex64_t *T,    int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *L1, int LDL1,
                 PLASMA_Complex64_t *L2, int LDL2,
                 int *IPIV);
#ifdef COMPLEX
void CORE_zhemm(int side, int uplo,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
void CORE_zherk(int uplo, int trans,
                int N, int K,
                double alpha, PLASMA_Complex64_t *A, int LDA,
                double beta, PLASMA_Complex64_t *C, int LDC);
#endif
void CORE_zsyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
void CORE_ztrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB);
int  CORE_ztslqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
int  CORE_zttqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T,  int LDT,
                 PLASMA_Complex64_t *TAU,
                 PLASMA_Complex64_t *WORK);
int  CORE_ztsqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
int  CORE_ztstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex64_t *U, int LDU,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *L, int LDL,
                 int *IPIV, PLASMA_Complex64_t *WORK,
                 int LDWORK, int *INFO);
int  CORE_zunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK);
int  CORE_zunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK);

/** ****************************************************************************
 *  Dynamic scheduler wrapper prototypes
 **/
void CORE_zgetrf_quark(Quark* quark);
void CORE_zgessm_quark(Quark* quark);
void CORE_ztstrf_quark(Quark* quark);
void CORE_zssssm_quark(Quark* quark);
void CORE_ztrsm_quark(Quark* quark);
void CORE_zgemm_quark(Quark* quark);
void CORE_zsymm_quark(Quark* quark);
void CORE_zpotrf_quark(Quark* quark);
#ifdef COMPLEX
void CORE_zhemm_quark(Quark* quark);
void CORE_zherk_quark(Quark* quark);
#endif
void CORE_zsyrk_quark(Quark* quark);
void CORE_zgeqrt_quark(Quark* quark);
void CORE_zunmqr_quark(Quark* quark);
void CORE_ztsqrt_quark(Quark* quark);
void CORE_zssmqr_quark(Quark* quark);
void CORE_zgelqt_quark(Quark* quark);
void CORE_zunmlq_quark(Quark* quark);
void CORE_ztslqt_quark(Quark* quark);
void CORE_zssmlq_quark(Quark* quark);

#ifdef __cplusplus
}
#endif

#endif
