/**
 *
 * @file core_sblas.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @author Hatem Ltaief
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_CORE_SBLAS_H_
#define _PLASMA_CORE_SBLAS_H_
#define COMPLEX

#ifdef __cplusplus
extern "C" {
#endif

/** ****************************************************************************
 *  Function prototypes
 **/
int  CORE_sgelqt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK);
void CORE_sgemm(int transA, int transB,
                int M, int N, int K,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC);
void CORE_ssymm(int side, int uplo,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC);
int  CORE_sgeqrt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK);
int  CORE_sgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 float *L, int LDL,
                 float *A, int LDA);
int  CORE_sgetrf(int M, int N, int IB,
                 float *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_spotrf(int uplo, int N, float *A, int LDA, int *INFO);
int  CORE_sssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK);
int  CORE_sssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK);
int  CORE_sttmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1,   int LDA1,
                 float *A2,   int LDA2,
                 float *V,    int LDV,
                 float *T,    int LDT,
                 float *WORK, int LDWORK);
int  CORE_sssrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 float *A1,   int LDA1,
                 float *A2,   int LDA2,
                 float *V,    int LDV,
                 float *T,    int LDT,
                 float *WORK, int LDWORK);
int  CORE_sttrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 float *A1,   int LDA1,
                 float *A2,   int LDA2,
                 float *V,    int LDV,
                 float *T,    int LDT,
                 float *WORK, int LDWORK);
int  CORE_sssssm(int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *L1, int LDL1,
                 float *L2, int LDL2,
                 int *IPIV);
#ifdef COMPLEX
void CORE_ssymm(int side, int uplo,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC);
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC);
#endif
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC);
void CORE_strsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB);
int  CORE_stslqt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK);
int  CORE_sttqrt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T,  int LDT,
                 float *TAU,
                 float *WORK);
int  CORE_stsqrt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK);
int  CORE_ststrf(int M, int N, int IB, int NB,
                 float *U, int LDU,
                 float *A, int LDA,
                 float *L, int LDL,
                 int *IPIV, float *WORK,
                 int LDWORK, int *INFO);
int  CORE_sormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK);
int  CORE_sormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK);

/** ****************************************************************************
 *  Dynamic scheduler wrapper prototypes
 **/
void CORE_sgetrf_quark(Quark* quark);
void CORE_sgessm_quark(Quark* quark);
void CORE_ststrf_quark(Quark* quark);
void CORE_sssssm_quark(Quark* quark);
void CORE_strsm_quark(Quark* quark);
void CORE_sgemm_quark(Quark* quark);
void CORE_ssymm_quark(Quark* quark);
void CORE_spotrf_quark(Quark* quark);
#ifdef COMPLEX
void CORE_ssymm_quark(Quark* quark);
void CORE_ssyrk_quark(Quark* quark);
#endif
void CORE_ssyrk_quark(Quark* quark);
void CORE_sgeqrt_quark(Quark* quark);
void CORE_sormqr_quark(Quark* quark);
void CORE_stsqrt_quark(Quark* quark);
void CORE_sssmqr_quark(Quark* quark);
void CORE_sgelqt_quark(Quark* quark);
void CORE_sormlq_quark(Quark* quark);
void CORE_stslqt_quark(Quark* quark);
void CORE_sssmlq_quark(Quark* quark);

#ifdef __cplusplus
}
#endif

#endif
