/**
 *
 * @file core_dblas.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @author Hatem Ltaief
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_CORE_DBLAS_H_
#define _PLASMA_CORE_DBLAS_H_
#define COMPLEX

#ifdef __cplusplus
extern "C" {
#endif

/** ****************************************************************************
 *  Function prototypes
 **/
int  CORE_dgelqt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK);
void CORE_dgemm(int transA, int transB,
                int M, int N, int K,
                double alpha, double *A, int LDA,
                double *B, int LDB,
                double beta, double *C, int LDC);
void CORE_dsymm(int side, int uplo,
                int M, int N,
                double alpha, double *A, int LDA,
                double *B, int LDB,
                double beta, double *C, int LDC);
int  CORE_dgeqrt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK);
int  CORE_dgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 double *L, int LDL,
                 double *A, int LDA);
int  CORE_dgetrf(int M, int N, int IB,
                 double *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_dpotrf(int uplo, int N, double *A, int LDA, int *INFO);
int  CORE_dssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK);
int  CORE_dssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK);
int  CORE_dttmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1,   int LDA1,
                 double *A2,   int LDA2,
                 double *V,    int LDV,
                 double *T,    int LDT,
                 double *WORK, int LDWORK);
int  CORE_dssrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 double *A1,   int LDA1,
                 double *A2,   int LDA2,
                 double *V,    int LDV,
                 double *T,    int LDT,
                 double *WORK, int LDWORK);
int  CORE_dttrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 double *A1,   int LDA1,
                 double *A2,   int LDA2,
                 double *V,    int LDV,
                 double *T,    int LDT,
                 double *WORK, int LDWORK);
int  CORE_dssssm(int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *L1, int LDL1,
                 double *L2, int LDL2,
                 int *IPIV);
#ifdef COMPLEX
void CORE_dsymm(int side, int uplo,
                int M, int N,
                double alpha, double *A, int LDA,
                double *B, int LDB,
                double beta, double *C, int LDC);
void CORE_dsyrk(int uplo, int trans,
                int N, int K,
                double alpha, double *A, int LDA,
                double beta, double *C, int LDC);
#endif
void CORE_dsyrk(int uplo, int trans,
                int N, int K,
                double alpha, double *A, int LDA,
                double beta, double *C, int LDC);
void CORE_dtrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                double alpha, double *A, int LDA,
                double *B, int LDB);
int  CORE_dtslqt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK);
int  CORE_dttqrt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T,  int LDT,
                 double *TAU,
                 double *WORK);
int  CORE_dtsqrt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK);
int  CORE_dtstrf(int M, int N, int IB, int NB,
                 double *U, int LDU,
                 double *A, int LDA,
                 double *L, int LDL,
                 int *IPIV, double *WORK,
                 int LDWORK, int *INFO);
int  CORE_dormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK);
int  CORE_dormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK);

/** ****************************************************************************
 *  Dynamic scheduler wrapper prototypes
 **/
void CORE_dgetrf_quark(Quark* quark);
void CORE_dgessm_quark(Quark* quark);
void CORE_dtstrf_quark(Quark* quark);
void CORE_dssssm_quark(Quark* quark);
void CORE_dtrsm_quark(Quark* quark);
void CORE_dgemm_quark(Quark* quark);
void CORE_dsymm_quark(Quark* quark);
void CORE_dpotrf_quark(Quark* quark);
#ifdef COMPLEX
void CORE_dsymm_quark(Quark* quark);
void CORE_dsyrk_quark(Quark* quark);
#endif
void CORE_dsyrk_quark(Quark* quark);
void CORE_dgeqrt_quark(Quark* quark);
void CORE_dormqr_quark(Quark* quark);
void CORE_dtsqrt_quark(Quark* quark);
void CORE_dssmqr_quark(Quark* quark);
void CORE_dgelqt_quark(Quark* quark);
void CORE_dormlq_quark(Quark* quark);
void CORE_dtslqt_quark(Quark* quark);
void CORE_dssmlq_quark(Quark* quark);

#ifdef __cplusplus
}
#endif

#endif
