/**
 *
 * @file core_cblas.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @author Hatem Ltaief
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_CORE_CBLAS_H_
#define _PLASMA_CORE_CBLAS_H_
#define COMPLEX

#ifdef __cplusplus
extern "C" {
#endif

/** ****************************************************************************
 *  Function prototypes
 **/
int  CORE_cgelqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
void CORE_cgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
void CORE_csymm(int side, int uplo,
                int M, int N,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
int  CORE_cgeqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
int  CORE_cgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex32_t *L, int LDL,
                 PLASMA_Complex32_t *A, int LDA);
int  CORE_cgetrf(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_cpotrf(int uplo, int N, PLASMA_Complex32_t *A, int LDA, int *INFO);
int  CORE_cssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cttmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1,   int LDA1,
                 PLASMA_Complex32_t *A2,   int LDA2,
                 PLASMA_Complex32_t *V,    int LDV,
                 PLASMA_Complex32_t *T,    int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cssrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 PLASMA_Complex32_t *A1,   int LDA1,
                 PLASMA_Complex32_t *A2,   int LDA2,
                 PLASMA_Complex32_t *V,    int LDV,
                 PLASMA_Complex32_t *T,    int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cttrfb(int side, int trans, int direct, int storev,
                 int M1, int M2, int NN, int IB,
                 PLASMA_Complex32_t *A1,   int LDA1,
                 PLASMA_Complex32_t *A2,   int LDA2,
                 PLASMA_Complex32_t *V,    int LDV,
                 PLASMA_Complex32_t *T,    int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *L1, int LDL1,
                 PLASMA_Complex32_t *L2, int LDL2,
                 int *IPIV);
#ifdef COMPLEX
void CORE_chemm(int side, int uplo,
                int M, int N,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
void CORE_cherk(int uplo, int trans,
                int N, int K,
                float alpha, PLASMA_Complex32_t *A, int LDA,
                float beta, PLASMA_Complex32_t *C, int LDC);
#endif
void CORE_csyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
void CORE_ctrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB);
int  CORE_ctslqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
int  CORE_cttqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T,  int LDT,
                 PLASMA_Complex32_t *TAU,
                 PLASMA_Complex32_t *WORK);
int  CORE_ctsqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
int  CORE_ctstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex32_t *U, int LDU,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *L, int LDL,
                 int *IPIV, PLASMA_Complex32_t *WORK,
                 int LDWORK, int *INFO);
int  CORE_cunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK);
int  CORE_cunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK);

/** ****************************************************************************
 *  Dynamic scheduler wrapper prototypes
 **/
void CORE_cgetrf_quark(Quark* quark);
void CORE_cgessm_quark(Quark* quark);
void CORE_ctstrf_quark(Quark* quark);
void CORE_cssssm_quark(Quark* quark);
void CORE_ctrsm_quark(Quark* quark);
void CORE_cgemm_quark(Quark* quark);
void CORE_csymm_quark(Quark* quark);
void CORE_cpotrf_quark(Quark* quark);
#ifdef COMPLEX
void CORE_chemm_quark(Quark* quark);
void CORE_cherk_quark(Quark* quark);
#endif
void CORE_csyrk_quark(Quark* quark);
void CORE_cgeqrt_quark(Quark* quark);
void CORE_cunmqr_quark(Quark* quark);
void CORE_ctsqrt_quark(Quark* quark);
void CORE_cssmqr_quark(Quark* quark);
void CORE_cgelqt_quark(Quark* quark);
void CORE_cunmlq_quark(Quark* quark);
void CORE_ctslqt_quark(Quark* quark);
void CORE_cssmlq_quark(Quark* quark);

#ifdef __cplusplus
}
#endif

#endif
