        PROGRAM EXAMPLE_CPOSV_F
*
*********************************************************************
*     PLASMA example routine (version 2.2.0)                        *
*     Author: Bilel Hadri                                           *
*     Release Date: November, 15th 2009                             *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
        IMPLICIT NONE
*
        INCLUDE "plasmaf.h"
*
*  Purpose
*  =======
*
*   FORTRAN EXAMPLE FOR PLASMA_CPOSV
*   Example for solving a system of linear equations using Cholesky 
*   factorization
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER           CORES, N, NRHS
      PARAMETER         ( CORES = 2 )
      PARAMETER         ( N = 15 )
      PARAMETER         ( NRHS = 5 )
      COMPLEX*16        CONE
      PARAMETER         ( CONE = ( 1.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      COMPLEX*16  A1( N, N ), B1( N, NRHS ), WORK( 2*N )
      COMPLEX*16  A2( N, N ), B2( N, NRHS )
      REAL  D( N )
      REAL  RWORK ( N )
      INTEGER           I, INFO
      INTEGER           ISEED( 4 )
      REAL  XNORM, ANORM, BNORM, RNORM, EPS
      REAL  SLAMCH, CLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL          DLARNV, CLAGHE, SLAMCH, CLANGE
      EXTERNAL          PLASMA_INIT, PLASMA_CPOSV, PLASMA_FINALIZE
      EXTERNAL          CGEMM
*     ..
*     .. Executable Statements ..
*
      DO  I = 1, 4
          ISEED( I ) = 1
      ENDDO
*
*     Initialize Plasma
*
      CALL PLASMA_INIT( CORES, INFO )
      WRITE(*,*) "-- PLASMA is initialized on", CORES, "cores."
*
*     Initialization of the matrix A1
*
      CALL DLARNV( 1, ISEED, N, D )
      CALL CLAGHE( N, N-1, D, A1, N, ISEED, WORK, INFO )
*
*     Make it definite positive
*
      DO I = 1, N
         A1( I, I ) = A1( I, I ) + N
      ENDDO
      A2(:,:)=A1(:,:)
*
*     Initialization of the RHS
*
      CALL CLARNV( 1, ISEED, N*NRHS, B1 )
      B2(:,:)=B1(:,:)
*
*     Perform the Cholesky solve
*
      CALL PLASMA_CPOSV( PlasmaUpper, N, NRHS, A2, N, B2, N, INFO )
*
*     Check the solution
*
      XNORM = CLANGE('I',N, NRHS, B2, N, RWORK)
      ANORM = CLANGE('I',N, N, A1, N, RWORK)
      BNORM = CLANGE('I',N, NRHS, B1, N, RWORK)

      CALL CGEMM('No transpose','No transpose', N, NRHS, N, CONE,
     $              A1, N, B2, N, -CONE, B1, N)

      RNORM = CLANGE('I',N, NRHS, B1, N, RWORK)

      EPS= SLAMCH('Epsilon')

      WRITE(*,*) '============'
      WRITE(*,*) 'Checking the Residual of the solution '
      WRITE(*,*) '-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps)=',
     $        RNORM / ((ANORM * XNORM + BNORM) * N * EPS)

      IF ((RNORM > 60.0).AND.( INFO < 0 )) THEN
          WRITE(*,*) "-- Error in CPOSV example !"
      ELSE
          WRITE(*,*) "-- Run of CPOSV example successful !"
      ENDIF
*
*    Finalize Plasma
*
      CALL PLASMA_FINALIZE( INFO )
*
*     End of EXAMPLE_CPOSV.
*
      END PROGRAM EXAMPLE_CPOSV_F
