      SUBROUTINE CORE_ZTTRFB( SIDE, TRANS, DIRECT, STOREV,
     $                         M1, M2, NN, IB, A1, LDA1, A2, LDA2,
     $                         V, LDV, T, LDT, WORK, LDWORK, INFO )

*********************************************************************
*     PLASMA core_blas routine (version 2.2.0)                      *
*     Author: Hatem Ltaief                                          *
*     Release Date: November, 15th 2009                             *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
*     .. Scalar Arguments ..
      INTEGER            M1, M2, NN, IB
      INTEGER            LDA1, LDA2, LDV, LDT, LDWORK
      INTEGER            INFO
*     ..
*     .. Array Arguments ..
      COMPLEX*16            A1(LDA1, * ), A2( LDA2, * )
      COMPLEX*16            V( LDV, * ), T( LDT, * )
      COMPLEX*16            WORK( LDWORK, * )
*     ..
*     .. Character Arguments ..
      CHARACTER          SIDE, TRANS, DIRECT, STOREV
*     ..
*
*  Purpose
*  =======
*
*  CORE_ZTTRFB applies a complex upper triangular block reflector H
*  or its transpose H' to a
*  complex rectangular matrix formed by coupling two tiles A1 and A2.
*  (Only SIDE='L' and STOREV='C' supported!)
*
*  Arguments
*  =========
*
*  SIDE    (input) CHARACTER*1
*          = 'L': apply H or H' from the Left
*          = 'R': apply H or H' from the Right
*
*  TRANS   (input) CHARACTER*1
*          = 'N': apply H (No transpose)
*          = 'C': apply H' (Conjugate transpose)
*
*  DIRECT  (input) CHARACTER*1
*          Indicates how H is formed from a product of elementary
*          reflectors
*          = 'F': H = H(1) H(2) . . . H(k) (Forward)
*          = 'B': H = H(k) . . . H(2) H(1) (Backward)
*
*  STOREV  (input) CHARACTER*1
*          Indicates how the vectors which define the elementary
*          reflectors are stored:
*          = 'C': Columnwise
*          = 'R': Rowwise
*
*  M1      (input) INTEGER
*          The number of rows of the tile A1. M1 >= 0.
*
*  M2      (input) INTEGER
*          The number of rows of the tile A2. M2 >= 0.
*
*  NN      (input) INTEGER
*          The number of columns of the tiles A1 and A2. NN >= 0.
*
*  IB      (input) INTEGER
*          The inner-blocking size.  IB >= 0.
*
*  K       (input) INTEGER
*          The order of the matrix T (= the number of elementary
*          reflectors whose product defines the block reflector).
*
*  A1      (input/output) COMPLEX*16 array, dimension (LDA1,M1)
*          On entry, the M1-by-NN tile A1.
*          On exit, A1 is overwritten by the application of Q.
*
*  LDA1    (input) INTEGER
*          The leading dimension of the tile A1. LDA1 >= max(1,M1).
*
*  A2      (input/output) COMPLEX*16 array, dimension (LDA2,M2)
*          On entry, the M2-by-NN tile A2.
*          On exit, A2 is overwritten by the application of Q.
*
*  LDA2    (input) INTEGER
*          The leading dimension of the tile A2. LDA2 >= max(1,M2).
*
*  V       (input) COMPLEX*16 array, dimension
*                                (LDV,K) if STOREV = 'C'
*                                (LDV,M) if STOREV = 'R' and SIDE = 'L'
*                                (LDV,N) if STOREV = 'R' and SIDE = 'R'
*          The upper triangular matrix V.
*
*  LDV     (input) INTEGER
*          The leading dimension of the array V.
*          If STOREV = 'C' and SIDE = 'L', LDV >= max(1,M);
*          if STOREV = 'C' and SIDE = 'R', LDV >= max(1,N);
*          if STOREV = 'R', LDV >= K.
*
*  T       (input) COMPLEX*16 array, dimension (LDT,K)
*          The triangular K-by-K matrix T in the representation of the
*          block reflector.
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T. LDT >= K.
*
*  WORK    (workspace/output) COMPLEX*16 array, dimension (LDWORK,K)
*
*  LDWORK  (input) INTEGER
*          The dimension of the array WORK.
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*
*  =====================================================================
*     ..
*     .. Local Scalars ..
      INTEGER            J
*     ..
*     .. Parameters ..
      COMPLEX*16            ZONE, MZONE
      INTEGER            IONE
      PARAMETER          ( ZONE = 1.0D+0 )
      PARAMETER          ( MZONE = -1.0D+0 )
      PARAMETER          ( IONE = 1 )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     Test the input arguments.
      INFO = 0
      IF( M1.LT.0 ) THEN
         INFO = -5
      ELSE IF( M2.LT.0 ) THEN
         INFO = -6
      ELSE IF( NN.LT.0 ) THEN
         INFO = -7
      ELSE IF( IB.LT.0 ) THEN
         INFO = -8
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_ZTTRFB', -INFO )
         RETURN
      END IF
*
*     Quick return if possible.
*
      IF( M1.LE.0 .OR. M2.LE.0 .OR. NN.LE.0 .OR. IB.LE.0 )
     $   RETURN
*
      IF( LSAME( STOREV, 'C' ) ) THEN
*
         IF( LSAME( SIDE, 'L' ) ) THEN
*
*              B = A1+V'*A2
*
               CALL ZLACPY( 'General', IB, NN, A2( M2-IB+1, 1 ), LDA2,
     $                      WORK, LDWORK )
*
               CALL ZTRMM( 'Left', 'Upper', 'ConjTranspose', 'Nounit',
     $                    IB, NN, ZONE,
     $                    V( M2-IB+1, 1 ), LDV,
     $                    WORK, LDWORK )
*
               IF ( M2.GT.IB ) THEN
                   CALL ZGEMM( 'ConjTranspose', 'Notranspose', IB, NN,
     $                    M2-IB, ZONE, V, LDV,
     $                    A2, LDA2,
     $                    ZONE, WORK, LDWORK )
               ENDIF
*
               DO 900 J = 1, NN
                  CALL ZAXPY( IB, ZONE, A1( 1, J ), IONE,
     $                       WORK( 1, J ), IONE )
 900           CONTINUE
*
*              A2 = A2 - V*T*B --->  B=T*B, A2=A2-V*B
*
               CALL ZTRMM( 'Left', 'Upper', TRANS, 'Nounit', IB, NN,
     $                    ZONE, T, LDT, WORK, LDWORK )
*
*              A1 = A1 - T*B
*
               DO 20 J = 1, NN
                  CALL ZAXPY( IB, MZONE, WORK( 1, J ), IONE,
     $                       A1( 1, J ), IONE )
 20            CONTINUE

               IF ( M2.GT.IB ) THEN
                  CALL ZGEMM( 'Notranspose', 'Notranspose', M2-IB,
     $                    NN, IB, MZONE, V, LDV, WORK,
     $                    LDWORK, ZONE, A2, LDA2 )
               ENDIF

               CALL ZTRMM( 'Left', 'Upper', 'Notranspose', 'Nounit',
     $                    IB, NN, MZONE,
     $                    V( M2-IB+1, 1 ), LDV,
     $                    WORK, LDWORK )
               DO 920 J = 1, NN
                  CALL ZAXPY( IB, ZONE, WORK( 1, J ), IONE,
     $                       A2( M2-IB+1, J ), IONE )
 920           CONTINUE
*
         ENDIF
*
      ENDIF
*
*     End of CORE_ZTTRFB.
*
      END
