      SUBROUTINE CORE_ZTTQRT( M, N, IB, A1, LDA1, A2, LDA2, T, LDT,
     $     TAU, WORK, INFO )

*********************************************************************
*     PLASMA core_blas routine (version 2.2.0)                      *
*     Author: Hatem Ltaief                                          *
*     Release Date: November, 15th 2009                             *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
*     .. Scalar Arguments ..
      INTEGER            M, N, IB, LDA1, LDA2, LDT, INFO
*     ..
*     .. Array Arguments ..
      COMPLEX*16   A1( LDA1, * ), A2( LDA2, * )
      COMPLEX*16   T( LDT, * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  CORE_ZTTQRT computes a QR factorization of a rectangular matrix
*  formed by coupling a complex N-by-N upper triangular tile A1
*  on top of a complex M-by-N upper triangular tile A2:
*
*  | A1 | = Q * R
*  | A2 |
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the tile A2.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the tile A1 and A2.  N >= 0.
*
*  IB      (input) INTEGER
*          The inner-blocking size.  IB >= 0.
*
*  A1      (input/output) COMPLEX*16 array, dimension (LDA1,N)
*          On entry, the N-by-N tile A1.
*          On exit, the elements on and above the diagonal of the array
*          contain the N-by-N upper trapezoidal tile R;
*          the elements below the diagonal are not referenced.
*
*  LDA1    (input) INTEGER
*          The leading dimension of the array A1.  LDA1 >= max(1,N).
*
*  A2      (input/output) COMPLEX*16 array, dimension (LDA2,N)
*          On entry, the M-by-N upper triangular tile A2.
*          On exit, the elements on and above the diagonal of the array
*          with the array TAU, represent
*          the unitary tile Q as a product of elementary reflectors
*          (see Further Details).
*
*  LDA2    (input) INTEGER
*          The leading dimension of the array A2.  LDA2 >= max(1,M).
*
*  T       (output) COMPLEX*16 array, dimension (LDT,N)
*          The IB-by-N triangular factor T of the block reflector.
*          T is upper triangular by block (economic storage);
*          The rest of the array is not referenced.
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T. LDT >= IB.
*
*  TAU     (output) COMPLEX*16 array, dimension (min(M,N))
*          The scalar factors of the elementary reflectors (see Further
*          Details).
*
*  WORK    (workspace) COMPLEX*16 array, dimension (N)
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -i, the i-th argument had an illegal value
*
*  Further Details
*  ===============
*
*  The tile Q is represented as a product of elementary reflectors
*
*     Q = H(1) H(2) . . . H(k), where k = min(M,N).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a complex scalar, and v is a complex vector with
*  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A2(1:m,i),
*  and tau in TAU(i).
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX*16            ZONE, ZZERO
      INTEGER            IONE
      PARAMETER          ( ZONE = ( 1.0D+0, 0.0D+0 ) )
      PARAMETER          ( ZZERO = ( 0.0D+0, 0.0D+0 ) )
      PARAMETER          ( IONE = 1 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, II, J, SB, IINFO
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZLARFG, CORE_ZTTSSMQR, XERBLA
      EXTERNAL           ZCOPY, ZGEMV, ZTRMV, ZAXPY, ZGERC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CONJG, MAX
*     ..
*     Test the input arguments.
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( IB.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA2.LT.MAX( 1, M ) ) THEN
         INFO = -7
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_ZTTQRT', -INFO )
         RETURN
      END IF
*
*     Quick return if possible.
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 )
     $   RETURN
*
      DO 10 II = 1, N, IB
         SB = MIN( N-II+1, IB )
         DO 20 I = 1, SB
*
*           Generate elementary reflector H( II*IB+I ) to annihilate
*           A( II*IB+I:M, II*IB+I ).
*
            CALL ZLARFG( II+I, A1( II+I-1, II+I-1 ), A2( 1, II+I-1 ),
     $                  IONE, TAU( II+I-1 ) )
*
            IF( ( II+I-1 ).LT.N ) THEN
*
*              Apply H( II*IB+I ) to A( II*IB+I:M, II*IB+I+1:II*IB+IB ) from the left.
*
               CALL ZCOPY( SB-I, A1( II+I-1, II+I ), LDA1,
     $                    WORK, IONE )
*#IFDEF COMPLEX .OR. COMPLEX_16
               CALL ZLACGV( SB-I, WORK, IONE )
*#ENDIF
               CALL ZGEMV( 'ConjTranspose', II+I-1, SB-I, ZONE,
     $                    A2( 1, II+I ), LDA2, A2( 1, II+I-1 ),
     $                    IONE, ZONE, WORK, IONE )
*#IFDEF COMPLEX .OR. COMPLEX_16
               CALL ZLACGV( SB-I, WORK, IONE )
*#ENDIF
               CALL ZAXPY( SB-I, -CONJG( TAU( II+I-1 ) ), WORK, IONE,
     $                    A1( II+I-1, II+I ), LDA1 )
*#IFDEF COMPLEX .OR. COMPLEX_16
               CALL ZLACGV( SB-I, WORK, IONE )
*#ENDIF
               CALL ZGERC( II+I-1, SB-I, -CONJG( TAU( II+I-1 ) ),
     $                    A2( 1, II+I-1 ), IONE, WORK, IONE,
     $                    A2( 1, II+I ), LDA2 )
            END IF
*
*           Calculate T.
*
            CALL ZCOPY( I-1, A2( II, II+I-1 ), IONE, WORK(II), IONE )
*
            CALL ZTRMV( 'Upper', 'ConjTranspose', 'Nonunit', I-1,
     $                 A2( II, II ), LDA2, WORK(II), IONE )
*
            DO 40 J = 1, I-1
               WORK( II+J-1 )  = -TAU( II+I-1 ) * WORK( II+J-1 )
 40         CONTINUE
*
            IF ( II.GT.1 ) THEN
                CALL ZGEMV( 'ConjTranspose', II-1, I-1, -TAU( II+I-1 ),
     $                 A2( 1, II ), LDA2, A2( 1, II+I-1 ), IONE,
     $                 ZZERO, WORK, IONE )
                CALL ZAXPY( I-1, ZONE, WORK( II ), IONE, WORK, IONE )
            ENDIF
*
            CALL ZCOPY( I-1, WORK, IONE, T( 1, II+I-1 ) , IONE )
*
            CALL ZTRMV( 'Upper', 'Notranspose', 'Nonunit', I-1,
     $                 T( 1, II ), LDT, T( 1, II+I-1 ), IONE )
            T( I, II+I-1 ) = TAU( II+I-1 )
 20      CONTINUE
         IF ( N.GT.( II+IB-1 ) ) THEN
             CALL CORE_ZTTMQR( 'Left', 'ConjTranspose',
     $                    SB, II+SB-1, N-( II+SB-1 ), IB, IB,
     $                    A1( II, II+SB ), LDA1,
     $                    A2( 1, II+SB ), LDA2,
     $                    A2( 1, II ), LDA2,
     $                    T( 1, II ), LDT, WORK, SB, IINFO )
         ENDIF
 10   CONTINUE
*
      RETURN
*
*     End of CORE_ZTTQRT.
*
      END
