/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.2.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "core_blas.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zgelqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK)
{
    int INFO;

    core_zgelqt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC)
{
    cblas_zgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        CBLAS_SADDR(alpha), A, LDA,
        B, LDB,
        CBLAS_SADDR(beta), C, LDC);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zhemm(int side, int uplo,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC)
{
    cblas_zhemm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        M, N,
        CBLAS_SADDR(alpha), A, LDA,
        B, LDB,
        CBLAS_SADDR(beta), C, LDC);
}


/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zgeqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK)
{
    int INFO;

    core_zgeqrt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex64_t *L, int LDL,
                 PLASMA_Complex64_t *A, int LDA)
{
    int INFO;

    core_zgessm(
        &M, &N, &K, &IB,
        IPIV,
        L, &LDL,
        A, &LDA,
        &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zgetrf(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 int *IPIV, int *INFO)
{
    core_zgetrf(
        &M, &N, &IB,
        A, &LDA,
        IPIV, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zpotrf(int uplo, int N, PLASMA_Complex64_t *A, int LDA, int *INFO)
{
    zpotrf(lapack_const(uplo), &N, A, &LDA, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK)
{
    int INFO;

    core_zssmlq(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK)
{
    int INFO;

    core_zssmqr(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *L1, int LDL1,
                 PLASMA_Complex64_t *L2, int LDL2,
                 int *IPIV)
{
    int INFO;

    core_zssssm(
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        L1, &LDL1,
        L2, &LDL2,
        IPIV,
        &INFO);
}
//#IFDEF COMPLEX .OR. COMPLEX_16
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zherk(int uplo, int trans,
                int N, int K,
                double alpha, PLASMA_Complex64_t *A, int LDA,
                double beta, PLASMA_Complex64_t *C, int LDC)
{
    cblas_zherk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        alpha, A, LDA,
        beta, C, LDC);
}
//#ENDIF
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zsyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC)
{
    cblas_zsyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        CBLAS_SADDR(alpha), A, LDA,
        CBLAS_SADDR(beta), C, LDC);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ztrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB)
{
    cblas_ztrsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        CBLAS_SADDR(alpha), A, LDA,
        B, LDB);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ztslqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK)
{
    int INFO;

    core_ztslqt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ztsqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK)
{
    int INFO;

    core_ztsqrt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ztstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex64_t *U, int LDU,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *L, int LDL,
                 int *IPIV, PLASMA_Complex64_t *WORK,
                 int LDWORK, int *INFO)
{
    core_ztstrf(
        &M, &N, &IB, &NB,
        U, &LDU,
        A, &LDA,
        L, &LDL,
        IPIV,
        WORK, &LDWORK, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK)
{
    int INFO;

    core_zunmlq(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_zunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK)
{
    int INFO;

    core_zunmqr(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}
