/**
 *
 * @file core_sblas.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @author Hatem Ltaief
 * @date 2009-11-15
 *
 **/
#include <lapack.h>
#include "common.h"
#include "core_blas.h"
#undef COMPLEX
#define REAL

/***************************************************************************//**
 *
 **/
void CORE_sgemm(int transA, int transB,
                int M, int N, int K,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC)
{
    cblas_sgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_sgemm_quark(Quark* quark)
{
    int transA;
    int transB;
    int M;
    int N;
    int K;
    float alpha;
    float *A;
    int LDA;
    float *B;
    int LDB;
    float beta;
    float *C;
    int LDC;

    quark_unpack_args_13(quark, transA, transB, M, N, K, alpha, A, LDA, B, LDB, beta, C, LDC);
    cblas_sgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssymm(int side, int uplo,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC)
{
    cblas_ssymm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        M, N,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssymm_quark(Quark* quark)
{
    int side;
    int uplo;
    int M;
    int N;
    float alpha;
    float *A;
    int LDA;
    float *B;
    int LDB;
    float beta;
    float *C;
    int LDC;

    quark_unpack_args_12(quark, side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC);
    cblas_ssymm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        M, N,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_spotrf(int uplo, int N, float *A, int LDA, int *INFO)
{
    lapack_spotrf((enum lapack_uplo_type)uplo, N, A, LDA, INFO);
}

/***************************************************************************//**
 *
 **/
void CORE_spotrf_quark(Quark* quark)
{
    int uplo;
    int N;
    float *A;
    int LDA;
    PLASMA_sequence *sequence;
    PLASMA_request *request;
    int iinfo;

    int info;

    quark_unpack_args_7(quark, uplo, N, A, LDA, sequence, request, iinfo);
    lapack_spotrf((enum lapack_uplo_type)uplo, N, A, LDA, &info);
    if ((sequence->status == PLASMA_SUCCESS) && (info != 0) )
      plasma_sequence_flush(quark, sequence, request, iinfo + info);
}

#ifdef COMPLEX
/***************************************************************************//**
 *
 **/
void CORE_ssymm(int side, int uplo,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC)
{
    cblas_ssymm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        M, N,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssymm_quark(Quark* quark)
{
    int side;
    int uplo;
    int M;
    int N;
    float alpha;
    float *A;
    int LDA;
    float *B;
    int LDB;
    float beta;
    float *C;
    int LDC;

    quark_unpack_args_12(quark, side, uplo, M, N, alpha, A, LDA, B, LDB, beta, C, LDC);
    cblas_ssymm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        M, N,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC)
{
    cblas_ssyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        alpha, A, LDA,
        beta, C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssyrk_quark(Quark* quark)
{
    int uplo;
    int trans;
    int N;
    int K;
    float alpha;
    float *A;
    int LDA;
    float beta;
    float *C;
    int LDC;

    quark_unpack_args_10(quark, uplo, trans, N, K, alpha, A, LDA, beta, C, LDC);
    cblas_ssyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        alpha, A, LDA,
        beta, C, LDC);
}
#endif

/***************************************************************************//**
 *
 **/
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC)
{
    cblas_ssyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        (alpha), A, LDA,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_ssyrk_quark(Quark* quark)
{
    int uplo;
    int trans;
    int N;
    int K;
    float alpha;
    float *A;
    int LDA;
    float beta;
    float *C;
    int LDC;

    quark_unpack_args_10(quark, uplo, trans, N, K, alpha, A, LDA, beta, C, LDC);
    cblas_ssyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        (alpha), A, LDA,
        (beta), C, LDC);
}

/***************************************************************************//**
 *
 **/
void CORE_strsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB)
{
    cblas_strsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        (alpha), A, LDA,
        B, LDB);
}

/***************************************************************************//**
 *
 **/
void CORE_strsm_quark(Quark* quark)
{
    int side;
    int uplo;
    int transA;
    int diag;
    int M;
    int N;
    float alpha;
    float *A;
    int LDA;
    float *B;
    int LDB;

    quark_unpack_args_11(quark, side, uplo, transA, diag, M, N, alpha, A, LDA, B, LDB);
    cblas_strsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        (alpha), A, LDA,
        B, LDB);
}
