/**
 *
 * @file workspace_z.h
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _WORKSPACE_Z_H_
#define _WORKSPACE_Z_H_

#ifdef __cplusplus
extern "C" {
#endif

int PLASMA_Alloc_Workspace_zgels(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgeqrf(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgelqf(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgesv(int N, PLASMA_Complex64_t **L, int **IPIV);
int PLASMA_Alloc_Workspace_zgetrf(int M, int N, PLASMA_Complex64_t **L, int **IPIV);

int PLASMA_Alloc_Workspace_zgels_Tile (int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_zgeqrf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_zgelqf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_zgesv_Tile (int N, PLASMA_desc **descL, int **IPIV); 
int PLASMA_Alloc_Workspace_zgetrf_Tile(int N, PLASMA_desc **descL, int **IPIV); 
#ifdef __cplusplus
}
#endif

#endif
