/**
 *
 * @file workspace_d.h
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _WORKSPACE_D_H_
#define _WORKSPACE_D_H_

#ifdef __cplusplus
extern "C" {
#endif

int PLASMA_Alloc_Workspace_dgels(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgeqrf(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgelqf(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgesv(int N, double **L, int **IPIV);
int PLASMA_Alloc_Workspace_dgetrf(int M, int N, double **L, int **IPIV);

int PLASMA_Alloc_Workspace_dgels_Tile (int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_dgeqrf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_dgelqf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_dgesv_Tile (int N, PLASMA_desc **descL, int **IPIV); 
int PLASMA_Alloc_Workspace_dgetrf_Tile(int N, PLASMA_desc **descL, int **IPIV); 
#ifdef __cplusplus
}
#endif

#endif
