/**
 *
 * @file workspace_c.h
 *
 *  PLASMA computational routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _WORKSPACE_C_H_
#define _WORKSPACE_C_H_

#ifdef __cplusplus
extern "C" {
#endif

int PLASMA_Alloc_Workspace_cgels(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgeqrf(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgelqf(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgesv(int N, PLASMA_Complex32_t **L, int **IPIV);
int PLASMA_Alloc_Workspace_cgetrf(int M, int N, PLASMA_Complex32_t **L, int **IPIV);

int PLASMA_Alloc_Workspace_cgels_Tile (int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_cgeqrf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_cgelqf_Tile(int M, int N, PLASMA_desc **descT);
int PLASMA_Alloc_Workspace_cgesv_Tile (int N, PLASMA_desc **descL, int **IPIV); 
int PLASMA_Alloc_Workspace_cgetrf_Tile(int N, PLASMA_desc **descL, int **IPIV); 
#ifdef __cplusplus
}
#endif

#endif
