/**
 *
 * @file workspace.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_WORKSPACE_H_
#define _PLASMA_WORKSPACE_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  Internal routines
 **/
int plasma_alloc_ibnb     (int M, int N, int operation, int type, void **memptr);
int plasma_alloc_ibnb_tile(int M, int N, int operation, int type, PLASMA_desc **desc);
int plasma_alloc_ipiv     (int M, int N, int operation, void **memptr);


/***************************************************************************//**
 *  User routines
 **/
int PLASMA_Dealloc_Handle(void **handle);
int PLASMA_Dealloc_Handle_Tile(PLASMA_desc **desc);

#include "workspace_z.h"
#include "workspace_d.h"
#include "workspace_c.h"
#include "workspace_s.h"

#ifdef __cplusplus
}
#endif

#endif
