/**
 *
 * @file tile.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_TILE_H_
#define _PLASMA_TILE_H_

#include <inttypes.h>
#define BLKADDR(A, type, m, n)  &(((type*)A.mat)[(int64_t)A.bsiz*(int64_t)((m+A.i/A.nb)+(int64_t)A.lmt*(int64_t)(n+A.j/A.nb))])

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  Internal routines
 **/
void plasma_tile_to_lapack(plasma_context_t *plasma);
void plasma_lapack_to_tile(plasma_context_t *plasma);
void plasma_tile_zero(plasma_context_t *plasma);

void plasma_ztile_to_lapack(plasma_context_t *plasma);
void plasma_ctile_to_lapack(plasma_context_t *plasma);
void plasma_dtile_to_lapack(plasma_context_t *plasma);
void plasma_stile_to_lapack(plasma_context_t *plasma);
void plasma_zlapack_to_tile(plasma_context_t *plasma);
void plasma_clapack_to_tile(plasma_context_t *plasma);
void plasma_dlapack_to_tile(plasma_context_t *plasma);
void plasma_slapack_to_tile(plasma_context_t *plasma);
void plasma_ztile_zero(plasma_context_t *plasma);
void plasma_ctile_zero(plasma_context_t *plasma);
void plasma_dtile_zero(plasma_context_t *plasma);
void plasma_stile_zero(plasma_context_t *plasma);

/***************************************************************************//**
 * Dynamic scheduler routines
 **/
void plasma_ztile_to_lapack_quark(PLASMA_desc, PLASMA_Complex64_t*, int, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_ctile_to_lapack_quark(PLASMA_desc, PLASMA_Complex32_t*, int, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_dtile_to_lapack_quark(PLASMA_desc, double*,             int, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_stile_to_lapack_quark(PLASMA_desc, float*,              int, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_zlapack_to_tile_quark(PLASMA_Complex64_t*, int, PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_clapack_to_tile_quark(PLASMA_Complex32_t*, int, PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_dlapack_to_tile_quark(double*,             int, PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_slapack_to_tile_quark(float*,              int, PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_ztile_zero_quark(PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_ctile_zero_quark(PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_dtile_zero_quark(PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);
void plasma_stile_zero_quark(PLASMA_desc, PLASMA_sequence *sequence, PLASMA_request *request);

/***************************************************************************//**
 *  User routines
 **/
int PLASMA_Lapack_to_Tile(void *Af77, int LDA, PLASMA_desc *A);
int PLASMA_Tile_to_Lapack(PLASMA_desc *A, void *Af77, int LDA);

#ifdef __cplusplus
}
#endif

#endif
