/**
 *
 * @file descriptor.h
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#ifndef _PLASMA_DESCRIPTOR_H_
#define _PLASMA_DESCRIPTOR_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 *  Internal routines
 **/
PLASMA_desc plasma_desc_init(void *mat, PLASMA_enum dtyp, int mb, int nb, int bsiz, int lm, int ln, int i, int j, int m, int n);
PLASMA_desc plasma_desc_submatrix(PLASMA_desc descA, int i, int j, int m, int n);
int plasma_desc_check(PLASMA_desc *desc);

/***************************************************************************//**
 *  User routines
 **/
int PLASMA_Desc_Create(PLASMA_desc **desc, void *mat, PLASMA_enum dtyp, int mb, int nb, int bsiz, int lm, int ln, int i, int j, int m, int n);
int PLASMA_Desc_Destroy(PLASMA_desc **desc);

#ifdef __cplusplus
}
#endif

#endif
