/**
 *
 * @file pzungqr.c
 *
 *  PLASMA auxiliary routines
 *  PLASMA is a software package provided by Univ. of Tennessee,
 *  Univ. of California Berkeley and Univ. of Colorado Denver
 *
 * @version 2.2.0
 * @author Hatem Ltaief
 * @author Jakub Kurzak
 * @date 2009-11-15
 *
 **/
#include "common.h"

#define A(m,n) BLKADDR(A, PLASMA_Complex64_t, m, n)
#define Q(m,n) BLKADDR(Q, PLASMA_Complex64_t, m, n)
#define T(m,n) BLKADDR(T, PLASMA_Complex64_t, m, n)
/***************************************************************************//**
 *  Parallel construction of Q using tile V (application to identity) - dynamic scheduling
 **/
void plasma_pzungqr_quark(PLASMA_desc A, PLASMA_desc Q, PLASMA_desc T, PLASMA_sequence *sequence, PLASMA_request *request)
{
    int k, m, n;
    plasma_context_t *plasma;
    PLASMA_enum plasma_left = PlasmaLeft;
    PLASMA_enum plasma_no_trans = PlasmaNoTrans;
    int temp1, temp2, temp3;
    Quark_Task_Flags task_flags = Quark_Task_Flags_Initializer;

    plasma = plasma_context_self();
    if (sequence->status != PLASMA_SUCCESS)
        return;
    QUARK_Task_Flag_Set(&task_flags, TASK_SEQUENCE, (intptr_t)sequence->quark_sequence);

    for (k = A.nt - 1; k >= 0; k--) {
        for (m = Q.mt - 1; m > k; m--) {
            for (n = 0; n < Q.nt; n++) {
                temp1 = Q.m-m*Q.nb;
                temp2 = Q.n-n*Q.nb;
                temp3 = A.n-k*A.nb;
                QUARK_Insert_Task(plasma->quark, CORE_zssmqr_quark, &task_flags,
                    sizeof(PLASMA_enum),                  &plasma_left,                 VALUE,
                    sizeof(PLASMA_enum),                  &plasma_no_trans,             VALUE,
                    sizeof(int),                          &A.nb,                        VALUE,
                    sizeof(int),                          m == Q.mt-1 ? &temp1 : &Q.nb, VALUE,
                    sizeof(int),                          n == Q.nt-1 ? &temp2 : &Q.nb, VALUE,
                    sizeof(int),                          &T.mb,                        VALUE,
                    sizeof(int),                          k == A.nt-1 ? &temp3 : &A.nb, VALUE,
                    sizeof(PLASMA_Complex64_t)*A.mb*A.nb, Q(k, n),                          INOUT | LOCALITY,
                    sizeof(int),                          &Q.nb,                        VALUE,
                    sizeof(PLASMA_Complex64_t)*A.mb*A.nb, Q(m, n),                          INOUT,
                    sizeof(int),                          &Q.nb,                        VALUE,
                    sizeof(PLASMA_Complex64_t)*A.mb*A.nb, A(m, k),                          INPUT,
                    sizeof(int),                          &A.nb,                        VALUE,
                    sizeof(PLASMA_Complex64_t)*T.mb*T.nb, T(m, k),                          INPUT,
                    sizeof(int),                          &T.mb,                        VALUE,
                    sizeof(PLASMA_Complex64_t)*T.mb*T.nb, NULL,                             SCRATCH,
                    sizeof(int),                          &T.mb,                        VALUE,
                    0);
            }
        }
        for (n = 0; n < Q.nt; n++) {
            temp1 = A.m-k*A.nb;
            temp2 = Q.n-n*Q.nb;
            temp3 = min(A.m, A.n)-k*A.nb;
            QUARK_Insert_Task(plasma->quark, CORE_zunmqr_quark, &task_flags,
                sizeof(PLASMA_enum),                  &plasma_left,                 VALUE,
                sizeof(PLASMA_enum),                  &plasma_no_trans,             VALUE,
                sizeof(int),                          k == A.mt-1 ? &temp1 : &A.nb, VALUE,
                sizeof(int),                          n == Q.nt-1 ? &temp2 : &Q.nb, VALUE,
                sizeof(int),                          &T.mb,                        VALUE,
                sizeof(int),                          k == A.nt-1 ? &temp3 : &A.nb, VALUE,
                sizeof(PLASMA_Complex64_t)*A.mb*A.nb, A(k, k),                          INPUT,
                sizeof(int),                          &A.nb,                        VALUE,
                sizeof(PLASMA_Complex64_t)*T.mb*T.nb, T(k, k),                          INPUT,
                sizeof(int),                          &T.mb,                        VALUE,
                sizeof(PLASMA_Complex64_t)*A.mb*A.nb, Q(k, n),                          INOUT | LOCALITY,
                sizeof(int),                          &Q.nb,                        VALUE,
                sizeof(PLASMA_Complex64_t)*T.mb*T.nb, NULL,                             SCRATCH,
                sizeof(int),                          &T.nb,                        VALUE,
                0);
        }
    }
}
